<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\FrontendHeaderSection;
use App\Models\Admin\FrontendHeaderSectionFaq;
use App\Models\Admin\FrontendHeaderSectionPage;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class HeaderSectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $frontend_header_sections = array(
            array('id' => '1','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-receipt"},"ar":{"icon":"fas fa-receipt"},"es":{"icon":"fas fa-receipt"},"fr":{"icon":"fas fa-receipt"},"hi":{"icon":"fas fa-receipt"}}}','title' => '{"language":{"en":{"title":"Receive Money"},"ar":{"title":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Recibir dinero"},"fr":{"title":"Recevoir de l\'argent"},"hi":{"title":"\\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Securely receive funds directly into your QRPay Pro account\\u2014fast, flexible, and hassle-free."},"ar":{"sub_title":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 - \\u0633\\u0631\\u064a\\u0639 \\u0648\\u0645\\u0631\\u0646 \\u0648\\u062e\\u0627\\u0644\\u064a \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628."},"es":{"sub_title":"Reciba fondos de forma segura directamente en su cuenta QRPay Pro: r\\u00e1pido, flexible y sin complicaciones."},"fr":{"sub_title":"Recevez des fonds en toute s\\u00e9curit\\u00e9 directement sur votre compte QRPay Pro : rapide, flexible et sans tracas."},"hi":{"sub_title":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902 - \\u0924\\u0947\\u091c\\u093c, \\u0932\\u091a\\u0940\\u0932\\u093e \\u0914\\u0930 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 08:58:04','updated_at' => '2024-11-06 18:59:29'),
            array('id' => '2','type' => 'company','slug' => 'about','icon' => '{"language":{"en":{"icon":"fas fa-plus-circle"},"es":{"icon":"fas fa-plus-circle"},"ar":{"icon":"fas fa-plus-circle"},"fr":{"icon":"fas fa-plus-circle"},"hi":{"icon":"fas fa-plus-circle"}}}','title' => '{"language":{"en":{"title":"About Us"},"es":{"title":"Sobre nosotros"},"ar":{"title":"\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0639\\u0646\\u0627"},"fr":{"title":"\\u00c0 propos de nous"},"hi":{"title":"\\u0939\\u092e\\u093e\\u0930\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Discover our mission to simplify payments with cutting-edge technology."},"es":{"sub_title":"Descubra nuestra misi\\u00f3n de simplificar los pagos con tecnolog\\u00eda de punta."},"ar":{"sub_title":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0645\\u0647\\u0645\\u062a\\u0646\\u0627 \\u0644\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631\\u0629."},"fr":{"sub_title":"D\\u00e9couvrez notre mission de simplifier les paiements gr\\u00e2ce \\u00e0 une technologie de pointe."},"hi":{"sub_title":"\\u0905\\u0924\\u094d\\u092f\\u093e\\u0927\\u0941\\u0928\\u093f\\u0915 \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u0940 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u094b \\u0938\\u0930\\u0932 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0939\\u092e\\u093e\\u0930\\u0947 \\u092e\\u093f\\u0936\\u0928 \\u0915\\u0940 \\u0916\\u094b\\u091c \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 13:09:52','updated_at' => '2024-12-12 19:06:17'),
            array('id' => '3','type' => 'company','slug' => 'service','icon' => '{"language":{"en":{"icon":"fas fa-paper-plane"},"es":{"icon":null},"ar":{"icon":"fas fa-paper-plane"},"fr":{"icon":"fas fa-paper-plane"},"hi":{"icon":"fas fa-paper-plane"}}}','title' => '{"language":{"en":{"title":"Service Details"},"es":{"title":"Detalles del servicio"},"ar":{"title":"\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629"},"fr":{"title":"D\\u00e9tails des services"},"hi":{"title":"\\u0938\\u0947\\u0935\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923"}}}','sub_title' => '{"language":{"en":{"sub_title":"View comprehensive information about QRPay  Pro\'s services, including features, fees, and supported payment options."},"es":{"sub_title":"Vea informaci\\u00f3n completa sobre los servicios de QRPay Pro, incluidas funciones, tarifas y opciones de pago admitidas."},"ar":{"sub_title":"\\u0639\\u0631\\u0636 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0634\\u0627\\u0645\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062e\\u062f\\u0645\\u0627\\u062a QRPay Pro\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0648\\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629."},"fr":{"sub_title":"Consultez des informations compl\\u00e8tes sur les services de QRPay Pro, y compris les fonctionnalit\\u00e9s, les frais et les options de paiement prises en charge."},"hi":{"sub_title":"\\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902, \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0914\\u0930 \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0938\\u0939\\u093f\\u0924 QRPay Pro \\u0915\\u0940 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u094d\\u092f\\u093e\\u092a\\u0915 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0926\\u0947\\u0916\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 13:11:22','updated_at' => '2024-12-12 19:08:08'),
            array('id' => '4','type' => 'company','slug' => 'blog','icon' => '{"language":{"en":{"icon":"fas fa-receipt"},"es":{"icon":"fas fa-receipt"},"ar":{"icon":"fas fa-receipt"},"fr":{"icon":"fas fa-receipt"},"hi":{"icon":"fas fa-receipt"}}}','title' => '{"language":{"en":{"title":"Web Journal"},"es":{"title":"Diario Web"},"ar":{"title":"\\u0645\\u062c\\u0644\\u0629 \\u0627\\u0644\\u0648\\u064a\\u0628"},"fr":{"title":"Journal Web"},"hi":{"title":"\\u0935\\u0947\\u092c \\u091c\\u0930\\u094d\\u0928\\u0932"}}}','sub_title' => '{"language":{"en":{"sub_title":"Access detailed logs and reports of your online transactions and activities within QRPay Pro\\u2019s platform."},"es":{"sub_title":"Acceda a registros e informes detallados de sus transacciones y actividades en l\\u00ednea dentro de la plataforma de QRPay Pro."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0642\\u0627\\u0631\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0641\\u0635\\u064a\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0648\\u0623\\u0646\\u0634\\u0637\\u062a\\u0643 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0646\\u0635\\u0629 QRPay Pro."},"fr":{"sub_title":"Acc\\u00e9dez \\u00e0 des journaux et des rapports d\\u00e9taill\\u00e9s de vos transactions et activit\\u00e9s en ligne sur la plateforme QRPay Pro."},"hi":{"sub_title":"QRPay Pro \\u0915\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0914\\u0930 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u0932\\u0949\\u0917 \\u0914\\u0930 \\u0930\\u093f\\u092a\\u094b\\u0930\\u094d\\u091f \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0901\\u091a\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 13:12:06','updated_at' => '2024-12-12 19:09:39'),
            array('id' => '5','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-exchange-alt"},"ar":{"icon":"fas fa-exchange-alt"},"es":{"icon":"fas fa-exchange-alt"},"fr":{"icon":"fas fa-exchange-alt"},"hi":{"icon":"fas fa-exchange-alt"}}}','title' => '{"language":{"en":{"title":"Exchange Money"},"ar":{"title":"\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Cambiar dinero"},"fr":{"title":"Cambiar dinero"},"hi":{"title":"\\u0935\\u093f\\u0926\\u0947\\u0936\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Instantly convert your funds to multiple currencies with ease and flexibility."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0625\\u0644\\u0649 \\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0628\\u0643\\u0644 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0645\\u0631\\u0648\\u0646\\u0629."},"es":{"sub_title":"Convierta instant\\u00e1neamente sus fondos a m\\u00faltiples monedas con facilidad y flexibilidad."},"fr":{"sub_title":"Convertissez instantan\\u00e9ment vos fonds dans plusieurs devises avec facilit\\u00e9 et flexibilit\\u00e9."},"hi":{"sub_title":"\\u0906\\u0938\\u093e\\u0928\\u0940 \\u0914\\u0930 \\u0932\\u091a\\u0940\\u0932\\u0947\\u092a\\u0928 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0905\\u092a\\u0928\\u0947 \\u092b\\u0902\\u0921 \\u0915\\u094b \\u0915\\u0908 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u092c\\u0926\\u0932\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:36:55','updated_at' => '2024-11-06 19:11:36'),
            array('id' => '6','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-paper-plane"},"ar":{"icon":"fas fa-paper-plane"},"es":{"icon":"fas fa-paper-plane"},"fr":{"icon":"fas fa-paper-plane"},"hi":{"icon":"fas fa-paper-plane"}}}','title' => '{"language":{"en":{"title":"Send Money"},"ar":{"title":"\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"enviar dinero"},"fr":{"title":"enviar dinero"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Quickly transfer funds to friends, family, or businesses with ease and security."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0628\\u0643\\u0644 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646."},"es":{"sub_title":"Transfiera fondos r\\u00e1pidamente a amigos, familiares o empresas con facilidad y seguridad."},"fr":{"sub_title":"Transf\\u00e9rez rapidement des fonds \\u00e0 vos amis, \\u00e0 votre famille ou \\u00e0 votre entreprise, en toute simplicit\\u00e9 et en toute s\\u00e9curit\\u00e9."},"hi":{"sub_title":"\\u0906\\u0938\\u093e\\u0928\\u0940 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902, \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u092f\\u093e \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:42:21','updated_at' => '2024-11-06 19:19:23'),
            array('id' => '7','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-link"},"ar":{"icon":"fas fa-link"},"es":{"icon":"fas fa-link"},"fr":{"icon":"fas fa-link"},"hi":{"icon":"fas fa-link"}}}','title' => '{"language":{"en":{"title":"Payment Link"},"ar":{"title":"\\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"title":"Enlace de pago"},"fr":{"title":"Enlace de pago"},"hi":{"title":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915"}}}','sub_title' => '{"language":{"en":{"sub_title":"Create and share payment links for quick and secure payments from anyone, anywhere."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647\\u0627 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062f\\u0641\\u0639 \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0645\\u0646 \\u0623\\u064a \\u0634\\u062e\\u0635 \\u0648\\u0641\\u064a \\u0623\\u064a \\u0645\\u0643\\u0627\\u0646."},"es":{"sub_title":"Cree y comparta enlaces de pago para pagos r\\u00e1pidos y seguros desde cualquier persona y en cualquier lugar."},"fr":{"sub_title":"Cr\\u00e9ez et partagez des liens de paiement pour des paiements rapides et s\\u00e9curis\\u00e9s depuis n\'importe qui, n\'importe o\\u00f9."},"hi":{"sub_title":"\\u0915\\u0939\\u0940\\u0902 \\u092d\\u0940, \\u0915\\u093f\\u0938\\u0940 \\u0938\\u0947 \\u092d\\u0940 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:52:21','updated_at' => '2024-11-06 19:26:16'),
            array('id' => '8','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-hand-holding-usd"},"ar":{"icon":"fas fa-hand-holding-usd"},"es":{"icon":"fas fa-hand-holding-usd"},"fr":{"icon":"fas fa-hand-holding-usd"},"hi":{"icon":"fas fa-hand-holding-usd"}}}','title' => '{"language":{"en":{"title":"Request Money"},"ar":{"title":"\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Solicitar dinero"},"fr":{"title":"Solicitar dinero"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927"}}}','sub_title' => '{"language":{"en":{"sub_title":"Easily request funds from friends, family, or clients with just a few clicks."},"ar":{"sub_title":"\\u0627\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0628\\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637."},"es":{"sub_title":"Solicite fondos f\\u00e1cilmente a amigos, familiares o clientes con solo unos pocos clics."},"fr":{"sub_title":"Demandez facilement des fonds \\u00e0 vos amis, \\u00e0 votre famille ou \\u00e0 vos clients en quelques clics."},"hi":{"sub_title":"\\u092c\\u0938 \\u0915\\u0941\\u091b \\u0939\\u0940 \\u0915\\u094d\\u0932\\u093f\\u0915 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902, \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u092f\\u093e \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:55:04','updated_at' => '2024-11-06 19:32:37'),
            array('id' => '9','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-coins"},"ar":{"icon":"fas fa-coins"},"es":{"icon":"fas fa-coins"},"fr":{"icon":"fas fa-coins"},"hi":{"icon":"fas fa-coins"}}}','title' => '{"language":{"en":{"title":"Remittance"},"ar":{"title":"\\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a"},"es":{"title":"Remesa"},"fr":{"title":"Remesa"},"hi":{"title":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923"}}}','sub_title' => '{"language":{"en":{"sub_title":"Send money internationally to support family and friends with ease."},"ar":{"sub_title":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627 \\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0621 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629."},"es":{"sub_title":"Env\\u00ede dinero internacionalmente para apoyar a familiares y amigos con facilidad."},"fr":{"sub_title":"Envoyez de l\\u2019argent \\u00e0 l\\u2019international pour soutenir facilement votre famille et vos amis."},"hi":{"sub_title":"\\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0914\\u0930 \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u092a\\u0948\\u0938\\u093e \\u092d\\u0947\\u091c\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:56:02','updated_at' => '2024-11-06 19:37:45'),
            array('id' => '10','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-plus-circle"},"ar":{"icon":"fas fa-plus-circle"},"es":{"icon":"fas fa-plus-circle"},"fr":{"icon":"fas fa-plus-circle"},"hi":{"icon":"fas fa-plus-circle"}}}','title' => '{"language":{"en":{"title":"Add Money"},"ar":{"title":"\\u0623\\u0636\\u0641 \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Agregar dinero"},"fr":{"title":"Agregar dinero"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Quickly and securely deposit funds into your QRPay Pro account."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u064a\\u062f\\u0627\\u0639 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"sub_title":"Deposite fondos de forma r\\u00e1pida y segura en su cuenta QRPay Pro."},"fr":{"sub_title":"D\\u00e9posez des fonds rapidement et en toute s\\u00e9curit\\u00e9 sur votre compte QRPay Pro."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:56:43','updated_at' => '2024-11-06 19:41:43'),
            array('id' => '11','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-arrow-alt-circle-right"},"ar":{"icon":"fas fa-arrow-alt-circle-right"},"es":{"icon":"fas fa-arrow-alt-circle-right"},"fr":{"icon":"fas fa-arrow-alt-circle-right"},"hi":{"icon":"fas fa-arrow-alt-circle-right"}}}','title' => '{"language":{"en":{"title":"Withdraw Money"},"ar":{"title":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Retirar dinero"},"fr":{"title":"Retirar dinero"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947"}}}','sub_title' => '{"language":{"en":{"sub_title":"Easily transfer funds from your QRPay Pro account to your bank account or digital wallet."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a \\u0623\\u0648 \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629."},"es":{"sub_title":"Transfiera fondos f\\u00e1cilmente desde su cuenta QRPay Pro a su cuenta bancaria o billetera digital."},"fr":{"sub_title":"Transf\\u00e9rez facilement des fonds de votre compte QRPay Pro vers votre compte bancaire ou votre portefeuille num\\u00e9rique."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092f\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:57:46','updated_at' => '2024-11-06 19:48:36'),
            array('id' => '12','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-fighter-jet"},"ar":{"icon":"fas fa-fighter-jet"},"es":{"icon":"fas fa-fighter-jet"},"fr":{"icon":null},"hi":{"icon":"fas fa-fighter-jet"}}}','title' => '{"language":{"en":{"title":"Make Payment"},"ar":{"title":"\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"title":"Realizar pago"},"fr":{"title":"Realizar pago"},"hi":{"title":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Seamlessly pay for goods and services directly from your QRPay Pro account."},"ar":{"sub_title":"\\u0627\\u062f\\u0641\\u0639 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629\\u064b \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"sub_title":"Pague sin problemas bienes y servicios directamente desde su cuenta QRPay Pro."},"fr":{"sub_title":"Payez en toute transparence des biens et des services directement depuis votre compte QRPay Pro."},"hi":{"sub_title":"\\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0935\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 15:59:11','updated_at' => '2024-11-06 20:04:56'),
            array('id' => '13','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-share-square"},"ar":{"icon":"fas fa-share-square"},"es":{"icon":"fas fa-share-square"},"fr":{"icon":"fas fa-share-square"},"hi":{"icon":"fas fa-share-square"}}}','title' => '{"language":{"en":{"title":"Money Out"},"ar":{"title":"\\u0627\\u0644\\u0645\\u0627\\u0644 \\u062e\\u0627\\u0631\\u062c"},"es":{"title":"Salida de dinero"},"fr":{"title":"Salida de dinero"},"hi":{"title":"\\u0927\\u0928 \\u0932\\u0947 \\u091c\\u093e\\u0928\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Effortlessly withdraw funds from your QRPay Pro account to QRPay Pro agents."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u0644\\u0627\\u0621 QRPay Pro."},"es":{"sub_title":"Retire fondos sin esfuerzo de su cuenta QRPay Pro a agentes de QRPay Pro."},"fr":{"sub_title":"Retirez sans effort des fonds de votre compte QRPay Pro vers les agents QRPay Pro."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay Pro \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 QRPay Pro \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:00:11','updated_at' => '2024-11-06 20:11:12'),
            array('id' => '14','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-credit-card"},"ar":{"icon":"fas fa-credit-card"},"es":{"icon":"fas fa-credit-card"},"fr":{"icon":"fas fa-credit-card"},"hi":{"icon":"fas fa-credit-card"}}}','title' => '{"language":{"en":{"title":"Virtual Card"},"ar":{"title":"\\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629"},"es":{"title":"Tarjeta virtual"},"fr":{"title":"Tarjeta virtual"},"hi":{"title":"\\u0906\\u092d\\u093e\\u0938\\u0940 \\u0915\\u093e\\u0930\\u094d\\u0921"}}}','sub_title' => '{"language":{"en":{"sub_title":"Create secure virtual cards for safe online purchases."},"ar":{"sub_title":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a."},"es":{"sub_title":"Cree tarjetas virtuales seguras para compras en l\\u00ednea seguras."},"fr":{"sub_title":"Cr\\u00e9ez des cartes virtuelles s\\u00e9curis\\u00e9es pour des achats en ligne en toute s\\u00e9curit\\u00e9."},"hi":{"sub_title":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u090f\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:01:32','updated_at' => '2024-11-07 09:51:43'),
            array('id' => '15','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-gift"},"ar":{"icon":"fas fa-gift"},"es":{"icon":"fas fa-gift"},"fr":{"icon":"fas fa-gift"},"hi":{"icon":"fas fa-gift"}}}','title' => '{"language":{"en":{"title":"Gift Card"},"ar":{"title":"\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u064a\\u0629"},"es":{"title":"Tarjeta de regalo"},"fr":{"title":"Tarjeta de regalo"},"hi":{"title":"\\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921"}}}','sub_title' => '{"language":{"en":{"sub_title":"Purchase digital gift cards for your favorite services effortlessly."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621."},"es":{"sub_title":"Compra tarjetas de regalo digitales para tus servicios favoritos sin esfuerzo."},"fr":{"sub_title":"Achetez sans effort des cartes-cadeaux num\\u00e9riques pour vos services pr\\u00e9f\\u00e9r\\u00e9s."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0940 \\u092a\\u0938\\u0902\\u0926\\u0940\\u0926\\u093e \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:02:49','updated_at' => '2024-11-07 09:58:14'),
            array('id' => '16','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-shopping-bag"},"ar":{"icon":"fas fa-shopping-bag"},"es":{"icon":"fas fa-shopping-bag"},"fr":{"icon":"fas fa-shopping-bag"},"hi":{"icon":"fas fa-shopping-bag"}}}','title' => '{"language":{"en":{"title":"Bill Pay"},"ar":{"title":"\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629"},"es":{"title":"Pago de facturas"},"fr":{"title":"Pago de facturas"},"hi":{"title":"\\u092c\\u093f\\u0932 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928"}}}','sub_title' => '{"language":{"en":{"sub_title":"Easily pay your utility and service bills directly from your QRPay Pro account."},"ar":{"sub_title":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0641\\u0642 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"sub_title":"Pague f\\u00e1cilmente sus facturas de servicios y servicios p\\u00fablicos directamente desde su cuenta QRPay Pro."},"fr":{"sub_title":"Payez facilement vos factures de services publics et de services directement depuis votre compte QRPay Pro."},"hi":{"sub_title":"\\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:04:11','updated_at' => '2024-11-07 10:03:34'),
            array('id' => '17','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-mobile"},"ar":{"icon":"fas fa-mobile"},"es":{"icon":"fas fa-mobile"},"fr":{"icon":"fas fa-mobile"},"hi":{"icon":"fas fa-mobile"}}}','title' => '{"language":{"en":{"title":"Mobile TopUp"},"ar":{"title":"\\u0645\\u0648\\u0628\\u0627\\u064a\\u0644 \\u0627\\u0634\\u062d\\u0646 \\u0631\\u0635\\u064a\\u062f\\u0643"},"es":{"title":"Recarga M\\u00f3vil"},"fr":{"title":"Recharge mobile"},"hi":{"title":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a\\u0905\\u092a"}}}','sub_title' => '{"language":{"en":{"sub_title":"Instantly recharge your mobile phone accounts using your QRPay Pro balance."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0635\\u064a\\u062f QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"sub_title":"Recargue instant\\u00e1neamente sus cuentas de tel\\u00e9fonos m\\u00f3viles utilizando su saldo QRPay Pro."},"fr":{"sub_title":"Rechargez instantan\\u00e9ment vos comptes de t\\u00e9l\\u00e9phonie mobile en utilisant votre solde QRPay Pro."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u093c\\u094b\\u0928 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:05:03','updated_at' => '2024-11-07 10:10:44'),
            array('id' => '18','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-receipt"},"ar":{"icon":"fas fa-receipt"},"es":{"icon":"fas fa-receipt"},"fr":{"icon":"fas fa-receipt"},"hi":{"icon":"fas fa-receipt"}}}','title' => '{"language":{"en":{"title":"Receive Money"},"ar":{"title":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Recibir dinero"},"fr":{"title":"Recevoir de l\'argent"},"hi":{"title":"\\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Accept payments seamlessly with QRPay Pro\\u2019s permanent QR Code feature."},"ar":{"sub_title":"\\u0627\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062f\\u0627\\u0626\\u0645 \\u0641\\u064a QRPay Pro."},"es":{"sub_title":"Acepte pagos sin problemas con la funci\\u00f3n de c\\u00f3digo QR permanente de QRPay Pro."},"fr":{"sub_title":"Acceptez les paiements en toute transparence gr\\u00e2ce \\u00e0 la fonctionnalit\\u00e9 QR Code permanente de QRPay Pro."},"hi":{"sub_title":"QRPay Pro \\u0915\\u0940 \\u0938\\u094d\\u0925\\u093e\\u092f\\u0940 QR \\u0915\\u094b\\u0921 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:44:11','updated_at' => '2024-11-06 17:15:56'),
            array('id' => '19','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-exchange-alt"},"ar":{"icon":"fas fa-exchange-alt"},"es":{"icon":"fas fa-exchange-alt"},"fr":{"icon":"fas fa-exchange-alt"},"hi":{"icon":"fas fa-exchange-alt"}}}','title' => '{"language":{"en":{"title":"Exchange Money"},"ar":{"title":"\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Cambiar dinero"},"fr":{"title":"\\u00c9changer de l\'argent"},"hi":{"title":"\\u0935\\u093f\\u0926\\u0947\\u0936\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Easily convert currencies within your QRPay Pro account for seamless global transactions."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u062f\\u0627\\u062e\\u0644 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0633\\u0644\\u0633\\u0629."},"es":{"sub_title":"Convierta f\\u00e1cilmente monedas dentro de su cuenta QRPay Pro para realizar transacciones globales sin problemas."},"fr":{"sub_title":"Convertissez facilement les devises au sein de votre compte QRPay Pro pour des transactions mondiales transparentes."},"hi":{"sub_title":"\\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u090f\\u0902 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:44:42','updated_at' => '2024-11-06 17:24:18'),
            array('id' => '20','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-link"},"ar":{"icon":"fas fa-link"},"es":{"icon":"fas fa-link"},"fr":{"icon":"fas fa-link"},"hi":{"icon":"fas fa-link"}}}','title' => '{"language":{"en":{"title":"Payment Link"},"ar":{"title":"\\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"title":"Enlace de pago"},"fr":{"title":"Lien de paiement"},"hi":{"title":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915"}}}','sub_title' => '{"language":{"en":{"sub_title":"Easily collect payments by sharing a secure link with your customers using QRPay Pro."},"ar":{"sub_title":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u062d\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0622\\u0645\\u0646 \\u0645\\u0639 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0643 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Cobre pagos f\\u00e1cilmente compartiendo un enlace seguro con sus clientes utilizando QRPay Pro."},"fr":{"sub_title":"Collectez facilement les paiements en partageant un lien s\\u00e9curis\\u00e9 avec vos clients \\u00e0 l\'aide de QRPay Pro."},"hi":{"sub_title":"QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0915\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:45:48','updated_at' => '2024-11-06 17:29:11'),
            array('id' => '21','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-arrow-alt-circle-right"},"ar":{"icon":"fas fa-arrow-alt-circle-right"},"es":{"icon":"fas fa-arrow-alt-circle-right"},"fr":{"icon":"fas fa-arrow-alt-circle-right"},"hi":{"icon":"fas fa-arrow-alt-circle-right"}}}','title' => '{"language":{"en":{"title":"Withdraw Money"},"ar":{"title":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Retirar dinero"},"fr":{"title":"Retirer de l\'argent"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947"}}}','sub_title' => '{"language":{"en":{"sub_title":"Transfer your QRPay Pro balance to your bank account or digital wallet with ease."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0631\\u0635\\u064a\\u062f QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0628\\u0646\\u0643\\u064a \\u0623\\u0648 \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629."},"es":{"sub_title":"Transfiera su saldo de QRPay Pro a su cuenta bancaria o billetera digital con facilidad."},"fr":{"sub_title":"Transf\\u00e9rez facilement votre solde QRPay Pro sur votre compte bancaire ou votre portefeuille num\\u00e9rique."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092f\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:46:21','updated_at' => '2024-11-06 17:36:13'),
            array('id' => '22','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-tools"},"ar":{"icon":"fas fa-tools"},"es":{"icon":"fas fa-tools"},"fr":{"icon":"fas fa-tools"},"hi":{"icon":"fas fa-tools"}}}','title' => '{"language":{"en":{"title":"Gateway Setting"},"ar":{"title":"\\u0625\\u0639\\u062f\\u0627\\u062f \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629"},"es":{"title":"Configuraci\\u00f3n de puerta de enlace"},"fr":{"title":"Param\\u00e8tre de passerelle"},"hi":{"title":"\\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917"}}}','sub_title' => '{"language":{"en":{"sub_title":"Seamlessly integrate and customize your payment gateway with QRPay Pro for a streamlined checkout experience."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062f\\u0645\\u062c \\u0648\\u062a\\u062e\\u0635\\u064a\\u0635 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0639 QRPay Pro \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u062f\\u0641\\u0639 \\u0645\\u0628\\u0633\\u0637\\u0629."},"es":{"sub_title":"Integre y personalice perfectamente su pasarela de pago con QRPay Pro para una experiencia de pago optimizada."},"fr":{"sub_title":"Int\\u00e9grez et personnalisez en toute transparence votre passerelle de paiement avec QRPay Pro pour une exp\\u00e9rience de paiement simplifi\\u00e9e."},"hi":{"sub_title":"\\u0938\\u0941\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093f\\u0924 \\u091a\\u0947\\u0915\\u0906\\u0909\\u091f \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u094b \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0914\\u0930 \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:48:10','updated_at' => '2024-11-06 17:55:36'),
            array('id' => '23','type' => 'business','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-tools"},"ar":{"icon":"fas fa-tools"},"es":{"icon":"fas fa-tools"},"fr":{"icon":"fas fa-tools"},"hi":{"icon":"fas fa-tools"}}}','title' => '{"language":{"en":{"title":"API Key"},"ar":{"title":"\\u0645\\u0641\\u062a\\u0627\\u062d \\u0648\\u0627\\u062c\\u0647\\u0629 \\u0628\\u0631\\u0645\\u062c\\u0629 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642\\u0627\\u062a"},"es":{"title":"Clave API"},"fr":{"title":"Cl\\u00e9 API"},"hi":{"title":"\\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940"}}}','sub_title' => '{"language":{"en":{"sub_title":"Generate and control API keys to securely integrate QRPay Pro\\u2019s payment features into your system."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0648\\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0641\\u064a\\u0647\\u0627 \\u0644\\u062f\\u0645\\u062c \\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0641\\u064a \\u0646\\u0638\\u0627\\u0645\\u0643."},"es":{"sub_title":"Genere y controle claves API para integrar de forma segura las funciones de pago de QRPay Pro en su sistema."},"fr":{"sub_title":"G\\u00e9n\\u00e9rez et contr\\u00f4lez des cl\\u00e9s API pour int\\u00e9grer en toute s\\u00e9curit\\u00e9 les fonctionnalit\\u00e9s de paiement de QRPay Pro dans votre syst\\u00e8me."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0938\\u093f\\u0938\\u094d\\u091f\\u092e \\u092e\\u0947\\u0902 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u092c\\u0928\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 16:48:38','updated_at' => '2024-11-06 18:03:46'),
            array('id' => '24','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-receipt"},"ar":{"icon":"fas fa-receipt"},"es":{"icon":"fas fa-receipt"},"fr":{"icon":"fas fa-receipt"},"hi":{"icon":"fas fa-receipt"}}}','title' => '{"language":{"en":{"title":"Receive Money"},"ar":{"title":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Recibir dinero"},"fr":{"title":"Recevoir de l\'argent"},"hi":{"title":"\\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Accept incoming funds directly to your QRPay Pro account for seamless transactions."},"ar":{"sub_title":"\\u0627\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0627\\u0631\\u062f\\u0629 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0633\\u0644\\u0633\\u0629."},"es":{"sub_title":"Acepte fondos entrantes directamente en su cuenta QRPay Pro para realizar transacciones sin problemas."},"fr":{"sub_title":"Acceptez les fonds entrants directement sur votre compte QRPay Pro pour des transactions transparentes."},"hi":{"sub_title":"\\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u094b \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:00:36','updated_at' => '2024-11-06 16:12:53'),
            array('id' => '25','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-exchange-alt"},"ar":{"icon":"fas fa-exchange-alt"},"es":{"icon":"fas fa-exchange-alt"},"fr":{"icon":"fas fa-exchange-alt"},"hi":{"icon":"fas fa-exchange-alt"}}}','title' => '{"language":{"en":{"title":"Exchange Money"},"ar":{"title":"\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Cambiar dinero"},"fr":{"title":"\\u00c9changer de l\'argent"},"hi":{"title":"\\u0935\\u093f\\u0926\\u0947\\u0936\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Effortlessly manage currency exchanges with QRPay Pro\\u2019s secure and convenient platform."},"ar":{"sub_title":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0646\\u0635\\u0629 QRPay Pro \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0631\\u064a\\u062d\\u0629."},"es":{"sub_title":"Administre sin esfuerzo los cambios de divisas con la plataforma segura y conveniente de QRPay Pro."},"fr":{"sub_title":"G\\u00e9rez sans effort les \\u00e9changes de devises avec la plateforme s\\u00e9curis\\u00e9e et pratique de QRPay Pro."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u0949\\u0930\\u094d\\u092e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u094b \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:01:04','updated_at' => '2024-11-06 15:28:17'),
            array('id' => '26','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-plus-circle"},"ar":{"icon":"fas fa-plus-circle"},"es":{"icon":"fas fa-plus-circle"},"fr":{"icon":"fas fa-plus-circle"},"hi":{"icon":"fas fa-plus-circle"}}}','title' => '{"language":{"en":{"title":"Add Money"},"ar":{"title":"\\u0623\\u0636\\u0641 \\u0627\\u0644\\u0645\\u0627\\u0644"},"es":{"title":"Agregar dinero"},"fr":{"title":"Ajouter de l\'argent"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902"}}}','sub_title' => '{"language":{"en":{"sub_title":"Quickly and securely fund your QRPay Pro account to facilitate transactions with clients."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u0645\\u0648\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0644\\u062a\\u0633\\u0647\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621."},"es":{"sub_title":"Deposite fondos de forma r\\u00e1pida y segura en su cuenta QRPay Pro para facilitar las transacciones con los clientes."},"fr":{"sub_title":"Alimentez rapidement et en toute s\\u00e9curit\\u00e9 votre compte QRPay Pro pour faciliter les transactions avec les clients."},"hi":{"sub_title":"\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:01:50','updated_at' => '2024-11-06 16:00:11'),
            array('id' => '27','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-arrow-alt-circle-right"},"ar":{"icon":"fas fa-arrow-alt-circle-right"},"es":{"icon":"fas fa-arrow-alt-circle-right"},"fr":{"icon":"fas fa-arrow-alt-circle-right"},"hi":{"icon":"fas fa-arrow-alt-circle-right"}}}','title' => '{"language":{"en":{"title":"Withdraw Money"},"ar":{"title":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Retirar dinero"},"fr":{"title":"Retirer de l\'argent"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947"}}}','sub_title' => '{"language":{"en":{"sub_title":"Seamlessly withdraw funds from your QRPay Pro account to your preferred bank account."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644."},"es":{"sub_title":"Retire fondos sin problemas de su cuenta QRPay Pro a su cuenta bancaria preferida."},"fr":{"sub_title":"Retirez en toute transparence des fonds de votre compte QRPay Pro vers votre compte bancaire pr\\u00e9f\\u00e9r\\u00e9."},"hi":{"sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u0938\\u0902\\u0926\\u0940\\u0926\\u093e \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:02:20','updated_at' => '2024-11-06 16:20:35'),
            array('id' => '28','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-paper-plane"},"ar":{"icon":"fas fa-paper-plane"},"es":{"icon":"fas fa-paper-plane"},"fr":{"icon":"fas fa-paper-plane"},"hi":{"icon":"fas fa-paper-plane"}}}','title' => '{"language":{"en":{"title":"Send Money"},"ar":{"title":"\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"title":"Enviar enviar dinero"},"fr":{"title":"Envoyer de l\'argent"},"hi":{"title":"\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Seamlessly transfer funds between agents using QRPay Pro."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Transfiera fondos sin problemas entre agentes utilizando QRPay Pro."},"fr":{"sub_title":"Transf\\u00e9rez facilement des fonds entre agents \\u00e0 l\\u2019aide de QRPay Pro."},"hi":{"sub_title":"QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:03:00','updated_at' => '2024-11-06 16:37:15'),
            array('id' => '29','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-paper-plane"},"ar":{"icon":"fas fa-paper-plane"},"es":{"icon":"fas fa-paper-plane"},"fr":{"icon":"fas fa-paper-plane"},"hi":{"icon":"fas fa-paper-plane"}}}','title' => '{"language":{"en":{"title":"Money In"},"ar":{"title":"\\u0627\\u0644\\u0645\\u0627\\u0644 \\u0641\\u064a"},"es":{"title":"Dinero en"},"fr":{"title":"Argent entrant"},"hi":{"title":"\\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u093e"}}}','sub_title' => '{"language":{"en":{"sub_title":"Facilitate seamless fund transfers from agents to users with QRPay Pro."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u0633\\u0647\\u064a\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Facilite transferencias de fondos fluidas de agentes a usuarios con QRPay Pro."},"fr":{"sub_title":"Facilitez les transferts de fonds transparents des agents aux utilisateurs avec QRPay Pro."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0938\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0924\\u0915 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092b\\u0902\\u0921 \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092b\\u0930 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:03:58','updated_at' => '2024-11-06 16:38:34'),
            array('id' => '30','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-shopping-bag"},"ar":{"icon":"fas fa-shopping-bag"},"es":{"icon":"fas fa-shopping-bag"},"fr":{"icon":"fas fa-shopping-bag"},"hi":{"icon":"fas fa-shopping-bag"}}}','title' => '{"language":{"en":{"title":"Bill Pay"},"ar":{"title":"\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629"},"es":{"title":"Pago de facturas"},"fr":{"title":"Paiement de facture"},"hi":{"title":"\\u092c\\u093f\\u0932 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928"}}}','sub_title' => '{"language":{"en":{"sub_title":"Simplify your bill payment process with QRPay Pro."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062f\\u0641\\u0639 \\u0641\\u0627\\u062a\\u0648\\u0631\\u062a\\u0643 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Simplifique su proceso de pago de facturas con QRPay Pro."},"fr":{"sub_title":"Simplifiez votre processus de paiement de factures avec QRPay Pro."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0940 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0938\\u0930\\u0932 \\u092c\\u0928\\u093e\\u090f\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:04:33','updated_at' => '2024-11-06 16:45:00'),
            array('id' => '31','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-mobile"},"ar":{"icon":"fas fa-mobile"},"es":{"icon":"fas fa-mobile"},"fr":{"icon":"fas fa-mobile"},"hi":{"icon":"fas fa-mobile"}}}','title' => '{"language":{"en":{"title":"Mobile TopUp"},"ar":{"title":"\\u0645\\u0648\\u0628\\u0627\\u064a\\u0644 \\u0627\\u0634\\u062d\\u0646 \\u0631\\u0635\\u064a\\u062f\\u0643"},"es":{"title":"Recarga M\\u00f3vil"},"fr":{"title":"Recharge mobile"},"hi":{"title":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a\\u0905\\u092a"}}}','sub_title' => '{"language":{"en":{"sub_title":"Instantly recharge mobile phones with QRPay Pro."},"ar":{"sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Recarga instant\\u00e1neamente tel\\u00e9fonos m\\u00f3viles con QRPay Pro."},"fr":{"sub_title":"Rechargez instantan\\u00e9ment les t\\u00e9l\\u00e9phones mobiles avec QRPay Pro."},"hi":{"sub_title":"QRPay Pro \\u0938\\u0947 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u094b\\u0928 \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:05:37','updated_at' => '2024-11-06 16:53:49'),
            array('id' => '32','type' => 'enterprise','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-coins"},"ar":{"icon":"fas fa-coins"},"es":{"icon":"fas fa-coins"},"fr":{"icon":"fas fa-coins"},"hi":{"icon":"fas fa-coins"}}}','title' => '{"language":{"en":{"title":"Remittance"},"ar":{"title":"\\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a"},"es":{"title":"Remesa"},"fr":{"title":"Remise"},"hi":{"title":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923"}}}','sub_title' => '{"language":{"en":{"sub_title":"Effortlessly send money across borders with QRPay Pro."},"ar":{"sub_title":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"sub_title":"Env\\u00ede dinero a trav\\u00e9s de fronteras sin esfuerzo con QRPay Pro."},"fr":{"sub_title":"Envoyez de l\'argent sans effort au-del\\u00e0 des fronti\\u00e8res avec QRPay Pro."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092a\\u093e\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 17:06:25','updated_at' => '2024-11-06 17:08:10'),
            array('id' => '33','type' => 'company','slug' => 'pricing','icon' => '{"language":{"en":{"icon":"fas fa-comment-dollar"},"es":{"icon":"fas fa-comment-dollar"},"ar":{"icon":"fas fa-comment-dollar"},"fr":{"icon":"fas fa-comment-dollar"},"hi":{"icon":"fas fa-comment-dollar"}}}','title' => '{"language":{"en":{"title":"Pricing & Limits"},"es":{"title":"Precios y l\\u00edmites"},"ar":{"title":"\\u0627\\u0644\\u062a\\u0633\\u0639\\u064a\\u0631 \\u0648\\u0627\\u0644\\u062d\\u062f\\u0648\\u062f"},"fr":{"title":"Prix \\u200b\\u200bet limites"},"hi":{"title":"\\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u0914\\u0930 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0901"}}}','sub_title' => '{"language":{"en":{"sub_title":"Get a clear overview of QRPay Pro\'s pricing structure, transaction limits, and operational ranges."},"es":{"sub_title":"Obtenga una descripci\\u00f3n general clara de la estructura de precios, los l\\u00edmites de transacciones y los rangos operativos de QRPay Pro."},"ar":{"sub_title":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0646\\u0638\\u0631\\u0629 \\u0639\\u0627\\u0645\\u0629 \\u0648\\u0627\\u0636\\u062d\\u0629 \\u0639\\u0644\\u0649 \\u0647\\u064a\\u0643\\u0644 \\u062a\\u0633\\u0639\\u064a\\u0631 QRPay Pro \\u0648\\u062d\\u062f\\u0648\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u0646\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u062a\\u0634\\u063a\\u064a\\u0644\\u064a\\u0629."},"fr":{"sub_title":"Obtenez un aper\\u00e7u clair de la structure tarifaire, des limites de transaction et des plages op\\u00e9rationnelles de QRPay Pro."},"hi":{"sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0940 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e, \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0940\\u092e\\u093e \\u0914\\u0930 \\u092a\\u0930\\u093f\\u091a\\u093e\\u0932\\u0928 \\u0938\\u0940\\u092e\\u093e \\u0915\\u093e \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0905\\u0935\\u0932\\u094b\\u0915\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-12-12 18:50:32','updated_at' => '2024-12-12 18:59:44'),
            array('id' => '34','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-chart-line"},"ar":{"icon":"fas fa-chart-line"},"es":{"icon":"fas fa-chart-line"},"fr":{"icon":"fas fa-chart-line"},"hi":{"icon":"fas fa-chart-line"}}}','title' => '{"language":{"en":{"title":"P2P Trading"},"ar":{"title":"\\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0634\\u062e\\u0635 \\u0644\\u0634\\u062e\\u0635"},"es":{"title":"Comercio P2P"},"fr":{"title":"\\u00c9change P2P"},"hi":{"title":"\\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917"}}}','sub_title' => '{"language":{"en":{"sub_title":"Secure peer-to-peer currency exchange with dynamic offers, marketplace listings, and encrypted transactions."},"ar":{"sub_title":"\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0639\\u0645\\u0644\\u0627\\u062a \\u0622\\u0645\\u0646 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 \\u0645\\u0639 \\u0639\\u0631\\u0648\\u0636 \\u062f\\u064a\\u0646\\u0627\\u0645\\u064a\\u0643\\u064a\\u0629\\u060c \\u0648\\u0625\\u062f\\u0631\\u0627\\u062c \\u0641\\u064a \\u0627\\u0644\\u0633\\u0648\\u0642\\u060c \\u0648\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0634\\u0641\\u0631\\u0629."},"es":{"sub_title":"Intercambio de divisas seguro entre pares con ofertas din\\u00e1micas, listados en el mercado y transacciones encriptadas."},"fr":{"sub_title":"\\u00c9change de devises s\\u00e9curis\\u00e9 entre pairs avec offres dynamiques, annonces sur le march\\u00e9 et transactions chiffr\\u00e9es."},"hi":{"sub_title":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u0940\\u092f\\u0930-\\u091f\\u0942-\\u092a\\u0940\\u092f\\u0930 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0921\\u093e\\u092f\\u0928\\u093e\\u092e\\u093f\\u0915 \\u0911\\u092b\\u093c\\u0930, \\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f\\u092a\\u094d\\u0932\\u0947\\u0938 \\u0932\\u093f\\u0938\\u094d\\u091f\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 12:54:25','updated_at' => '2025-05-23 13:16:59'),
            array('id' => '35','type' => 'personal','slug' => NULL,'icon' => '{"language":{"en":{"icon":"fas fa-comments"},"ar":{"icon":"fas fa-comments"},"es":{"icon":"fas fa-comments"},"fr":{"icon":"fas fa-comments"},"hi":{"icon":"fas fa-comments"}}}','title' => '{"language":{"en":{"title":"P2P Live Chat"},"ar":{"title":"\\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0629 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631"},"es":{"title":"Chat en vivo P2P"},"fr":{"title":"Chat en direct P2P"},"hi":{"title":"\\u092a\\u09402\\u092a\\u0940 \\u0932\\u093e\\u0907\\u0935 \\u091a\\u0948\\u091f"}}}','sub_title' => '{"language":{"en":{"sub_title":"Instantly connect with other users to discuss and finalize trade terms."},"ar":{"sub_title":"\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0641\\u0648\\u0631\\u0627\\u064b \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u0644\\u0645\\u0646\\u0627\\u0642\\u0634\\u0629 \\u0648\\u0625\\u0646\\u0647\\u0627\\u0621 \\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u0635\\u0641\\u0642\\u0629."},"es":{"sub_title":"Con\\u00e9ctate al instante con otros usuarios para discutir y finalizar los t\\u00e9rminos del comercio."},"fr":{"sub_title":"Connectez-vous instantan\\u00e9ment avec d\\u2019autres utilisateurs pour discuter et finaliser les conditions de la transaction."},"hi":{"sub_title":"\\u0924\\u0941\\u0930\\u0902\\u0924 \\u0905\\u0928\\u094d\\u092f \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0947\\u0902 \\u0914\\u0930 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0915\\u0947 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u091a\\u0930\\u094d\\u091a\\u093e \\u0915\\u0930 \\u0907\\u0938\\u0947 \\u0905\\u0902\\u0924\\u093f\\u092e \\u0930\\u0942\\u092a \\u0926\\u0947\\u0902\\u0964"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 12:54:50','updated_at' => '2025-05-23 13:42:23')
        );

        // Disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        FrontendHeaderSection::truncate();
        // Enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1');

        FrontendHeaderSection::insert($frontend_header_sections);

        $frontend_header_section_pages = array(
            array('id' => '1','parent_id' => '1','type' => 'personal','value' => '{"images":{"section_image":"a7d0c116-855c-4dc3-9a85-713b7c2015d9.webp","step_image":"a62cff34-351a-4604-8030-aa134e4c35c7.webp"},"language":{"en":{"heading":"Receive Money Instantly and Securely with QRPay Pro","sub_heading":"Effortless payments are now a reality. With QRPay Pro, receiving money from friends, family, or clients is easy. Your funds are transferred securely into your account with a quick QR code scan. Multi-currency support and global accessibility ensure that you can receive payments from anywhere, anytime, with the assurance of enhanced security for every transaction.","process_step_title":"Get Started in 3 Easy Steps","button_name":"Start Receiving Now","button_link":"user\\/receive-money","step_title":"Effortlessly Receive Money in Your QRPay Pro Account","step_sub_title":"Here\\u2019s how you can quickly and securely receive payments in just a few steps."},"es":{"heading":"Reciba dinero de forma instant\\u00e1nea y segura con QRPay Pro","sub_heading":"Los pagos sin esfuerzo son ahora una realidad. Con QRPay Pro, recibir dinero de amigos, familiares o clientes es f\\u00e1cil. Sus fondos se transfieren de forma segura a su cuenta con un r\\u00e1pido escaneo del c\\u00f3digo QR. El soporte multidivisa y la accesibilidad global garantizan que pueda recibir pagos desde cualquier lugar y en cualquier momento, con la garant\\u00eda de una seguridad mejorada para cada transacci\\u00f3n.","process_step_title":"Comience en 3 sencillos pasos","button_name":"Comience a recibir ahora","button_link":"user\\/receive-money","step_title":"Reciba dinero sin esfuerzo en su cuenta QRPay Pro","step_sub_title":"A continuaci\\u00f3n le mostramos c\\u00f3mo puede recibir pagos de forma r\\u00e1pida y segura en solo unos pocos pasos."},"ar":{"heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0648\\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u0623\\u0635\\u0628\\u062d\\u062a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0622\\u0646 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0648\\u0627\\u0642\\u0639\\u0629. \\u0645\\u0639 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0633\\u0647\\u0644\\u0627\\u064b. \\u064a\\u062a\\u0645 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0633\\u062d \\u0633\\u0631\\u064a\\u0639 \\u0644\\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629. \\u064a\\u0636\\u0645\\u0646 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0648\\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0646 \\u0623\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a\\u060c \\u0645\\u0639 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0632\\u0632 \\u0644\\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629.","process_step_title":"\\u0627\\u0628\\u062f\\u0623 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/receive-money","step_title":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0625\\u0644\\u064a\\u0643 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0641\\u064a \\u0628\\u0636\\u0639 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0641\\u0642\\u0637."},"fr":{"heading":"Recevez de l\'argent instantan\\u00e9ment et en toute s\\u00e9curit\\u00e9 avec QRPay Pro","sub_heading":"Les paiements sans effort sont d\\u00e9sormais une r\\u00e9alit\\u00e9. Avec QRPay Pro, recevoir de l\'argent d\'amis, de famille ou de clients est simple. Vos fonds sont transf\\u00e9r\\u00e9s en toute s\\u00e9curit\\u00e9 sur votre compte avec un scan rapide du code QR. La prise en charge multidevises et l\'accessibilit\\u00e9 mondiale garantissent que vous pouvez recevoir des paiements de n\'importe o\\u00f9 et \\u00e0 tout moment, avec l\'assurance d\'une s\\u00e9curit\\u00e9 renforc\\u00e9e pour chaque transaction.","process_step_title":"Commencez en 3 \\u00e9tapes faciles","button_name":"Commencez \\u00e0 recevoir maintenant","button_link":"user\\/receive-money","step_title":"Recevez de l\'argent sans effort sur votre compte QRPay Pro","step_sub_title":"Voici comment recevoir des paiements rapidement et en toute s\\u00e9curit\\u00e9 en quelques \\u00e9tapes seulement."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","sub_heading":"\\u0938\\u0939\\u091c \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u092c \\u090f\\u0915 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902, \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u092f\\u093e \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0939\\u0948\\u0964 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u092a\\u0915\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0926\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0914\\u0930 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a \\u0939\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0922\\u093c\\u0940 \\u0939\\u0941\\u0908 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0906\\u0936\\u094d\\u0935\\u093e\\u0938\\u0928 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0915\\u0939\\u0940\\u0902 \\u0938\\u0947 \\u092d\\u0940, \\u0915\\u092d\\u0940 \\u092d\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0906\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/receive-money","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u092f\\u0939\\u093e\\u0902 \\u092c\\u0924\\u093e\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0941\\u091b \\u0939\\u0940 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"items":{"6722fd0c94fb0":{"language":{"en":{"name":"Select the Currency"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629"},"es":{"name":"Seleccione la moneda"},"fr":{"name":"S\\u00e9lectionnez la devise"},"hi":{"name":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6722fd0c94fb0"},"6722fd16d0a1d":{"language":{"en":{"name":"Enter the Amount"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629"},"es":{"name":"Seleccione la moneda"},"fr":{"name":"S\\u00e9lectionnez la devise"},"hi":{"name":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6722fd16d0a1d"},"6722fd20d6a05":{"language":{"en":{"name":"Confirm the Exchange"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0635\\u0631\\u0641"},"es":{"name":"Confirmar el cambio"},"fr":{"name":"Confirmer l\'\\u00e9change"},"hi":{"name":"\\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6722fd20d6a05"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 09:43:33','updated_at' => '2024-12-12 18:35:05'),
            array('id' => '2','parent_id' => '5','type' => 'personal','value' => '{"images":{"section_image":"e96aa65d-6669-4457-97d3-1adf9f5cf271.webp","step_image":"6fb292b3-dc74-4b20-841a-27686245b69b.webp"},"language":{"en":{"heading":"Seamless Currency Exchange at Your Fingertips","sub_heading":"With QRPay Pro\\u2019s Exchange Money feature, you can quickly convert your balance into the currency of your choice. Enjoy real-time exchange rates, competitive fees, and an intuitive experience that makes currency conversion fast and simple. QRPay Pro supports a wide range of currencies, so you\\u2019re ready for transactions, whether you\\u2019re at home or abroad.","process_step_title":"Get Started with Currency Exchange in 3 Easy Steps","button_name":"Start Exchanging Now","button_link":"user\\/money-exchange","step_title":"Convert Money in Just a Few Taps","step_sub_title":"Follow these simple steps to exchange money in your QRPay Pro account with confidence."},"es":{"heading":"Cambio de divisas fluido a tu alcance","sub_heading":"Con la funci\\u00f3n Exchange Money de QRPay Pro, puede convertir r\\u00e1pidamente su saldo a la moneda que elija. Disfrute de tipos de cambio en tiempo real, tarifas competitivas y una experiencia intuitiva que hace que la conversi\\u00f3n de divisas sea r\\u00e1pida y sencilla. QRPay Pro admite una amplia gama de monedas, por lo que est\\u00e1 listo para realizar transacciones, ya sea que est\\u00e9 en casa o en el extranjero.","process_step_title":"Comience con el cambio de divisas en 3 sencillos pasos","button_name":"Comience a intercambiar ahora","button_link":"user\\/money-exchange","step_title":"Convierta dinero con solo unos pocos toques","step_sub_title":"Siga estos sencillos pasos para cambiar dinero en su cuenta QRPay Pro con confianza."},"ar":{"heading":"\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0641\\u064a \\u0645\\u062a\\u0646\\u0627\\u0648\\u0644 \\u064a\\u062f\\u0643","sub_heading":"\\u0645\\u0639 \\u0645\\u064a\\u0632\\u0629 Exchange Money \\u0641\\u064a QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0631\\u0635\\u064a\\u062f\\u0643 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0627\\u0631\\u0647\\u0627. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a\\u060c \\u0648\\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629\\u060c \\u0648\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0628\\u062f\\u064a\\u0647\\u064a\\u0629 \\u062a\\u062c\\u0639\\u0644 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u064b\\u0627 \\u0648\\u0628\\u0633\\u064a\\u0637\\u064b\\u0627. \\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u060c \\u0644\\u0630\\u0627 \\u0641\\u0623\\u0646\\u062a \\u062c\\u0627\\u0647\\u0632 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u060c \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0623\\u0648 \\u0641\\u064a \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c.","process_step_title":"\\u0627\\u0628\\u062f\\u0623 \\u0645\\u0639 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/money-exchange","step_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0643\\u0644 \\u062b\\u0642\\u0629."},"fr":{"heading":"Cambio de divisas fluido a tu alcance","sub_heading":"Avec la fonction Exchange Money de QRPay Pro, vous pouvez rapidement convertir votre solde dans la devise de votre choix. Profitez de taux de change en temps r\\u00e9el, de frais comp\\u00e9titifs et d\'une exp\\u00e9rience intuitive qui rend la conversion de devises rapide et simple. QRPay Pro prend en charge une large gamme de devises, vous \\u00eates donc pr\\u00eat \\u00e0 effectuer des transactions, que vous soyez chez vous ou \\u00e0 l\'\\u00e9tranger.","process_step_title":"D\\u00e9marrez avec le change de devises en 3 \\u00e9tapes faciles","button_name":"Commencez \\u00e0 \\u00e9changer maintenant","button_link":"user\\/money-exchange","step_title":"Convertissez de l\'argent en quelques clics","step_sub_title":"Suivez ces \\u00e9tapes simples pour \\u00e9changer de l\'argent sur votre compte QRPay Pro en toute confiance."},"hi":{"heading":"\\u0906\\u092a\\u0915\\u0940 \\u0909\\u0902\\u0917\\u0932\\u093f\\u092f\\u094b\\u0902 \\u092a\\u0930 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f","sub_heading":"QRPay Pro \\u0915\\u0947 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u092e\\u0928\\u0940 \\u092b\\u0940\\u091a\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u0915\\u094b \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0905\\u092a\\u0928\\u0940 \\u092a\\u0938\\u0902\\u0926 \\u0915\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u092e\\u0947\\u0902 \\u092c\\u0926\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u0939\\u091c \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902 \\u091c\\u094b \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u094b \\u0924\\u0947\\u091c\\u093c \\u0914\\u0930 \\u0938\\u0930\\u0932 \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u090f\\u0915 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u0936\\u094d\\u0930\\u0943\\u0902\\u0916\\u0932\\u093e \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0907\\u0938\\u0932\\u093f\\u090f \\u0906\\u092a \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0939\\u0948\\u0902, \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a \\u0918\\u0930 \\u092a\\u0930 \\u0939\\u094b\\u0902 \\u092f\\u093e \\u0935\\u093f\\u0926\\u0947\\u0936 \\u092e\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/money-exchange","step_title":"\\u092c\\u0938 \\u0915\\u0941\\u091b \\u0939\\u0940 \\u091f\\u0948\\u092a \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u092c\\u0926\\u0932\\u0947\\u0902","step_sub_title":"\\u0906\\u0924\\u094d\\u092e\\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67247a302b5cc":{"language":{"en":{"name":"Select the Currency"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629"},"es":{"name":"Seleccione la moneda"},"fr":{"name":"Seleccione la moneda"},"hi":{"name":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"67247a302b5cc"},"67247a38d7552":{"language":{"en":{"name":"Enter the Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese la cantidad"},"fr":{"name":"Ingrese la cantidad"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"67247a38d7552"},"67247a4055c9d":{"language":{"en":{"name":"Confirm the Exchange"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0635\\u0631\\u0641"},"es":{"name":"Confirmar el cambio"},"fr":{"name":"Confirmar el cambio"},"hi":{"name":"\\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"67247a4055c9d"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 12:48:33','updated_at' => '2024-12-12 18:35:26'),
            array('id' => '6','parent_id' => '6','type' => 'personal','value' => '{"images":{"section_image":"6582641d-0075-46a5-a5e1-a0b3e771966a.webp","step_image":"d150696c-fa00-4d7c-a4f2-7efb3a6b0dfd.webp"},"language":{"en":{"heading":"Send Money Instantly to Anyone, Anywhere","sub_heading":"With QRPay Pro, sending money is fast, easy, and secure. Transfer funds to friends, family, or businesses by entering their QRPay Pro ID or scanning a QR code. Enjoy seamless transfers with low fees, multi-currency support, and real-time tracking to keep you informed at every step.","process_step_title":"Start Sending Money in 3 Simple Steps","button_name":"Send Money Now","button_link":"user\\/send-money","step_title":"How to Send Money with QRPay Pro","step_sub_title":"Follow these easy steps to securely send funds from your QRPay Pro account."},"es":{"heading":"Env\\u00ede dinero al instante a cualquier persona y en cualquier lugar","sub_heading":"Con QRPay Pro, enviar dinero es r\\u00e1pido, f\\u00e1cil y seguro. Transfiera fondos a amigos, familiares o empresas ingresando su ID de QRPay Pro o escaneando un c\\u00f3digo QR. Disfrute de transferencias fluidas con tarifas bajas, soporte multidivisa y seguimiento en tiempo real para mantenerlo informado en cada paso.","process_step_title":"Comience a enviar dinero en 3 sencillos pasos","button_name":"Env\\u00eda dinero ahora","button_link":"user\\/send-money","step_title":"C\\u00f3mo enviar dinero con QRPay Pro","step_sub_title":"Siga estos sencillos pasos para enviar fondos de forma segura desde su cuenta QRPay Pro."},"ar":{"heading":"Env\\u00ede dinero al instante a cualquier persona y en cualquier lugar","sub_heading":"Con QRPay Pro, enviar dinero es r\\u00e1pido, f\\u00e1cil y seguro. Transfiera fondos a amigos, familiares o empresas ingresando su ID de QRPay Pro o escaneando un c\\u00f3digo QR. Disfrute de transferencias fluidas con tarifas bajas, soporte multidivisa y seguimiento en tiempo real para mantenerlo informado en cada paso.","process_step_title":"Comience a enviar dinero en 3 sencillos pasos","button_name":"Env\\u00eda dinero ahora","button_link":"user\\/send-money","step_title":"C\\u00f3mo enviar dinero con QRPay Pro","step_sub_title":"Siga estos sencillos pasos para enviar fondos de forma segura desde su cuenta QRPay Pro."},"fr":{"heading":"Env\\u00ede dinero al instante a cualquier persona y en cualquier lugar","sub_heading":"Avec QRPay Pro, envoyer de l\'argent est rapide, facile et s\\u00e9curis\\u00e9. Transf\\u00e9rez des fonds \\u00e0 des amis, \\u00e0 la famille ou \\u00e0 des entreprises en saisissant leur identifiant QRPay Pro ou en scannant un code QR. Profitez de transferts fluides avec des frais peu \\u00e9lev\\u00e9s, une prise en charge multidevises et un suivi en temps r\\u00e9el pour vous tenir inform\\u00e9 \\u00e0 chaque \\u00e9tape.","process_step_title":"Commencez \\u00e0 envoyer de l\'argent en 3 \\u00e9tapes simples","button_name":"Envoyez de l\'argent maintenant","button_link":"user\\/send-money","step_title":"Comment envoyer de l\'argent avec QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour envoyer des fonds en toute s\\u00e9curit\\u00e9 depuis votre compte QRPay Pro."},"hi":{"heading":"\\u0915\\u0939\\u0940\\u0902 \\u092d\\u0940, \\u0915\\u093f\\u0938\\u0940 \\u0915\\u094b \\u092d\\u0940 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e \\u0924\\u0947\\u091c\\u093c, \\u0906\\u0938\\u093e\\u0928 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u092e\\u093f\\u0924\\u094d\\u0930\\u094b\\u0902, \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u092f\\u093e \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0915\\u0947 \\u092f\\u093e QR \\u0915\\u094b\\u0921 \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0915\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u0906\\u092a\\u0915\\u094b \\u0939\\u0930 \\u0915\\u0926\\u092e \\u092a\\u0930 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u092e \\u0936\\u0941\\u0932\\u094d\\u0915, \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0914\\u0930 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u091f\\u094d\\u0930\\u0948\\u0915\\u093f\\u0902\\u0917 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","button_link":"user\\/send-money","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724961b0da16":{"language":{"en":{"name":"Enter Recipient Details"},"ar":{"name":null},"es":{"name":null},"fr":{"name":null},"hi":{"name":null}},"id":"6724961b0da16"},"672496257e41a":{"language":{"en":{"name":"Choose Amount and Currency"},"ar":{"name":null},"es":{"name":null},"fr":{"name":null},"hi":{"name":null}},"id":"672496257e41a"},"6724962bd01af":{"language":{"en":{"name":"Confirm and Send"},"ar":{"name":null},"es":{"name":null},"fr":{"name":null},"hi":{"name":null}},"id":"6724962bd01af"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:35:01','updated_at' => '2024-12-12 18:35:49'),
            array('id' => '7','parent_id' => '7','type' => 'personal','value' => '{"images":{"section_image":"385fb6df-94f4-4752-93f2-aa2431038c76.webp","step_image":"19f6152d-1a24-494b-90d4-ef5f047655c5.webp"},"language":{"en":{"heading":"Get Paid Instantly with QRPay Pro Payment Links","sub_heading":"QRPay Pro\\u2019s Payment Link feature allows you to receive payments effortlessly by creating a shareable link. Whether it\\u2019s for a friend, client, or anyone else, just send the link and let them complete the payment at their convenience. No need to share account details\\u2014just generate, share, and receive funds securely.","process_step_title":"Set Up Your Payment Link in 3 Simple Steps","button_name":"Create Payment Link","button_link":"user\\/payment-link","step_title":"How to Use QRPay Pro\\u2019s Payment Link Feature","step_sub_title":"Follow these easy steps to generate and share your payment link for fast payments."},"es":{"heading":"Reciba pagos al instante con enlaces de pago QRPay Pro","sub_heading":"La funci\\u00f3n Enlace de pago de QRPay Pro le permite recibir pagos sin esfuerzo mediante la creaci\\u00f3n de un enlace para compartir. Ya sea para un amigo, cliente o cualquier otra persona, simplemente env\\u00ede el enlace y perm\\u00edtale completar el pago a su conveniencia. No es necesario compartir los detalles de la cuenta: simplemente genere, comparta y reciba fondos de forma segura.","process_step_title":"Configure su enlace de pago en 3 sencillos pasos","button_name":"Crear enlace de pago","button_link":"user\\/payment-link","step_title":"C\\u00f3mo utilizar la funci\\u00f3n de enlace de pago de QRPay Pro","step_sub_title":"Siga estos sencillos pasos para generar y compartir su enlace de pago para pagos r\\u00e1pidos."},"ar":{"heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro","sub_heading":"\\u062a\\u062a\\u064a\\u062d \\u0644\\u0643 \\u0645\\u064a\\u0632\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0642\\u0627\\u0628\\u0644 \\u0644\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646 \\u0630\\u0644\\u0643 \\u0644\\u0635\\u062f\\u064a\\u0642 \\u0623\\u0648 \\u0639\\u0645\\u064a\\u0644 \\u0623\\u0648 \\u0623\\u064a \\u0634\\u062e\\u0635 \\u0622\\u062e\\u0631\\u060c \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637 \\u0648\\u0627\\u0644\\u0633\\u0645\\u0627\\u062d \\u0644\\u0647\\u0645 \\u0628\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0630\\u064a \\u064a\\u0646\\u0627\\u0633\\u0628\\u0647\\u0645. \\u0644\\u0627 \\u062f\\u0627\\u0639\\u064a \\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628 \\u2014 \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647\\u0627 \\u0648\\u0627\\u0633\\u062a\\u0644\\u0627\\u0645\\u0647\\u0627 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646.","process_step_title":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u062f\\u0627\\u062f \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639","button_link":"user\\/payment-link","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647 \\u0644\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629."},"fr":{"heading":"Reciba pagos al instante con enlaces de pago QRPay Pro","sub_heading":"La fonction Payment Link de QRPay Pro vous permet de recevoir des paiements sans effort en cr\\u00e9ant un lien partageable. Que ce soit pour un ami, un client ou toute autre personne, envoyez simplement le lien et laissez-le effectuer le paiement \\u00e0 sa convenance. Pas besoin de partager les d\\u00e9tails de votre compte\\u00a0: g\\u00e9n\\u00e9rez, partagez et recevez simplement des fonds en toute s\\u00e9curit\\u00e9.","process_step_title":"Configurez votre lien de paiement en 3 \\u00e9tapes simples","button_name":"Cr\\u00e9er un lien de paiement","button_link":"user\\/payment-link","step_title":"Comment utiliser la fonctionnalit\\u00e9 de lien de paiement de QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour g\\u00e9n\\u00e9rer et partager votre lien de paiement pour des paiements rapides."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0906\\u092a\\u0915\\u094b \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u092f\\u094b\\u0917\\u094d\\u092f \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u0915\\u0930 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u092f\\u0939 \\u0915\\u093f\\u0938\\u0940 \\u092e\\u093f\\u0924\\u094d\\u0930, \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u092f\\u093e \\u0915\\u093f\\u0938\\u0940 \\u0905\\u0928\\u094d\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u094b, \\u092c\\u0938 \\u0932\\u093f\\u0902\\u0915 \\u092d\\u0947\\u091c\\u0947\\u0902 \\u0914\\u0930 \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0928\\u0941\\u0938\\u093e\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0926\\u0947\\u0902\\u0964 \\u0916\\u093e\\u0924\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948 - \\u092c\\u0938 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902","button_name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u090f\\u0902","button_link":"user\\/payment-link","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0924\\u0947\\u091c\\u093c \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"672496f92c3b1":{"language":{"en":{"name":"Generate a Payment Link"},"ar":{"name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Generar un enlace de pago"},"fr":{"name":"Generar un enlace de pago"},"hi":{"name":"\\u090f\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"672496f92c3b1"},"672496ffdb248":{"language":{"en":{"name":"Share the Link"},"ar":{"name":"\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637"},"es":{"name":"Comparte el enlace"},"fr":{"name":"Comparte el enlace"},"hi":{"name":"\\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"672496ffdb248"},"67249705758e6":{"language":{"en":{"name":"Receive Payment"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Recibir pago"},"fr":{"name":"Recibir pago"},"hi":{"name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249705758e6"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:53:04','updated_at' => '2024-12-12 18:36:21'),
            array('id' => '8','parent_id' => '8','type' => 'personal','value' => '{"images":{"section_image":"33f24ecf-bcd4-44fc-a9ab-14680a6f8922.webp","step_image":"bc42cf73-34d2-455d-bb22-9fd74dfcd260.webp"},"language":{"en":{"heading":"Effortlessly Request Money with QRPay Pro","sub_heading":"With QRPay Pro\\u2019s Request Money feature, you can quickly send payment requests to anyone. Whether it\\u2019s for a shared expense, a loan repayment, or a service fee, simply enter the amount, send the request, and get paid instantly. It\\u2019s a secure and hassle-free way to manage your finances.","process_step_title":"Request Money in 3 Simple Steps","button_name":"Request Funds Now","button_link":"user\\/request-money","step_title":"How to Request Money with QRPay Pro","step_sub_title":"Follow these simple steps to send a request for payment to anyone using QRPay Pro."},"es":{"heading":"Solicite dinero sin esfuerzo con QRPay Pro","sub_heading":"Con la funci\\u00f3n Solicitar dinero de QRPay Pro, puede enviar r\\u00e1pidamente solicitudes de pago a cualquier persona. Ya sea para un gasto compartido, el pago de un pr\\u00e9stamo o una tarifa de servicio, simplemente ingrese el monto, env\\u00ede la solicitud y reciba el pago al instante. Es una forma segura y sin complicaciones de administrar sus finanzas.","process_step_title":"Solicita dinero en 3 sencillos pasos","button_name":"Solicitar fondos ahora","button_link":"user\\/request-money","step_title":"C\\u00f3mo solicitar dinero con QRPay Pro","step_sub_title":"Siga estos sencillos pasos para enviar una solicitud de pago a cualquier persona que utilice QRPay Pro."},"ar":{"heading":"\\u0627\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"\\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0625\\u0644\\u0649 \\u0623\\u064a \\u0634\\u062e\\u0635. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0631 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0646\\u0641\\u0642\\u0629 \\u0645\\u0634\\u062a\\u0631\\u0643\\u0629\\u060c \\u0623\\u0648 \\u0633\\u062f\\u0627\\u062f \\u0642\\u0631\\u0636\\u060c \\u0623\\u0648 \\u0631\\u0633\\u0648\\u0645 \\u062e\\u062f\\u0645\\u0629\\u060c \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0625\\u062f\\u062e\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0637\\u0644\\u0628 \\u0648\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631. \\u0625\\u0646\\u0647\\u0627 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628 \\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643.","process_step_title":"\\u0627\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0627\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/request-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0637\\u0644\\u0628 \\u0644\\u0644\\u062f\\u0641\\u0639 \\u0625\\u0644\\u0649 \\u0623\\u064a \\u0634\\u062e\\u0635 \\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro."},"fr":{"heading":"Solicite dinero sin esfuerzo con QRPay Pro","sub_heading":"Avec la fonction Request Money de QRPay Pro, vous pouvez envoyer rapidement des demandes de paiement \\u00e0 n\'importe qui. Qu\'il s\'agisse d\'une d\\u00e9pense partag\\u00e9e, d\'un remboursement de pr\\u00eat ou de frais de service, entrez simplement le montant, envoyez la demande et soyez pay\\u00e9 instantan\\u00e9ment. C\\u2019est un moyen s\\u00fbr et sans tracas de g\\u00e9rer vos finances.","process_step_title":"Demandez de l\'argent en 3 \\u00e9tapes simples","button_name":"Demander des fonds maintenant","button_link":"user\\/request-money","step_title":"Comment demander de l\'argent avec QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour envoyer une demande de paiement \\u00e0 toute personne utilisant QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0930\\u093f\\u0915\\u094d\\u0935\\u0947\\u0938\\u094d\\u091f \\u092e\\u0928\\u0940 \\u092b\\u0940\\u091a\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a \\u0915\\u093f\\u0938\\u0940 \\u0915\\u094b \\u092d\\u0940 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0935\\u0939 \\u0938\\u093e\\u091d\\u093e \\u0935\\u094d\\u092f\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u094b, \\u090b\\u0923 \\u092a\\u0941\\u0928\\u0930\\u094d\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u094b, \\u092f\\u093e \\u0938\\u0947\\u0935\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u094b, \\u092c\\u0938 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c\\u0947\\u0902 \\u0914\\u0930 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u092f\\u0939 \\u0906\\u092a\\u0915\\u0947 \\u0935\\u093f\\u0924\\u094d\\u0924 \\u0915\\u094b \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924 \\u0924\\u0930\\u0940\\u0915\\u093e \\u0939\\u0948\\u0964","process_step_title":"3 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/request-money","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724985094bee":{"language":{"en":{"name":"Enter Request Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0637\\u0644\\u0628"},"es":{"name":"Ingrese los detalles de la solicitud"},"fr":{"name":"Entrez les d\\u00e9tails de la demande"},"hi":{"name":"\\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724985094bee"},"67249857752b8":{"language":{"en":{"name":"Send the Request"},"ar":{"name":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0637\\u0644\\u0628"},"es":{"name":"Enviar la solicitud"},"fr":{"name":"Envoyer la demande"},"hi":{"name":"\\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c\\u0947\\u0902"}},"id":"67249857752b8"},"6724985e429ec":{"language":{"en":{"name":"Receive Notification"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0625\\u062e\\u0637\\u0627\\u0631"},"es":{"name":"Recibir notificaci\\u00f3n"},"fr":{"name":"Recevoir une notification"},"hi":{"name":"\\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724985e429ec"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:58:48','updated_at' => '2024-12-12 18:36:48'),
            array('id' => '9','parent_id' => '9','type' => 'personal','value' => '{"images":{"section_image":"975939bc-aa8a-401e-886f-35494adc0e4f.webp","step_image":"1a249f43-394f-4b85-8c3f-66aae4203f60.webp"},"language":{"en":{"heading":"Send Remittances Quickly and Securely with QRPay Pro","sub_heading":"QRPay Pro makes international money transfers simple and reliable. Whether you\\u2019re sending money to support family members abroad or paying bills for friends, our remittance service ensures your funds arrive safely and swiftly. With competitive rates and real-time tracking, you can send money confidently, knowing it\\u2019s in good hands.","process_step_title":"Remit Funds in 3 Easy Steps","button_name":"Start Sending Remittance Now","button_link":"user\\/remittance","step_title":"How to Use QRPay Pro for Remittances","step_sub_title":"Follow these simple steps to send remittance funds anywhere in the world using QRPay Pro."},"es":{"heading":"Env\\u00ede remesas de forma r\\u00e1pida y segura con QRPay Pro","sub_heading":"QRPay Pro hace que las transferencias de dinero internacionales sean simples y confiables. Ya sea que env\\u00ede dinero para mantener a familiares en el extranjero o pague facturas de amigos, nuestro servicio de remesas garantiza que sus fondos lleguen de forma segura y r\\u00e1pida. Con tarifas competitivas y seguimiento en tiempo real, puede enviar dinero con confianza sabiendo que est\\u00e1 en buenas manos.","process_step_title":"Enviar fondos en 3 sencillos pasos","button_name":"Comience a enviar remesas ahora","button_link":"user\\/remittance","step_title":"C\\u00f3mo utilizar QRPay Pro para remesas","step_sub_title":"Siga estos sencillos pasos para enviar fondos de remesas a cualquier parte del mundo utilizando QRPay Pro."},"ar":{"heading":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0645\\u0639 QRPay Pro","sub_heading":"QRPay Pro \\u064a\\u062c\\u0639\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629 \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u062a\\u0631\\u0633\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0627\\u064b \\u0644\\u062f\\u0639\\u0645 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0639\\u0627\\u0626\\u0644\\u062a\\u0643 \\u0641\\u064a \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c \\u0623\\u0648 \\u062a\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0626\\u0643\\u060c \\u0641\\u0625\\u0646 \\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0644\\u062f\\u064a\\u0646\\u0627 \\u062a\\u0636\\u0645\\u0646 \\u0648\\u0635\\u0648\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0623\\u0645\\u0627\\u0646 \\u0648\\u0633\\u0631\\u0639\\u0629. \\u0628\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u062a\\u0628\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u062b\\u0642\\u0629\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0644\\u0645 \\u0623\\u0646\\u0647\\u0627 \\u0641\\u064a \\u0623\\u064a\\u062f\\u064d \\u0623\\u0645\\u064a\\u0646\\u0629.","process_step_title":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u062d\\u0648\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/remittance","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro \\u0644\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0625\\u0644\\u0649 \\u0623\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0641\\u064a \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"fr":{"heading":"Env\\u00ede remesas de forma r\\u00e1pida y segura con QRPay Pro","sub_heading":"QRPay Pro rend les transferts d\'argent internationaux simples et fiables. Que vous envoyiez de l\'argent pour subvenir aux besoins de membres de votre famille \\u00e0 l\'\\u00e9tranger ou que vous payiez des factures \\u00e0 des amis, notre service de transfert de fonds garantit que vos fonds arrivent rapidement et en toute s\\u00e9curit\\u00e9. Avec des tarifs comp\\u00e9titifs et un suivi en temps r\\u00e9el, vous pouvez envoyer de l\\u2019argent en toute confiance, sachant qu\\u2019il est entre de bonnes mains.","process_step_title":"Transf\\u00e9rer des fonds en 3 \\u00e9tapes faciles","button_name":"Commencez \\u00e0 envoyer des fonds maintenant","button_link":"user\\/remittance","step_title":"Comment utiliser QRPay Pro pour les envois de fonds","step_sub_title":"Suivez ces \\u00e9tapes simples pour envoyer des fonds partout dans le monde \\u00e0 l\'aide de QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0947\\u0902","sub_heading":"QRPay Pro \\u0905\\u0902\\u0924\\u0930\\u094d\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u094b \\u0938\\u0930\\u0932 \\u0914\\u0930 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a \\u0935\\u093f\\u0926\\u0947\\u0936 \\u092e\\u0947\\u0902 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0915\\u0947 \\u0938\\u0926\\u0938\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0927\\u0928 \\u092d\\u0947\\u091c \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902 \\u092f\\u093e \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u093f\\u0932 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902, \\u0939\\u092e\\u093e\\u0930\\u0940 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0938\\u0947\\u0935\\u093e \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a\\u0915\\u093e \\u0927\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0924\\u0947\\u091c\\u0940 \\u0938\\u0947 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0964 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0926\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0915\\u0940 \\u091f\\u094d\\u0930\\u0948\\u0915\\u093f\\u0902\\u0917 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a \\u0906\\u0924\\u094d\\u092e\\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u093e \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092f\\u0939 \\u091c\\u093e\\u0928\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0915\\u093f \\u092f\\u0939 \\u0905\\u091a\\u094d\\u091b\\u0947 \\u0939\\u093e\\u0925\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092d\\u0947\\u091c\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/remittance","step_title":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0926\\u0941\\u0928\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0915\\u0939\\u0940\\u0902 \\u092d\\u0940 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249928d6543":{"language":{"en":{"name":"Enter Recipient Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645"},"es":{"name":"Ingrese los detalles del destinatario"},"fr":{"name":"Ingrese los detalles del destinatario"},"hi":{"name":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"67249928d6543"},"67249930052f4":{"language":{"en":{"name":"Choose Transfer Method"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0646\\u0642\\u0644"},"es":{"name":"Elija el m\\u00e9todo de transferencia"},"fr":{"name":"Elija el m\\u00e9todo de transferencia"},"hi":{"name":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"67249930052f4"},"6724993747058":{"language":{"en":{"name":"Confirm and Send"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644"},"es":{"name":"Confirmar y enviar"},"fr":{"name":"Confirmar y enviar"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0947\\u0902"}},"id":"6724993747058"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:02:21','updated_at' => '2024-12-12 18:37:23'),
            array('id' => '10','parent_id' => '10','type' => 'personal','value' => '{"images":{"section_image":"8536606e-b16d-4f8f-8ede-ac0066ea23ec.webp","step_image":"55a99f4b-489d-44a7-90d7-e38af5286315.webp"},"language":{"en":{"heading":"Easily Add Funds to Your QRPay Pro Account","sub_heading":"With QRPay Pro, adding money to your account is fast and straightforward. Whether you\\u2019re funding your wallet for future transactions or ensuring you have a balance ready for bills and purchases, our seamless process makes it simple to add funds anytime, anywhere. Enjoy peace of mind with secure transactions and multiple funding options.","process_step_title":"Add Money in 3 Simple Steps","button_name":"Add Funds Now","button_link":"user\\/add-money","step_title":"How to Add Money to Your QRPay Pro Account","step_sub_title":"Follow these straightforward steps to deposit funds into your QRPay Pro account effortlessly."},"es":{"heading":"Agregue fondos f\\u00e1cilmente a su cuenta QRPay Pro","sub_heading":"Con QRPay Pro, agregar dinero a su cuenta es r\\u00e1pido y sencillo. Ya sea que est\\u00e9 financiando su billetera para transacciones futuras o asegur\\u00e1ndose de tener un saldo listo para facturas y compras, nuestro proceso fluido simplifica la adici\\u00f3n de fondos en cualquier momento y en cualquier lugar. Disfrute de la tranquilidad con transacciones seguras y m\\u00faltiples opciones de financiaci\\u00f3n.","process_step_title":"Agregue dinero en 3 simples pasos","button_name":"Agregar fondos ahora","button_link":"user\\/add-money","step_title":"C\\u00f3mo agregar dinero a su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para depositar fondos en su cuenta QRPay Pro sin esfuerzo."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u062a\\u0639\\u062f \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0633\\u0631\\u064a\\u0639\\u064b\\u0627 \\u0648\\u0645\\u0628\\u0627\\u0634\\u0631\\u064b\\u0627. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u062a\\u0642\\u0648\\u0645 \\u0628\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0642\\u0628\\u0644\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0644\\u062f\\u064a\\u0643 \\u0631\\u0635\\u064a\\u062f\\u064b\\u0627 \\u062c\\u0627\\u0647\\u0632\\u064b\\u0627 \\u0644\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u064a\\u0627\\u062a\\u060c \\u0641\\u0625\\u0646 \\u0639\\u0645\\u0644\\u064a\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0633\\u0629 \\u062a\\u062c\\u0639\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0647\\u0644 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a \\u0648\\u0641\\u064a \\u0623\\u064a \\u0645\\u0643\\u0627\\u0646. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629.","process_step_title":"\\u0623\\u0636\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0623\\u0636\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/add-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u0625\\u064a\\u062f\\u0627\\u0639 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621."},"fr":{"heading":"Agregue fondos f\\u00e1cilmente a su cuenta QRPay Pro","sub_heading":"Avec QRPay Pro, ajouter de l\'argent sur votre compte est rapide et simple. Que vous approvisionniez votre portefeuille pour de futures transactions ou que vous vous assuriez d\'avoir un solde pr\\u00eat pour les factures et les achats, notre processus transparent facilite l\'ajout de fonds \\u00e0 tout moment et en tout lieu. Profitez d\'une tranquillit\\u00e9 d\'esprit gr\\u00e2ce \\u00e0 des transactions s\\u00e9curis\\u00e9es et \\u00e0 de multiples options de financement.","process_step_title":"Ajoutez de l\'argent en 3 \\u00e9tapes simples","button_name":"Ajouter des fonds maintenant","button_link":"user\\/add-money","step_title":"Comment ajouter de l\'argent \\u00e0 votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour d\\u00e9poser des fonds sur votre compte QRPay Pro sans effort."},"hi":{"heading":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u093e \\u0924\\u0947\\u091c\\u093c \\u0914\\u0930 \\u0938\\u0930\\u0932 \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a \\u092d\\u0935\\u093f\\u0937\\u094d\\u092f \\u0915\\u0947 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 \\u092c\\u091f\\u0941\\u090f \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u0932\\u0917\\u093e \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902 \\u092f\\u093e \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902 \\u0915\\u093f \\u0906\\u092a\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0914\\u0930 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0936\\u0947\\u0937 \\u0930\\u093e\\u0936\\u093f \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0939\\u0948, \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0938\\u092e\\u092f, \\u0915\\u0939\\u0940\\u0902 \\u092d\\u0940 \\u0927\\u0928 \\u091c\\u094b\\u0921\\u093c\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0914\\u0930 \\u0915\\u0908 \\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915 \\u0936\\u093e\\u0902\\u0924\\u093f \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902","button_link":"user\\/add-money","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249a18b8964":{"language":{"en":{"name":"Select Funding Source"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0645\\u0635\\u062f\\u0631 \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644"},"es":{"name":"Seleccionar fuente de financiamiento"},"fr":{"name":"Seleccionar fuente de financiamiento"},"hi":{"name":"\\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0938\\u094d\\u0930\\u094b\\u0924 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249a18b8964"},"67249a1f07139":{"language":{"en":{"name":"Enter Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese el monto"},"fr":{"name":"Ingrese el monto"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0921\\u093e\\u0932\\u0947\\u0902"}},"id":"67249a1f07139"},"67249a248a80d":{"language":{"en":{"name":"Confirm the Transaction"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629"},"es":{"name":"Confirmar la transacci\\u00f3n"},"fr":{"name":"Confirmar la transacci\\u00f3n"},"hi":{"name":"\\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"67249a248a80d"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:06:25','updated_at' => '2024-12-12 18:37:54'),
            array('id' => '11','parent_id' => '11','type' => 'personal','value' => '{"images":{"section_image":"bab98721-83ae-4a7d-b4f8-499a0f828c74.webp","step_image":"2167781a-e9eb-449a-a9eb-5e23f1c411f3.webp"},"language":{"en":{"heading":"Effortlessly Withdraw Funds from Your QRPay Pro Account","sub_heading":"With QRPay Pro, withdrawing your money is quick and secure. Whether you need cash for your daily expenses or want to transfer funds to your bank account, our streamlined withdrawal process makes it simple to access your funds when you need them. Enjoy peace of mind with robust security measures protecting your transactions.","process_step_title":"Withdraw Money in 3 Simple Steps","button_name":"Withdraw Funds Now","button_link":"user\\/withdraw","step_title":"How to Withdraw Money from Your QRPay Pro Account","step_sub_title":"Follow these easy steps to withdraw funds from your QRPay Pro account seamlessly."},"es":{"heading":"Retire fondos sin esfuerzo de su cuenta QRPay Pro","sub_heading":"Con QRPay Pro, retirar tu dinero es r\\u00e1pido y seguro. Ya sea que necesite efectivo para sus gastos diarios o desee transferir fondos a su cuenta bancaria, nuestro proceso de retiro simplificado simplifica el acceso a sus fondos cuando los necesita. Disfrute de la tranquilidad con s\\u00f3lidas medidas de seguridad que protegen sus transacciones.","process_step_title":"Retirar dinero en 3 sencillos pasos","button_name":"Retirar fondos ahora","button_link":"user\\/withdraw","step_title":"C\\u00f3mo retirar dinero de su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para retirar fondos de su cuenta QRPay Pro sin problemas."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u0633\\u062d\\u0628 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0633\\u0631\\u064a\\u0639\\u064b\\u0627 \\u0648\\u0622\\u0645\\u0646\\u064b\\u0627. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0646\\u0642\\u062f\\u064a\\u0629 \\u0644\\u062a\\u063a\\u0637\\u064a\\u0629 \\u0646\\u0641\\u0642\\u0627\\u062a\\u0643 \\u0627\\u0644\\u064a\\u0648\\u0645\\u064a\\u0629 \\u0623\\u0648 \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u060c \\u0641\\u0625\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0628\\u0633\\u0637\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u062a\\u062c\\u0639\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0647\\u0644 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u064a\\u0647\\u0627. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0645\\u064a \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643.","process_step_title":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/withdraw","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629."},"fr":{"heading":"Retire fondos sin esfuerzo de su cuenta QRPay Pro","sub_heading":"Avec QRPay Pro, retirer votre argent est rapide et s\\u00e9curis\\u00e9. Que vous ayez besoin d\'argent pour vos d\\u00e9penses quotidiennes ou que vous souhaitiez transf\\u00e9rer des fonds sur votre compte bancaire, notre processus de retrait simplifi\\u00e9 facilite l\'acc\\u00e8s \\u00e0 vos fonds lorsque vous en avez besoin. Profitez d\'une tranquillit\\u00e9 d\'esprit gr\\u00e2ce \\u00e0 des mesures de s\\u00e9curit\\u00e9 robustes prot\\u00e9geant vos transactions.","process_step_title":"Retirer de l\'argent en 3 \\u00e9tapes simples","button_name":"Retirer des fonds maintenant","button_link":"user\\/withdraw","step_title":"Comment retirer de l\'argent de votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour retirer des fonds de votre compte QRPay Pro en toute transparence."},"hi":{"heading":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0905\\u092a\\u0928\\u093e \\u092a\\u0948\\u0938\\u093e \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u093e \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0926\\u0948\\u0928\\u093f\\u0915 \\u0916\\u0930\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u0915\\u0926\\u0940 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b \\u092f\\u093e \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u094b\\u0902, \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u0941\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093f\\u0924 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u091c\\u0930\\u0942\\u0930\\u0924 \\u092a\\u0921\\u093c\\u0928\\u0947 \\u092a\\u0930 \\u0906\\u092a\\u0915\\u0947 \\u0927\\u0928 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928 \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0928\\u0947 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092e\\u091c\\u092c\\u0942\\u0924 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915 \\u0936\\u093e\\u0902\\u0924\\u093f \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","button_link":"user\\/withdraw","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249ac22c6bd":{"language":{"en":{"name":"Choose Withdrawal Method"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Elija el m\\u00e9todo de retiro"},"fr":{"name":"Elija el m\\u00e9todo de retiro"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"67249ac22c6bd"},"67249ac80326e":{"language":{"en":{"name":"Enter Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese el monto"},"fr":{"name":"Ingrese el monto"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0921\\u093e\\u0932\\u0947\\u0902"}},"id":"67249ac80326e"},"67249acd4186f":{"language":{"en":{"name":"Confirm the Transaction"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629"},"es":{"name":"Confirmar la transacci\\u00f3n"},"fr":{"name":"Confirmar la transacci\\u00f3n"},"hi":{"name":"\\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"67249acd4186f"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:09:15','updated_at' => '2024-12-31 12:26:00'),
            array('id' => '12','parent_id' => '12','type' => 'personal','value' => '{"images":{"section_image":"4d37f2ff-4896-4026-9446-9b3ff64e72f7.webp","step_image":"90201c5b-2a67-4443-aad2-cf6a19b03edc.webp"},"language":{"en":{"heading":"Quick and Convenient Payments to QRPay Pro Merchants","sub_heading":"With QRPay Pro, making payments for your purchases has never been easier. As a user, you can effortlessly transfer funds to merchants registered on the QRPay Pro platform. Enjoy the convenience of using your QRPay Pro account for all your transactions while benefiting from robust security measures that protect your financial information.","process_step_title":"Make Payments in 3 Simple Steps","button_name":"Make a Payment Now","button_link":"user\\/make-payment","step_title":"How to Make a Payment to QRPay Pro Merchants","step_sub_title":"Follow these straightforward steps to complete your payment effortlessly."},"es":{"heading":"Pagos r\\u00e1pidos y convenientes a comerciantes de QRPay Pro","sub_heading":"Con QRPay Pro realizar pagos de tus compras nunca ha sido tan f\\u00e1cil. Como usuario, puede transferir fondos sin esfuerzo a comerciantes registrados en la plataforma QRPay Pro. Disfrute de la comodidad de utilizar su cuenta QRPay Pro para todas sus transacciones mientras se beneficia de s\\u00f3lidas medidas de seguridad que protegen su informaci\\u00f3n financiera.","process_step_title":"Realice pagos en 3 sencillos pasos","button_name":"Realizar un pago ahora","button_link":"user\\/make-payment","step_title":"C\\u00f3mo realizar un pago a comerciantes de QRPay Pro","step_sub_title":"Siga estos sencillos pasos para completar su pago sin esfuerzo."},"ar":{"heading":"\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0645\\u0631\\u064a\\u062d\\u0629 \\u0644\\u062a\\u062c\\u0627\\u0631 QRPay Pro","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0645\\u0634\\u062a\\u0631\\u064a\\u0627\\u062a\\u0643 \\u0623\\u0633\\u0647\\u0644 \\u0645\\u0646 \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0636\\u0649. \\u0643\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0633\\u062c\\u0644\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0645\\u0646\\u0635\\u0629 QRPay Pro. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0645\\u0639 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0645\\u064a \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629.","process_step_title":"\\u0642\\u0645 \\u0628\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0642\\u0645 \\u0628\\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/make-payment","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u062a\\u062c\\u0627\\u0631 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u0625\\u0643\\u0645\\u0627\\u0644 \\u062f\\u0641\\u0639\\u062a\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621."},"fr":{"heading":"Pagos r\\u00e1pidos y convenientes a comerciantes de QRPay Pro","sub_heading":"Avec QRPay Pro, effectuer des paiements pour vos achats n\'a jamais \\u00e9t\\u00e9 aussi simple. En tant qu\'utilisateur, vous pouvez facilement transf\\u00e9rer des fonds aux commer\\u00e7ants enregistr\\u00e9s sur la plateforme QRPay Pro. Profitez de la commodit\\u00e9 d\'utiliser votre compte QRPay Pro pour toutes vos transactions tout en b\\u00e9n\\u00e9ficiant de mesures de s\\u00e9curit\\u00e9 robustes qui prot\\u00e8gent vos informations financi\\u00e8res.","process_step_title":"Effectuez des paiements en 3 \\u00e9tapes simples","button_name":"Effectuer un paiement maintenant","button_link":"user\\/make-payment","step_title":"Comment effectuer un paiement aux marchands QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour effectuer votre paiement sans effort."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0905\\u092a\\u0928\\u0940 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0907\\u0924\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0915\\u092d\\u0940 \\u0928\\u0939\\u0940\\u0902 \\u0930\\u0939\\u093e\\u0964 \\u090f\\u0915 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902, \\u0906\\u092a QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092a\\u0930 \\u092a\\u0902\\u091c\\u0940\\u0915\\u0943\\u0924 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0905\\u092a\\u0928\\u0940 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092e\\u091c\\u092c\\u0942\\u0924 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u0932\\u093e\\u092d \\u0909\\u0920\\u093e\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0905\\u092a\\u0928\\u0947 \\u0938\\u092d\\u0940 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/make-payment","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249bf0b6879":{"language":{"en":{"name":"Scan Merchant QRCode"},"ar":{"name":"\\u0645\\u0633\\u062d \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0644\\u0644\\u062a\\u0627\\u062c\\u0631"},"es":{"name":"Escanear el c\\u00f3digo QR del comerciante"},"fr":{"name":"Escanear el c\\u00f3digo QR del comerciante"},"hi":{"name":"\\u092e\\u0930\\u094d\\u091a\\u0947\\u0902\\u091f QRCode \\u0915\\u094b \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249bf0b6879"},"67249bfb359a1":{"language":{"en":{"name":"Enter Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese el monto"},"fr":{"name":"Ingrese el monto"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0921\\u093e\\u0932\\u0947\\u0902"}},"id":"67249bfb359a1"},"67249c0627136":{"language":{"en":{"name":"Confirm the Payment"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Confirmar el pago"},"fr":{"name":"Confirmar el pago"},"hi":{"name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f"}},"id":"67249c0627136"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:13:59','updated_at' => '2024-12-12 18:38:50'),
            array('id' => '13','parent_id' => '13','type' => 'personal','value' => '{"images":{"section_image":"958e8e32-c3ed-4a09-ab06-44f27c86abce.webp","step_image":"a6e95d6a-bcdc-406d-b97c-0c30d42db0a5.webp"},"language":{"en":{"heading":"Quick and Secure Withdrawals to QRPay Pro Agents","sub_heading":"With QRPay Pro, accessing your funds has never been easier. Users can withdraw money from their QRPay Pro account to trusted QRPay Pro agents. Enjoy peace of mind with every transaction, knowing your funds are secure and the process is hassle-free.","process_step_title":"Withdraw Funds in 3 Simple Steps","button_name":"Withdraw Money Now","button_link":"user\\/money-out","step_title":"How to Withdraw Money from Your QRPay Pro Account","step_sub_title":"Follow these straightforward steps to securely transfer your funds to a QRPay Pro agent."},"es":{"heading":"Retiros r\\u00e1pidos y seguros a agentes QRPay Pro","sub_heading":"Con QRPay Pro, acceder a sus fondos nunca ha sido tan f\\u00e1cil. Los usuarios pueden retirar dinero de su cuenta QRPay Pro a agentes QRPay Pro confiables. Disfrute de la tranquilidad con cada transacci\\u00f3n, sabiendo que sus fondos est\\u00e1n seguros y el proceso es sencillo.","process_step_title":"Retirar fondos en 3 sencillos pasos","button_name":"Retirar dinero ahora","button_link":"user\\/money-out","step_title":"C\\u00f3mo retirar dinero de su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para transferir sus fondos de forma segura a un agente de QRPay Pro."},"ar":{"heading":"\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0633\\u062d\\u0628 \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u0644\\u0627\\u0621 QRPay Pro","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0623\\u0633\\u0647\\u0644 \\u0645\\u0646 \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0636\\u0649. \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0647\\u0645 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u0644\\u0627\\u0621 QRPay Pro \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u064a\\u0646. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644 \\u0645\\u0639 \\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0644\\u0645 \\u0623\\u0646 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0623\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628.","process_step_title":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/money-out","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 QRPay Pro."},"fr":{"heading":"Retiros r\\u00e1pidos y seguros a agentes QRPay Pro","sub_heading":"Avec QRPay Pro, acc\\u00e9der \\u00e0 vos fonds n\'a jamais \\u00e9t\\u00e9 aussi simple. Les utilisateurs peuvent retirer de l\'argent de leur compte QRPay Pro vers des agents QRPay Pro de confiance. Ayez l\'esprit tranquille \\u00e0 chaque transaction, sachant que vos fonds sont en s\\u00e9curit\\u00e9 et que le processus se d\\u00e9roule sans tracas.","process_step_title":"Retirer des fonds en 3 \\u00e9tapes simples","button_name":"Retirer de l\'argent maintenant","button_link":"user\\/money-out","step_title":"Comment retirer de l\'argent de votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour transf\\u00e9rer en toute s\\u00e9curit\\u00e9 vos fonds vers un agent QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a\\u0915\\u0947 \\u092b\\u0902\\u0921 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a \\u0915\\u092d\\u0940 \\u0907\\u0924\\u0928\\u0940 \\u0906\\u0938\\u093e\\u0928 \\u0928\\u0939\\u0940\\u0902 \\u0930\\u0939\\u0940\\u0964 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915 \\u0936\\u093e\\u0902\\u0924\\u093f \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902, \\u092f\\u0939 \\u091c\\u093e\\u0928\\u0915\\u0930 \\u0915\\u093f \\u0906\\u092a\\u0915\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924 \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","button_link":"user\\/money-out","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 \\u092b\\u0902\\u0921 \\u0915\\u094b QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249ccf1b85e":{"language":{"en":{"name":"Scan QRPay Pro Agent\'s QRCode"},"ar":{"name":"\\u0642\\u0645 \\u0628\\u0645\\u0633\\u062d QRCode \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0648\\u0643\\u064a\\u0644 QRPay Pro"},"es":{"name":"Escanee el c\\u00f3digo QR del agente QRPay Pro"},"fr":{"name":"Escanee el c\\u00f3digo QR del agente QRPay Pro"},"hi":{"name":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 QRCode \\u0915\\u094b \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249ccf1b85e"},"67249cd59b605":{"language":{"en":{"name":"Enter Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese el monto"},"fr":{"name":"Ingrese el monto"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0921\\u093e\\u0932\\u0947\\u0902"}},"id":"67249cd59b605"},"67249cdb11e84":{"language":{"en":{"name":"Specify the amount you wish to withdraw from your QRPayPro account."},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u0633\\u062d\\u0628\\u0647 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPayPro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"name":"Especifique el monto que desea retirar de su cuenta QRPayPro."},"fr":{"name":"Especifique el monto que desea retirar de su cuenta QRPayPro."},"hi":{"name":"\\u0935\\u0939 \\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902 \\u091c\\u093f\\u0938\\u0947 \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 QRPayPro \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249cdb11e84"},"67249ce09bf45":{"language":{"en":{"name":"Confirm the Withdrawal"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0627\\u0646\\u0633\\u062d\\u0627\\u0628"},"es":{"name":"Confirmar el retiro"},"fr":{"name":"Confirmar el retiro"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"67249ce09bf45"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:17:59','updated_at' => '2024-12-12 18:39:20'),
            array('id' => '14','parent_id' => '14','type' => 'personal','value' => '{"images":{"section_image":"aa013ae0-d785-4156-9650-8f92ea480df9.webp","step_image":"cc5b11d0-c369-4360-87f3-663874a7ee96.webp"},"language":{"en":{"heading":"Enjoy Safe Online Shopping with QRPay Pro Virtual Cards","sub_heading":"With QRPay Pro\'s virtual card feature, you can make online purchases without revealing your actual credit card details. Generate a virtual card in seconds and use it for all your online transactions with confidence, knowing that your financial information is protected.","process_step_title":"Generate Your Virtual Card in 3 Simple Steps","button_name":"Create a Virtual Card Now","button_link":"user\\/strowallet-virtual-card","step_title":"How to Create and Use Your QRPay Pro Virtual Card","step_sub_title":"Follow these easy steps to set up your virtual card for secure online payments."},"es":{"heading":"Disfrute de compras seguras en l\\u00ednea con las tarjetas virtuales QRPay Pro","sub_heading":"Con la funci\\u00f3n de tarjeta virtual de QRPay Pro, puede realizar compras en l\\u00ednea sin revelar los datos reales de su tarjeta de cr\\u00e9dito. Genera una tarjeta virtual en segundos y \\u00fasala para todas tus transacciones en l\\u00ednea con confianza, sabiendo que tu informaci\\u00f3n financiera est\\u00e1 protegida.","process_step_title":"Genera tu tarjeta virtual en 3 sencillos pasos","button_name":"Crea una tarjeta virtual ahora","button_link":"user\\/strowallet-virtual-card","step_title":"C\\u00f3mo crear y utilizar su tarjeta virtual QRPay Pro","step_sub_title":"Siga estos sencillos pasos para configurar su tarjeta virtual para pagos seguros en l\\u00ednea."},"ar":{"heading":"\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0627\\u0644\\u062a\\u0633\\u0648\\u0642 \\u0627\\u0644\\u0622\\u0645\\u0646 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u0639 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a QRPay Pro \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","sub_heading":"\\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0634\\u0631\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u062f\\u0648\\u0646 \\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629. \\u0623\\u0646\\u0634\\u0626 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0641\\u064a \\u062b\\u0648\\u0627\\u0646\\u064d \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0645\\u0647\\u0627 \\u0641\\u064a \\u062c\\u0645\\u064a\\u0639 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0628\\u0643\\u0644 \\u062b\\u0642\\u0629\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0644\\u0645 \\u0623\\u0646 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0645\\u062d\\u0645\\u064a\\u0629.","process_step_title":"\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0623\\u0646\\u0634\\u0626 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/strowallet-virtual-card","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 QRPay Pro \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u0625\\u0639\\u062f\\u0627\\u062f \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062f\\u0641\\u0639 \\u0622\\u0645\\u0646\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a."},"fr":{"heading":"Disfrute de compras seguras en l\\u00ednea con las tarjetas virtuales QRPay Pro","sub_heading":"Avec la fonctionnalit\\u00e9 de carte virtuelle de QRPay Pro, vous pouvez effectuer des achats en ligne sans r\\u00e9v\\u00e9ler les d\\u00e9tails r\\u00e9els de votre carte de cr\\u00e9dit. G\\u00e9n\\u00e9rez une carte virtuelle en quelques secondes et utilisez-la pour toutes vos transactions en ligne en toute confiance, sachant que vos informations financi\\u00e8res sont prot\\u00e9g\\u00e9es.","process_step_title":"G\\u00e9n\\u00e9rez votre carte virtuelle en 3 \\u00e9tapes simples","button_name":"Cr\\u00e9ez une carte virtuelle maintenant","button_link":"user\\/strowallet-virtual-card","step_title":"Comment cr\\u00e9er et utiliser votre carte virtuelle QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour configurer votre carte virtuelle pour des paiements en ligne s\\u00e9curis\\u00e9s."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0936\\u0949\\u092a\\u093f\\u0902\\u0917 \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0940 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u093e \\u0916\\u0941\\u0932\\u093e\\u0938\\u093e \\u0915\\u093f\\u090f \\u092c\\u093f\\u0928\\u093e \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0941\\u091b \\u0939\\u0940 \\u0938\\u0947\\u0915\\u0902\\u0921 \\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0906\\u0924\\u094d\\u092e\\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 \\u0938\\u092d\\u0940 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0938\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902, \\u092f\\u0939 \\u091c\\u093e\\u0928\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0915\\u093f \\u0906\\u092a\\u0915\\u0940 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u093e \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u090f\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u090f\\u0915 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u090f\\u0902","button_link":"user\\/strowallet-virtual-card","step_title":"\\u0905\\u092a\\u0928\\u093e QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0948\\u0938\\u0947 \\u092c\\u0928\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0938\\u0947\\u091f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249dc22b315":{"language":{"en":{"name":"Generate a Virtual Card"},"ar":{"name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629"},"es":{"name":"Generar una tarjeta virtual"},"fr":{"name":"Generar una tarjeta virtual"},"hi":{"name":"\\u090f\\u0915 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"67249dc22b315"},"67249dc95f68e":{"language":{"en":{"name":"Set Your Preferences"},"ar":{"name":"\\u0627\\u0636\\u0628\\u0637 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643"},"es":{"name":"Establece tus preferencias"},"fr":{"name":"Establece tus preferencias"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0940 \\u092a\\u094d\\u0930\\u093e\\u0925\\u092e\\u093f\\u0915\\u0924\\u093e\\u090f\\u0901 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249dc95f68e"},"67249dcebbeee":{"language":{"en":{"name":"Use Your Card for Online Purchases"},"ar":{"name":"\\u0627\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a"},"es":{"name":"Utilice su tarjeta para compras en l\\u00ednea"},"fr":{"name":"Utilice su tarjeta para compras en l\\u00ednea"},"hi":{"name":"\\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249dcebbeee"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:22:02','updated_at' => '2024-12-12 18:39:41'),
            array('id' => '15','parent_id' => '15','type' => 'personal','value' => '{"images":{"section_image":"eadf7d55-b05f-41ac-8b81-6e17f8e509f3.webp","step_image":"920a0609-3cd4-447e-87c3-1e31398fd448.webp"},"language":{"en":{"heading":"Send Joy with QRPay Pro Gift Cards","sub_heading":"QRPay Pro allows you to purchase and send digital gift cards for a variety of services, making gifting easy and thoughtful. Whether it\'s for a birthday, holiday, or just because, our gift cards are the perfect way to show you care. Enjoy a seamless buying experience and share happiness with friends and family.","process_step_title":"Buy a Gift Card in 3 Simple Steps","button_name":"Get Your Gift Card Now","button_link":"user\\/gift-card","step_title":"How to Purchase and Send a Gift Card","step_sub_title":"Follow these simple steps to easily purchase and send a gift card through QRPay Pro."},"es":{"heading":"Env\\u00eda alegr\\u00eda con tarjetas de regalo QRPay Pro","sub_heading":"QRPay Pro le permite comprar y enviar tarjetas de regalo digitales para una variedad de servicios, lo que hace que regalar sea f\\u00e1cil y reflexivo. Ya sea para un cumplea\\u00f1os, un d\\u00eda festivo o simplemente porque s\\u00ed, nuestras tarjetas de regalo son la manera perfecta de demostrar que te preocupas. Disfrute de una experiencia de compra perfecta y comparta la felicidad con amigos y familiares.","process_step_title":"Compra una tarjeta regalo en 3 sencillos pasos","button_name":"Obtenga su tarjeta de regalo ahora","button_link":"user\\/gift-card","step_title":"C\\u00f3mo comprar y enviar una tarjeta de regalo","step_sub_title":"Siga estos sencillos pasos para comprar y enviar f\\u00e1cilmente una tarjeta de regalo a trav\\u00e9s de QRPay Pro."},"ar":{"heading":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062d \\u0645\\u0639 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0647\\u062f\\u0627\\u064a\\u0627 QRPay Pro","sub_heading":"\\u064a\\u062a\\u064a\\u062d \\u0644\\u0643 QRPay Pro \\u0634\\u0631\\u0627\\u0621 \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0644\\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0633\\u0647\\u0644\\u0629 \\u0648\\u0645\\u062f\\u0631\\u0648\\u0633\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646 \\u0630\\u0644\\u0643 \\u0644\\u0639\\u064a\\u062f \\u0645\\u064a\\u0644\\u0627\\u062f\\u060c \\u0623\\u0648 \\u0639\\u0637\\u0644\\u0629\\u060c \\u0623\\u0648 \\u0644\\u0645\\u062c\\u0631\\u062f \\u0630\\u0644\\u0643\\u060c \\u0641\\u0625\\u0646 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062b\\u0627\\u0644\\u064a\\u0629 \\u0644\\u0625\\u0638\\u0647\\u0627\\u0631 \\u0627\\u0647\\u062a\\u0645\\u0627\\u0645\\u0643. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0634\\u0631\\u0627\\u0621 \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0634\\u0627\\u0631\\u0643 \\u0627\\u0644\\u0633\\u0639\\u0627\\u062f\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0623\\u0635\\u062f\\u0642\\u0627\\u0621 \\u0648\\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629.","process_step_title":"\\u0642\\u0645 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/gift-card","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0634\\u0631\\u0627\\u0621 \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u064a\\u0629","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644\\u0647\\u0627 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro."},"fr":{"heading":"Env\\u00eda alegr\\u00eda con tarjetas de regalo QRPay Pro","sub_heading":"QRPay Pro vous permet d\'acheter et d\'envoyer des cartes-cadeaux num\\u00e9riques pour une vari\\u00e9t\\u00e9 de services, rendant les cadeaux faciles et r\\u00e9fl\\u00e9chis. Que ce soit pour un anniversaire, des vacances ou tout simplement parce que nos cartes cadeaux sont le moyen id\\u00e9al de montrer votre attention. Profitez d\'une exp\\u00e9rience d\'achat fluide et partagez votre bonheur avec vos amis et votre famille.","process_step_title":"Achetez une carte-cadeau en 3 \\u00e9tapes simples","button_name":"Obtenez votre carte-cadeau maintenant","button_link":"user\\/gift-card","step_title":"Comment acheter et envoyer une carte-cadeau","step_sub_title":"Suivez ces \\u00e9tapes simples pour acheter et envoyer facilement une carte-cadeau via QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0916\\u0941\\u0936\\u0940 \\u092d\\u0947\\u091c\\u0947\\u0902","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u092a\\u0915\\u094b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0926\\u0947\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u0936\\u0940\\u0932 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0935\\u0939 \\u091c\\u0928\\u094d\\u092e\\u0926\\u093f\\u0928 \\u0939\\u094b, \\u091b\\u0941\\u091f\\u094d\\u091f\\u0940 \\u0939\\u094b \\u092f\\u093e \\u0938\\u093f\\u0930\\u094d\\u092b \\u0907\\u0938\\u0932\\u093f\\u090f, \\u0939\\u092e\\u093e\\u0930\\u0947 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0906\\u092a\\u0915\\u0940 \\u092a\\u0930\\u0935\\u093e\\u0939 \\u0926\\u093f\\u0916\\u093e\\u0928\\u0947 \\u0915\\u093e \\u0938\\u0939\\u0940 \\u0924\\u0930\\u0940\\u0915\\u093e \\u0939\\u0948\\u0902\\u0964 \\u090f\\u0915 \\u0938\\u0939\\u091c \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902 \\u0914\\u0930 \\u0926\\u094b\\u0938\\u094d\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0916\\u0941\\u0936\\u093f\\u092f\\u093e\\u0901 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u0905\\u092a\\u0928\\u093e \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/gift-card","step_title":"\\u0917\\u093f\\u092b\\u094d\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0948\\u0938\\u0947 \\u0916\\u0930\\u0940\\u0926\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0947\\u0902","step_sub_title":"QRPay Pro \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249e922ec29":{"language":{"en":{"name":"Choose Your Gift Card"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Elija su tarjeta de regalo"},"fr":{"name":"Choisissez votre carte cadeau"},"hi":{"name":"\\u0905\\u092a\\u0928\\u093e \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"67249e922ec29"},"67249e982d41b":{"language":{"en":{"name":"Enter Recipient Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645"},"es":{"name":"Ingrese los detalles del destinatario"},"fr":{"name":"Saisir les d\\u00e9tails du destinataire"},"hi":{"name":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"67249e982d41b"},"67249e9da134d":{"language":{"en":{"name":"Make Payment and Send"},"ar":{"name":"\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644"},"es":{"name":"Realizar pago y enviar"},"fr":{"name":"Effectuer le paiement et envoyer"},"hi":{"name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0947\\u0902"}},"id":"67249e9da134d"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:25:17','updated_at' => '2024-12-12 18:43:25'),
            array('id' => '16','parent_id' => '16','type' => 'personal','value' => '{"images":{"section_image":"ed226f28-df2f-43f7-bb02-c7f3061d0b0a.webp","step_image":"c4427edf-10ae-41f2-8ec6-0b5de01939c1.webp"},"language":{"en":{"heading":"Simplify Your Bill Payments with QRPay Pro","sub_heading":"With QRPay Pro\\u2019s Bill Pay feature, managing and paying your utility and service bills has never been easier. Eliminate the hassle of manual payments and enjoy the convenience of paying your bills directly from your QRPay Pro account, all while ensuring your transactions are secure and efficient.","process_step_title":"Pay Your Bills in 3 Easy Steps","button_name":"Start Paying Bills Now","button_link":"user\\/bill-pay","step_title":"How to Pay Your Bills Using QRPay Pro","step_sub_title":"Follow these simple steps to effortlessly pay your bills through your QRPay Pro account."},"es":{"heading":"Simplifique sus pagos de facturas con QRPay Pro","sub_heading":"Con la funci\\u00f3n Bill Pay de QRPay Pro, administrar y pagar sus facturas de servicios p\\u00fablicos nunca ha sido tan f\\u00e1cil. Elimine la molestia de los pagos manuales y disfrute de la conveniencia de pagar sus facturas directamente desde su cuenta QRPay Pro, mientras garantiza que sus transacciones sean seguras y eficientes.","process_step_title":"Pague sus facturas en 3 sencillos pasos","button_name":"Comience a pagar facturas ahora","button_link":"user\\/bill-pay","step_title":"C\\u00f3mo pagar sus facturas con QRPay Pro","step_sub_title":"Siga estos sencillos pasos para pagar sus facturas sin esfuerzo a trav\\u00e9s de su cuenta QRPay Pro."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u062a\\u0628\\u0633\\u064a\\u0637 \\u062f\\u0641\\u0639\\u0627\\u062a \\u0641\\u0627\\u062a\\u0648\\u0631\\u062a\\u0643 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"\\u0645\\u0639 \\u0645\\u064a\\u0632\\u0629 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d\\u062a \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0648\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0641\\u0642 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0623\\u0633\\u0647\\u0644 \\u0645\\u0646 \\u0623\\u064a \\u0648\\u0642\\u062a \\u0645\\u0636\\u0649. \\u062a\\u062e\\u0644\\u0635 \\u0645\\u0646 \\u0645\\u062a\\u0627\\u0639\\u0628 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0627\\u0644\\u064a\\u062f\\u0648\\u064a\\u0629 \\u0648\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0627\\u062d\\u0629 \\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643\\u060c \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0645\\u0639 \\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629.","process_step_title":"\\u0627\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/bill-pay","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"fr":{"heading":"Simplifique sus pagos de facturas con QRPay Pro","sub_heading":"Avec la fonction Bill Pay de QRPay Pro, g\\u00e9rer et payer vos factures de services publics et de services n\'a jamais \\u00e9t\\u00e9 aussi simple. \\u00c9liminez les tracas des paiements manuels et profitez de la commodit\\u00e9 de payer vos factures directement depuis votre compte QRPay Pro, tout en garantissant que vos transactions sont s\\u00e9curis\\u00e9es et efficaces.","process_step_title":"Payez vos factures en 3 \\u00e9tapes faciles","button_name":"Commencez \\u00e0 payer vos factures maintenant","button_link":"user\\/bill-pay","step_title":"Comment payer vos factures avec QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour payer vos factures sans effort via votre compte QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u094b \\u0938\\u0930\\u0932 \\u092c\\u0928\\u093e\\u090f\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0905\\u092a\\u0928\\u0940 \\u0909\\u092a\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0907\\u0924\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0915\\u092d\\u0940 \\u0928\\u0939\\u0940\\u0902 \\u0930\\u0939\\u093e\\u0964 \\u092e\\u0948\\u0928\\u094d\\u092f\\u0941\\u0905\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u0915\\u094b \\u0926\\u0942\\u0930 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0915\\u093f \\u0906\\u092a\\u0915\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u0941\\u0936\\u0932 \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/bill-pay","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249f71307f5":{"language":{"en":{"name":"Select Your Bill Type"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Seleccione su tipo de factura"},"fr":{"name":"Seleccione su tipo de factura"},"hi":{"name":"\\u0905\\u092a\\u0928\\u093e \\u092c\\u093f\\u0932 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"67249f71307f5"},"67249f75b93a6":{"language":{"en":{"name":"Enter Billing Information"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631"},"es":{"name":"Ingrese la informaci\\u00f3n de facturaci\\u00f3n"},"fr":{"name":"Ingrese la informaci\\u00f3n de facturaci\\u00f3n"},"hi":{"name":"\\u092c\\u093f\\u0932\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"67249f75b93a6"},"67249f7b36e9e":{"language":{"en":{"name":"Confirm and Pay"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Confirmar y pagar"},"fr":{"name":"Confirmar y pagar"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"67249f7b36e9e"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:29:10','updated_at' => '2024-12-12 18:40:21'),
            array('id' => '17','parent_id' => '17','type' => 'personal','value' => '{"images":{"section_image":"6431b748-6918-4b7b-8bdd-43bc09d87835.webp","step_image":"6e5c537e-af0f-4258-9b5d-748c9c1178e4.webp"},"language":{"en":{"heading":"Recharge Your Mobile Account Effortlessly with QRPay Pro","sub_heading":"With QRPay Pro\\u2019s Mobile Top-Up feature, keeping your mobile phone topped up is quick and hassle-free. Whether you need to add credit for yourself or someone else, QRPay Pro allows you to recharge mobile accounts instantly, all while ensuring secure transactions.","process_step_title":"Top Up Your Mobile in 3 Simple Steps","button_name":"Start Top-Up Now","button_link":"user\\/mobile-topup","step_title":"How to Recharge Your Mobile Phone with QRPay Pro","step_sub_title":"Follow these easy steps to top up your mobile account directly from your QRPay Pro wallet."},"es":{"heading":"Recargue su cuenta m\\u00f3vil sin esfuerzo con QRPay Pro","sub_heading":"Con la funci\\u00f3n de recarga m\\u00f3vil de QRPay Pro, mantener tu tel\\u00e9fono m\\u00f3vil recargado es r\\u00e1pido y sin complicaciones. Ya sea que necesite agregar cr\\u00e9dito para usted o para otra persona, QRPay Pro le permite recargar cuentas m\\u00f3viles al instante, garantizando al mismo tiempo transacciones seguras.","process_step_title":"Recarga tu m\\u00f3vil en 3 sencillos pasos","button_name":"Comience a recargar ahora","button_link":"user\\/mobile-topup","step_title":"C\\u00f3mo recargar tu tel\\u00e9fono m\\u00f3vil con QRPay Pro","step_sub_title":"Siga estos sencillos pasos para recargar su cuenta m\\u00f3vil directamente desde su billetera QRPay Pro."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u062d\\u0633\\u0627\\u0628 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u0645\\u0639 \\u0645\\u064a\\u0632\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0641\\u064a QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0631\\u0635\\u064a\\u062f \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0633\\u0631\\u064a\\u0639\\u064b\\u0627 \\u0648\\u062e\\u0627\\u0644\\u064a\\u064b\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0644\\u0646\\u0641\\u0633\\u0643 \\u0623\\u0648 \\u0644\\u0634\\u062e\\u0635 \\u0622\\u062e\\u0631\\u060c \\u0641\\u0625\\u0646 QRPay Pro \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631\\u060c \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0645\\u0639 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629.","process_step_title":"\\u0642\\u0645 \\u0628\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/mobile-topup","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u062a\\u0639\\u0628\\u0626\\u0629 \\u062d\\u0633\\u0627\\u0628 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u0645\\u062d\\u0641\\u0638\\u0629 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643."},"fr":{"heading":"Rechargez votre compte mobile sans effort avec QRPay Pro","sub_heading":"Avec la fonction de recharge mobile de QRPay Pro, garder votre t\\u00e9l\\u00e9phone mobile recharg\\u00e9 est rapide et sans tracas. Que vous ayez besoin d\'ajouter du cr\\u00e9dit pour vous-m\\u00eame ou pour quelqu\'un d\'autre, QRPay Pro vous permet de recharger instantan\\u00e9ment vos comptes mobiles, tout en garantissant des transactions s\\u00e9curis\\u00e9es.","process_step_title":"Rechargez votre mobile en 3 \\u00e9tapes simples","button_name":"Commencez la recharge maintenant","button_link":"user\\/mobile-topup","step_title":"Comment recharger votre t\\u00e9l\\u00e9phone mobile avec QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour recharger votre compte mobile directement depuis votre portefeuille QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0940 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u094b\\u0928 \\u0915\\u094b \\u091f\\u0949\\u092a \\u0905\\u092a \\u0930\\u0916\\u0928\\u093e \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924 \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0932\\u093f\\u090f \\u092f\\u093e \\u0915\\u093f\\u0938\\u0940 \\u0914\\u0930 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b, \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930\\u092a\\u0947 \\u092a\\u094d\\u0930\\u094b \\u0906\\u092a\\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0915\\u094b \\u091f\\u0949\\u092a \\u0905\\u092a \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/mobile-topup","step_title":"QRPay Pro \\u0938\\u0947 \\u0905\\u092a\\u0928\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u094b\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u0949\\u0932\\u0947\\u091f \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u091f\\u0949\\u092a \\u0905\\u092a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724a01b88713":{"language":{"en":{"name":"Select Your Mobile Carrier"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0645\\u0634\\u063a\\u0644 \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643"},"es":{"name":"Seleccione su operador de telefon\\u00eda m\\u00f3vil"},"fr":{"name":"S\\u00e9lectionnez votre op\\u00e9rateur mobile"},"hi":{"name":"\\u0905\\u092a\\u0928\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0915\\u0948\\u0930\\u093f\\u092f\\u0930 \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724a01b88713"},"6724a024435fa":{"language":{"en":{"name":"Enter the Phone Number"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641"},"es":{"name":"Ingrese el n\\u00famero de tel\\u00e9fono"},"fr":{"name":"Entrez le num\\u00e9ro de t\\u00e9l\\u00e9phone"},"hi":{"name":"\\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724a024435fa"},"6724a02991bc6":{"language":{"en":{"name":"Choose the Amount and Confirm"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u0623\\u0643\\u062f"},"es":{"name":"Elija el monto y confirme"},"fr":{"name":"Choisissez le montant et confirmez"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724a02991bc6"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:32:04','updated_at' => '2024-12-12 18:40:48'),
            array('id' => '18','parent_id' => '18','type' => 'business','value' => '{"images":{"section_image":"24e78c49-c6c0-4d43-9ec9-74ef2f151a31.webp","step_image":"5de7d9f1-5ed8-45b0-826d-09a921a35a2d.webp"},"language":{"en":{"heading":"Receive Payments Instantly with QRPay Pro\\u2019s QR Code Technology","sub_heading":"With QRPay Pro, receiving payments is simple and reliable. Each merchant account comes with a unique, permanent QR Code, allowing you to accept payments anytime without needing to generate new codes. This secure and contactless payment method supports multiple currencies, making global transactions convenient and efficient.","process_step_title":"Start Receiving Money in 3 Simple Steps","button_name":"Start Receiving Payments","button_link":"merchant\\/receive-money","step_title":"How to Receive Money with Your QRPay Pro QR Code","step_sub_title":"Follow these steps to seamlessly receive payments using your dedicated QR Code."},"es":{"heading":"Reciba pagos al instante con la tecnolog\\u00eda de c\\u00f3digo QR de QRPay Pro","sub_heading":"Con QRPay Pro, recibir pagos es sencillo y confiable. Cada cuenta de comerciante viene con un c\\u00f3digo QR \\u00fanico y permanente, que le permite aceptar pagos en cualquier momento sin necesidad de generar nuevos c\\u00f3digos. Este m\\u00e9todo de pago seguro y sin contacto admite m\\u00faltiples monedas, lo que hace que las transacciones globales sean convenientes y eficientes.","process_step_title":"Comience a recibir dinero en 3 sencillos pasos","button_name":"Comience a recibir pagos","button_link":"merchant\\/receive-money","step_title":"C\\u00f3mo recibir dinero con su c\\u00f3digo QR QRPay Pro","step_sub_title":"Siga estos pasos para recibir pagos sin problemas utilizando su c\\u00f3digo QR exclusivo."},"ar":{"heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062a\\u0642\\u0646\\u064a\\u0629 QR Code \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u0623\\u0635\\u0628\\u062d \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0628\\u0633\\u064a\\u0637\\u064b\\u0627 \\u0648\\u0645\\u0648\\u062b\\u0648\\u0642\\u064b\\u0627. \\u064a\\u0623\\u062a\\u064a \\u0643\\u0644 \\u062d\\u0633\\u0627\\u0628 \\u062a\\u0627\\u062c\\u0631 \\u0645\\u0632\\u0648\\u062f\\u064b\\u0627 \\u0628\\u0631\\u0645\\u0632 QR \\u0641\\u0631\\u064a\\u062f \\u0648\\u062f\\u0627\\u0626\\u0645\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0641\\u064a \\u0623\\u064a \\u0648\\u0642\\u062a \\u062f\\u0648\\u0646 \\u0627\\u0644\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0645\\u0648\\u0632 \\u062c\\u062f\\u064a\\u062f\\u0629. \\u062a\\u062f\\u0639\\u0645 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0648\\u063a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0644\\u0627\\u0645\\u0633\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0645\\u0631\\u064a\\u062d\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629.","process_step_title":"\\u0627\\u0628\\u062f\\u0623 \\u0641\\u064a \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a","button_link":"merchant\\/receive-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0645\\u062e\\u0635\\u0635 \\u0644\\u062f\\u064a\\u0643."},"fr":{"heading":"Recevez des paiements instantan\\u00e9ment avec la technologie QR Code de QRPay Pro","sub_heading":"Avec QRPay Pro, recevoir des paiements est simple et fiable. Chaque compte marchand est livr\\u00e9 avec un code QR unique et permanent, vous permettant d\'accepter des paiements \\u00e0 tout moment sans avoir besoin de g\\u00e9n\\u00e9rer de nouveaux codes. Cette m\\u00e9thode de paiement s\\u00e9curis\\u00e9e et sans contact prend en charge plusieurs devises, rendant les transactions mondiales pratiques et efficaces.","process_step_title":"Commencez \\u00e0 recevoir de l\'argent en 3 \\u00e9tapes simples","button_name":"Commencez \\u00e0 recevoir des paiements","button_link":"merchant\\/receive-money","step_title":"Comment recevoir de l\'argent avec votre code QR QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes pour recevoir des paiements en toute transparence \\u00e0 l\'aide de votre code QR d\\u00e9di\\u00e9."},"hi":{"heading":"QRPay Pro \\u0915\\u0940 QR \\u0915\\u094b\\u0921 \\u0924\\u0915\\u0928\\u0940\\u0915 \\u0938\\u0947 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0938\\u0930\\u0932 \\u0914\\u0930 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0939\\u0948\\u0964 \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0916\\u093e\\u0924\\u093e \\u090f\\u0915 \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f, \\u0938\\u094d\\u0925\\u093e\\u092f\\u0940 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0924\\u093e \\u0939\\u0948, \\u091c\\u094b \\u0906\\u092a\\u0915\\u094b \\u0928\\u090f \\u0915\\u094b\\u0921 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0915\\u0947 \\u092c\\u093f\\u0928\\u093e \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0938\\u092e\\u092f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u0930\\u0939\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u0926\\u094d\\u0927\\u0924\\u093f \\u0915\\u0908 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u0914\\u0930 \\u0915\\u0941\\u0936\\u0932 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964","process_step_title":"3 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"merchant\\/receive-money","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay Pro QR \\u0915\\u094b\\u0921 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 \\u0938\\u092e\\u0930\\u094d\\u092a\\u093f\\u0924 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724b6da8bdb9":{"language":{"en":{"name":"Access Your Unique QR Code"},"ar":{"name":"\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643"},"es":{"name":"Acceda a su c\\u00f3digo QR \\u00fanico"},"fr":{"name":"Acc\\u00e9dez \\u00e0 votre code QR unique"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0902"}},"id":"6724b6da8bdb9"},"6724b6e2c73b4":{"language":{"en":{"name":"Let Customers Scan and Pay"},"ar":{"name":"\\u0627\\u0633\\u0645\\u062d \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0628\\u0627\\u0644\\u0645\\u0633\\u062d \\u0627\\u0644\\u0636\\u0648\\u0626\\u064a \\u0648\\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Permita que los clientes escaneen y paguen"},"fr":{"name":"Laissez les clients scanner et payer"},"hi":{"name":"\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0926\\u0947\\u0902"}},"id":"6724b6e2c73b4"},"6724b6e8f2831":{"language":{"en":{"name":"Get Real-Time Payment Notifications"},"ar":{"name":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a"},"es":{"name":"Obtenga notificaciones de pago en tiempo real"},"fr":{"name":"Recevez des notifications de paiement en temps r\\u00e9el"},"hi":{"name":"\\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0902 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b6e8f2831"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 16:30:37','updated_at' => '2024-12-12 18:24:27'),
            array('id' => '19','parent_id' => '19','type' => 'business','value' => '{"images":{"section_image":"2c74bddb-a6bc-4941-ae0e-52cf45e854b1.webp","step_image":"e9bab8c3-4846-408e-b891-cb574d508028.webp"},"language":{"en":{"heading":"Manage Multi-Currency Transactions with QRPay Pro\\u2019s Exchange Money Feature","sub_heading":"QRPay Pro enables merchants to easily exchange currencies, ensuring smooth transactions with international customers. Stay updated with real-time exchange rates and enjoy a seamless process when converting funds in your account, allowing you to serve a global customer base efficiently.","process_step_title":"Convert Currency in 3 Simple Steps","button_name":"Start Exchanging Currency","button_link":"merchant\\/money-exchange","step_title":"How to Exchange Money in QRPay Pro","step_sub_title":"Follow these steps to quickly and securely exchange money between currencies in your QRPay Pro account."},"es":{"heading":"Administre transacciones en m\\u00faltiples divisas con la funci\\u00f3n Exchange Money de QRPay Pro","sub_heading":"QRPay Pro permite a los comerciantes cambiar divisas f\\u00e1cilmente, garantizando transacciones fluidas con clientes internacionales. Mant\\u00e9ngase actualizado con los tipos de cambio en tiempo real y disfrute de un proceso fluido al convertir fondos en su cuenta, lo que le permitir\\u00e1 atender a una base de clientes global de manera eficiente.","process_step_title":"Convierta moneda en 3 sencillos pasos","button_name":"Comience a cambiar moneda","button_link":"merchant\\/money-exchange","step_title":"C\\u00f3mo cambiar dinero en QRPay Pro","step_sub_title":"Siga estos pasos para cambiar dinero de forma r\\u00e1pida y segura entre monedas en su cuenta QRPay Pro."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a QRPay Pro","sub_heading":"\\u064a\\u062a\\u064a\\u062d QRPay Pro \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0633\\u0644\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u064a\\u0646. \\u0627\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u0637\\u0644\\u0627\\u0639 \\u062f\\u0627\\u0626\\u0645 \\u0628\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a \\u0648\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0633\\u0644\\u0633\\u0629 \\u0639\\u0646\\u062f \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u062e\\u062f\\u0645\\u0629 \\u0642\\u0627\\u0639\\u062f\\u0629 \\u0639\\u0645\\u0644\\u0627\\u0621 \\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0628\\u0643\\u0641\\u0627\\u0621\\u0629.","process_step_title":"\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629","button_name":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a","button_link":"merchant\\/money-exchange","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"fr":{"heading":"G\\u00e9rez les transactions multidevises avec la fonction Exchange Money de QRPay Pro","sub_heading":"QRPay Pro permet aux commer\\u00e7ants d\'\\u00e9changer facilement des devises, garantissant ainsi des transactions fluides avec les clients internationaux. Restez inform\\u00e9 des taux de change en temps r\\u00e9el et profitez d\'un processus transparent lors de la conversion des fonds sur votre compte, vous permettant ainsi de servir efficacement une client\\u00e8le mondiale.","process_step_title":"Convertir des devises en 3 \\u00e9tapes simples","button_name":"Commencer \\u00e0 \\u00e9changer des devises","button_link":"merchant\\/money-exchange","step_title":"Comment \\u00e9changer de l\'argent dans QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes pour \\u00e9changer de l\'argent rapidement et en toute s\\u00e9curit\\u00e9 entre les devises de votre compte QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u092e\\u0928\\u0940 \\u092b\\u0940\\u091a\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0915\\u094d\\u0937\\u092e \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0939\\u091c \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0921\\u0947\\u091f \\u0930\\u0939\\u0947\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f \\u090f\\u0915 \\u0938\\u0939\\u091c \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u0906\\u0927\\u093e\\u0930 \\u0915\\u094b \\u0915\\u0941\\u0936\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u0938\\u0947\\u0935\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0917\\u0947\\u0964","process_step_title":"3 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"merchant\\/money-exchange","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724b7a6800f7":{"language":{"en":{"name":"Select the Currency to Exchange"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0631\\u0627\\u062f \\u0635\\u0631\\u0641\\u0647\\u0627"},"es":{"name":"Seleccione la moneda a cambiar"},"fr":{"name":"S\\u00e9lectionnez la devise \\u00e0 \\u00e9changer"},"hi":{"name":"\\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b7a6800f7"},"6724b7ac97533":{"language":{"en":{"name":"Choose Your Target Currency"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u062f\\u0641\\u0629"},"es":{"name":"Elija su moneda objetivo"},"fr":{"name":"Choisissez votre devise cible"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0940 \\u0932\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724b7ac97533"},"6724b7b383f24":{"language":{"en":{"name":"Confirm and Exchange"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u062a\\u0628\\u0627\\u062f\\u0644"},"es":{"name":"Confirmar e intercambiar"},"fr":{"name":"Confirmer et \\u00e9changer"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b7b383f24"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:12:28','updated_at' => '2024-12-12 18:17:34'),
            array('id' => '20','parent_id' => '20','type' => 'business','value' => '{"images":{"section_image":"b7479304-2e1b-489d-95b4-c5f207baeee3.webp","step_image":"efbff342-f9fd-4366-a740-fbb2099639e1.webp"},"language":{"en":{"heading":"Collect Payments Easily with QRPay Pro Payment Links","sub_heading":"QRPay Pro enables merchants to create and share unique payment links, making it convenient for customers to pay online. Whether you\\u2019re sending invoices or offering remote payment options, the QRPay Pro payment link feature simplifies the payment process and offers enhanced security for your transactions.","process_step_title":"Accept Payments in 3 Easy Steps","button_name":"Create Payment Link","button_link":"merchant\\/payment-link","step_title":"How to Use Payment Links in QRPay Pro","step_sub_title":"Generate and share payment links in minutes to streamline payment collection for your business."},"es":{"heading":"Cobre pagos f\\u00e1cilmente con los enlaces de pago QRPay Pro","sub_heading":"QRPay Pro permite a los comerciantes crear y compartir enlaces de pago \\u00fanicos, lo que hace que sea conveniente para los clientes pagar en l\\u00ednea. Ya sea que env\\u00ede facturas u ofrezca opciones de pago remoto, la funci\\u00f3n de enlace de pago QRPay Pro simplifica el proceso de pago y ofrece mayor seguridad para sus transacciones.","process_step_title":"Acepte pagos en 3 sencillos pasos","button_name":"Crear enlace de pago","button_link":"merchant\\/payment-link","step_title":"C\\u00f3mo utilizar enlaces de pago en QRPay Pro","step_sub_title":"Genere y comparta enlaces de pago en minutos para agilizar el cobro de pagos para su empresa."},"ar":{"heading":"Collect Payments Easily with QRPay Pro Payment Links","sub_heading":"\\u064a\\u062a\\u064a\\u062d QRPay Pro \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639 \\u0641\\u0631\\u064a\\u062f\\u0629 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647\\u0627\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0647\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u062a\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0623\\u0648 \\u062a\\u0642\\u062f\\u0645 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0646 \\u0628\\u0639\\u062f\\u060c \\u0641\\u0625\\u0646 \\u0645\\u064a\\u0632\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro \\u062a\\u0639\\u0645\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u062a\\u0648\\u0641\\u0631 \\u0623\\u0645\\u0627\\u0646\\u064b\\u0627 \\u0645\\u062d\\u0633\\u0646\\u064b\\u0627 \\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643.","process_step_title":"\\u0627\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0641\\u064a 3 \\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629","button_name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639","button_link":"merchant\\/payment-link","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro","step_sub_title":"\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647\\u0627 \\u0641\\u064a \\u062f\\u0642\\u0627\\u0626\\u0642 \\u0644\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u062d\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0644\\u0634\\u0631\\u0643\\u062a\\u0643."},"fr":{"heading":"Collectez facilement des paiements avec les liens de paiement QRPay Pro","sub_heading":"QRPay Pro permet aux commer\\u00e7ants de cr\\u00e9er et de partager des liens de paiement uniques, ce qui permet aux clients de payer en ligne facilement. Que vous envoyiez des factures ou proposiez des options de paiement \\u00e0 distance, la fonction de lien de paiement QRPay Pro simplifie le processus de paiement et offre une s\\u00e9curit\\u00e9 renforc\\u00e9e pour vos transactions.","process_step_title":"Acceptez les paiements en 3 \\u00e9tapes faciles","button_name":"Cr\\u00e9er un lien de paiement","button_link":"merchant\\/payment-link","step_title":"Comment utiliser les liens de paiement dans QRPay Pro","step_sub_title":"G\\u00e9n\\u00e9rez et partagez des liens de paiement en quelques minutes pour rationaliser la collecte des paiements pour votre entreprise."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0915\\u094d\\u0937\\u092e \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a \\u091a\\u093e\\u0932\\u093e\\u0928 \\u092d\\u0947\\u091c \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902 \\u092f\\u093e \\u0926\\u0942\\u0930\\u0938\\u094d\\u0925 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u092a\\u0947\\u0936 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u094b\\u0902, QRPay \\u092a\\u094d\\u0930\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0938\\u0930\\u0932 \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u0906\\u092a\\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0922\\u093c\\u0940 \\u0939\\u0941\\u0908 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964","process_step_title":"3 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u090f\\u0902","button_link":"merchant\\/payment-link","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939 \\u0915\\u094b \\u0938\\u0941\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u093f\\u0928\\u091f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724b8c540a68":{"language":{"en":{"name":"Generate a Payment Link"},"ar":{"name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Generar un enlace de pago"},"fr":{"name":"G\\u00e9n\\u00e9rer un lien de paiement"},"hi":{"name":"\\u090f\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b8c540a68"},"6724b8cb81a6f":{"language":{"en":{"name":"Share the Link with Customers"},"ar":{"name":"\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637 \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621"},"es":{"name":"Comparta el enlace con los clientes"},"fr":{"name":"Partagez le lien avec les clients"},"hi":{"name":"\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b8cb81a6f"},"6724b8d4454dc":{"language":{"en":{"name":"Receive Instant Payment Notifications"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0631\\u064a"},"es":{"name":"Reciba notificaciones de pago instant\\u00e1neas"},"fr":{"name":"Recevez des notifications de paiement instantan\\u00e9es"},"hi":{"name":"\\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0902 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b8d4454dc"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:17:18','updated_at' => '2024-12-12 18:18:35'),
            array('id' => '21','parent_id' => '21','type' => 'business','value' => '{"images":{"section_image":"6cad9e7b-6878-42c6-956e-6c4ab24bf1fe.webp","step_image":"dd5aa5d2-8cd3-47f6-a5b8-e93d2c1b621c.webp"},"language":{"en":{"heading":"Access Your Funds Easily with QRPay Pro","sub_heading":"QRPay Pro makes it simple for merchants to withdraw funds from their accounts. Transfer your balance directly to your bank or preferred digital wallet, enjoying quick and secure access to your earnings.","process_step_title":"Three Simple Steps to Withdraw Your Funds","button_name":"Withdraw Now","button_link":"merchant\\/withdraw","step_title":"How to Withdraw Money from Your QRPay Pro Account","step_sub_title":"Follow these easy steps to move your QRPay Pro funds to your bank or digital wallet."},"es":{"heading":"Acceda a sus fondos f\\u00e1cilmente con QRPay Pro","sub_heading":"QRPay Pro simplifica a los comerciantes el retiro de fondos de sus cuentas. Transfiera su saldo directamente a su banco o billetera digital preferida, disfrutando de un acceso r\\u00e1pido y seguro a sus ganancias.","process_step_title":"Tres sencillos pasos para retirar sus fondos","button_name":"Retirar ahora","button_link":"merchant\\/withdraw","step_title":"C\\u00f3mo retirar dinero de su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para transferir sus fondos de QRPay Pro a su banco o billetera digital."},"ar":{"heading":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"QRPay Pro \\u064a\\u062c\\u0639\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0647\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a\\u0647\\u0645. \\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0631\\u0635\\u064a\\u062f\\u0643 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0628\\u0646\\u0643 \\u0627\\u0644\\u0630\\u064a \\u062a\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639\\u0647 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0644\\u062f\\u064a\\u0643\\u060c \\u0644\\u062a\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639 \\u0648\\u0627\\u0644\\u0622\\u0645\\u0646 \\u0625\\u0644\\u0649 \\u0623\\u0631\\u0628\\u0627\\u062d\\u0643.","process_step_title":"\\u062b\\u0644\\u0627\\u062b \\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0633\\u062d\\u0628 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643","button_name":"\\u0627\\u0646\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0622\\u0646","button_link":"merchant\\/withdraw","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u0646\\u0642\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644 QRPay Pro \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0628\\u0646\\u0643 \\u0627\\u0644\\u0630\\u064a \\u062a\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639\\u0647 \\u0623\\u0648 \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629."},"fr":{"heading":"Acc\\u00e9dez facilement \\u00e0 vos fonds avec QRPay Pro","sub_heading":"QRPay Pro permet aux commer\\u00e7ants de retirer facilement des fonds de leurs comptes. Transf\\u00e9rez votre solde directement vers votre banque ou votre portefeuille num\\u00e9rique pr\\u00e9f\\u00e9r\\u00e9, b\\u00e9n\\u00e9ficiant d\'un acc\\u00e8s rapide et s\\u00e9curis\\u00e9 \\u00e0 vos gains.","process_step_title":"Trois \\u00e9tapes simples pour retirer vos fonds","button_name":"Retirer maintenant","button_link":"merchant\\/withdraw","step_title":"Comment retirer de l\'argent de votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour transf\\u00e9rer vos fonds QRPay Pro vers votre banque ou votre portefeuille num\\u00e9rique."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092b\\u0902\\u0921 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0902","sub_heading":"QRPay Pro \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u094b\\u0902 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0928\\u0940 \\u0915\\u092e\\u093e\\u0908 \\u0924\\u0915 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u0939\\u0941\\u0902\\u091a \\u0915\\u093e \\u0906\\u0928\\u0902\\u0926 \\u0932\\u0947\\u0924\\u0947 \\u0939\\u0941\\u090f, \\u0905\\u092a\\u0928\\u093e \\u0936\\u0947\\u0937 \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u092f\\u093e \\u092a\\u0938\\u0902\\u0926\\u0940\\u0926\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964","process_step_title":"\\u0905\\u092a\\u0928\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0940\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u0905\\u092d\\u0940 \\u0935\\u093e\\u092a\\u0938 \\u0932\\u0947\\u0902","button_link":"merchant\\/withdraw","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u092b\\u0902\\u0921 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u092f\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724b9c2ec46d":{"language":{"en":{"name":"Select Withdraw Option"},"ar":{"name":"\\u062d\\u062f\\u062f \\u062e\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Seleccione la opci\\u00f3n de retiro"},"fr":{"name":"S\\u00e9lectionnez l\'option de retrait"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724b9c2ec46d"},"6724b9c9dbf68":{"language":{"en":{"name":"Choose Withdrawal Method"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Elija el m\\u00e9todo de retiro"},"fr":{"name":"Choisissez la m\\u00e9thode de retrait"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724b9c9dbf68"},"6724b9d034749":{"language":{"en":{"name":"Confirm Withdrawal"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Confirmar retiro"},"fr":{"name":"Confirmer le retrait"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724b9d034749"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:21:29','updated_at' => '2024-12-31 12:26:35'),
            array('id' => '22','parent_id' => '22','type' => 'business','value' => '{"images":{"section_image":"d1a4b4c0-3c07-4e4a-93be-7770903d9b1e.webp","step_image":"ec81ccf2-fa4d-4378-a7b2-0ce22869282c.webp"},"language":{"en":{"heading":"Configure Your Payment Gateway for Secure Transactions","sub_heading":"With QRPay Pro, merchants can easily set up and manage their payment gateway settings. Customize payment options to create a secure, frictionless experience for your customers, supported by QRPay Pro\'s robust security and compliance standards.","process_step_title":"Three Simple Steps to Set Up Your Payment Gateway","button_name":"Configure Now","button_link":"merchant\\/gateway-setting","step_title":"How to Set Up and Manage Your QRPay Pro Gateway","step_sub_title":"Follow these steps to integrate QRPay Pro\\u2019s secure payment gateway into your platform."},"es":{"heading":"Configure su pasarela de pago para transacciones seguras","sub_heading":"Con QRPay Pro, los comerciantes pueden configurar y administrar f\\u00e1cilmente la configuraci\\u00f3n de su pasarela de pago. Personalice las opciones de pago para crear una experiencia segura y sin fricciones para sus clientes, respaldada por los s\\u00f3lidos est\\u00e1ndares de seguridad y cumplimiento de QRPay Pro.","process_step_title":"Tres sencillos pasos para configurar su pasarela de pago","button_name":"Configurar ahora","button_link":"merchant\\/gateway-setting","step_title":"C\\u00f3mo configurar y administrar su puerta de enlace QRPay Pro","step_sub_title":"Siga estos pasos para integrar la pasarela de pago seguro de QRPay Pro en su plataforma."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u062a\\u0643\\u0648\\u064a\\u0646 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0625\\u0639\\u062f\\u0627\\u062f \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629. \\u0642\\u0645 \\u0628\\u062a\\u062e\\u0635\\u064a\\u0635 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0643 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0643\\u060c \\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0628\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro.","process_step_title":"\\u0642\\u0645 \\u0628\\u062a\\u0643\\u0648\\u064a\\u0646 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629","button_name":"\\u062a\\u0643\\u0648\\u064a\\u0646 \\u0627\\u0644\\u0622\\u0646","button_link":"merchant\\/gateway-setting","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0639\\u062f\\u0627\\u062f \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0628\\u0648\\u0627\\u0628\\u0629 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u062f\\u0645\\u062c \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0644\\u0640 QRPay Pro \\u0641\\u064a \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"fr":{"heading":"Configurez votre passerelle de paiement pour des transactions s\\u00e9curis\\u00e9es","sub_heading":"Avec QRPay Pro, les commer\\u00e7ants peuvent facilement configurer et g\\u00e9rer les param\\u00e8tres de leur passerelle de paiement. Personnalisez les options de paiement pour cr\\u00e9er une exp\\u00e9rience s\\u00e9curis\\u00e9e et fluide pour vos clients, soutenue par les normes robustes de s\\u00e9curit\\u00e9 et de conformit\\u00e9 de QRPay Pro.","process_step_title":"Trois \\u00e9tapes simples pour configurer votre passerelle de paiement","button_name":"Configurer maintenant","button_link":"merchant\\/gateway-setting","step_title":"Comment configurer et g\\u00e9rer votre passerelle QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes pour int\\u00e9grer la passerelle de paiement s\\u00e9curis\\u00e9e de QRPay Pro dans votre plateforme."},"hi":{"heading":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u0949\\u0928\\u094d\\u092b\\u093c\\u093f\\u0917\\u0930 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0938\\u0947\\u091f \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092e\\u091c\\u092c\\u0942\\u0924 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924, \\u0905\\u092a\\u0928\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924, \\u0918\\u0930\\u094d\\u0937\\u0923 \\u0930\\u0939\\u093f\\u0924 \\u0905\\u0928\\u0941\\u092d\\u0935 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964","process_step_title":"\\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0940\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u0905\\u092d\\u0940 \\u0915\\u0949\\u0928\\u094d\\u092b\\u093c\\u093f\\u0917\\u0930 \\u0915\\u0930\\u0947\\u0902","button_link":"merchant\\/gateway-setting","step_title":"\\u0905\\u092a\\u0928\\u093e QRPay \\u092a\\u094d\\u0930\\u094b \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0938\\u0947\\u091f \\u0905\\u092a \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"QRPay Pro \\u0915\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092e\\u0947\\u0902 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724ba7aadd13":{"language":{"en":{"name":"Access Gateway Settings"},"ar":{"name":"\\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644"},"es":{"name":"Configuraci\\u00f3n de la puerta de enlace de acceso"},"fr":{"name":"Param\\u00e8tres de la passerelle d\'acc\\u00e8s"},"hi":{"name":"\\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0902"}},"id":"6724ba7aadd13"},"6724ba7fea0b5":{"language":{"en":{"name":"Customize Your Settings"},"ar":{"name":"\\u062a\\u062e\\u0635\\u064a\\u0635 \\u0627\\u0644\\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Personaliza tu configuraci\\u00f3n"},"fr":{"name":"Personnalisez vos param\\u00e8tres"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0940 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724ba7fea0b5"},"6724ba862ef69":{"language":{"en":{"name":"Save and Go Live"},"ar":{"name":"\\u0627\\u062d\\u0641\\u0638 \\u0648\\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0628\\u062b \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631"},"es":{"name":"Guardar y publicar"},"fr":{"name":"Enregistrez et lancez le direct"},"hi":{"name":"\\u0938\\u0939\\u0947\\u091c\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u093e\\u0907\\u0935 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0902"}},"id":"6724ba862ef69"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:24:34','updated_at' => '2024-12-12 18:21:18'),
            array('id' => '23','parent_id' => '23','type' => 'business','value' => '{"images":{"section_image":"4a7413d5-0f24-4eec-ae2b-7ef2d9b7f72c.webp","step_image":"749747f3-d508-4f6b-9e6c-75db53ccf9ce.webp"},"language":{"en":{"heading":"Seamlessly Connect Your Platform with Secure API Keys","sub_heading":"With QRPay Pro, creating and managing API keys is simple and secure. Use API keys to integrate QRPay Pro\\u2019s payment features directly into your platform, allowing you to provide smooth, efficient, and secure payment solutions.","process_step_title":"Steps to Generate and Use API Keys with QRPay Pro","button_name":"Generate API Key","button_link":"merchant\\/developer\\/api","step_title":"How to Manage Your QRPay Pro API Key","step_sub_title":"Follow these steps to create and configure your API keys for secure integration"},"es":{"heading":"Conecte su plataforma sin problemas con claves API seguras","sub_heading":"Con QRPay Pro, crear y administrar claves API es simple y seguro. Utilice claves API para integrar las funciones de pago de QRPay Pro directamente en su plataforma, lo que le permitir\\u00e1 brindar soluciones de pago fluidas, eficientes y seguras.","process_step_title":"Pasos para generar y utilizar claves API con QRPay Pro","button_name":"Generar clave API","button_link":"merchant\\/developer\\/api","step_title":"C\\u00f3mo administrar su clave API QRPay Pro","step_sub_title":"Siga estos pasos para crear y configurar sus claves API para una integraci\\u00f3n segura"},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u062a\\u0648\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u064a\\u0639\\u062f \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0648\\u0625\\u062f\\u0627\\u0631\\u062a\\u0647\\u0627 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0628\\u0633\\u064a\\u0637\\u064b\\u0627 \\u0648\\u0622\\u0645\\u0646\\u064b\\u0627. \\u0627\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0644\\u062f\\u0645\\u062c \\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u062a\\u0648\\u0641\\u064a\\u0631 \\u062d\\u0644\\u0648\\u0644 \\u062f\\u0641\\u0639 \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0645\\u0639 QRPay Pro","button_name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u062a\\u0627\\u062d API","button_link":"merchant\\/developer\\/api","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0645\\u0641\\u062a\\u0627\\u062d QRPay Pro API \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u062a\\u0643\\u0648\\u064a\\u0646 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0644\\u0644\\u062a\\u0643\\u0627\\u0645\\u0644 \\u0627\\u0644\\u0622\\u0645\\u0646"},"fr":{"heading":"Connectez facilement votre plateforme avec des cl\\u00e9s API s\\u00e9curis\\u00e9es","sub_heading":"Avec QRPay Pro, la cr\\u00e9ation et la gestion des cl\\u00e9s API sont simples et s\\u00e9curis\\u00e9es. Utilisez les cl\\u00e9s API pour int\\u00e9grer les fonctionnalit\\u00e9s de paiement de QRPay Pro directement dans votre plateforme, vous permettant ainsi de fournir des solutions de paiement fluides, efficaces et s\\u00e9curis\\u00e9es.","process_step_title":"\\u00c9tapes pour g\\u00e9n\\u00e9rer et utiliser des cl\\u00e9s API avec QRPay Pro","button_name":"G\\u00e9n\\u00e9rer une cl\\u00e9 API","button_link":"merchant\\/developer\\/api","step_title":"Comment g\\u00e9rer votre cl\\u00e9 API QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes pour cr\\u00e9er et configurer vos cl\\u00e9s API pour une int\\u00e9gration s\\u00e9curis\\u00e9e"},"hi":{"heading":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0915\\u0928\\u0947\\u0915\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, API \\u0915\\u0941\\u0902\\u091c\\u0940 \\u092c\\u0928\\u093e\\u0928\\u093e \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0938\\u0930\\u0932 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0964 QRPay Pro \\u0915\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0938\\u0940\\u0927\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092e\\u0947\\u0902 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f API \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0938\\u0939\\u091c, \\u0915\\u0941\\u0936\\u0932 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0917\\u0947\\u0964","process_step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u091a\\u0930\\u0923","button_name":"\\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902","button_link":"merchant\\/developer\\/api","step_title":"\\u0905\\u092a\\u0928\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u090f\\u0915\\u0940\\u0915\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u093e\\u0901 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u0915\\u0949\\u0928\\u094d\\u092b\\u093c\\u093f\\u0917\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"items":{"6724bb43acef5":{"language":{"en":{"name":"Navigate to API Key Settings"},"ar":{"name":"\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0645\\u0641\\u062a\\u0627\\u062d API"},"es":{"name":"Navegue a Configuraci\\u00f3n de clave API"},"fr":{"name":"Acc\\u00e9dez aux param\\u00e8tres de la cl\\u00e9 API"},"hi":{"name":"\\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u092a\\u0930 \\u0928\\u0947\\u0935\\u093f\\u0917\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bb43acef5"},"6724bb49eb177":{"language":{"en":{"name":"Generate a New Key"},"ar":{"name":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u062a\\u0627\\u062d \\u062c\\u062f\\u064a\\u062f"},"es":{"name":"Generar una nueva clave"},"fr":{"name":"G\\u00e9n\\u00e9rer une nouvelle cl\\u00e9"},"hi":{"name":"\\u090f\\u0915 \\u0928\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bb49eb177"},"6724bb4f864ed":{"language":{"en":{"name":"Configure Permissions and Save"},"ar":{"name":"\\u062a\\u0643\\u0648\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0630\\u0648\\u0646\\u0627\\u062a \\u0648\\u062d\\u0641\\u0638\\u0647\\u0627"},"es":{"name":"Configurar permisos y guardar"},"fr":{"name":"Configurer les autorisations et enregistrer"},"hi":{"name":"\\u0905\\u0928\\u0941\\u092e\\u0924\\u093f\\u092f\\u093e\\u0901 \\u0915\\u0949\\u0928\\u094d\\u092b\\u093c\\u093f\\u0917\\u0930 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0938\\u0939\\u0947\\u091c\\u0947\\u0902"}},"id":"6724bb4f864ed"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:27:44','updated_at' => '2024-12-12 18:21:52'),
            array('id' => '24','parent_id' => '24','type' => 'enterprise','value' => '{"images":{"section_image":"f28f4df8-6d2b-40ba-875a-5611d1fb409b.webp","step_image":"436cb13b-8967-4460-ae1e-1ceb485c0a4d.webp"},"language":{"en":{"heading":"Receive Money Easily and Securely with QRPay Pro","sub_heading":"QRPay Pro makes it simple for agents to receive funds, whether it\\u2019s from customers or other agents. With fast and secure transfers, QRPay Pro ensures that every transaction is processed with top-tier security and convenience, enabling multi-currency support to accept payments from various regions.","process_step_title":"Steps to Receive Money Instantly with QRPay Pro","button_name":"Start Receiving Money","button_link":"agent\\/receive-money","step_title":"How to Receive Funds in Your QRPay Pro Account","step_sub_title":"Follow these simple steps to receive funds quickly and securely to your QRPay Pro account."},"es":{"heading":"Reciba dinero de forma f\\u00e1cil y segura con QRPay Pro","sub_heading":"QRPay Pro facilita que los agentes reciban fondos, ya sean de clientes u otros agentes. Con transferencias r\\u00e1pidas y seguras, QRPay Pro garantiza que cada transacci\\u00f3n se procese con seguridad y conveniencia de primer nivel, lo que permite soporte multidivisa para aceptar pagos de varias regiones.","process_step_title":"Pasos para recibir dinero al instante con QRPay Pro","button_name":"Comience a recibir dinero","button_link":"agent\\/receive-money","step_title":"C\\u00f3mo recibir fondos en su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para recibir fondos de forma r\\u00e1pida y segura en su cuenta QRPay Pro."},"ar":{"heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u064a\\u0633\\u0647\\u0651\\u0644 QRPay Pro \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0627\\u0644\\u0622\\u0645\\u0646\\u0629\\u060c \\u064a\\u0636\\u0645\\u0646 QRPay Pro \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0628\\u0623\\u0645\\u0627\\u0646 \\u0648\\u0631\\u0627\\u062d\\u0629 \\u0639\\u0644\\u0649 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062a\\u064a\\u062d \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0644\\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0646 \\u0645\\u0646\\u0627\\u0637\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0645\\u0639 QRPay Pro","button_name":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","button_link":"agent\\/receive-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"fr":{"heading":"Recevez de l\'argent facilement et en toute s\\u00e9curit\\u00e9 avec QRPay Pro","sub_heading":"QRPay Pro permet aux agents de recevoir facilement des fonds, qu\'ils proviennent de clients ou d\'autres agents. Avec des transferts rapides et s\\u00e9curis\\u00e9s, QRPay Pro garantit que chaque transaction est trait\\u00e9e avec une s\\u00e9curit\\u00e9 et une commodit\\u00e9 de haut niveau, permettant une prise en charge multidevises pour accepter les paiements de diff\\u00e9rentes r\\u00e9gions.","process_step_title":"\\u00c9tapes pour recevoir de l\'argent instantan\\u00e9ment avec QRPay Pro","button_name":"Commencez \\u00e0 recevoir de l\'argent","button_link":"agent\\/receive-money","step_title":"Comment recevoir des fonds sur votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour recevoir des fonds rapidement et en toute s\\u00e9curit\\u00e9 sur votre compte QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","sub_heading":"QRPay Pro \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091a\\u093e\\u0939\\u0947 \\u0935\\u0939 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0939\\u094b \\u092f\\u093e \\u0905\\u0928\\u094d\\u092f \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0938\\u0947\\u0964 \\u0924\\u0947\\u091c \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0938\\u093e\\u0925, QRPay \\u092a\\u094d\\u0930\\u094b \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0936\\u0940\\u0930\\u094d\\u0937 \\u0938\\u094d\\u0924\\u0930\\u0940\\u092f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0938\\u0915\\u094d\\u0937\\u092e \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964","process_step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u091a\\u0930\\u0923","button_name":"\\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/receive-money","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0936\\u0940\\u0918\\u094d\\u0930 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724bda066b3a":{"language":{"en":{"name":"Share Your QR Code or Account ID"},"ar":{"name":"\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0623\\u0648 \\u0645\\u0639\\u0631\\u0641 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628"},"es":{"name":"Comparta su c\\u00f3digo QR o ID de cuenta"},"fr":{"name":"Partagez votre code QR ou votre identifiant de compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u093e \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u092f\\u093e \\u0916\\u093e\\u0924\\u093e \\u0906\\u0908\\u0921\\u0940 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bda066b3a"},"6724bda707a61":{"language":{"en":{"name":"Confirm the Transfer Details"},"ar":{"name":"\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0646\\u0642\\u0644"},"es":{"name":"Confirmar los detalles de la transferencia"},"fr":{"name":"Confirmez les d\\u00e9tails du transfert"},"hi":{"name":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bda707a61"},"6724bdad88796":{"language":{"en":{"name":"Receive Notification of Funds Received"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0625\\u0634\\u0639\\u0627\\u0631 \\u0628\\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u0629"},"es":{"name":"Recibir notificaci\\u00f3n de fondos recibidos"},"fr":{"name":"Recevoir une notification des fonds re\\u00e7us"},"hi":{"name":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bdad88796"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:38:02','updated_at' => '2024-12-12 18:28:05'),
            array('id' => '25','parent_id' => '25','type' => 'enterprise','value' => '{"images":{"section_image":"81c24481-93c9-4b8c-a39d-348bde89156e.webp","step_image":"4c92b1ac-d191-460d-abcf-f0f02a871bbc.webp"},"language":{"en":{"heading":"Seamless Currency Exchange with QRPay Pro","sub_heading":"QRPay Pro enables agents to exchange currencies in real-time, making it easier to handle international transactions. With competitive exchange rates and a straightforward process, agents can support clients and customers without the hassle of external currency exchanges.","process_step_title":"Steps to Exchange Money Instantly with QRPay Pro","button_name":"Start Exchanging Money","button_link":"agent\\/money-exchange","step_title":"How to Exchange Currencies in Your QRPay Pro Account","step_sub_title":"Follow these quick steps to securely exchange funds in different currencies directly within QRPay Pro."},"es":{"heading":"Cambio de divisas sin problemas con QRPay Pro","sub_heading":"QRPay Pro permite a los agentes cambiar divisas en tiempo real, lo que facilita el manejo de transacciones internacionales. Con tipos de cambio competitivos y un proceso sencillo, los agentes pueden ayudar a clientes y clientes sin la molestia de los cambios de moneda externos.","process_step_title":"Pasos para cambiar dinero al instante con QRPay Pro","button_name":"Comience a intercambiar dinero","button_link":"agent\\/money-exchange","step_title":"C\\u00f3mo cambiar monedas en su cuenta QRPay Pro","step_sub_title":"Siga estos r\\u00e1pidos pasos para intercambiar fondos de forma segura en diferentes monedas directamente dentro de QRPay Pro."},"ar":{"heading":"\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u064a\\u0645\\u0643\\u0651\\u0646 QRPay Pro \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0645\\u0646 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0647\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629. \\u0628\\u0641\\u0636\\u0644 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0627\\u0644\\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0648\\u0627\\u0644\\u0632\\u0628\\u0627\\u0626\\u0646 \\u062f\\u0648\\u0646 \\u0645\\u062a\\u0627\\u0639\\u0628 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0645\\u0639 QRPay Pro","button_name":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","button_link":"agent\\/money-exchange","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0628\\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629\\u064b \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro."},"fr":{"heading":"\\u00c9change de devises transparent avec QRPay Pro","sub_heading":"QRPay Pro permet aux agents d\'\\u00e9changer des devises en temps r\\u00e9el, facilitant ainsi la gestion des transactions internationales. Avec des taux de change comp\\u00e9titifs et un processus simple, les agents peuvent assister les clients sans les tracas des \\u00e9changes de devises externes.","process_step_title":"\\u00c9tapes pour \\u00e9changer de l\'argent instantan\\u00e9ment avec QRPay Pro","button_name":"Commencez \\u00e0 \\u00e9changer de l\'argent","button_link":"agent\\/money-exchange","step_title":"Comment \\u00e9changer des devises dans votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes rapides pour \\u00e9changer en toute s\\u00e9curit\\u00e9 des fonds dans diff\\u00e9rentes devises directement dans QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0915\\u094d\\u0937\\u092e \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u0940\\u0927\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u090f\\u091c\\u0947\\u0902\\u091f \\u092c\\u093e\\u0939\\u0930\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0940 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u0915\\u0947 \\u092c\\u093f\\u0928\\u093e \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964","process_step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092a\\u0948\\u0938\\u0947 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u091a\\u0930\\u0923","button_name":"\\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/money-exchange","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0938\\u0940\\u0927\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724be6867727":{"language":{"en":{"name":"Select Currencies for Exchange"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0644\\u0644\\u0635\\u0631\\u0641"},"es":{"name":"Seleccionar monedas para el cambio"},"fr":{"name":"S\\u00e9lectionnez les devises pour l\'\\u00e9change"},"hi":{"name":"\\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u090f\\u0901 \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724be6867727"},"6724be6dd6ca8":{"language":{"en":{"name":"Enter Exchange Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0635\\u0631\\u0641"},"es":{"name":"Ingrese el monto del cambio"},"fr":{"name":"Entrez le montant d\'\\u00e9change"},"hi":{"name":"\\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724be6dd6ca8"},"6724be73267d4":{"language":{"en":{"name":"Confirm and Complete"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0643\\u0645\\u0627\\u0644"},"es":{"name":"Confirmar y completar"},"fr":{"name":"Confirmer et compl\\u00e9ter"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u0942\\u0930\\u094d\\u0923 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724be73267d4"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:41:20','updated_at' => '2024-12-12 18:28:36'),
            array('id' => '26','parent_id' => '26','type' => 'enterprise','value' => '{"images":{"section_image":"f3cfddc6-8a40-46d8-b8ed-9f8195b70f97.webp","step_image":"041b4520-1498-4b62-8568-2e9c327c6736.webp"},"language":{"en":{"heading":"Quickly and securely fund your QRPay Pro account to facilitate transactions with clients.","sub_heading":"With QRPay Pro, adding funds to your account is a straightforward process. Whether you need to increase your balance for transactions or client services, our platform offers various secure funding options.","process_step_title":"Simple Steps to Add Money to Your Account","button_name":"Start Adding Money","button_link":"agent\\/add-money","step_title":"How to Add Money to Your QRPay Pro Account","step_sub_title":"Follow these easy steps to fund your QRPay Pro account swiftly and securely."},"es":{"heading":"Deposite fondos de forma r\\u00e1pida y segura en su cuenta QRPay Pro para facilitar las transacciones con los clientes.","sub_heading":"Con QRPay Pro, agregar fondos a su cuenta es un proceso sencillo. Ya sea que necesite aumentar su saldo para transacciones o servicios al cliente, nuestra plataforma ofrece varias opciones de financiaci\\u00f3n segura.","process_step_title":"Pasos sencillos para agregar dinero a su cuenta","button_name":"Comience a agregar dinero","button_link":"agent\\/add-money","step_title":"C\\u00f3mo agregar dinero a su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para depositar fondos en su cuenta QRPay Pro de forma r\\u00e1pida y segura."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u062a\\u0645\\u0648\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0644\\u062a\\u0633\\u0647\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621.","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u062a\\u0639\\u062f \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0632\\u064a\\u0627\\u062f\\u0629 \\u0631\\u0635\\u064a\\u062f\\u0643 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621\\u060c \\u0641\\u0625\\u0646 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u062a\\u0648\\u0641\\u0631 \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643","button_name":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","button_link":"agent\\/add-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646."},"fr":{"heading":"Alimentez rapidement et en toute s\\u00e9curit\\u00e9 votre compte QRPay Pro pour faciliter les transactions avec les clients.","sub_heading":"Avec QRPay Pro, ajouter des fonds \\u00e0 votre compte est un processus simple. Que vous ayez besoin d\'augmenter votre solde pour des transactions ou des services clients, notre plateforme propose diverses options de financement s\\u00e9curis\\u00e9es.","process_step_title":"\\u00c9tapes simples pour ajouter de l\'argent \\u00e0 votre compte","button_name":"Commencez \\u00e0 ajouter de l\'argent","button_link":"agent\\/add-money","step_title":"Comment ajouter de l\'argent \\u00e0 votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour approvisionner votre compte QRPay Pro rapidement et en toute s\\u00e9curit\\u00e9."},"hi":{"heading":"\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u094b\\u0921\\u093c\\u0928\\u093e \\u090f\\u0915 \\u0938\\u0940\\u0927\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u0948\\u0964 \\u091a\\u093e\\u0939\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092f\\u093e \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u092c\\u0922\\u093c\\u093e\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b, \\u0939\\u092e\\u093e\\u0930\\u093e \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964","process_step_title":"\\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u092a\\u0948\\u0938\\u093e \\u091c\\u094b\\u0921\\u093c\\u0928\\u093e \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/add-money","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u0947\\u091c\\u0940 \\u0938\\u0947 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724bf4929a21":{"language":{"en":{"name":"Choose Your Funding Method"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Elija su m\\u00e9todo de financiaci\\u00f3n"},"fr":{"name":"Choisissez votre m\\u00e9thode de financement"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0940 \\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724bf4929a21"},"6724bf4e5fe76":{"language":{"en":{"name":"Enter the Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Ingrese la cantidad"},"fr":{"name":"Entrez le montant"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bf4e5fe76"},"6724bf543f724":{"language":{"en":{"name":"Confirm Your Details"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Confirma tus datos"},"fr":{"name":"Confirmez vos coordonn\\u00e9es"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bf543f724"},"6724bf59b689c":{"language":{"en":{"name":"Receive Confirmation"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f"},"es":{"name":"Recibir confirmaci\\u00f3n"},"fr":{"name":"Recevoir une confirmation"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f\\u0915\\u0930\\u0923 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724bf59b689c"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:45:07','updated_at' => '2024-12-12 18:28:58'),
            array('id' => '27','parent_id' => '27','type' => 'enterprise','value' => '{"images":{"section_image":"a2b386fa-4cce-4dfd-8f9f-f2b70e1d8559.webp","step_image":"04eff4d4-05c8-4b1f-9b20-2550bf288a32.webp"},"language":{"en":{"heading":"Effortlessly Withdraw Funds from Your QRPay Pro Account","sub_heading":"With QRPay Pro, withdrawing money is a simple and secure process. Access your funds easily and transfer them to your bank account when needed.","process_step_title":"Simple Steps to Withdraw Money from Your Account","button_name":"Start Withdrawal","button_link":"agent\\/withdraw","step_title":"How to Withdraw Money from Your QRPay Pro Account","step_sub_title":"Follow these straightforward steps to securely withdraw funds from your account."},"es":{"heading":"Retire fondos sin esfuerzo de su cuenta QRPay Pro","sub_heading":"Con QRPay Pro, retirar dinero es un proceso sencillo y seguro. Acceda a sus fondos f\\u00e1cilmente y transfi\\u00e9ralos a su cuenta bancaria cuando sea necesario.","process_step_title":"Pasos sencillos para retirar dinero de su cuenta","button_name":"Iniciar retiro","button_link":"agent\\/withdraw","step_title":"C\\u00f3mo retirar dinero de su cuenta QRPay Pro","step_sub_title":"Siga estos sencillos pasos para retirar fondos de su cuenta de forma segura."},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u064a\\u0639\\u062f \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u062a\\u062d\\u0648\\u064a\\u0644\\u0647\\u0627 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0628\\u0646\\u0643\\u064a \\u0639\\u0646\\u062f \\u0627\\u0644\\u062d\\u0627\\u062c\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0643","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u0627\\u0644\\u0633\\u062d\\u0628","button_link":"agent\\/withdraw","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646."},"fr":{"heading":"Retirez sans effort des fonds de votre compte QRPay Pro","sub_heading":"Avec QRPay Pro, retirer de l\'argent est un processus simple et s\\u00e9curis\\u00e9. Acc\\u00e9dez facilement \\u00e0 vos fonds et transf\\u00e9rez-les sur votre compte bancaire en cas de besoin.","process_step_title":"\\u00c9tapes simples pour retirer de l\'argent de votre compte","button_name":"Commencer le retrait","button_link":"agent\\/withdraw","step_title":"Comment retirer de l\'argent de votre compte QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour retirer des fonds de votre compte en toute s\\u00e9curit\\u00e9."},"hi":{"heading":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u093e \\u090f\\u0915 \\u0938\\u0930\\u0932 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0928\\u0947 \\u092b\\u0902\\u0921 \\u0924\\u0915 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u0930\\u0942\\u0930\\u0924 \\u092a\\u0921\\u093c\\u0928\\u0947 \\u092a\\u0930 \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964","process_step_title":"\\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/withdraw","step_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c00381850":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c00381850"},"6724c00952871":{"language":{"en":{"name":"Navigate to the Withdraw Section"},"ar":{"name":"\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Navegue a la secci\\u00f3n de retiro"},"fr":{"name":"Acc\\u00e9dez \\u00e0 la section Retrait"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901"}},"id":"6724c00952871"},"6724c00f8d8ee":{"language":{"en":{"name":"Enter the Withdrawal Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0633\\u062d\\u0628"},"es":{"name":"Ingrese el monto del retiro"},"fr":{"name":"Entrez le montant du retrait"},"hi":{"name":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c00f8d8ee"},"6724c01531602":{"language":{"en":{"name":"Choose Your Withdrawal Method"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643"},"es":{"name":"Elija su m\\u00e9todo de retiro"},"fr":{"name":"Choisissez votre m\\u00e9thode de retrait"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c01531602"},"6724c01a59eb1":{"language":{"en":{"name":"Review and Confirm"},"ar":{"name":"\\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f"},"es":{"name":"Revisar y confirmar"},"fr":{"name":"V\\u00e9rifier et confirmer"},"hi":{"name":"\\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c01a59eb1"},"6724c02166181":{"language":{"en":{"name":"Receive Confirmation"},"ar":{"name":"\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f"},"es":{"name":"Recibir confirmaci\\u00f3n"},"fr":{"name":"Recevoir une confirmation"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f\\u0915\\u0930\\u0923 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c02166181"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:48:11','updated_at' => '2024-12-31 12:27:03'),
            array('id' => '28','parent_id' => '28','type' => 'enterprise','value' => '{"images":{"section_image":"64920fcf-1991-4f43-b469-477398a5cc1c.webp","step_image":"553fe347-7ee9-41bc-bb18-9a76f4ce47f8.webp"},"language":{"en":{"heading":"Effortlessly Send Money Between Agents on QRPay Pro","sub_heading":"With QRPay Pro, sending money between agents is quick, secure, and efficient. Ensure your transactions are safe with our robust platform designed for agent-to-agent transfers.","process_step_title":"Simple Steps to Send Money Between Agents","button_name":"Send Money Now","button_link":"agent\\/send-money","step_title":"How to Send Money as an Agent Using QRPay Pro","step_sub_title":"Follow these straightforward steps to securely transfer funds to another agent."},"es":{"heading":"Enviar dinero entre agentes f\\u00e1cilmente en QRPay Pro","sub_heading":"Con QRPay Pro, enviar dinero entre agentes es r\\u00e1pido, seguro y eficiente. Asegure sus transacciones con nuestra plataforma robusta, dise\\u00f1ada para transferencias de agente a agente.","process_step_title":"Pasos sencillos para enviar dinero entre agentes.","button_name":"Enviar dinero ahora.","button_link":"agent\\/send-money","step_title":"C\\u00f3mo enviar dinero como agente en QRPay Pro","step_sub_title":"Siga estos sencillos pasos para transferir fondos de forma segura a otro agente."},"ar":{"heading":"\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0633\\u0631\\u064a\\u0639 \\u0648\\u0622\\u0645\\u0646 \\u0648\\u0641\\u0639\\u0627\\u0644. \\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0645\\u0627\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u0627\\u064b \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621.","button_name":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646.","button_link":"agent\\/send-money","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0643\\u0648\\u0643\\u064a\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 \\u0622\\u062e\\u0631."},"fr":{"heading":"Envoyez de l\'argent facilement entre agents avec QRPay Pro","sub_heading":"Avec QRPay Pro, envoyer de l\'argent entre agents est rapide, s\\u00e9curis\\u00e9 et efficace. Assurez la s\\u00e9curit\\u00e9 de vos transactions gr\\u00e2ce \\u00e0 notre plateforme robuste, con\\u00e7ue pour les transferts entre agents.","process_step_title":"\\u00c9tapes simples pour envoyer de l\'argent entre agents.","button_name":"Envoyez de l\'argent maintenant.","button_link":"agent\\/send-money","step_title":"Comment envoyer de l\'argent en tant qu\'agent sur QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour transf\\u00e9rer des fonds en toute s\\u00e9curit\\u00e9 vers un autre agent."},"hi":{"heading":"QRPay Pro \\u092a\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e \\u0924\\u0947\\u091c\\u093c, \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u0941\\u0936\\u0932 \\u0939\\u0948\\u0964 \\u090f\\u091c\\u0947\\u0902\\u091f-\\u091f\\u0942-\\u090f\\u091c\\u0947\\u0902\\u091f \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092b\\u0930 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0939\\u092e\\u093e\\u0930\\u0947 \\u092e\\u091c\\u092c\\u0942\\u0924 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0947\\u0902\\u0964","process_step_title":"\\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0927\\u0928 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0930\\u0932 \\u0915\\u0926\\u092e\\u0964","button_name":"\\u0905\\u092c \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902\\u0964","button_link":"agent\\/send-money","step_title":"QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","step_sub_title":"\\u0915\\u093f\\u0938\\u0940 \\u0905\\u0928\\u094d\\u092f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c11ddbc5e":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c11ddbc5e"},"6724c153a8c89":{"language":{"en":{"name":"Navigate to the Send Money Section"},"ar":{"name":"\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"},"es":{"name":"Navegue a la secci\\u00f3n Enviar dinero"},"fr":{"name":"Acc\\u00e9dez \\u00e0 la section Envoyer de l\'argent"},"hi":{"name":"\\u0927\\u0928 \\u092d\\u0947\\u091c\\u0947\\u0902 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901"}},"id":"6724c153a8c89"},"6724c159aac89":{"language":{"en":{"name":"Enter Recipient Agent\\u2019s Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645"},"es":{"name":"Ingrese los detalles del agente destinatario"},"fr":{"name":"Entrez les d\\u00e9tails de l\'agent destinataire"},"hi":{"name":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c159aac89"},"6724c15ed69c0":{"language":{"en":{"name":"Specify the Amount"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Especifique la cantidad"},"fr":{"name":"Pr\\u00e9cisez le montant"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c15ed69c0"},"6724c164704ef":{"language":{"en":{"name":"Review Transaction Details"},"ar":{"name":"\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629"},"es":{"name":"Revisar los detalles de la transacci\\u00f3n"},"fr":{"name":"V\\u00e9rifier les d\\u00e9tails de la transaction"},"hi":{"name":"\\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c164704ef"},"6724c16be1fea":{"language":{"en":{"name":"Confirm and Send"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0631\\u0633\\u0627\\u0644"},"es":{"name":"Confirmar y enviar"},"fr":{"name":"Confirmer et envoyer"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0947\\u091c\\u0947\\u0902"}},"id":"6724c16be1fea"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:52:47','updated_at' => '2024-12-12 18:29:58'),
            array('id' => '29','parent_id' => '29','type' => 'enterprise','value' => '{"images":{"section_image":"6046b16b-3f4c-413e-8fa4-77f455d2f780.webp","step_image":"0dbb06b3-3580-43a5-8f43-8321c2780ac6.webp"},"language":{"en":{"heading":"Quick and Secure Money Transfers to Users with QRPay Pro","sub_heading":"With QRPay Pro, agents can easily send money to users\' wallets, ensuring a smooth and secure transaction process.","process_step_title":"Simple Steps to Send Money to Users","button_name":"Send Money Now","button_link":"agent\\/money-in","step_title":"How to Transfer Money to Users\' Wallets","step_sub_title":"Follow these easy steps to send funds from your QRPay Pro account to users\' wallets."},"es":{"heading":"Transferencias de dinero r\\u00e1pidas y seguras a usuarios con QRPay Pro","sub_heading":"Con QRPay Pro, los agentes pueden enviar dinero f\\u00e1cilmente a las billeteras de los usuarios, garantizando un proceso de transacci\\u00f3n seguro y sin problemas.","process_step_title":"Pasos sencillos para enviar dinero a los usuarios","button_name":"Env\\u00eda dinero ahora","button_link":"agent\\/money-in","step_title":"C\\u00f3mo transferir dinero a las billeteras de los usuarios","step_sub_title":"Siga estos sencillos pasos para enviar fondos desde su cuenta QRPay Pro a las billeteras de los usuarios."},"ar":{"heading":"\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0645\\u0627\\u0644\\u064a\\u0629 \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"\\u0645\\u0639 QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646","button_name":"\\u0623\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"agent\\/money-in","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0633\\u0647\\u0644\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646."},"fr":{"heading":"Transferts d\'argent rapides et s\\u00e9curis\\u00e9s vers les utilisateurs avec QRPay Pro","sub_heading":"Avec QRPay Pro, les agents peuvent facilement envoyer de l\'argent vers les portefeuilles des utilisateurs, garantissant ainsi un processus de transaction fluide et s\\u00e9curis\\u00e9.","process_step_title":"\\u00c9tapes simples pour envoyer de l\'argent aux utilisateurs","button_name":"Envoyez de l\'argent maintenant","button_link":"agent\\/money-in","step_title":"Comment transf\\u00e9rer de l\'argent vers les portefeuilles des utilisateurs","step_sub_title":"Suivez ces \\u00e9tapes simples pour envoyer des fonds de votre compte QRPay Pro vers les portefeuilles des utilisateurs."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u090f\\u091c\\u0947\\u0902\\u091f \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u090f\\u0915 \\u0938\\u0939\\u091c \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964","process_step_title":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","button_link":"agent\\/money-in","step_title":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092b\\u0930 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c4dfd0366":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c4dfd0366"},"6724c4e620c76":{"language":{"en":{"name":"Select Money In Option"},"ar":{"name":"\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0627\\u0644 \\u0641\\u064a \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631"},"es":{"name":"Seleccione la opci\\u00f3n Dinero en efectivo"},"fr":{"name":"S\\u00e9lectionnez l\'option d\'entr\\u00e9e d\'argent"},"hi":{"name":"\\u092e\\u0928\\u0940 \\u0907\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c4e620c76"},"6724c4ec29391":{"language":{"en":{"name":"Choose the User"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645"},"es":{"name":"Elige el usuario"},"fr":{"name":"Choisissez l\'utilisateur"},"hi":{"name":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c4ec29391"},"6724c516d4116":{"language":{"en":{"name":"Enter Transfer Amount"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644"},"es":{"name":"Ingrese el monto de la transferencia"},"fr":{"name":"Saisir le montant du transfert"},"hi":{"name":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c516d4116"},"6724c51c36147":{"language":{"en":{"name":"Review Transaction Details"},"ar":{"name":"\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629"},"es":{"name":"Revisar los detalles de la transacci\\u00f3n"},"fr":{"name":"V\\u00e9rifier les d\\u00e9tails de la transaction"},"hi":{"name":"\\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c51c36147"},"6724c522ee912":{"language":{"en":{"name":"Confirm and Complete Transfer"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0646\\u0642\\u0644"},"es":{"name":"Confirmar y completar la transferencia"},"fr":{"name":"Confirmer et terminer le transfert"},"hi":{"name":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u0942\\u0930\\u094d\\u0923 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c522ee912"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:08:56','updated_at' => '2024-12-12 18:30:27'),
            array('id' => '30','parent_id' => '30','type' => 'enterprise','value' => '{"images":{"section_image":"17c20ddf-9ce9-4a2e-9ebc-e549de16cb04.webp","step_image":"b8899c75-0138-4a91-a0d1-d74d1d12cc88.webp"},"language":{"en":{"heading":"Easy and Secure Bill Payments with QRPay Pro","sub_heading":"QRPay Pro allows agents to pay bills seamlessly on behalf of users, ensuring timely payments and hassle-free transactions.","process_step_title":"Quick Steps to Pay Bills","button_name":"Start Bill Payment Now","button_link":"agent\\/bill-pay","step_title":"How to Pay Bills Using QRPay Pro","step_sub_title":"Follow these simple steps to make bill payments on behalf of users."},"es":{"heading":"Pagos de facturas f\\u00e1ciles y seguros con QRPay Pro","sub_heading":"QRPay Pro permite a los agentes pagar facturas sin problemas en nombre de los usuarios, garantizando pagos puntuales y transacciones sin complicaciones.","process_step_title":"Pasos r\\u00e1pidos para pagar facturas","button_name":"Iniciar el pago de facturas ahora","button_link":"agent\\/bill-pay","step_title":"C\\u00f3mo pagar facturas usando QRPay Pro","step_sub_title":"Siga estos sencillos pasos para realizar pagos de facturas en nombre de los usuarios."},"ar":{"heading":"\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u064a\\u0633\\u0645\\u062d QRPay Pro \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0628\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628 \\u0648\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0622\\u0646","button_link":"agent\\/bill-pay","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u062a\\u0633\\u062f\\u064a\\u062f \\u062f\\u0641\\u0639\\u0627\\u062a \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646."},"fr":{"heading":"Paiements de factures faciles et s\\u00e9curis\\u00e9s avec QRPay Pro","sub_heading":"QRPay Pro permet aux agents de payer les factures de mani\\u00e8re transparente au nom des utilisateurs, garantissant ainsi des paiements en temps opportun et des transactions sans tracas.","process_step_title":"\\u00c9tapes rapides pour payer les factures","button_name":"Commencez le paiement des factures maintenant","button_link":"agent\\/bill-pay","step_title":"Comment payer ses factures avec QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour effectuer des paiements de factures au nom des utilisateurs."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0938\\u093e\\u0928 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0913\\u0930 \\u0938\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0938\\u092e\\u092f \\u092a\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0914\\u0930 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964","process_step_title":"\\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0915\\u0926\\u092e","button_name":"\\u0905\\u092d\\u0940 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/bill-pay","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0913\\u0930 \\u0938\\u0947 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c5cfec25e":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c5cfec25e"},"6724c5d599e6e":{"language":{"en":{"name":"Select Bill Pay Option"},"ar":{"name":"\\u062d\\u062f\\u062f \\u062e\\u064a\\u0627\\u0631 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629"},"es":{"name":"Seleccione la opci\\u00f3n de pago de facturas"},"fr":{"name":"S\\u00e9lectionnez l\'option de paiement de facture"},"hi":{"name":"\\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c5d599e6e"},"6724c5db7e253":{"language":{"en":{"name":"Choose the Type of Bill"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629"},"es":{"name":"Elija el tipo de factura"},"fr":{"name":"Choisissez le type de facture"},"hi":{"name":"\\u092c\\u093f\\u0932 \\u0915\\u093e \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c5db7e253"},"6724c5e076c0c":{"language":{"en":{"name":"Enter Bill Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629"},"es":{"name":"Ingrese los detalles de la factura"},"fr":{"name":"Entrez les d\\u00e9tails de la facture"},"hi":{"name":"\\u092c\\u093f\\u0932 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c5e076c0c"},"6724c5e889efa":{"language":{"en":{"name":"Review Payment Details"},"ar":{"name":"\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Revisar detalles de pago"},"fr":{"name":"V\\u00e9rifier les d\\u00e9tails du paiement"},"hi":{"name":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c5e889efa"},"6724c5ee1863f":{"language":{"en":{"name":"Confirm and Complete Payment"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639"},"es":{"name":"Confirmar y completar el pago"},"fr":{"name":"Confirmer et finaliser le paiement"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c5ee1863f"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:12:57','updated_at' => '2024-12-12 18:30:51'),
            array('id' => '31','parent_id' => '31','type' => 'enterprise','value' => '{"images":{"section_image":"dd394b87-6030-40b2-b451-442a41c94244.webp","step_image":"14bd55c6-ddf2-4309-9df6-4beef0513723.webp"},"language":{"en":{"heading":"Quick and Convenient Mobile Top-Ups with QRPay Pro","sub_heading":"QRPay Pro enables agents to easily top up mobile accounts for users, ensuring they stay connected without interruption.","process_step_title":"Simple Steps to Top-Up Mobile Accounts","button_name":"Start Mobile Top-Up Now","button_link":"agent\\/mobile-topup","step_title":"How to Top-Up Mobile Phones Using QRPay Pro","step_sub_title":"How to Top-Up Mobile Phones Using QRPay Pro"},"es":{"heading":"Recargas m\\u00f3viles r\\u00e1pidas y c\\u00f3modas con QRPay Pro","sub_heading":"QRPay Pro permite a los agentes recargar f\\u00e1cilmente las cuentas m\\u00f3viles de los usuarios, garantizando que permanezcan conectados sin interrupciones.","process_step_title":"Pasos sencillos para recargar cuentas m\\u00f3viles","button_name":"Iniciar recarga m\\u00f3vil ahora","button_link":"agent\\/mobile-topup","step_title":"C\\u00f3mo recargar tel\\u00e9fonos m\\u00f3viles usando QRPay Pro","step_sub_title":"C\\u00f3mo recargar tel\\u00e9fonos m\\u00f3viles usando QRPay Pro"},"ar":{"heading":"Quick and Convenient Mobile Top-Ups with QRPay Pro","sub_heading":"\\u064a\\u062a\\u064a\\u062d QRPay Pro \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0628\\u0642\\u0627\\u0626\\u0647\\u0645 \\u0639\\u0644\\u0649 \\u0627\\u062a\\u0635\\u0627\\u0644 \\u062f\\u0648\\u0646 \\u0627\\u0646\\u0642\\u0637\\u0627\\u0639.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0644\\u0625\\u0639\\u0627\\u062f\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"agent\\/mobile-topup","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro"},"fr":{"heading":"Recharges mobiles rapides et pratiques avec QRPay Pro","sub_heading":"QRPay Pro permet aux agents de recharger facilement les comptes mobiles des utilisateurs, garantissant ainsi qu\'ils restent connect\\u00e9s sans interruption.","process_step_title":"\\u00c9tapes simples pour recharger les comptes mobiles","button_name":"Commencez la recharge mobile maintenant","button_link":"agent\\/mobile-topup","step_title":"Comment recharger des t\\u00e9l\\u00e9phones mobiles \\u00e0 l\'aide de QRPay Pro","step_sub_title":"Comment recharger des t\\u00e9l\\u00e9phones mobiles \\u00e0 l\'aide de QRPay Pro"},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0915\\u094d\\u0937\\u092e \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0935\\u0947 \\u092c\\u093f\\u0928\\u093e \\u0915\\u093f\\u0938\\u0940 \\u0930\\u0941\\u0915\\u093e\\u0935\\u091f \\u0915\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0947 \\u0930\\u0939\\u0947\\u0902\\u0964","process_step_title":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u094b\\u0902 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923","button_name":"\\u0905\\u092d\\u0940 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/mobile-topup","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u094b\\u0928 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u094b\\u0928 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902"}},"items":{"6724c69fee051":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c69fee051"},"6724c6a52e314":{"language":{"en":{"name":"Select Mobile Top-Up Option"},"ar":{"name":"\\u062d\\u062f\\u062f \\u062e\\u064a\\u0627\\u0631 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644"},"es":{"name":"Seleccione la opci\\u00f3n de recarga m\\u00f3vil"},"fr":{"name":"S\\u00e9lectionnez l\'option de recharge mobile"},"hi":{"name":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c6a52e314"},"6724c6ab1876e":{"language":{"en":{"name":"Enter the Mobile Number"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0644"},"es":{"name":"Ingrese el n\\u00famero de m\\u00f3vil"},"fr":{"name":"Entrez le num\\u00e9ro de portable"},"hi":{"name":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c6ab1876e"},"6724c6afee3bb":{"language":{"en":{"name":"Choose the Amount"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a"},"es":{"name":"Elige la cantidad"},"fr":{"name":"Choisissez le montant"},"hi":{"name":"\\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c6afee3bb"},"6724c6b53ff08":{"language":{"en":{"name":"Review Top-Up Details"},"ar":{"name":"\\u0642\\u0645 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0628\\u0626\\u0629"},"es":{"name":"Revisar los detalles de la recarga"},"fr":{"name":"V\\u00e9rifier les d\\u00e9tails de la recharge"},"hi":{"name":"\\u091f\\u0949\\u092a-\\u0905\\u092a \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c6b53ff08"},"6724c6c01e447":{"language":{"en":{"name":"Confirm and Complete Top-Up"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0628\\u0626\\u0629"},"es":{"name":"Confirmar y completar recarga"},"fr":{"name":"Confirmer et terminer la recharge"},"hi":{"name":"\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c6c01e447"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:16:14','updated_at' => '2024-12-12 18:31:12'),
            array('id' => '32','parent_id' => '32','type' => 'enterprise','value' => '{"images":{"section_image":"c4ee9177-b2ac-4374-aead-2990abf37daa.webp","step_image":"ee4c38f2-50eb-4d40-8aac-6f8248ea5b3b.webp"},"language":{"en":{"heading":"Fast and Secure Remittance Services with QRPay Pro","sub_heading":"QRPay Pro allows agents to send money internationally, ensuring funds reach users quickly and securely.","process_step_title":"Easy Steps to Send Remittances","button_name":"Start Send Remittance Now","button_link":"agent\\/remittance","step_title":"How to Remit Funds Using QRPay Pro","step_sub_title":"Follow these straightforward steps to send money to users quickly and reliably."},"es":{"heading":"Servicios de remesas r\\u00e1pidos y seguros con QRPay Pro","sub_heading":"QRPay Pro permite a los agentes enviar dinero internacionalmente, garantizando que los fondos lleguen a los usuarios de forma r\\u00e1pida y segura.","process_step_title":"Pasos sencillos para enviar remesas","button_name":"Comience a enviar remesas ahora","button_link":"agent\\/remittance","step_title":"C\\u00f3mo enviar fondos usando QRPay Pro","step_sub_title":"Siga estos sencillos pasos para enviar dinero a los usuarios de forma r\\u00e1pida y confiable."},"ar":{"heading":"\\u062e\\u062f\\u0645\\u0627\\u062a \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u064a\\u062a\\u064a\\u062d QRPay Pro \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646.","process_step_title":"\\u062e\\u0637\\u0648\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u062d\\u0648\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0646","button_link":"agent\\/remittance","step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0648\\u0628\\u0634\\u0643\\u0644 \\u0645\\u0648\\u062b\\u0648\\u0642."},"fr":{"heading":"Services de transfert de fonds rapides et s\\u00e9curis\\u00e9s avec QRPay Pro","sub_heading":"QRPay Pro permet aux agents d\'envoyer de l\'argent \\u00e0 l\'international, garantissant ainsi que les fonds parviennent aux utilisateurs rapidement et en toute s\\u00e9curit\\u00e9.","process_step_title":"\\u00c9tapes faciles pour envoyer des fonds","button_name":"Commencez \\u00e0 envoyer des fonds maintenant","button_link":"agent\\/remittance","step_title":"Comment transf\\u00e9rer des fonds \\u00e0 l\'aide de QRPay Pro","step_sub_title":"Suivez ces \\u00e9tapes simples pour envoyer de l\\u2019argent aux utilisateurs de mani\\u00e8re rapide et fiable."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0924\\u0947\\u091c\\u093c \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0938\\u0947\\u0935\\u093e\\u090f\\u0901","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u092a\\u0948\\u0938\\u093e \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0927\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0924\\u0915 \\u091c\\u0932\\u094d\\u0926\\u0940 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u0939\\u0941\\u0902\\u091a\\u0947\\u0964","process_step_title":"\\u0927\\u0928 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0906\\u0938\\u093e\\u0928 \\u091a\\u0930\\u0923","button_name":"\\u0905\\u092d\\u0940 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0947\\u0902","button_link":"agent\\/remittance","step_title":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902","step_sub_title":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0936\\u0940\\u0918\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u0938\\u0930\\u0932 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c8cb3013b":{"language":{"en":{"name":"Log In to Your Account"},"ar":{"name":"\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643"},"es":{"name":"Inicie sesi\\u00f3n en su cuenta"},"fr":{"name":"Connectez-vous \\u00e0 votre compte"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u0905\\u0915\\u093e\\u0909\\u0902\\u091f \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c8cb3013b"},"6724c8d013fd0":{"language":{"en":{"name":"Select the Remittance Option"},"ar":{"name":"\\u062d\\u062f\\u062f \\u062e\\u064a\\u0627\\u0631 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644"},"es":{"name":"Seleccione la opci\\u00f3n de remesa"},"fr":{"name":"S\\u00e9lectionnez l\'option de versement"},"hi":{"name":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c8d013fd0"},"6724c8d4c78e5":{"language":{"en":{"name":"Enter Recipient Details"},"ar":{"name":"\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645"},"es":{"name":"Ingrese los detalles del destinatario"},"fr":{"name":"Saisir les d\\u00e9tails du destinataire"},"hi":{"name":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c8d4c78e5"},"6724c8da7b20e":{"language":{"en":{"name":"Choose the Amount to Send"},"ar":{"name":"\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0631\\u0627\\u062f \\u0625\\u0631\\u0633\\u0627\\u0644\\u0647"},"es":{"name":"Elija la cantidad a enviar"},"fr":{"name":"Choisissez le montant \\u00e0 envoyer"},"hi":{"name":"\\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902"}},"id":"6724c8da7b20e"},"6724c8e103e92":{"language":{"en":{"name":"Review Transaction Details"},"ar":{"name":"\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629"},"es":{"name":"Revisar los detalles de la transacci\\u00f3n"},"fr":{"name":"V\\u00e9rifier les d\\u00e9tails de la transaction"},"hi":{"name":"\\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c8e103e92"},"6724c8e6b507a":{"language":{"en":{"name":"Confirm and Complete the Remittance"},"ar":{"name":"\\u062a\\u0623\\u0643\\u064a\\u062f \\u0648\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644"},"es":{"name":"Confirmar y completar la remesa"},"fr":{"name":"Confirmer et compl\\u00e9ter le versement"},"hi":{"name":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"6724c8e6b507a"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:25:39','updated_at' => '2024-12-12 18:31:35'),
            array('id' => '34','parent_id' => '34','type' => 'personal','value' => '{"images":{"section_image":"239be8d2-8d9d-4783-bfc9-77e06b8f8a3e.webp","step_image":"0cda7b56-6e84-4814-a066-ccc552c1c219.webp"},"language":{"en":{"heading":"Seamless Peer-to-Peer Currency Trading with QRPay Pro","sub_heading":"Experience flexible and secure currency exchange directly with other users. With QRPay Pro\\u2019s P2P Trading feature, users can browse the marketplace, negotiate terms, and complete transactions \\u2014 all within one trusted platform.","process_step_title":"How to Trade Currency on QRPay Pro","button_name":"Start Trading Now","button_link":"user\\/trade","step_title":"Getting Started with P2P Trading","step_sub_title":"Follow these steps to buy or sell currency securely via our peer-to-peer system."},"es":{"heading":"Comercio de divisas entre pares sin interrupciones con QRPay Pro","sub_heading":"Experimenta un intercambio de divisas flexible y seguro directamente con otros usuarios. Con la funci\\u00f3n de comercio P2P de QRPay Pro, los usuarios pueden explorar el mercado, negociar t\\u00e9rminos y completar transacciones, todo dentro de una plataforma confiable.","process_step_title":"C\\u00f3mo comerciar divisas en QRPay Pro","button_name":"Comienza a comerciar ahora","button_link":"user\\/trade","step_title":"Comenzando con el comercio P2P","step_sub_title":"Sigue estos pasos para comprar o vender moneda de forma segura a trav\\u00e9s de nuestro sistema peer-to-peer."},"ar":{"heading":"\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0639 QRPay Pro","sub_heading":"\\u0627\\u062e\\u062a\\u0628\\u0631 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0645\\u0631\\u0646\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0622\\u062e\\u0631\\u064a\\u0646. \\u0645\\u0639 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 \\u0641\\u064a QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u062a\\u0635\\u0641\\u062d \\u0627\\u0644\\u0633\\u0648\\u0642\\u060c \\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637\\u060c \\u0648\\u0625\\u062a\\u0645\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u2014 \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0636\\u0645\\u0646 \\u0645\\u0646\\u0635\\u0629 \\u0645\\u0648\\u062b\\u0648\\u0642\\u0629 \\u0648\\u0627\\u062d\\u062f\\u0629.","process_step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0639\\u0644\\u0649 QRPay Pro","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0622\\u0646","button_link":"user\\/trade","step_title":"\\u0627\\u0644\\u0628\\u062f\\u0621 \\u0641\\u064a \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631","step_sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0644\\u0634\\u0631\\u0627\\u0621 \\u0623\\u0648 \\u0628\\u064a\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0628\\u0623\\u0645\\u0627\\u0646 \\u0639\\u0628\\u0631 \\u0646\\u0638\\u0627\\u0645\\u0646\\u0627 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631."},"fr":{"heading":"\\u00c9change de devises fluide entre pairs avec QRPay Pro","sub_heading":"D\\u00e9couvrez un \\u00e9change de devises flexible et s\\u00e9curis\\u00e9 directement avec d\'autres utilisateurs. Gr\\u00e2ce \\u00e0 la fonctionnalit\\u00e9 de trading P2P de QRPay Pro, les utilisateurs peuvent parcourir le march\\u00e9, n\\u00e9gocier les conditions et finaliser les transactions \\u2014 le tout sur une seule plateforme fiable.","process_step_title":"Comment \\u00e9changer des devises sur QRPay Pro","button_name":"Commencez \\u00e0 trader maintenant","button_link":"user\\/trade","step_title":"Commencer avec le trading P2P","step_sub_title":"Suivez ces \\u00e9tapes pour acheter ou vendre des devises en toute s\\u00e9curit\\u00e9 via notre syst\\u00e8me peer-to-peer."},"hi":{"heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0939\\u091c \\u092a\\u0940\\u092f\\u0930-\\u091f\\u0942-\\u092a\\u0940\\u092f\\u0930 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917","sub_heading":"\\u0905\\u0928\\u094d\\u092f \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0940\\u0927\\u0947 \\u0932\\u091a\\u0940\\u0932\\u093e \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u093e \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0930\\u0947\\u0902\\u0964 QRPay Pro \\u0915\\u0940 \\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f\\u092a\\u094d\\u0932\\u0947\\u0938 \\u092c\\u094d\\u0930\\u093e\\u0909\\u091c\\u093c \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u092c\\u093e\\u0924\\u091a\\u0940\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u2014 \\u0935\\u094b \\u092d\\u0940 \\u090f\\u0915 \\u0939\\u0940 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092a\\u0930\\u0964","process_step_title":"QRPay Pro \\u092a\\u0930 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0915\\u093e \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u0905\\u092d\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/trade","step_title":"\\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0915\\u0940 \\u0936\\u0941\\u0930\\u0941\\u0906\\u0924 \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0939\\u092e\\u093e\\u0930\\u0947 \\u092a\\u0940\\u092f\\u0930-\\u091f\\u0942-\\u092a\\u0940\\u092f\\u0930 \\u0938\\u093f\\u0938\\u094d\\u091f\\u092e \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u092f\\u093e \\u092c\\u0947\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0928 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6830229c9230f":{"language":{"en":{"name":"Log in to Your QRPay Pro Account"},"ar":{"name":"\\u0633\\u062c\\u0651\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0639\\u0644\\u0649 QRPay Pro"},"es":{"name":"Inicia sesi\\u00f3n en tu cuenta de QRPay Pro"},"fr":{"name":"Connectez-vous \\u00e0 votre compte QRPay Pro"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 QRPay Pro \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"6830229c9230f"},"683022d469943":{"language":{"en":{"name":"Navigate to the P2P Trade Marketplace"},"ar":{"name":"\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0633\\u0648\\u0642 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631"},"es":{"name":"Navega al mercado de comercio P2P"},"fr":{"name":"Acc\\u00e9dez au march\\u00e9 du trading P2P"},"hi":{"name":"\\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f\\u092a\\u094d\\u0932\\u0947\\u0938 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902"}},"id":"683022d469943"},"683022f526189":{"language":{"en":{"name":"Browse Offers or Post a Trade"},"ar":{"name":"\\u062a\\u0635\\u0641\\u062d \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0623\\u0648 \\u0627\\u0646\\u0634\\u0631 \\u0635\\u0641\\u0642\\u0629"},"es":{"name":"Navega ofertas o publica una operaci\\u00f3n"},"fr":{"name":"Parcourez les offres ou publiez une transaction"},"hi":{"name":"\\u0911\\u092b\\u093c\\u0930 \\u0926\\u0947\\u0916\\u0947\\u0902 \\u092f\\u093e \\u091f\\u094d\\u0930\\u0947\\u0921 \\u092a\\u094b\\u0938\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902"}},"id":"683022f526189"},"6830231fe3456":{"language":{"en":{"name":"Negotiate Terms via Offer\\/Counteroffer System"},"ar":{"name":"\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0639\\u0631\\u0636\\/\\u0627\\u0644\\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0636\\u0627\\u062f"},"es":{"name":"Negocia los t\\u00e9rminos mediante el sistema de oferta\\/contraoferta"},"fr":{"name":"N\\u00e9gociez les conditions via le syst\\u00e8me d\'offre\\/contre-offre"},"hi":{"name":"\\u0911\\u092b\\u0930\\/\\u0915\\u093e\\u0909\\u0902\\u091f\\u0930\\u0911\\u092b\\u0930 \\u0938\\u093f\\u0938\\u094d\\u091f\\u092e \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u092c\\u093e\\u0924\\u091a\\u0940\\u0924 \\u0915\\u0930\\u0947\\u0902"}},"id":"6830231fe3456"},"6830234315094":{"language":{"en":{"name":"Use Live Chat to Finalize Deal"},"ar":{"name":"\\u0627\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u0625\\u0646\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0635\\u0641\\u0642\\u0629"},"es":{"name":"Usa el chat en vivo para finalizar el trato"},"fr":{"name":"Utilisez le chat en direct pour finaliser l\'accord"},"hi":{"name":"\\u0921\\u0940\\u0932 \\u092b\\u093e\\u0907\\u0928\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0932\\u093e\\u0907\\u0935 \\u091a\\u0948\\u091f \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902"}},"id":"6830234315094"},"683023659ad9a":{"language":{"en":{"name":"Confirm Trade & Process Payment Securely"},"ar":{"name":"\\u0623\\u0643\\u062f \\u0627\\u0644\\u0635\\u0641\\u0642\\u0629 \\u0648\\u0642\\u0645 \\u0628\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0623\\u0645\\u0627\\u0646"},"es":{"name":"Confirma la operaci\\u00f3n y procesa el pago de forma segura"},"fr":{"name":"Confirmez la transaction et effectuez le paiement en toute s\\u00e9curit\\u00e9"},"hi":{"name":"\\u091f\\u094d\\u0930\\u0947\\u0921 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902"}},"id":"683023659ad9a"},"68302382e7150":{"language":{"en":{"name":"View Transaction in Your Trade History"},"ar":{"name":"\\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0641\\u064a \\u0633\\u062c\\u0644 \\u062a\\u062f\\u0627\\u0648\\u0644\\u0627\\u062a\\u0643"},"es":{"name":"Ver la transacci\\u00f3n en tu historial de operaciones"},"fr":{"name":"Voir la transaction dans votre historique de trading"},"hi":{"name":"\\u0905\\u092a\\u0928\\u0947 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092e\\u0947\\u0902 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0926\\u0947\\u0916\\u0947\\u0902"}},"id":"68302382e7150"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 13:00:03','updated_at' => '2025-05-23 14:47:18'),
                array('id' => '35','parent_id' => '35','type' => 'personal','value' => '{"images":{"section_image":"9fca4760-93df-4d10-884e-233c7f80d67e.webp","step_image":"db40ae70-374a-4ec5-9e47-aca5e20b69b0.webp"},"language":{"en":{"heading":"Instant Messaging Between Users for Smoother Transactions","sub_heading":"With QRPay Pro\\u2019s built-in P2P Live Chat, users can communicate in real time \\u2014 making currency trading and deal negotiations faster, easier, and more secure.","process_step_title":"How to Use P2P Chat on QRPay Pro","button_name":"Start Chatting","button_link":"user\\/my-chat","step_title":"Chat Directly With Buyers or Sellers","step_sub_title":"Connect instantly to finalize terms, ask questions, and resolve any concerns directly within the platform."},"es":{"heading":"Mensajer\\u00eda instant\\u00e1nea entre usuarios para transacciones m\\u00e1s fluidas","sub_heading":"Con el chat en vivo P2P integrado de QRPay Pro, los usuarios pueden comunicarse en tiempo real, haciendo que el comercio de divisas y la negociaci\\u00f3n de acuerdos sean m\\u00e1s r\\u00e1pidos, f\\u00e1ciles y seguros.","process_step_title":"C\\u00f3mo usar el chat P2P en QRPay Pro","button_name":"Comenzar a chatear","button_link":"user\\/my-chat","step_title":"Chatea directamente con compradores o vendedores","step_sub_title":"Con\\u00e9ctate al instante para finalizar los t\\u00e9rminos, hacer preguntas y resolver cualquier inquietud directamente dentro de la plataforma."},"ar":{"heading":"\\u0627\\u0644\\u0645\\u0631\\u0627\\u0633\\u0644\\u0629 \\u0627\\u0644\\u0641\\u0648\\u0631\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0644\\u062a\\u0633\\u0647\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a","sub_heading":"\\u0645\\u0639 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0645\\u062c\\u0629 \\u0641\\u064a QRPay Pro\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a \\u2014 \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644 \\u062a\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0635\\u0641\\u0642\\u0627\\u062a \\u0623\\u0633\\u0631\\u0639 \\u0648\\u0623\\u0633\\u0647\\u0644 \\u0648\\u0623\\u0643\\u062b\\u0631 \\u0623\\u0645\\u0627\\u0646\\u064b\\u0627.","process_step_title":"\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 (P2P) \\u0639\\u0644\\u0649 QRPay Pro","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629","button_link":"user\\/my-chat","step_title":"\\u062f\\u0631\\u062f\\u0634 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u064a\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639\\u064a\\u0646","step_sub_title":"\\u0627\\u062a\\u0635\\u0644 \\u0641\\u0648\\u0631\\u064b\\u0627 \\u0644\\u0625\\u0646\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637\\u060c \\u0648\\u0637\\u0631\\u062d \\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629\\u060c \\u0648\\u062d\\u0644 \\u0623\\u064a \\u0645\\u062e\\u0627\\u0648\\u0641 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629\\u064b \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629."},"fr":{"heading":"Messagerie instantan\\u00e9e entre utilisateurs pour des transactions plus fluides","sub_heading":"Avec le chat en direct P2P int\\u00e9gr\\u00e9 de QRPay Pro, les utilisateurs peuvent communiquer en temps r\\u00e9el \\u2014 rendant le trading de devises et les n\\u00e9gociations d\\u2019accords plus rapides, plus faciles et plus s\\u00fbrs.","process_step_title":"Comment utiliser le chat P2P sur QRPay Pro","button_name":"Commencer \\u00e0 discuter","button_link":"user\\/my-chat","step_title":"Discutez directement avec les acheteurs ou les vendeurs","step_sub_title":"Connectez-vous instantan\\u00e9ment pour finaliser les conditions, poser des questions et r\\u00e9soudre toutes les pr\\u00e9occupations directement sur la plateforme."},"hi":{"heading":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0938\\u0902\\u0926\\u0947\\u0936 \\u0938\\u0947\\u0935\\u093e \\u0924\\u093e\\u0915\\u093f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u091a\\u093e\\u0930\\u0942 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0939\\u094b \\u0938\\u0915\\u0947\\u0902","sub_heading":"QRPay Pro \\u0915\\u0947 \\u092c\\u093f\\u0932\\u094d\\u091f-\\u0907\\u0928 P2P \\u0932\\u093e\\u0907\\u0935 \\u091a\\u0948\\u091f \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0930\\u093f\\u092f\\u0932 \\u091f\\u093e\\u0907\\u092e \\u092e\\u0947\\u0902 \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u2014 \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u0921\\u0940\\u0932 \\u0928\\u0947\\u0917\\u094b\\u0938\\u093f\\u090f\\u0936\\u0928 \\u0924\\u0947\\u091c\\u093c, \\u0906\\u0938\\u093e\\u0928 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964","process_step_title":"QRPay Pro \\u092a\\u0930 P2P \\u091a\\u0948\\u091f \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902","button_name":"\\u091a\\u0948\\u091f \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0947\\u0902","button_link":"user\\/my-chat","step_title":"\\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u094b\\u0902 \\u092f\\u093e \\u0935\\u093f\\u0915\\u094d\\u0930\\u0947\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0940\\u0927\\u0947 \\u091a\\u0948\\u091f \\u0915\\u0930\\u0947\\u0902","step_sub_title":"\\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0902\\u0924\\u093f\\u092e \\u0930\\u0942\\u092a \\u0926\\u0947\\u0928\\u0947, \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928 \\u092a\\u0942\\u091b\\u0928\\u0947, \\u0914\\u0930 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u091a\\u093f\\u0902\\u0924\\u093e \\u0915\\u094b \\u0938\\u0940\\u0927\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0939\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u091c\\u0941\\u0921\\u093c\\u0947\\u0902\\u0964"}},"items":{"683028ce90045":{"language":{"en":{"name":"Open a Trade Listing"},"ar":{"name":"\\u0627\\u0641\\u062a\\u062d \\u0625\\u0639\\u0644\\u0627\\u0646 \\u062a\\u062c\\u0627\\u0631\\u0629"},"es":{"name":"Abre un anuncio de comercio"},"fr":{"name":"Ouvrir une annonce commerciale"},"hi":{"name":"\\u091f\\u094d\\u0930\\u0947\\u0921 \\u0932\\u093f\\u0938\\u094d\\u091f\\u093f\\u0902\\u0917 \\u0916\\u094b\\u0932\\u0947\\u0902"}},"id":"683028ce90045"},"683028fa68fb4":{"language":{"en":{"name":"Click \\u2018Chat with User\\u2019"},"ar":{"name":"\\u0627\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\"\\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\""},"es":{"name":"Haz clic en \\"Chatear con usuario\\""},"fr":{"name":"Cliquez sur \\u00ab\\u00a0Discuter avec l\'utilisateur\\u00a0\\u00bb"},"hi":{"name":"\\u092f\\u0942\\u091c\\u093c\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091a\\u0948\\u091f \\u0915\\u0930\\u0947\\u0902\' \\u092a\\u0930 \\u0915\\u094d\\u0932\\u093f\\u0915 \\u0915\\u0930\\u0947\\u0902"}},"id":"683028fa68fb4"},"68302917410fd":{"language":{"en":{"name":"Discuss Pricing or Conditions"},"ar":{"name":"\\u0646\\u0627\\u0642\\u0634 \\u0627\\u0644\\u062a\\u0633\\u0639\\u064a\\u0631 \\u0623\\u0648 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637"},"es":{"name":"Discute el precio o las condiciones"},"fr":{"name":"Discutez des prix ou des conditions"},"hi":{"name":"\\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u092f\\u093e \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u091a\\u0930\\u094d\\u091a\\u093e \\u0915\\u0930\\u0947\\u0902"}},"id":"68302917410fd"},"68302935f2846":{"language":{"en":{"name":"Confirm Details in Real-Time"},"ar":{"name":"\\u0623\\u0643\\u062f \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a"},"es":{"name":"Confirma los detalles en tiempo real"},"fr":{"name":"Confirmez les d\\u00e9tails en temps r\\u00e9el"},"hi":{"name":"\\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902"}},"id":"68302935f2846"},"68302958c482b":{"language":{"en":{"name":"Proceed with Secure Transaction"},"ar":{"name":"\\u062a\\u0627\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629"},"es":{"name":"Procede con la transacci\\u00f3n segura"},"fr":{"name":"Proc\\u00e9dez \\u00e0 la transaction s\\u00e9curis\\u00e9e"},"hi":{"name":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0917\\u0947 \\u092c\\u0922\\u093c\\u0947\\u0902"}},"id":"68302958c482b"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 13:01:52','updated_at' => '2025-05-23 14:55:52')
        );
        FrontendHeaderSectionPage::truncate();
        FrontendHeaderSectionPage::insert($frontend_header_section_pages);

        $frontend_header_section_faqs = array(
            array('id' => '1','parent_id' => '1','type' => 'personal','value' => '{"language":{"en":{"heading":"How can I receive money through QRPay Pro?","sub_heading":"Simply share your QRPay Pro ID, email, or phone number with the sender, and they can transfer funds directly to your  account."},"ar":{"heading":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro\\u061f","sub_heading":"\\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0645\\u0639\\u0631\\u0641 QRPay Pro \\u0623\\u0648 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0631\\u0633\\u0644\\u060c \\u0648\\u064a\\u0645\\u0643\\u0646\\u0647 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643."},"es":{"heading":"\\u00bfC\\u00f3mo puedo recibir dinero a trav\\u00e9s de QRPay Pro?","sub_heading":"Simplemente comparta su ID de QRPay Pro, correo electr\\u00f3nico o n\\u00famero de tel\\u00e9fono con el remitente, y \\u00e9l podr\\u00e1 transferir fondos directamente a su cuenta."},"fr":{"heading":"Comment puis-je recevoir de l\'argent via QRPay Pro\\u00a0?","sub_heading":"Partagez simplement votre identifiant QRPay Pro, votre adresse e-mail ou votre num\\u00e9ro de t\\u00e9l\\u00e9phone avec l\'exp\\u00e9diteur, et il pourra transf\\u00e9rer des fonds directement sur votre compte."},"hi":{"heading":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","sub_heading":"\\u092c\\u0938 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0915 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u092a\\u0928\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940, \\u0908\\u092e\\u0947\\u0932 \\u092f\\u093e \\u092b\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0947\\u0902, \\u0914\\u0930 \\u0935\\u0947 \\u0938\\u0940\\u0927\\u0947 \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"items":{"6722fdf3dd60c":{"language":{"en":{"question":"Which currencies can I exchange with QRPay Pro?","answer":"QRPay Pro supports a variety of major currencies, allowing you to exchange between them with ease. For a full list of supported currencies, check your account settings or visit the Exchange Money page in the app."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u0644\\u0647\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0628\\u064a\\u0646\\u0647\\u0627 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629. \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0643\\u0627\\u0645\\u0644\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629\\u060c \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0623\\u0648 \\u0642\\u0645 \\u0628\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0635\\u0641\\u062d\\u0629 Exchange Money \\u0641\\u064a \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642."},"es":{"question":"\\u00bfQu\\u00e9 monedas puedo cambiar con QRPay Pro?","answer":"QRPay Pro admite una variedad de monedas importantes, lo que le permite intercambiarlas con facilidad. Para obtener una lista completa de las monedas admitidas, verifique la configuraci\\u00f3n de su cuenta o visite la p\\u00e1gina Exchange Money en la aplicaci\\u00f3n."},"fr":{"question":"Quelles devises puis-je \\u00e9changer avec QRPay Pro ?","answer":"QRPay Pro prend en charge une vari\\u00e9t\\u00e9 de devises principales, vous permettant d\'\\u00e9changer facilement entre elles. Pour une liste compl\\u00e8te des devises prises en charge, v\\u00e9rifiez les param\\u00e8tres de votre compte ou visitez la page Exchange Money de l\'application."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093f\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0909\\u0928\\u0915\\u0947 \\u092c\\u0940\\u091a \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u092a\\u0942\\u0930\\u0940 \\u0938\\u0942\\u091a\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902 \\u092f\\u093e \\u0910\\u092a \\u092e\\u0947\\u0902 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u092e\\u0928\\u0940 \\u092a\\u0947\\u091c \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902\\u0964"}},"id":"6722fdf3dd60c"},"6722fe0991db1":{"language":{"en":{"question":"How long does a currency exchange transaction take?","answer":"Currency exchanges are processed instantly. Once you confirm the transaction, your new balance will be available in your account within moments."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u062a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631. \\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0633\\u064a\\u0643\\u0648\\u0646 \\u0631\\u0635\\u064a\\u062f\\u0643 \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f \\u0645\\u062a\\u0627\\u062d\\u064b\\u0627 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u062e\\u0644\\u0627\\u0644 \\u0644\\u062d\\u0638\\u0627\\u062a."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo lleva una transacci\\u00f3n de cambio de moneda?","answer":"Los cambios de moneda se procesan al instante. Una vez que confirme la transacci\\u00f3n, su nuevo saldo estar\\u00e1 disponible en su cuenta en unos momentos."},"fr":{"question":"Combien de temps dure une op\\u00e9ration de change ?","answer":"Les \\u00e9changes de devises sont trait\\u00e9s instantan\\u00e9ment. Une fois la transaction confirm\\u00e9e, votre nouveau solde sera disponible sur votre compte en quelques instants."},"hi":{"question":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u090f\\u0915 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0915\\u0941\\u091b \\u0939\\u0940 \\u0915\\u094d\\u0937\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0906\\u092a\\u0915\\u093e \\u0928\\u092f\\u093e \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"6722fe0991db1"},"6722fe1edb933":{"language":{"en":{"question":"Are there any fees for exchanging currencies?","answer":"Yes, a small transaction fee may apply for currency exchanges. QRPay Pro offers competitive rates, and you\\u2019ll see any applicable fees and the exact conversion rate before you confirm the exchange."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0639\\u0644\\u0649 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0635\\u063a\\u064a\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a. \\u064a\\u0642\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631\\u064b\\u0627 \\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629\\u060c \\u0648\\u0633\\u062a\\u0631\\u0649 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0648\\u0645\\u0639\\u062f\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0642\\u064a\\u0642 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644."},"es":{"question":"\\u00bfHay alguna tarifa por cambiar divisas?","answer":"S\\u00ed, es posible que se aplique una peque\\u00f1a tarifa de transacci\\u00f3n para los cambios de moneda. QRPay Pro ofrece tarifas competitivas y ver\\u00e1 las tarifas aplicables y la tasa de conversi\\u00f3n exacta antes de confirmar el cambio."},"fr":{"question":"Y a-t-il des frais pour \\u00e9changer des devises ?","answer":"Oui, des frais de transaction minimes peuvent s\'appliquer pour les \\u00e9changes de devises. QRPay Pro propose des tarifs comp\\u00e9titifs et vous verrez tous les frais applicables ainsi que le taux de conversion exact avant de confirmer l\'\\u00e9change."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u091b\\u094b\\u091f\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0926\\u0930\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u094b\\u0908 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0914\\u0930 \\u0938\\u091f\\u0940\\u0915 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0926\\u0930 \\u0926\\u093f\\u0916\\u093e\\u0908 \\u0926\\u0947\\u0917\\u0940\\u0964"}},"id":"6722fe1edb933"},"6722fe33662d2":{"language":{"en":{"question":"How do I know the exchange rate is accurate?","answer":"QRPay Pro uses real-time exchange rates provided by trusted financial institutions. The rate you see at the time of transaction is the rate applied to your currency conversion, ensuring transparency and accuracy."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0623\\u0646 \\u0633\\u0639\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u062f\\u0642\\u064a\\u0642\\u061f","answer":"\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u062f\\u0645\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629. \\u0627\\u0644\\u0633\\u0639\\u0631 \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u0627\\u0647 \\u0641\\u064a \\u0648\\u0642\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0647\\u0648 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u0627\\u0644\\u0645\\u0637\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0642\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo s\\u00e9 que el tipo de cambio es exacto?","answer":"QRPay Pro utiliza tipos de cambio en tiempo real proporcionados por instituciones financieras confiables. La tasa que ve en el momento de la transacci\\u00f3n es la tasa aplicada a su conversi\\u00f3n de moneda, lo que garantiza transparencia y precisi\\u00f3n."},"fr":{"question":"Comment puis-je savoir si le taux de change est exact ?","answer":"QRPay Pro utilise les taux de change en temps r\\u00e9el fournis par des institutions financi\\u00e8res de confiance. Le taux que vous voyez au moment de la transaction est le taux appliqu\\u00e9 \\u00e0 votre conversion de devise, garantissant transparence et pr\\u00e9cision."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930 \\u0938\\u091f\\u0940\\u0915 \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0938\\u092e\\u092f \\u0906\\u092a \\u091c\\u094b \\u0926\\u0930 \\u0926\\u0947\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0935\\u0939 \\u0906\\u092a\\u0915\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0926\\u0930 \\u0939\\u0948, \\u091c\\u094b \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0938\\u091f\\u0940\\u0915\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"6722fe33662d2"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-10-31 09:45:14','updated_at' => '2024-11-06 19:10:19'),
            array('id' => '2','parent_id' => '5','type' => 'personal','value' => '{"language":{"en":{"heading":"Currency Exchange Made Easy","sub_heading":"Get quick answers to your questions about converting currencies in your QRPay Pro account."},"ar":{"heading":"\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0623\\u0635\\u0628\\u062d \\u0633\\u0647\\u0644\\u0627","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u062d\\u0648\\u0644 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"heading":"Cambio de moneda f\\u00e1cil","sub_heading":"Obtenga respuestas r\\u00e1pidas a sus preguntas sobre la conversi\\u00f3n de monedas en su cuenta QRPay Pro."},"fr":{"heading":"Cambio de moneda f\\u00e1cil","sub_heading":"Obtenez des r\\u00e9ponses rapides \\u00e0 vos questions sur la conversion de devises dans votre compte QRPay Pro."},"hi":{"heading":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u094b \\u0906\\u0938\\u093e\\u0928 \\u092c\\u0928\\u093e\\u092f\\u093e \\u0917\\u092f\\u093e","sub_heading":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67247b1515299":{"language":{"en":{"question":"Which currencies can I exchange with QRPay Pro?","answer":"QRPay Pro supports a variety of major currencies, allowing you to exchange between them with ease. For a full list of supported currencies, check your account settings or visit the Exchange Money page in the app."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u0644\\u0647\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0628\\u064a\\u0646\\u0647\\u0627 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629. \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0643\\u0627\\u0645\\u0644\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629\\u060c \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0623\\u0648 \\u0642\\u0645 \\u0628\\u0632\\u064a\\u0627\\u0631\\u0629 \\u0635\\u0641\\u062d\\u0629 Exchange Money \\u0641\\u064a \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642."},"es":{"question":"\\u00bfQu\\u00e9 monedas puedo cambiar con QRPay Pro?","answer":"QRPay Pro admite una variedad de monedas importantes, lo que le permite intercambiarlas con facilidad. Para obtener una lista completa de las monedas admitidas, verifique la configuraci\\u00f3n de su cuenta o visite la p\\u00e1gina Exchange Money en la aplicaci\\u00f3n."},"fr":{"question":"\\u00bfQu\\u00e9 monedas puedo cambiar con QRPay Pro?","answer":"QRPay Pro prend en charge une vari\\u00e9t\\u00e9 de devises principales, vous permettant d\'\\u00e9changer facilement entre elles. Pour une liste compl\\u00e8te des devises prises en charge, v\\u00e9rifiez les param\\u00e8tres de votre compte ou visitez la page Exchange Money de l\'application."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093f\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0909\\u0928\\u0915\\u0947 \\u092c\\u0940\\u091a \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u092a\\u0942\\u0930\\u0940 \\u0938\\u0942\\u091a\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902 \\u092f\\u093e \\u0910\\u092a \\u092e\\u0947\\u0902 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u092e\\u0928\\u0940 \\u092a\\u0947\\u091c \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902\\u0964"}},"id":"67247b1515299"},"67247b1fbbc53":{"language":{"en":{"question":"How long does a currency exchange transaction take?","answer":"Currency exchanges are processed instantly. Once you confirm the transaction, your new balance will be available in your account within moments."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u062a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631. \\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0633\\u064a\\u0643\\u0648\\u0646 \\u0631\\u0635\\u064a\\u062f\\u0643 \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f \\u0645\\u062a\\u0627\\u062d\\u064b\\u0627 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u062e\\u0644\\u0627\\u0644 \\u0644\\u062d\\u0638\\u0627\\u062a."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo lleva una transacci\\u00f3n de cambio de moneda?","answer":"Los cambios de moneda se procesan al instante. Una vez que confirme la transacci\\u00f3n, su nuevo saldo estar\\u00e1 disponible en su cuenta en unos momentos."},"fr":{"question":"\\u00bfCu\\u00e1nto tiempo lleva una transacci\\u00f3n de cambio de moneda?","answer":"Les \\u00e9changes de devises sont trait\\u00e9s instantan\\u00e9ment. Une fois la transaction confirm\\u00e9e, votre nouveau solde sera disponible sur votre compte en quelques instants."},"hi":{"question":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u090f\\u0915 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0915\\u0941\\u091b \\u0939\\u0940 \\u0915\\u094d\\u0937\\u0923\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0906\\u092a\\u0915\\u093e \\u0928\\u092f\\u093e \\u092c\\u0948\\u0932\\u0947\\u0902\\u0938 \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"67247b1fbbc53"},"67247b2c5e4fa":{"language":{"en":{"question":"Are there any fees for exchanging currencies?","answer":"Yes, a small transaction fee may apply for currency exchanges. QRPay Pro offers competitive rates, and you\\u2019ll see any applicable fees and the exact conversion rate before you confirm the exchange."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0639\\u0644\\u0649 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0635\\u063a\\u064a\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a. \\u064a\\u0642\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631\\u064b\\u0627 \\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629\\u060c \\u0648\\u0633\\u062a\\u0631\\u0649 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0648\\u0645\\u0639\\u062f\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0642\\u064a\\u0642 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644."},"es":{"question":"\\u00bfHay alguna tarifa por cambiar divisas?","answer":"S\\u00ed, es posible que se aplique una peque\\u00f1a tarifa de transacci\\u00f3n para los cambios de moneda. QRPay Pro ofrece tarifas competitivas y ver\\u00e1 las tarifas aplicables y la tasa de conversi\\u00f3n exacta antes de confirmar el cambio."},"fr":{"question":"\\u00bfHay alguna tarifa por cambiar divisas?","answer":"Oui, des frais de transaction minimes peuvent s\'appliquer pour les \\u00e9changes de devises. QRPay Pro propose des tarifs comp\\u00e9titifs et vous verrez tous les frais applicables ainsi que le taux de conversion exact avant de confirmer l\'\\u00e9change."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u091b\\u094b\\u091f\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0926\\u0930\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u094b\\u0908 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0914\\u0930 \\u0938\\u091f\\u0940\\u0915 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0926\\u0930 \\u0926\\u093f\\u0916\\u093e\\u0908 \\u0926\\u0947\\u0917\\u0940\\u0964"}},"id":"67247b2c5e4fa"},"67247b37b689e":{"language":{"en":{"question":"How do I know the exchange rate is accurate?","answer":"QRPay Pro uses real-time exchange rates provided by trusted financial institutions. The rate you see at the time of transaction is the rate applied to your currency conversion, ensuring transparency and accuracy."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0623\\u0646 \\u0633\\u0639\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u062f\\u0642\\u064a\\u0642\\u061f","answer":"\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u062f\\u0645\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629. \\u0627\\u0644\\u0633\\u0639\\u0631 \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u0627\\u0647 \\u0641\\u064a \\u0648\\u0642\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0647\\u0648 \\u0627\\u0644\\u0633\\u0639\\u0631 \\u0627\\u0644\\u0645\\u0637\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0642\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo s\\u00e9 que el tipo de cambio es exacto?","answer":"QRPay Pro utiliza tipos de cambio en tiempo real proporcionados por instituciones financieras confiables. La tasa que ve en el momento de la transacci\\u00f3n es la tasa aplicada a su conversi\\u00f3n de moneda, lo que garantiza transparencia y precisi\\u00f3n."},"fr":{"question":"\\u00bfC\\u00f3mo s\\u00e9 que el tipo de cambio es exacto?","answer":"QRPay Pro utilise les taux de change en temps r\\u00e9el fournis par des institutions financi\\u00e8res de confiance. Le taux que vous voyez au moment de la transaction est le taux appliqu\\u00e9 \\u00e0 votre conversion de devise, garantissant transparence et pr\\u00e9cision."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930 \\u0938\\u091f\\u0940\\u0915 \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0938\\u092e\\u092f \\u0906\\u092a \\u091c\\u094b \\u0926\\u0930 \\u0926\\u0947\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0935\\u0939 \\u0906\\u092a\\u0915\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0926\\u0930 \\u0939\\u0948, \\u091c\\u094b \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0938\\u091f\\u0940\\u0915\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"67247b37b689e"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 12:53:58','updated_at' => '2024-11-06 19:18:30'),
            array('id' => '6','parent_id' => '6','type' => 'personal','value' => '{"language":{"en":{"heading":"Sending Money with QRPay Pro: Your Questions Answered","sub_heading":"Learn everything you need to know to transfer funds effortlessly and securely."},"ar":{"heading":"\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro: \\u0627\\u0644\\u0625\\u062c\\u0627\\u0628\\u0629 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0626\\u0644\\u062a\\u0643","sub_heading":"\\u062a\\u0639\\u0644\\u0645 \\u0643\\u0644 \\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u0645\\u0639\\u0631\\u0641\\u062a\\u0647 \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646."},"es":{"heading":"Env\\u00edo de dinero con QRPay Pro: respuestas a sus preguntas","sub_heading":"Aprenda todo lo que necesita saber para transferir fondos de forma segura y sin esfuerzo."},"fr":{"heading":"Env\\u00edo de dinero con QRPay Pro: respuestas a sus preguntas","sub_heading":"Apprenez tout ce que vous devez savoir pour transf\\u00e9rer des fonds sans effort et en toute s\\u00e9curit\\u00e9."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e: \\u0906\\u092a\\u0915\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930","sub_heading":"\\u0938\\u0939\\u091c\\u0924\\u093e \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0924\\u0930\\u0940\\u0915\\u0947 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a\\u0915\\u094b \\u091c\\u094b \\u0915\\u0941\\u091b \\u092d\\u0940 \\u091c\\u093e\\u0928\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948, \\u0909\\u0938\\u0947 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"67249650b0783":{"language":{"en":{"question":"How can I send money to someone with QRPay Pro?","answer":"Simply enter the recipient\\u2019s QRPay Pro ID, email, or phone number, or scan their QR code. Once you confirm the details, the funds will be sent instantly to their account."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0634\\u062e\\u0635 \\u0645\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0625\\u062f\\u062e\\u0627\\u0644 \\u0645\\u0639\\u0631\\u0641 QRPay Pro \\u0623\\u0648 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u060c \\u0623\\u0648 \\u0645\\u0633\\u062d \\u0631\\u0645\\u0632 QR \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0647 \\u0636\\u0648\\u0626\\u064a\\u064b\\u0627. \\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644\\u060c \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0647\\u0645."},"es":{"question":"\\u00bfC\\u00f3mo puedo enviar dinero a alguien con QRPay Pro?","answer":"Simplemente ingrese el ID, el correo electr\\u00f3nico o el n\\u00famero de tel\\u00e9fono de QRPay Pro del destinatario, o escanee su c\\u00f3digo QR. Una vez que confirme los detalles, los fondos se enviar\\u00e1n instant\\u00e1neamente a su cuenta."},"fr":{"question":"\\u00bfC\\u00f3mo puedo enviar dinero a alguien con QRPay Pro?","answer":"Entrez simplement l\'identifiant QRPay Pro, l\'e-mail ou le num\\u00e9ro de t\\u00e9l\\u00e9phone du destinataire, ou scannez son code QR. Une fois les d\\u00e9tails confirm\\u00e9s, les fonds seront envoy\\u00e9s instantan\\u00e9ment sur leur compte."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0938\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092c\\u0938 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940, \\u0908\\u092e\\u0947\\u0932, \\u092f\\u093e \\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u092f\\u093e \\u0909\\u0928\\u0915\\u0947 QR \\u0915\\u094b\\u0921 \\u0915\\u094b \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u090f\\u0915 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0932\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0909\\u0928\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092d\\u0947\\u091c \\u0926\\u0940 \\u091c\\u093e\\u090f\\u0917\\u0940\\u0964"}},"id":"67249650b0783"},"6724965aec660":{"language":{"en":{"question":"Are there any fees for sending money?","answer":"QRPay Pro has competitive fees for money transfers, which may vary depending on the currency and destination. All fees are shown before you confirm the transaction, so there are no surprises."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0644\\u062f\\u0649 QRPay Pro \\u0631\\u0633\\u0648\\u0645 \\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629 \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0648\\u0627\\u0644\\u062a\\u064a \\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0648\\u0627\\u0644\\u0648\\u062c\\u0647\\u0629. \\u064a\\u062a\\u0645 \\u0639\\u0631\\u0636 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0644\\u0630\\u0644\\u0643 \\u0644\\u0627 \\u062a\\u0648\\u062c\\u062f \\u0645\\u0641\\u0627\\u062c\\u0622\\u062a."},"es":{"question":"\\u00bfHay alguna tarifa por enviar dinero?","answer":"QRPay Pro tiene tarifas competitivas para transferencias de dinero, que pueden variar seg\\u00fan la moneda y el destino. Todas las tarifas se muestran antes de confirmar la transacci\\u00f3n, para que no haya sorpresas."},"fr":{"question":"\\u00bfHay alguna tarifa por enviar dinero?","answer":"QRPay Pro propose des frais comp\\u00e9titifs pour les transferts d\'argent, qui peuvent varier en fonction de la devise et de la destination. Tous les frais sont affich\\u00e9s avant que vous confirmiez la transaction, il n\'y a donc pas de surprises."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"QRPay Pro \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948, \\u091c\\u094b \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0914\\u0930 \\u0917\\u0902\\u0924\\u0935\\u094d\\u092f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0938\\u092d\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0926\\u093f\\u0916\\u093e\\u090f \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0906\\u0936\\u094d\\u091a\\u0930\\u094d\\u092f \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948\\u0964"}},"id":"6724965aec660"},"672496649c9a2":{"language":{"en":{"question":"Can I send money internationally?","answer":"Yes! QRPay Pro supports international transfers. If the recipient\\u2019s currency differs, QRPay Pro will convert your funds at the current exchange rate, making global transfers simple and hassle-free."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062f\\u0648\\u0644\\u064a\\u0627\\u061f","answer":"\\u0646\\u0639\\u0645! \\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629. \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0641\\u0633\\u064a\\u0642\\u0648\\u0645 QRPay Pro \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0633\\u0639\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0627\\u0644\\u062d\\u0627\\u0644\\u064a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628."},"es":{"question":"\\u00bfPuedo enviar dinero internacionalmente?","answer":"\\u00a1S\\u00ed! QRPay Pro admite transferencias internacionales. Si la moneda del destinatario es diferente, QRPay Pro convertir\\u00e1 sus fondos al tipo de cambio actual, haciendo que las transferencias globales sean simples y sin complicaciones."},"fr":{"question":"\\u00bfPuedo enviar dinero internacionalmente?","answer":"Oui! QRPay Pro prend en charge les virements internationaux. Si la devise du destinataire diff\\u00e8re, QRPay Pro convertira vos fonds au taux de change actuel, rendant les transferts mondiaux simples et sans tracas."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u092a\\u0948\\u0938\\u093e \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901! QRPay \\u092a\\u094d\\u0930\\u094b \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0926\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u0948, \\u0924\\u094b QRPay Pro \\u0906\\u092a\\u0915\\u0947 \\u092b\\u0902\\u0921 \\u0915\\u094b \\u0935\\u0930\\u094d\\u0924\\u092e\\u093e\\u0928 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930 \\u092a\\u0930 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u0930 \\u0926\\u0947\\u0917\\u093e, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0938\\u0930\\u0932 \\u0914\\u0930 \\u092a\\u0930\\u0947\\u0936\\u093e\\u0928\\u0940 \\u092e\\u0941\\u0915\\u094d\\u0924 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"672496649c9a2"},"672496727c783":{"language":{"en":{"question":"How secure is it to send money through QRPay Pro?","answer":"Your security is our top priority. QRPay Pro uses advanced encryption and authentication methods to ensure your transactions are safe and secure, giving you peace of mind with every transfer."},"ar":{"question":"\\u0645\\u0627 \\u0645\\u062f\\u0649 \\u0623\\u0645\\u0627\\u0646 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0628\\u0631 QRPay Pro\\u061f","answer":"\\u0623\\u0645\\u0646\\u0643 \\u0647\\u0648 \\u0623\\u0648\\u0644\\u0648\\u064a\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0642\\u0635\\u0648\\u0649. \\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0627\\u0644\\u064a\\u0628 \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0645\\u0635\\u0627\\u062f\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0642\\u062f\\u0645\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0645\\u0623\\u0645\\u0648\\u0646\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0645\\u0646\\u062d\\u0643 \\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644 \\u0645\\u0639 \\u0643\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfQu\\u00e9 tan seguro es enviar dinero a trav\\u00e9s de QRPay Pro?","answer":"Su seguridad es nuestra principal prioridad. QRPay Pro utiliza m\\u00e9todos avanzados de cifrado y autenticaci\\u00f3n para garantizar que sus transacciones sean seguras, brind\\u00e1ndole tranquilidad con cada transferencia."},"fr":{"question":"\\u00bfQu\\u00e9 tan seguro es enviar dinero a trav\\u00e9s de QRPay Pro?","answer":"Votre s\\u00e9curit\\u00e9 est notre priorit\\u00e9 absolue. QRPay Pro utilise des m\\u00e9thodes avanc\\u00e9es de cryptage et d\'authentification pour garantir la s\\u00e9curit\\u00e9 de vos transactions, vous offrant ainsi une tranquillit\\u00e9 d\'esprit \\u00e0 chaque transfert."},"hi":{"question":"QRPay Pro \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u093e \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u0906\\u092a\\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u0930\\u094d\\u0935\\u094b\\u091a\\u094d\\u091a \\u092a\\u094d\\u0930\\u093e\\u0925\\u092e\\u093f\\u0915\\u0924\\u093e \\u0939\\u0948. QRPay Pro \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u0928\\u094d\\u0928\\u0924 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u0936\\u0928 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092e\\u093e\\u0923\\u0940\\u0915\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a\\u0915\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0939\\u0930 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915 \\u0936\\u093e\\u0902\\u0924\\u093f \\u092e\\u093f\\u0932\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"672496727c783"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:50:11','updated_at' => '2024-11-06 19:25:28'),
            array('id' => '7','parent_id' => '7','type' => 'personal','value' => '{"language":{"en":{"heading":"Quick Answers About QRPay Pro\\u2019s Payment Link Feature","sub_heading":"Find out how to create, share, and receive payments securely using QRPay Pro\\u2019s payment links."},"ar":{"heading":"\\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u0645\\u064a\\u0632\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647\\u0627 \\u0648\\u0627\\u0633\\u062a\\u0644\\u0627\\u0645\\u0647\\u0627 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro."},"es":{"heading":"Respuestas r\\u00e1pidas sobre la funci\\u00f3n de enlace de pago de QRPay Pro","sub_heading":"Descubra c\\u00f3mo crear, compartir y recibir pagos de forma segura utilizando los enlaces de pago de QRPay Pro."},"fr":{"heading":"Respuestas r\\u00e1pidas sobre la funci\\u00f3n de enlace de pago de QRPay Pro","sub_heading":"D\\u00e9couvrez comment cr\\u00e9er, partager et recevoir des paiements en toute s\\u00e9curit\\u00e9 \\u00e0 l\'aide des liens de paiement de QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0909\\u0924\\u094d\\u0924\\u0930","sub_heading":"QRPay Pro \\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092c\\u0928\\u093e\\u0928\\u0947, \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0924\\u0930\\u0940\\u0915\\u093e \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724979300b40":{"language":{"en":{"question":"How do I create a payment link in QRPay Pro?","answer":"To create a payment link, navigate to the Payment Link option in your QRPay Pro account. Enter the amount and currency, generate the link, and you\\u2019re ready to share it."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0642\\u0648\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u062e\\u064a\\u0627\\u0631 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643. \\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u0629\\u060c \\u0648\\u0623\\u0646\\u0634\\u0626 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637\\u060c \\u0648\\u0633\\u062a\\u0643\\u0648\\u0646 \\u062c\\u0627\\u0647\\u0632\\u064b\\u0627 \\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u062a\\u0647."},"es":{"question":"\\u00bfC\\u00f3mo creo un enlace de pago en QRPay Pro?","answer":"Para crear un enlace de pago, navegue hasta la opci\\u00f3n Enlace de pago en su cuenta QRPay Pro. Ingrese el monto y la moneda, genere el enlace y estar\\u00e1 listo para compartirlo."},"fr":{"question":"\\u00bfC\\u00f3mo creo un enlace de pago en QRPay Pro?","answer":"Pour cr\\u00e9er un lien de paiement, acc\\u00e9dez \\u00e0 l\'option Lien de paiement dans votre compte QRPay Pro. Entrez le montant et la devise, g\\u00e9n\\u00e9rez le lien et vous \\u00eates pr\\u00eat \\u00e0 le partager."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0948\\u0938\\u0947 \\u092c\\u0928\\u093e\\u090a\\u0902?","answer":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901\\u0964 \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0932\\u093f\\u0902\\u0915 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0906\\u092a \\u0907\\u0938\\u0947 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724979300b40"},"6724979f4c153":{"language":{"en":{"question":"Are there any fees for using a payment link?","answer":"A small transaction fee may apply to payment link transactions. You\\u2019ll see the fee before you confirm the link creation, ensuring transparency and no hidden costs."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639\\u061f","answer":"\\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0635\\u063a\\u064a\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639. \\u0633\\u062a\\u0631\\u0649 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0639\\u062f\\u0645 \\u0648\\u062c\\u0648\\u062f \\u062a\\u0643\\u0627\\u0644\\u064a\\u0641 \\u0645\\u062e\\u0641\\u064a\\u0629."},"es":{"question":"\\u00bfHay alguna tarifa por usar un enlace de pago?","answer":"Es posible que se aplique una peque\\u00f1a tarifa de transacci\\u00f3n a las transacciones de enlace de pago. Ver\\u00e1 la tarifa antes de confirmar la creaci\\u00f3n del enlace, lo que garantiza transparencia y sin costos ocultos."},"fr":{"question":"\\u00bfHay alguna tarifa por usar un enlace de pago?","answer":"Des frais de transaction minimes peuvent s\'appliquer aux transactions avec lien de paiement. Vous verrez les frais avant de confirmer la cr\\u00e9ation du lien, garantissant ainsi la transparence et l\\u2019absence de co\\u00fbts cach\\u00e9s."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u0930 \\u090f\\u0915 \\u091b\\u094b\\u091f\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0932\\u093f\\u0902\\u0915 \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0926\\u093f\\u0916\\u093e\\u0908 \\u0926\\u0947\\u0917\\u093e, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0917\\u0940 \\u0914\\u0930 \\u0915\\u094b\\u0908 \\u091b\\u093f\\u092a\\u0940 \\u0939\\u0941\\u0908 \\u0932\\u093e\\u0917\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"6724979f4c153"},"672497ae69f26":{"language":{"en":{"question":"Can I share a payment link with someone outside my country?","answer":"Yes, QRPay Pro supports international payments. If the payer\\u2019s currency is different, QRPay Pro will handle the currency conversion, making it easy to receive global payments."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0645\\u0639 \\u0634\\u062e\\u0635 \\u062e\\u0627\\u0631\\u062c \\u0628\\u0644\\u062f\\u064a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c QRPay Pro \\u064a\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629. \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062f\\u0627\\u0641\\u0639 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0641\\u0633\\u064a\\u0642\\u0648\\u0645 QRPay Pro \\u0628\\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0647\\u0644 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629."},"es":{"question":"\\u00bfPuedo compartir un enlace de pago con alguien fuera de mi pa\\u00eds?","answer":"S\\u00ed, QRPay Pro admite pagos internacionales. Si la moneda del pagador es diferente, QRPay Pro se encargar\\u00e1 de la conversi\\u00f3n de moneda, lo que facilitar\\u00e1 la recepci\\u00f3n de pagos globales."},"fr":{"question":"\\u00bfPuedo compartir un enlace de pago con alguien fuera de mi pa\\u00eds?","answer":"Oui, QRPay Pro prend en charge les paiements internationaux. Si la devise du payeur est diff\\u00e9rente, QRPay Pro se chargera de la conversion de devise, facilitant ainsi la r\\u00e9ception de paiements internationaux."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0926\\u0947\\u0936 \\u0915\\u0947 \\u092c\\u093e\\u0939\\u0930 \\u0915\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901, QRPay Pro \\u0905\\u0902\\u0924\\u0930\\u094d\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0926\\u093f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0905\\u0932\\u0917 \\u0939\\u0948, \\u0924\\u094b QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932 \\u0932\\u0947\\u0917\\u093e, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"672497ae69f26"},"672497b8544d1":{"language":{"en":{"question":"How secure is a payment link?","answer":"QRPay Pro\\u2019s payment links are encrypted and designed with security in mind. Each link is unique, and QRPay Pro uses advanced protection to ensure your transactions are safe and private."},"ar":{"question":"\\u0645\\u0627 \\u0645\\u062f\\u0649 \\u0623\\u0645\\u0627\\u0646 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639\\u061f","answer":"\\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0645\\u0634\\u0641\\u0631\\u0629 \\u0648\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0645\\u0639 \\u0623\\u062e\\u0630 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0641\\u064a \\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631. \\u0643\\u0644 \\u0631\\u0627\\u0628\\u0637 \\u0641\\u0631\\u064a\\u062f \\u0645\\u0646 \\u0646\\u0648\\u0639\\u0647\\u060c \\u0648\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u062a\\u0642\\u062f\\u0645\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u062e\\u0627\\u0635\\u0629."},"es":{"question":"\\u00bfQu\\u00e9 tan seguro es un enlace de pago?","answer":"Los enlaces de pago de QRPay Pro est\\u00e1n encriptados y dise\\u00f1ados teniendo en cuenta la seguridad. Cada enlace es \\u00fanico y QRPay Pro utiliza protecci\\u00f3n avanzada para garantizar que sus transacciones sean seguras y privadas."},"fr":{"question":"\\u00bfQu\\u00e9 tan seguro es un enlace de pago?","answer":"Les liens de paiement de QRPay Pro sont crypt\\u00e9s et con\\u00e7us dans un souci de s\\u00e9curit\\u00e9. Chaque lien est unique et QRPay Pro utilise une protection avanc\\u00e9e pour garantir que vos transactions sont s\\u00e9curis\\u00e9es et priv\\u00e9es."},"hi":{"question":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"QRPay Pro \\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u094b \\u0927\\u094d\\u092f\\u093e\\u0928 \\u092e\\u0947\\u0902 \\u0930\\u0916\\u0915\\u0930 \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u093f\\u0902\\u0915 \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f \\u0939\\u0948, \\u0914\\u0930 QRPay Pro \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u0928\\u094d\\u0928\\u0924 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a\\u0915\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0928\\u093f\\u091c\\u0940 \\u0939\\u0948\\u0964"}},"id":"672497b8544d1"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:55:33','updated_at' => '2024-11-06 19:31:49'),
            array('id' => '8','parent_id' => '8','type' => 'personal','value' => '{"language":{"en":{"heading":"Common Questions About Requesting Money with QRPay Pro","sub_heading":"Get the information you need to easily request funds from others using QRPay Pro."},"ar":{"heading":"\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u062a\\u0627\\u062c\\u0647\\u0627 \\u0644\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"heading":"Preguntas comunes sobre c\\u00f3mo solicitar dinero con QRPay Pro","sub_heading":"Obtenga la informaci\\u00f3n que necesita para solicitar fondos f\\u00e1cilmente a otras personas utilizando QRPay Pro."},"fr":{"heading":"Preguntas comunes sobre c\\u00f3mo solicitar dinero con QRPay Pro","sub_heading":"Obtenez les informations dont vous avez besoin pour demander facilement des fonds \\u00e0 d\'autres personnes en utilisant QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0947 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0926\\u0942\\u0938\\u0930\\u094b\\u0902 \\u0938\\u0947 \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249881b2a60":{"language":{"en":{"question":"How do I request money using QRPay Pro?","answer":"To request money, go to the Request Money feature, enter the recipient\'s QRPay Pro ID and the amount, then send your request. The recipient will receive a notification to complete the transaction."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0639\\u0631\\u0641 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0648\\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u062b\\u0645 \\u0623\\u0631\\u0633\\u0644 \\u0637\\u0644\\u0628\\u0643. \\u0633\\u064a\\u062a\\u0644\\u0642\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0644\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo solicito dinero usando QRPay Pro?","answer":"Para solicitar dinero, vaya a la funci\\u00f3n Solicitar dinero, ingrese el ID de QRPay Pro del destinatario y el monto, luego env\\u00ede su solicitud. El destinatario recibir\\u00e1 una notificaci\\u00f3n para completar la transacci\\u00f3n."},"fr":{"question":"\\u00bfC\\u00f3mo solicito dinero usando QRPay Pro?","answer":"Pour demander de l\'argent, acc\\u00e9dez \\u00e0 la fonction Demander de l\'argent, saisissez l\'identifiant QRPay Pro du destinataire et le montant, puis envoyez votre demande. Le destinataire recevra une notification pour finaliser la transaction."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0942\\u0901?","answer":"\\u0927\\u0928 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0927\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940 \\u0914\\u0930 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u092b\\u093f\\u0930 \\u0905\\u092a\\u0928\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c\\u0947\\u0902\\u0964 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"67249881b2a60"},"6724988f15b27":{"language":{"en":{"question":"Can I customize my payment request?","answer":"Yes, you can add a note or description to your payment request to specify what the funds are for, making it clear to the recipient."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u062e\\u0635\\u064a\\u0635 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0629 \\u0623\\u0648 \\u0648\\u0635\\u0641 \\u0644\\u0637\\u0644\\u0628 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u063a\\u0631\\u0636 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0648\\u0636\\u062d \\u0627\\u0644\\u0623\\u0645\\u0631 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645."},"es":{"question":"\\u00bfPuedo personalizar mi solicitud de pago?","answer":"S\\u00ed, puede agregar una nota o descripci\\u00f3n a su solicitud de pago para especificar para qu\\u00e9 son los fondos, dej\\u00e1ndolo claro al destinatario."},"fr":{"question":"\\u00bfPuedo personalizar mi solicitud de pago?","answer":"Oui, vous pouvez ajouter une note ou une description \\u00e0 votre demande de paiement pour pr\\u00e9ciser \\u00e0 quoi servent les fonds, ce qui sera clair pour le destinataire."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0928\\u094b\\u091f \\u092f\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u091c\\u094b\\u0921\\u093c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u092f\\u0939 \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947 \\u0915\\u093f \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0915\\u093f\\u0938 \\u0932\\u093f\\u090f \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u092f\\u0939 \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0939\\u094b \\u0938\\u0915\\u0947\\u0964"}},"id":"6724988f15b27"},"6724989e50c58":{"language":{"en":{"question":"What happens if the recipient doesn\\u2019t respond to my request?","answer":"If the recipient does not respond, you can resend the request or follow up with them directly. Notifications will inform you if the request has been viewed or accepted."},"ar":{"question":"\\u0645\\u0627\\u0630\\u0627 \\u064a\\u062d\\u062f\\u062b \\u0625\\u0630\\u0627 \\u0644\\u0645 \\u064a\\u0633\\u062a\\u062c\\u0628 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0644\\u0637\\u0644\\u0628\\u064a\\u061f","answer":"\\u0625\\u0630\\u0627 \\u0644\\u0645 \\u064a\\u0633\\u062a\\u062c\\u0628 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0637\\u0644\\u0628 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0628\\u0639\\u0629 \\u0645\\u0639\\u0647 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629. \\u0633\\u062a\\u062e\\u0628\\u0631\\u0643 \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0625\\u0630\\u0627 \\u062a\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0637\\u0644\\u0628 \\u0623\\u0648 \\u0642\\u0628\\u0648\\u0644\\u0647."},"es":{"question":"\\u00bfQu\\u00e9 pasa si el destinatario no responde a mi solicitud?","answer":"Si el destinatario no responde, puede reenviar la solicitud o hacer un seguimiento con \\u00e9l directamente. Las notificaciones le informar\\u00e1n si la solicitud ha sido vista o aceptada."},"fr":{"question":"\\u00bfQu\\u00e9 pasa si el destinatario no responde a mi solicitud?","answer":"Si le destinataire ne r\\u00e9pond pas, vous pouvez renvoyer la demande ou faire un suivi directement aupr\\u00e8s de lui. Les notifications vous informeront si la demande a \\u00e9t\\u00e9 consult\\u00e9e ou accept\\u00e9e."},"hi":{"question":"\\u092f\\u0926\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u092e\\u0947\\u0930\\u0947 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u093e \\u091c\\u0935\\u093e\\u092c \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0924\\u094b \\u0915\\u094d\\u092f\\u093e \\u0939\\u094b\\u0917\\u093e?","answer":"\\u092f\\u0926\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u091c\\u0935\\u093e\\u092c \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u0906\\u092a \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0926\\u094b\\u092c\\u093e\\u0930\\u093e \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u092f\\u093e \\u0938\\u0940\\u0927\\u0947 \\u0909\\u0928\\u0938\\u0947 \\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0926\\u093f \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0926\\u0947\\u0916\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948 \\u092f\\u093e \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930 \\u0932\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948 \\u0924\\u094b \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0902 \\u0906\\u092a\\u0915\\u094b \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0917\\u0940\\u0964"}},"id":"6724989e50c58"},"672498a9af0c5":{"language":{"en":{"question":"Are there any fees associated with requesting money?","answer":"QRPay Pro does not charge fees for sending a payment request. However, standard transaction fees may apply when the recipient sends the money to you."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0644\\u0627 \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u062f\\u0641\\u0639. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0642\\u064a\\u0627\\u0633\\u064a\\u0629 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0631\\u0633\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u064a\\u0643."},"es":{"question":"\\u00bfHay alg\\u00fan cargo asociado con la solicitud de dinero?","answer":"QRPay Pro no cobra tarifas por enviar una solicitud de pago. Sin embargo, es posible que se apliquen tarifas de transacci\\u00f3n est\\u00e1ndar cuando el destinatario le env\\u00ede el dinero."},"fr":{"question":"\\u00bfHay alg\\u00fan cargo asociado con la solicitud de dinero?","answer":"QRPay Pro ne facture pas de frais pour l\'envoi d\'une demande de paiement. Cependant, des frais de transaction standards peuvent s\'appliquer lorsque le destinataire vous envoie l\'argent."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"QRPay Pro \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u091c\\u092c \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0906\\u092a\\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0924\\u093e \\u0939\\u0948 \\u0924\\u094b \\u092e\\u093e\\u0928\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"672498a9af0c5"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 14:59:32','updated_at' => '2024-11-06 19:36:54'),
            array('id' => '9','parent_id' => '9','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Remittance","sub_heading":"Learn more about sending money internationally with QRPay Pro\\u2019s remittance feature."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062e\\u062f\\u0645\\u0629 \\u062a\\u062d\\u0648\\u064a\\u0644 QRPay Pro","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0641\\u064a QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre las remesas QRPay Pro","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo enviar dinero internacionalmente con la funci\\u00f3n de remesas de QRPay Pro."},"fr":{"heading":"Foire aux questions sur les versements QRPay Pro","sub_heading":"Apprenez-en davantage sur l\\u2019envoi d\\u2019argent \\u00e0 l\\u2019international gr\\u00e2ce \\u00e0 la fonction de versement de QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0930\\u0947\\u092e\\u093f\\u091f\\u0947\\u0902\\u0938 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"672499543b114":{"language":{"en":{"question":"How do I send money internationally using QRPay Pro?","answer":"To send remittance funds, navigate to the Remittance feature, enter the recipient\\u2019s information and the amount, select your transfer method, and confirm the transaction to initiate the transfer."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0648\\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u062d\\u062f\\u062f \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643\\u060c \\u0648\\u0623\\u0643\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0644\\u0628\\u062f\\u0621 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo env\\u00edo dinero internacionalmente usando QRPay Pro?","answer":"Para enviar fondos de remesas, navegue hasta la funci\\u00f3n Remesas, ingrese la informaci\\u00f3n del destinatario y el monto, seleccione su m\\u00e9todo de transferencia y confirme la transacci\\u00f3n para iniciar la transferencia."},"fr":{"question":"Comment envoyer de l\'argent \\u00e0 l\'international en utilisant QRPay Pro ?","answer":"Pour envoyer des fonds de transfert, acc\\u00e9dez \\u00e0 la fonction Remise de fonds, saisissez les informations du destinataire et le montant, s\\u00e9lectionnez votre m\\u00e9thode de transfert et confirmez la transaction pour lancer le transfert."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0942\\u0902?","answer":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0928\\u093f\\u0927\\u093f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0914\\u0930 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0905\\u092a\\u0928\\u0940 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902, \\u0914\\u0930 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"672499543b114"},"6724995e77e13":{"language":{"en":{"question":"What transfer methods can I use for remittances?","answer":"You can choose to send funds directly to a recipient\\u2019s bank account or opt for cash pickup at designated locations, depending on what is most convenient for the recipient."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0644\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0628\\u0646\\u0643\\u064a \\u0644\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0623\\u0648 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u062a\\u062d\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0646\\u0642\\u062f\\u064a\\u0629 \\u0645\\u0646 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0645\\u062d\\u062f\\u062f\\u0629\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0627 \\u0647\\u0648 \\u0623\\u0643\\u062b\\u0631 \\u0645\\u0644\\u0627\\u0621\\u0645\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de transferencia puedo utilizar para env\\u00edos de remesas?","answer":"Puede optar por enviar fondos directamente a la cuenta bancaria del destinatario u optar por el retiro en ventanilla en ubicaciones designadas, seg\\u00fan lo que sea m\\u00e1s conveniente para el destinatario."},"fr":{"question":"Quelles m\\u00e9thodes de transfert puis-je utiliser pour les envois de fonds ?","answer":"Vous pouvez choisir d\\u2019envoyer des fonds directement sur le compte bancaire d\\u2019un destinataire ou opter pour un retrait d\\u2019esp\\u00e8ces \\u00e0 des endroits d\\u00e9sign\\u00e9s, en fonction de ce qui convient le mieux au destinataire."},"hi":{"question":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0948\\u0902 \\u0915\\u093f\\u0928 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0906\\u092a \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0940\\u0927\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092d\\u0947\\u091c\\u0928\\u093e \\u091a\\u0941\\u0928 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u092f\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u092c\\u0938\\u0947 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u0915\\u094d\\u092f\\u093e \\u0939\\u0948, \\u0907\\u0938\\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u0928\\u0915\\u0926\\u0940 \\u0932\\u0947\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724995e77e13"},"6724996710b39":{"language":{"en":{"question":"How long does it take for the funds to arrive?","answer":"Transfer times vary based on the chosen method and destination country. Most transactions are processed quickly, but bank transfers may take longer depending on international banking protocols."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u064a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u062a\\u062e\\u062a\\u0644\\u0641 \\u0623\\u0648\\u0642\\u0627\\u062a \\u0627\\u0644\\u0646\\u0642\\u0644 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0627\\u0631\\u0629 \\u0648\\u0628\\u0644\\u062f \\u0627\\u0644\\u0648\\u062c\\u0647\\u0629. \\u062a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0645\\u0639\\u0638\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0628\\u0633\\u0631\\u0639\\u0629\\u060c \\u0648\\u0644\\u0643\\u0646 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0642\\u062f \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0648\\u0642\\u062a\\u064b\\u0627 \\u0623\\u0637\\u0648\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0628\\u0631\\u0648\\u062a\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo tardan en llegar los fondos?","answer":"Los tiempos de transferencia var\\u00edan seg\\u00fan el m\\u00e9todo elegido y el pa\\u00eds de destino. La mayor\\u00eda de las transacciones se procesan r\\u00e1pidamente, pero las transferencias bancarias pueden tardar m\\u00e1s seg\\u00fan los protocolos bancarios internacionales."},"fr":{"question":"Combien de temps faut-il pour que les fonds arrivent ?","answer":"Les temps de transfert varient en fonction de la m\\u00e9thode choisie et du pays de destination. La plupart des transactions sont trait\\u00e9es rapidement, mais les virements bancaires peuvent prendre plus de temps en fonction des protocoles bancaires internationaux."},"hi":{"question":"\\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0906\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u093e \\u0938\\u092e\\u092f \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u0935\\u093f\\u0927\\u093f \\u0914\\u0930 \\u0917\\u0902\\u0924\\u0935\\u094d\\u092f \\u0926\\u0947\\u0936 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0905\\u0932\\u0917-\\u0905\\u0932\\u0917 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0902\\u0936 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0936\\u0940\\u0918\\u094d\\u0930\\u0924\\u093e \\u0938\\u0947 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0932\\u0947\\u0915\\u093f\\u0928 \\u0905\\u0902\\u0924\\u0930\\u094d\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u092c\\u0948\\u0902\\u0915\\u093f\\u0902\\u0917 \\u092a\\u094d\\u0930\\u094b\\u091f\\u094b\\u0915\\u0949\\u0932 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724996710b39"},"67249970f157e":{"language":{"en":{"question":"Are there fees for sending remittance funds?","answer":"Yes, fees may apply based on the amount sent and the transfer method selected. You will be informed of any applicable fees before confirming your transaction, ensuring transparency."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0639\\u0644\\u0649 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0641\\u0631\\u0636 \\u0631\\u0633\\u0648\\u0645 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0631\\u0633\\u0644 \\u0648\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0628\\u0644\\u0627\\u063a\\u0643 \\u0628\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629."},"es":{"question":"\\u00bfExisten tarifas por enviar fondos de remesas?","answer":"S\\u00ed, se pueden aplicar tarifas seg\\u00fan el monto enviado y el m\\u00e9todo de transferencia seleccionado. Se le informar\\u00e1 de las tarifas aplicables antes de confirmar su transacci\\u00f3n, lo que garantiza la transparencia."},"fr":{"question":"Y a-t-il des frais pour l\'envoi de fonds\\u00a0?","answer":"Oui, des frais peuvent s\'appliquer en fonction du montant envoy\\u00e9 et de la m\\u00e9thode de transfert s\\u00e9lectionn\\u00e9e. Vous serez inform\\u00e9 des frais applicables avant de confirmer votre transaction, garantissant ainsi la transparence."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0928\\u093f\\u0927\\u093f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u092d\\u0947\\u091c\\u0940 \\u0917\\u0908 \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u091a\\u092f\\u0928\\u093f\\u0924 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0941\\u090f, \\u0906\\u092a\\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"67249970f157e"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:03:03','updated_at' => '2024-11-07 10:19:06'),
            array('id' => '10','parent_id' => '10','type' => 'personal','value' => '{"language":{"en":{"heading":"Common Questions About Adding Money to QRPay Pro","sub_heading":"Find answers to your queries regarding the process of adding funds to your QRPay Pro account."},"ar":{"heading":"\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"heading":"Preguntas comunes sobre c\\u00f3mo agregar dinero a QRPay Pro","sub_heading":"Encuentre respuestas a sus consultas sobre el proceso de agregar fondos a su cuenta QRPay Pro."},"fr":{"heading":"Preguntas comunes sobre c\\u00f3mo agregar dinero a QRPay Pro","sub_heading":"Trouvez des r\\u00e9ponses \\u00e0 vos questions concernant le processus d\'ajout de fonds \\u00e0 votre compte QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"67249a42c7f45":{"language":{"en":{"question":"How can I add money to my QRPay Pro account?","answer":"To add money, navigate to the Add Money feature, select your funding source, enter the desired amount, and confirm the transaction. Your funds will be available shortly after the process is complete."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 \\"\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644\\"\\u060c \\u0648\\u062d\\u062f\\u062f \\u0645\\u0635\\u062f\\u0631 \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u0633\\u062a\\u0643\\u0648\\u0646 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u0639\\u062f \\u0648\\u0642\\u062a \\u0642\\u0635\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo puedo agregar dinero a mi cuenta QRPay Pro?","answer":"Para agregar dinero, navegue hasta la funci\\u00f3n Agregar dinero, seleccione su fuente de financiamiento, ingrese el monto deseado y confirme la transacci\\u00f3n. Sus fondos estar\\u00e1n disponibles poco despu\\u00e9s de que se complete el proceso."},"fr":{"question":"\\u00bfC\\u00f3mo puedo agregar dinero a mi cuenta QRPay Pro?","answer":"Pour ajouter de l\'argent, acc\\u00e9dez \\u00e0 la fonction Ajouter de l\'argent, s\\u00e9lectionnez votre source de financement, entrez le montant souhait\\u00e9 et confirmez la transaction. Vos fonds seront disponibles peu de temps apr\\u00e8s la fin du processus."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947\\u0902 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u0905\\u092a\\u0928\\u0947 \\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0938\\u094d\\u0930\\u094b\\u0924 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0935\\u093e\\u0902\\u091b\\u093f\\u0924 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092a\\u0942\\u0930\\u0940 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092c\\u093e\\u0926 \\u0906\\u092a\\u0915\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u0940\\u0964"}},"id":"67249a42c7f45"},"67249a4d05c52":{"language":{"en":{"question":"What payment methods are available for adding money?","answer":"You can add money using various methods, including bank transfers, debit\\/credit cards, and other supported payment options. Choose the method that works best for you."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0637\\u0631\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0648\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u062e\\u0635\\u0645\\/\\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649. \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0627\\u0633\\u0628\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0641\\u0636\\u0644."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de pago est\\u00e1n disponibles para agregar dinero?","answer":"Puede agregar dinero utilizando varios m\\u00e9todos, incluidas transferencias bancarias, tarjetas de d\\u00e9bito\\/cr\\u00e9dito y otras opciones de pago admitidas. Elija el m\\u00e9todo que funcione mejor para usted."},"fr":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de pago est\\u00e1n disponibles para agregar dinero?","answer":"Vous pouvez ajouter de l\'argent en utilisant diverses m\\u00e9thodes, notamment les virements bancaires, les cartes de d\\u00e9bit\\/cr\\u00e9dit et d\'autres options de paiement prises en charge. Choisissez la m\\u00e9thode qui vous convient le mieux."},"hi":{"question":"\\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948\\u0902?","answer":"\\u0906\\u092a \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923, \\u0921\\u0947\\u092c\\u093f\\u091f\\/\\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u0939 \\u0924\\u0930\\u0940\\u0915\\u093e \\u091a\\u0941\\u0928\\u0947\\u0902 \\u091c\\u094b \\u0906\\u092a\\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u092c\\u0938\\u0947 \\u0905\\u091a\\u094d\\u091b\\u093e \\u0915\\u093e\\u092e \\u0915\\u0930\\u0947\\u0964"}},"id":"67249a4d05c52"},"67249a57d5602":{"language":{"en":{"question":"Are there any fees associated with adding money?","answer":"Fees may apply depending on the payment method you choose. You will be informed of any applicable fees before confirming your transaction to ensure transparency."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0627\\u0631\\u0647\\u0627. \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0628\\u0644\\u0627\\u063a\\u0643 \\u0628\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629."},"es":{"question":"\\u00bfHay alguna tarifa asociada con agregar dinero?","answer":"Es posible que se apliquen tarifas seg\\u00fan el m\\u00e9todo de pago que elija. Se le informar\\u00e1 de cualquier tarifa aplicable antes de confirmar su transacci\\u00f3n para garantizar la transparencia."},"fr":{"question":"\\u00bfHay alguna tarifa asociada con agregar dinero?","answer":"Des frais peuvent s\'appliquer selon le mode de paiement que vous choisissez. Vous serez inform\\u00e9 des frais applicables avant de confirmer votre transaction pour garantir la transparence."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0906\\u092a\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a\\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"67249a57d5602"},"67249a62a7ea6":{"language":{"en":{"question":"How long does it take for the funds to reflect in my account?","answer":"Funds are typically added to your QRPay Pro account instantly, but some methods may take a little longer to process. You will receive a notification confirming the addition of funds once completed."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u064a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0638\\u0647\\u0648\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u064a\\u061f","answer":"\\u0639\\u0627\\u062f\\u0629\\u064b \\u0645\\u0627 \\u062a\\u062a\\u0645 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631\\u060c \\u0648\\u0644\\u0643\\u0646 \\u0642\\u062f \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0637\\u0631\\u0642 \\u0648\\u0642\\u062a\\u064b\\u0627 \\u0623\\u0637\\u0648\\u0644 \\u0642\\u0644\\u064a\\u0644\\u0627\\u064b \\u0644\\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629. \\u0633\\u0648\\u0641 \\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0645\\u062c\\u0631\\u062f \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644\\u0647\\u0627."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo tardan los fondos en reflejarse en mi cuenta?","answer":"Por lo general, los fondos se agregan a su cuenta QRPay Pro al instante, pero algunos m\\u00e9todos pueden tardar un poco m\\u00e1s en procesarse. Recibir\\u00e1 una notificaci\\u00f3n confirmando la adici\\u00f3n de fondos una vez completada."},"fr":{"question":"\\u00bfCu\\u00e1nto tiempo tardan los fondos en reflejarse en mi cuenta?","answer":"Les fonds sont g\\u00e9n\\u00e9ralement ajout\\u00e9s instantan\\u00e9ment \\u00e0 votre compte QRPay Pro, mais certaines m\\u00e9thodes peuvent prendre un peu plus de temps \\u00e0 traiter. Vous recevrez une notification confirmant l\\u2019ajout de fonds une fois termin\\u00e9."},"hi":{"question":"\\u092e\\u0947\\u0930\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0906\\u092a\\u0915\\u0947 QRPay Pro \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u091c\\u094b\\u0921\\u093c \\u0926\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948, \\u0932\\u0947\\u0915\\u093f\\u0928 \\u0915\\u0941\\u091b \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0925\\u094b\\u0921\\u093c\\u093e \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u0942\\u0930\\u093e \\u0939\\u094b\\u0928\\u0947 \\u092a\\u0930 \\u0906\\u092a\\u0915\\u094b \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"67249a62a7ea6"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:07:03','updated_at' => '2024-11-06 19:47:36'),
            array('id' => '11','parent_id' => '11','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Withdrawing Money","sub_heading":"Get answers to your questions regarding the withdrawal process in QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0641\\u064a QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre retirar dinero","sub_heading":"Obtenga respuestas a sus preguntas sobre el proceso de retiro en QRPay Pro."},"fr":{"heading":"Preguntas frecuentes sobre retirar dinero","sub_heading":"Obtenez des r\\u00e9ponses \\u00e0 vos questions concernant le processus de retrait dans QRPay Pro."},"hi":{"heading":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249ae86d181":{"language":{"en":{"question":"How do I withdraw money from my QRPay Pro account?","answer":"To withdraw money, navigate to the Withdraw Money feature, choose your preferred withdrawal method, enter the amount you want to withdraw, and confirm the transaction. Your funds will be transferred promptly."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0648\\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0644\\u062f\\u064a\\u0643\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u064a\\u062f \\u0633\\u062d\\u0628\\u0647\\u060c \\u062b\\u0645 \\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631."},"es":{"question":"\\u00bfC\\u00f3mo retiro dinero de mi cuenta QRPay Pro?","answer":"Para retirar dinero, navegue hasta la funci\\u00f3n Retirar dinero, elija su m\\u00e9todo de retiro preferido, ingrese el monto que desea retirar y confirme la transacci\\u00f3n. Sus fondos ser\\u00e1n transferidos de inmediato."},"fr":{"question":"\\u00bfC\\u00f3mo retiro dinero de mi cuenta QRPay Pro?","answer":"Pour retirer de l\'argent, acc\\u00e9dez \\u00e0 la fonction Retirer de l\'argent, choisissez votre m\\u00e9thode de retrait pr\\u00e9f\\u00e9r\\u00e9e, saisissez le montant que vous souhaitez retirer et confirmez la transaction. Vos fonds seront transf\\u00e9r\\u00e9s rapidement."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0942\\u0902?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u0905\\u092a\\u0928\\u0940 \\u092a\\u0938\\u0902\\u0926\\u0940\\u0926\\u093e \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902, \\u0935\\u0939 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u091c\\u093f\\u0938\\u0947 \\u0906\\u092a \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964 \\u0906\\u092a\\u0915\\u093e \\u092b\\u0902\\u0921 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092b\\u0930 \\u0915\\u0930 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e."}},"id":"67249ae86d181"},"67249af3303d6":{"language":{"en":{"question":"What withdrawal methods are available?","answer":"You can withdraw money via various methods, including direct bank transfers and digital wallets. Choose the option that is most convenient for you."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0628\\u0631 \\u0637\\u0631\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0648\\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0645\\u0644\\u0627\\u0621\\u0645\\u0629 \\u0644\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de retiro est\\u00e1n disponibles?","answer":"Puede retirar dinero mediante varios m\\u00e9todos, incluidas transferencias bancarias directas y billeteras digitales. Elija la opci\\u00f3n que sea m\\u00e1s conveniente para usted."},"fr":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de retiro est\\u00e1n disponibles?","answer":"Vous pouvez retirer de l\'argent via diff\\u00e9rentes m\\u00e9thodes, notamment les virements bancaires directs et les portefeuilles num\\u00e9riques. Choisissez l\'option qui vous convient le mieux."},"hi":{"question":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0947 \\u0915\\u094c\\u0928 \\u0938\\u0947 \\u0924\\u0930\\u0940\\u0915\\u0947 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948\\u0902?","answer":"\\u0906\\u092a \\u0938\\u0940\\u0927\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0914\\u0930 \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u0939 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902 \\u091c\\u094b \\u0906\\u092a\\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u092c\\u0938\\u0947 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u0939\\u094b\\u0964"}},"id":"67249af3303d6"},"67249afc3c0e2":{"language":{"en":{"question":"Are there any fees associated with withdrawing money?","answer":"Yes, there may be fees depending on the withdrawal method you select. You will be informed of any applicable fees before confirming your transaction to ensure transparency."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u062d\\u0633\\u0628 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0627\\u0631\\u0647\\u0627. \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0628\\u0644\\u0627\\u063a\\u0643 \\u0628\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629."},"es":{"question":"\\u00bfExiste alguna tarifa asociada con el retiro de dinero?","answer":"S\\u00ed, puede haber tarifas seg\\u00fan el m\\u00e9todo de retiro que seleccione. Se le informar\\u00e1 de cualquier tarifa aplicable antes de confirmar su transacci\\u00f3n para garantizar la transparencia."},"fr":{"question":"\\u00bfExiste alguna tarifa asociada con el retiro de dinero?","answer":"Oui, des frais peuvent \\u00eatre factur\\u00e9s selon la m\\u00e9thode de retrait que vous s\\u00e9lectionnez. Vous serez inform\\u00e9 des frais applicables avant de confirmer votre transaction pour garantir la transparence."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a\\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"67249afc3c0e2"},"67249b0490b2a":{"language":{"en":{"question":"How long does it take for my withdrawal to process?","answer":"Withdrawal processing times can vary based on the method chosen. Bank transfers may take longer than digital wallet withdrawals, but you will receive a notification confirming when the transfer is complete."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u064a\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0623\\u0648\\u0642\\u0627\\u062a \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0627\\u0631\\u0629. \\u0642\\u062f \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0648\\u0642\\u062a\\u064b\\u0627 \\u0623\\u0637\\u0648\\u0644 \\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629\\u060c \\u0648\\u0644\\u0643\\u0646\\u0643 \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0645\\u0648\\u0639\\u062f \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo lleva procesar mi retiro?","answer":"Los tiempos de procesamiento de retiros pueden variar seg\\u00fan el m\\u00e9todo elegido. Las transferencias bancarias pueden tardar m\\u00e1s que los retiros de billetera digital, pero recibir\\u00e1s una notificaci\\u00f3n confirmando cuando se complete la transferencia."},"fr":{"question":"\\u00bfCu\\u00e1nto tiempo lleva procesar mi retiro?","answer":"Les d\\u00e9lais de traitement des retraits peuvent varier en fonction de la m\\u00e9thode choisie. Les virements bancaires peuvent prendre plus de temps que les retraits sur portefeuille num\\u00e9rique, mais vous recevrez une notification confirmant la fin du transfert."},"hi":{"question":"\\u092e\\u0947\\u0930\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0947\\u0917\\u093e?","answer":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u093e \\u0938\\u092e\\u092f \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092e\\u0947\\u0902 \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u0924\\u0941\\u0932\\u0928\\u093e \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u0932\\u0947\\u0915\\u093f\\u0928 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0942\\u0930\\u093e \\u0939\\u094b\\u0928\\u0947 \\u092a\\u0930 \\u0906\\u092a\\u0915\\u094b \\u0907\\u0938\\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"67249b0490b2a"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:09:49','updated_at' => '2024-11-06 20:03:57'),
            array('id' => '12','parent_id' => '12','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Making Payments","sub_heading":"Find answers to your questions regarding the payment process in QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre c\\u00f3mo realizar pagos","sub_heading":"Encuentre respuestas a sus preguntas sobre el proceso de pago en QRPay Pro."},"fr":{"heading":"Preguntas frecuentes sobre c\\u00f3mo realizar pagos","sub_heading":"Trouvez les r\\u00e9ponses \\u00e0 vos questions concernant le processus de paiement dans QRPay Pro."},"hi":{"heading":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"67249c393562d":{"language":{"en":{"question":"How can I make a payment using QRPay Pro?","answer":"To make a payment, navigate to the Make Payment feature, select the QRPay Pro merchant you wish to pay, enter the payment amount, and confirm the transaction. Your funds will be transferred instantly."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0648\\u062d\\u062f\\u062f \\u062a\\u0627\\u062c\\u0631 QRPay Pro \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0647\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631."},"es":{"question":"\\u00bfC\\u00f3mo puedo realizar un pago usando QRPay Pro?","answer":"Para realizar un pago, navegue hasta la funci\\u00f3n Realizar pago, seleccione el comerciante de QRPay Pro al que desea pagar, ingrese el monto del pago y confirme la transacci\\u00f3n. Sus fondos se transferir\\u00e1n instant\\u00e1neamente."},"fr":{"question":"\\u00bfC\\u00f3mo puedo realizar un pago usando QRPay Pro?","answer":"Pour effectuer un paiement, acc\\u00e9dez \\u00e0 la fonction Effectuer un paiement, s\\u00e9lectionnez le commer\\u00e7ant QRPay Pro que vous souhaitez payer, saisissez le montant du paiement et confirmez la transaction. Vos fonds seront transf\\u00e9r\\u00e9s instantan\\u00e9ment."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u0909\\u0938 QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902 \\u091c\\u093f\\u0938\\u0947 \\u0906\\u092a \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964 \\u0906\\u092a\\u0915\\u093e \\u092b\\u0902\\u0921 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u091f\\u094d\\u0930\\u093e\\u0902\\u0938\\u092b\\u0930 \\u0915\\u0930 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e."}},"id":"67249c393562d"},"67249c41c0e30":{"language":{"en":{"question":"Can I pay any merchant with QRPay Pro?","answer":"No, payments can only be made to merchants registered on the QRPay Pro platform. Ensure you are paying a QRPay Pro merchant to complete your transaction successfully."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0623\\u064a \\u062a\\u0627\\u062c\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0627\\u060c \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0625\\u0644\\u0627 \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0633\\u062c\\u0644\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0645\\u0646\\u0635\\u0629 QRPay Pro. \\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646\\u0643 \\u062a\\u062f\\u0641\\u0639 \\u0644\\u062a\\u0627\\u062c\\u0631 QRPay Pro \\u0644\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643 \\u0628\\u0646\\u062c\\u0627\\u062d."},"es":{"question":"\\u00bfPuedo pagarle a cualquier comerciante con QRPay Pro?","answer":"No, los pagos s\\u00f3lo se pueden realizar a comercios registrados en la plataforma QRPay Pro. Aseg\\u00farese de pagarle a un comerciante de QRPay Pro para completar su transacci\\u00f3n con \\u00e9xito."},"fr":{"question":"\\u00bfPuedo pagarle a cualquier comerciante con QRPay Pro?","answer":"Non, les paiements ne peuvent \\u00eatre effectu\\u00e9s qu\'aux commer\\u00e7ants inscrits sur la plateforme QRPay Pro. Assurez-vous de payer un commer\\u00e7ant QRPay Pro pour terminer votre transaction avec succ\\u00e8s."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 QRPay Pro \\u0938\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0915\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0928\\u0939\\u0940\\u0902, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947\\u0935\\u0932 QRPay Pro \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092a\\u0930 \\u092a\\u0902\\u091c\\u0940\\u0915\\u0943\\u0924 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0940 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902 \\u0915\\u093f \\u0906\\u092a \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u092b\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0915\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249c41c0e30"},"67249c49ca78c":{"language":{"en":{"question":"Are there any fees for making payments with QRPay Pro?","answer":"QRPay Pro typically does not charge fees for making payments. However, individual merchants may have their own policies regarding fees, so it\'s advisable to check before confirming your payment."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0639\\u0646\\u062f \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0627 \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u0639\\u0627\\u062f\\u0629\\u064b \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0627\\u0644\\u0641\\u0631\\u062f\\u064a\\u064a\\u0646 \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a\\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0627\\u0644\\u0631\\u0633\\u0648\\u0645\\u060c \\u0644\\u0630\\u0627 \\u064a\\u064f\\u0646\\u0635\\u062d \\u0628\\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062f\\u0641\\u0639."},"es":{"question":"\\u00bfHay alg\\u00fan cargo por realizar pagos con QRPay Pro?","answer":"QRPay Pro normalmente no cobra tarifas por realizar pagos. Sin embargo, los comerciantes individuales pueden tener sus propias pol\\u00edticas con respecto a las tarifas, por lo que es recomendable verificar antes de confirmar su pago."},"fr":{"question":"\\u00bfHay alg\\u00fan cargo por realizar pagos con QRPay Pro?","answer":"QRPay Pro ne facture g\\u00e9n\\u00e9ralement pas de frais pour effectuer des paiements. Cependant, chaque commer\\u00e7ant peut avoir ses propres politiques concernant les frais, il est donc conseill\\u00e9 de v\\u00e9rifier avant de confirmer votre paiement."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e QRPay Pro \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u092a\\u0930 \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"QRPay Pro \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u0932\\u0917-\\u0905\\u0932\\u0917 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0905\\u092a\\u0928\\u0940 \\u0928\\u0940\\u0924\\u093f\\u092f\\u093e\\u0902 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0932\\u093f\\u090f \\u0938\\u0932\\u093e\\u0939 \\u0926\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0915\\u093f \\u0905\\u092a\\u0928\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u091c\\u093e\\u0902\\u091a \\u0915\\u0930 \\u0932\\u0947\\u0902\\u0964"}},"id":"67249c49ca78c"},"67249c52ce2d3":{"language":{"en":{"question":"How will I know if my payment was successful?","answer":"Once you confirm the payment, you will receive a notification confirming the success of your transaction. You can also check your transaction history for confirmation."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u062f\\u0641\\u0639\\u062a\\u064a \\u0646\\u0627\\u062c\\u062d\\u0629\\u061f","answer":"\\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0646\\u062c\\u0627\\u062d \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0644\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si mi pago fue exitoso?","answer":"Una vez que confirmes el pago, recibir\\u00e1s una notificaci\\u00f3n confirmando el \\u00e9xito de tu transacci\\u00f3n. Tambi\\u00e9n puede consultar su historial de transacciones para confirmarlo."},"fr":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si mi pago fue exitoso?","answer":"Une fois le paiement confirm\\u00e9, vous recevrez une notification confirmant le succ\\u00e8s de votre transaction. Vous pouvez \\u00e9galement consulter l\\u2019historique de vos transactions pour confirmation."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092e\\u0947\\u0930\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u092b\\u0932 \\u0939\\u0941\\u0906?","answer":"\\u090f\\u0915 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0906\\u092a\\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u092b\\u0932\\u0924\\u093e \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092d\\u0940 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249c52ce2d3"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:15:25','updated_at' => '2024-11-06 20:10:08'),
            array('id' => '13','parent_id' => '13','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Money Out","sub_heading":"Find answers to your questions regarding the money withdrawal process in QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0635\\u0627\\u062f\\u0631\\u0629","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre retiros de dinero","sub_heading":"Encuentre respuestas a sus preguntas sobre el proceso de retiro de dinero en QRPay Pro."},"fr":{"heading":"Preguntas frecuentes sobre retiros de dinero","sub_heading":"Trouvez des r\\u00e9ponses \\u00e0 vos questions concernant le processus de retrait d\'argent dans QRPay Pro."},"hi":{"heading":"\\u092e\\u0928\\u0940 \\u0906\\u0909\\u091f \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"67249d34d9feb":{"language":{"en":{"question":"How can I withdraw money from my QRPay Pro account?","answer":"To withdraw money, go to the Money Out feature, select a QRPay Pro agent, enter the withdrawal amount, and confirm the transaction. Your funds will be transferred to the agent securely."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 Money Out\\u060c \\u0648\\u062d\\u062f\\u062f \\u0648\\u0643\\u064a\\u0644 QRPay Pro\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0633\\u062d\\u0628\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u0633\\u064a\\u062a\\u0645 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646."},"es":{"question":"\\u00bfC\\u00f3mo puedo retirar dinero de mi cuenta QRPay Pro?","answer":"Para retirar dinero, vaya a la funci\\u00f3n Retiro de dinero, seleccione un agente de QRPay Pro, ingrese el monto del retiro y confirme la transacci\\u00f3n. Sus fondos se transferir\\u00e1n al agente de forma segura."},"fr":{"question":"\\u00bfC\\u00f3mo puedo retirar dinero de mi cuenta QRPay Pro?","answer":"Pour retirer de l\'argent, acc\\u00e9dez \\u00e0 la fonction Money Out, s\\u00e9lectionnez un agent QRPay Pro, saisissez le montant du retrait et confirmez la transaction. Vos fonds seront transf\\u00e9r\\u00e9s \\u00e0 l\'agent en toute s\\u00e9curit\\u00e9."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092e\\u0928\\u0940 \\u0906\\u0909\\u091f \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964 \\u0906\\u092a\\u0915\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0926\\u0940 \\u091c\\u093e\\u090f\\u0917\\u0940\\u0964"}},"id":"67249d34d9feb"},"67249d3e34b04":{"language":{"en":{"question":"Who can I withdraw money to?","answer":"You can only withdraw money to authorized QRPay Pro agents registered on the QRPay Pro platform. Make sure you select a trusted agent for your transaction."},"ar":{"question":"\\u0644\\u0645\\u0646 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0641\\u0642\\u0637 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u0644\\u0627\\u0621 QRPay Pro \\u0627\\u0644\\u0645\\u0639\\u062a\\u0645\\u062f\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062c\\u0644\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0645\\u0646\\u0635\\u0629 QRPay Pro. \\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u062a\\u062d\\u062f\\u064a\\u062f \\u0648\\u0643\\u064a\\u0644 \\u0645\\u0648\\u062b\\u0648\\u0642 \\u0628\\u0647 \\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643."},"es":{"question":"\\u00bfA qui\\u00e9n puedo retirar dinero?","answer":"S\\u00f3lo puedes retirar dinero a agentes autorizados de QRPay Pro registrados en la plataforma QRPay Pro. Aseg\\u00farese de seleccionar un agente confiable para su transacci\\u00f3n."},"fr":{"question":"\\u00bfA qui\\u00e9n puedo retirar dinero?","answer":"Vous ne pouvez retirer de l\'argent qu\'aux agents QRPay Pro autoris\\u00e9s enregistr\\u00e9s sur la plateforme QRPay Pro. Assurez-vous de s\\u00e9lectionner un agent de confiance pour votre transaction."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0915\\u093f\\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0906\\u092a \\u0915\\u0947\\u0935\\u0932 QRPay Pro \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u092a\\u0930 \\u092a\\u0902\\u091c\\u0940\\u0915\\u0943\\u0924 \\u0905\\u0927\\u093f\\u0915\\u0943\\u0924 QRPay Pro \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0938\\u0947 \\u0939\\u0940 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902 \\u0915\\u093f \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249d3e34b04"},"67249d4923da9":{"language":{"en":{"question":"Are there any fees associated with withdrawing money?","answer":"Typically, QRPay Pro does not charge fees for withdrawing funds to agents. However, some agents may have their own fee structures, so it\'s a good idea to verify before proceeding with your withdrawal."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0639\\u0627\\u062f\\u0629\\u064b\\u060c \\u0644\\u0627 \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0647\\u064a\\u0627\\u0643\\u0644 \\u0631\\u0633\\u0648\\u0645 \\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645\\u060c \\u0644\\u0630\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u062c\\u064a\\u062f \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646\\u0647\\u0627 \\u0642\\u0628\\u0644 \\u0645\\u062a\\u0627\\u0628\\u0639\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628."},"es":{"question":"\\u00bfExiste alguna tarifa asociada con el retiro de dinero?","answer":"Normalmente, QRPay Pro no cobra tarifas por retirar fondos a los agentes. Sin embargo, algunos agentes pueden tener sus propias estructuras de tarifas, por lo que es una buena idea verificarlo antes de continuar con el retiro."},"fr":{"question":"\\u00bfExiste alguna tarifa asociada con el retiro de dinero?","answer":"En r\\u00e8gle g\\u00e9n\\u00e9rale, QRPay Pro ne facture pas de frais pour le retrait de fonds aux agents. Cependant, certains agents peuvent avoir leurs propres structures de frais, c\'est donc une bonne id\\u00e9e de v\\u00e9rifier avant de proc\\u00e9der \\u00e0 votre retrait."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930, QRPay Pro \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u0915\\u0941\\u091b \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0940 \\u0905\\u092a\\u0928\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948, \\u0907\\u0938\\u0932\\u093f\\u090f \\u0906\\u092a\\u0915\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906\\u0917\\u0947 \\u092c\\u0922\\u093c\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0938\\u0924\\u094d\\u092f\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u090f\\u0915 \\u0905\\u091a\\u094d\\u091b\\u093e \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0939\\u0948\\u0964"}},"id":"67249d4923da9"},"67249d51e9538":{"language":{"en":{"question":"How will I know when my withdrawal is complete?","answer":"After confirming your withdrawal, you will receive a notification once the funds have been successfully sent to the QRPay Pro agent. You can also check your transaction history for confirmation."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0645\\u062a\\u0649 \\u0627\\u0643\\u062a\\u0645\\u0644 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0628\\u0639\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0633\\u062d\\u0628\\u060c \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0628\\u0645\\u062c\\u0631\\u062f \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0646\\u062c\\u0627\\u062d \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 QRPay Pro. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0644\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 cuando se complete mi retiro?","answer":"Despu\\u00e9s de confirmar su retiro, recibir\\u00e1 una notificaci\\u00f3n una vez que los fondos se hayan enviado exitosamente al agente de QRPay Pro. Tambi\\u00e9n puede consultar su historial de transacciones para confirmarlo."},"fr":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 cuando se complete mi retiro?","answer":"Apr\\u00e8s avoir confirm\\u00e9 votre retrait, vous recevrez une notification une fois que les fonds auront \\u00e9t\\u00e9 envoy\\u00e9s avec succ\\u00e8s \\u00e0 l\'agent QRPay Pro. Vous pouvez \\u00e9galement consulter l\\u2019historique de vos transactions pour confirmation."},"hi":{"question":"\\u091c\\u092c \\u092e\\u0947\\u0930\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u0942\\u0930\\u0940 \\u0939\\u094b \\u091c\\u093e\\u090f\\u0917\\u0940 \\u0924\\u094b \\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e?","answer":"\\u0906\\u092a\\u0915\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926, QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u092b\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u092d\\u0947\\u091c\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u092a\\u0930 \\u0906\\u092a\\u0915\\u094b \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092d\\u0940 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249d51e9538"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:19:36','updated_at' => '2024-11-06 20:17:18'),
            array('id' => '14','parent_id' => '14','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Virtual Card","sub_heading":"Find answers to your questions regarding virtual card creation and usage."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0629 QRPay Pro \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627."},"es":{"heading":"Preguntas frecuentes sobre la tarjeta virtual QRPay Pro","sub_heading":"Encuentre respuestas a sus preguntas sobre la creaci\\u00f3n y el uso de tarjetas virtuales."},"fr":{"heading":"Preguntas frecuentes sobre la tarjeta virtual QRPay Pro","sub_heading":"Trouvez les r\\u00e9ponses \\u00e0 vos questions concernant la cr\\u00e9ation et l\'utilisation de cartes virtuelles."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"67249deaa7d38":{"language":{"en":{"question":"How do I create a virtual card using QRPay Pro?","answer":"To create a virtual card, go to the Virtual Card feature in your QRPay Pro app, click on \\"Create a Virtual Card,\\" and follow the prompts to set your preferences and generate your card."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0642\\u0648\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u064a\\u0632\\u0629 Virtual Card \\u0641\\u064a \\u062a\\u0637\\u0628\\u064a\\u0642 QRPay Pro\\u060c \\u0648\\u0627\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629\\"\\u060c \\u0648\\u0627\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0637\\u0627\\u0644\\u0628\\u0627\\u062a \\u0644\\u062a\\u0639\\u064a\\u064a\\u0646 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643 \\u0648\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643."},"es":{"question":"\\u00bfC\\u00f3mo creo una tarjeta virtual usando QRPay Pro?","answer":"Para crear una tarjeta virtual, vaya a la funci\\u00f3n Tarjeta virtual en su aplicaci\\u00f3n QRPay Pro, haga clic en \\"Crear una tarjeta virtual\\" y siga las instrucciones para configurar sus preferencias y generar su tarjeta."},"fr":{"question":"\\u00bfC\\u00f3mo creo una tarjeta virtual usando QRPay Pro?","answer":"Pour cr\\u00e9er une carte virtuelle, acc\\u00e9dez \\u00e0 la fonctionnalit\\u00e9 Carte virtuelle de votre application QRPay Pro, cliquez sur \\u00ab Cr\\u00e9er une carte virtuelle \\u00bb et suivez les invites pour d\\u00e9finir vos pr\\u00e9f\\u00e9rences et g\\u00e9n\\u00e9rer votre carte."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0948\\u0938\\u0947 \\u092c\\u0928\\u093e\\u090a\\u0902?","answer":"\\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0910\\u092a \\u092e\\u0947\\u0902 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\"\\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u090f\\u0902\\" \\u092a\\u0930 \\u0915\\u094d\\u0932\\u093f\\u0915 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0940 \\u092a\\u094d\\u0930\\u093e\\u0925\\u092e\\u093f\\u0915\\u0924\\u093e\\u090f\\u0902 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u093e \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0902\\u0915\\u0947\\u0924\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249deaa7d38"},"67249df3e5e68":{"language":{"en":{"question":"Can I use my QRPay Pro virtual card for international transactions?","answer":"Yes, QRPay Pro virtual cards can typically be used for international transactions as long as the merchant accepts card payments. Check with the merchant for their accepted payment methods."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 QRPay Pro \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u064a \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0639\\u0627\\u062f\\u0629\\u064b \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a QRPay Pro \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629 \\u0637\\u0627\\u0644\\u0645\\u0627 \\u0623\\u0646 \\u0627\\u0644\\u062a\\u0627\\u062c\\u0631 \\u064a\\u0642\\u0628\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0639 \\u0627\\u0644\\u062a\\u0627\\u062c\\u0631 \\u0644\\u0645\\u0639\\u0631\\u0641\\u0629 \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u0642\\u0628\\u0648\\u0644\\u0629 \\u0644\\u062f\\u064a\\u0647."},"es":{"question":"\\u00bfPuedo utilizar mi tarjeta virtual QRPay Pro para transacciones internacionales?","answer":"S\\u00ed, las tarjetas virtuales QRPay Pro normalmente se pueden utilizar para transacciones internacionales siempre que el comerciante acepte pagos con tarjeta. Consulte con el comerciante cu\\u00e1les son los m\\u00e9todos de pago aceptados."},"fr":{"question":"\\u00bfPuedo utilizar mi tarjeta virtual QRPay Pro para transacciones internacionales?","answer":"Oui, les cartes virtuelles QRPay Pro peuvent g\\u00e9n\\u00e9ralement \\u00eatre utilis\\u00e9es pour les transactions internationales tant que le commer\\u00e7ant accepte les paiements par carte. V\\u00e9rifiez aupr\\u00e8s du commer\\u00e7ant ses m\\u00e9thodes de paiement accept\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0939\\u093e\\u0902, QRPay Pro \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u091c\\u092c \\u0924\\u0915 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0938\\u0947 \\u0909\\u0928\\u0915\\u0940 \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249df3e5e68"},"67249e0019f6d":{"language":{"en":{"question":"Is it safe to use a virtual card for online purchases?","answer":"Absolutely! QRPay Pro\'s virtual card feature provides an additional layer of security by keeping your actual credit card details private, reducing the risk of fraud."},"ar":{"question":"\\u0647\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0622\\u0645\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u061f","answer":"\\u0642\\u0637\\u0639\\u0627\\u064b! \\u062a\\u0648\\u0641\\u0631 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0637\\u0628\\u0642\\u0629 \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0642\\u0644\\u0644 \\u0645\\u0646 \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u0644."},"es":{"question":"\\u00bfEs seguro utilizar una tarjeta virtual para compras online?","answer":"\\u00a1Absolutamente! La funci\\u00f3n de tarjeta virtual de QRPay Pro proporciona una capa adicional de seguridad al mantener privados los datos reales de su tarjeta de cr\\u00e9dito, lo que reduce el riesgo de fraude."},"fr":{"question":"\\u00bfEs seguro utilizar una tarjeta virtual para compras online?","answer":"Absolument! La fonctionnalit\\u00e9 de carte virtuelle de QRPay Pro offre une couche de s\\u00e9curit\\u00e9 suppl\\u00e9mentaire en gardant les d\\u00e9tails de votre carte de cr\\u00e9dit confidentiels, r\\u00e9duisant ainsi le risque de fraude."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932! QRPay Pro \\u0915\\u093e \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092b\\u0940\\u091a\\u0930 \\u0906\\u092a\\u0915\\u0947 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u094b \\u0928\\u093f\\u091c\\u0940 \\u0930\\u0916\\u0915\\u0930 \\u0927\\u094b\\u0916\\u093e\\u0927\\u0921\\u093c\\u0940 \\u0915\\u0947 \\u091c\\u094b\\u0916\\u093f\\u092e \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0915\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0940 \\u090f\\u0915 \\u0905\\u0924\\u093f\\u0930\\u093f\\u0915\\u094d\\u0924 \\u092a\\u0930\\u0924 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"67249e0019f6d"},"67249e0e36550":{"language":{"en":{"question":"Can I set limits on my virtual card?","answer":"Yes, when generating your virtual card, you can set spending limits and an expiration date based on your preferences, allowing you to manage your spending effectively."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0648\\u0636\\u0639 \\u062d\\u062f\\u0648\\u062f \\u0639\\u0644\\u0649 \\u0628\\u0637\\u0627\\u0642\\u062a\\u064a \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0639\\u0646\\u062f \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u0639\\u064a\\u064a\\u0646 \\u062d\\u062f\\u0648\\u062f \\u0627\\u0644\\u0625\\u0646\\u0641\\u0627\\u0642 \\u0648\\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0635\\u0644\\u0627\\u062d\\u064a\\u0629 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0625\\u0646\\u0641\\u0627\\u0642\\u0643 \\u0628\\u0641\\u0639\\u0627\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfPuedo poner l\\u00edmites a mi tarjeta virtual?","answer":"S\\u00ed, al generar tu tarjeta virtual, puedes establecer l\\u00edmites de gasto y una fecha de vencimiento seg\\u00fan tus preferencias, permiti\\u00e9ndote administrar tus gastos de manera efectiva."},"fr":{"question":"\\u00bfPuedo poner l\\u00edmites a mi tarjeta virtual?","answer":"Oui, lors de la g\\u00e9n\\u00e9ration de votre carte virtuelle, vous pouvez d\\u00e9finir des limites de d\\u00e9penses et une date d\'expiration en fonction de vos pr\\u00e9f\\u00e9rences, vous permettant ainsi de g\\u00e9rer efficacement vos d\\u00e9penses."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092a\\u0930 \\u0938\\u0940\\u092e\\u093e \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, \\u0905\\u092a\\u0928\\u093e \\u0935\\u0930\\u094d\\u091a\\u0941\\u0905\\u0932 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092c\\u0928\\u093e\\u0924\\u0947 \\u0938\\u092e\\u092f, \\u0906\\u092a \\u0905\\u092a\\u0928\\u0940 \\u092a\\u094d\\u0930\\u093e\\u0925\\u092e\\u093f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0916\\u0930\\u094d\\u091a \\u0938\\u0940\\u092e\\u093e \\u0914\\u0930 \\u0938\\u092e\\u093e\\u092a\\u094d\\u0924\\u093f \\u0924\\u093f\\u0925\\u093f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u0916\\u0930\\u094d\\u091a \\u0915\\u094b \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u0922\\u0902\\u0917 \\u0938\\u0947 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249e0e36550"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:22:40','updated_at' => '2024-11-07 09:57:24'),
            array('id' => '15','parent_id' => '15','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Gift Cards","sub_heading":"Find answers to your questions regarding gift card purchases and usage."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0647\\u062f\\u0627\\u064a\\u0627 QRPay Pro","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627."},"es":{"heading":"Preguntas frecuentes sobre las tarjetas regalo QRPay Pro","sub_heading":"Encuentre respuestas a sus preguntas sobre la compra y el uso de tarjetas de regalo."},"fr":{"heading":"Preguntas frecuentes sobre las tarjetas regalo QRPay Pro","sub_heading":"Trouvez les r\\u00e9ponses \\u00e0 vos questions concernant les achats et l\'utilisation des cartes-cadeaux."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0917\\u093f\\u092b\\u093c\\u094d\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0938\\u0947 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"67249ebe7ac0b":{"language":{"en":{"question":"How do I purchase a gift card through QRPay Pro?","answer":"To purchase a gift card, navigate to the Gift Card section in your QRPay Pro app, select the gift card you wish to buy, enter the recipient\\u2019s details, and make the payment."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro\\u061f","answer":"\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0641\\u064a \\u062a\\u0637\\u0628\\u064a\\u0642 QRPay Pro\\u060c \\u0648\\u062d\\u062f\\u062f \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u0634\\u0631\\u0627\\u0626\\u0647\\u0627\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u060c \\u0648\\u0642\\u0645 \\u0628\\u0627\\u0644\\u062f\\u0641\\u0639."},"es":{"question":"\\u00bfC\\u00f3mo compro una tarjeta de regalo a trav\\u00e9s de QRPay Pro?","answer":"Para comprar una tarjeta de regalo, navegue hasta la secci\\u00f3n Tarjeta de regalo en su aplicaci\\u00f3n QRPay Pro, seleccione la tarjeta de regalo que desea comprar, ingrese los detalles del destinatario y realice el pago."},"fr":{"question":"\\u00bfC\\u00f3mo compro una tarjeta de regalo a trav\\u00e9s de QRPay Pro?","answer":"Pour acheter une carte-cadeau, acc\\u00e9dez \\u00e0 la section Carte-cadeau de votre application QRPay Pro, s\\u00e9lectionnez la carte-cadeau que vous souhaitez acheter, saisissez les coordonn\\u00e9es du destinataire et effectuez le paiement."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0948\\u0938\\u0947 \\u0916\\u0930\\u0940\\u0926\\u0942\\u0902?","answer":"\\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0910\\u092a \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u0935\\u0939 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u091a\\u0941\\u0928\\u0947\\u0902 \\u091c\\u093f\\u0938\\u0947 \\u0906\\u092a \\u0916\\u0930\\u0940\\u0926\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249ebe7ac0b"},"67249ec84ff4e":{"language":{"en":{"question":"Can I customize the amount on the gift card?","answer":"Yes, when purchasing a gift card, you can choose the amount to load onto the card, allowing for personalized gifting options."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u062e\\u0635\\u064a\\u0635 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0648\\u062c\\u0648\\u062f \\u0639\\u0644\\u0649 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0639\\u0646\\u062f \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u064a\\u062f \\u062a\\u062d\\u0645\\u064a\\u0644\\u0647 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0628\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629."},"es":{"question":"\\u00bfPuedo personalizar el importe de la tarjeta regalo?","answer":"S\\u00ed, al comprar una tarjeta de regalo, puede elegir el monto a cargar en la tarjeta, lo que permite opciones de obsequio personalizadas."},"fr":{"question":"\\u00bfPuedo personalizar el importe de la tarjeta regalo?","answer":"Oui, lors de l\'achat d\'une carte-cadeau, vous pouvez choisir le montant \\u00e0 charger sur la carte, permettant ainsi des options de cadeaux personnalis\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092a\\u0930 \\u0930\\u093e\\u0936\\u093f \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0916\\u0930\\u0940\\u0926\\u0924\\u0947 \\u0938\\u092e\\u092f, \\u0906\\u092a \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092a\\u0930 \\u0932\\u094b\\u0921 \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u0948\\u092f\\u0915\\u094d\\u0924\\u093f\\u0915\\u0943\\u0924 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u092e\\u093f\\u0932\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"67249ec84ff4e"},"67249ed114449":{"language":{"en":{"question":"How will the recipient receive the gift card?","answer":"The recipient will receive their digital gift card via email or SMS, depending on the details you provided during the purchase."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0633\\u064a\\u062d\\u0635\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0639\\u0644\\u0649 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u064a\\u0629\\u061f","answer":"\\u0633\\u064a\\u062a\\u0644\\u0642\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0627\\u0644\\u0631\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0646\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0635\\u064a\\u0631\\u0629\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062a\\u064a \\u0642\\u062f\\u0645\\u062a\\u0647\\u0627 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621."},"es":{"question":"\\u00bfC\\u00f3mo recibir\\u00e1 el destinatario la tarjeta regalo?","answer":"El destinatario recibir\\u00e1 su tarjeta regalo digital por correo electr\\u00f3nico o SMS, dependiendo de los datos que hayas proporcionado durante la compra."},"fr":{"question":"\\u00bfC\\u00f3mo recibir\\u00e1 el destinatario la tarjeta regalo?","answer":"Le destinataire recevra sa carte cadeau num\\u00e9rique par e-mail ou SMS, en fonction des informations que vous avez fournies lors de l\'achat."},"hi":{"question":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u093e?","answer":"\\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u0906\\u092a\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0905\\u092a\\u0928\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0908\\u092e\\u0947\\u0932 \\u092f\\u093e \\u090f\\u0938\\u090f\\u092e\\u090f\\u0938 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u093e\\u0964"}},"id":"67249ed114449"},"67249ed819948":{"language":{"en":{"question":"Can gift cards be used internationally?","answer":"Gift cards can typically be used at merchants that accept them; however, it\\u2019s important to check the specific terms and conditions of the gift card provider to ensure it can be used internationally."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646 \\u0639\\u0627\\u062f\\u0629\\u064b \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u0642\\u0628\\u0644\\u0648\\u0646\\u0647\\u0627\\u061b \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0647\\u0645 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637 \\u0648\\u0627\\u0644\\u0623\\u062d\\u0643\\u0627\\u0645 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629 \\u0644\\u0645\\u0648\\u0641\\u0631 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0644\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u062f\\u0648\\u0644\\u064a\\u064b\\u0627."},"es":{"question":"\\u00bfSe pueden utilizar las tarjetas de regalo a nivel internacional?","answer":"Las tarjetas de regalo normalmente se pueden utilizar en comercios que las acepten; sin embargo, es importante verificar los t\\u00e9rminos y condiciones espec\\u00edficos del proveedor de la tarjeta de regalo para asegurarse de que pueda usarse internacionalmente."},"fr":{"question":"\\u00bfSe pueden utilizar las tarjetas de regalo a nivel internacional?","answer":"Les cartes-cadeaux peuvent g\\u00e9n\\u00e9ralement \\u00eatre utilis\\u00e9es chez les commer\\u00e7ants qui les acceptent\\u00a0; cependant, il est important de v\\u00e9rifier les conditions g\\u00e9n\\u00e9rales sp\\u00e9cifiques du fournisseur de la carte-cadeau pour s\\u2019assurer qu\\u2019elle peut \\u00eatre utilis\\u00e9e \\u00e0 l\\u2019international."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0909\\u0928 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902; \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u0939\\u093e\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0921 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0924\\u093e \\u0915\\u0947 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0914\\u0930 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0928\\u093e \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948 \\u0915\\u093f \\u0907\\u0938\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"67249ed819948"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:26:11','updated_at' => '2024-11-07 10:02:44'),
            array('id' => '16','parent_id' => '16','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Bill Pay","sub_heading":"Get answers to your questions about managing and paying your bills through QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 QRPay Pro Bill Pay","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u062d\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0648\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre el pago de facturas QRPay Pro","sub_heading":"Obtenga respuestas a sus preguntas sobre c\\u00f3mo administrar y pagar sus facturas a trav\\u00e9s de QRPay Pro."},"fr":{"heading":"Foire aux questions sur le paiement de factures QRPay Pro","sub_heading":"Obtenez des r\\u00e9ponses \\u00e0 vos questions sur la gestion et le paiement de vos factures via QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"67249f947409b":{"language":{"en":{"question":"How do I pay my bills using QRPay Pro?","answer":"To pay your bills, go to the Bill Pay section in your QRPay Pro app, select the type of bill, enter the required details, and confirm your payment."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u064a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u062f\\u0641\\u0639 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u0643\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\" \\u0641\\u064a \\u062a\\u0637\\u0628\\u064a\\u0642 QRPay Pro\\u060c \\u0648\\u062d\\u062f\\u062f \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u0629\\u060c \\u0648\\u0623\\u0643\\u062f \\u0627\\u0644\\u062f\\u0641\\u0639."},"es":{"question":"\\u00bfC\\u00f3mo pago mis facturas usando QRPay Pro?","answer":"Para pagar sus facturas, vaya a la secci\\u00f3n Pago de facturas en su aplicaci\\u00f3n QRPay Pro, seleccione el tipo de factura, ingrese los detalles requeridos y confirme su pago."},"fr":{"question":"Comment payer mes factures avec QRPay Pro ?","answer":"Pour payer vos factures, acc\\u00e9dez \\u00e0 la section Bill Pay de votre application QRPay Pro, s\\u00e9lectionnez le type de facture, saisissez les d\\u00e9tails requis et confirmez votre paiement."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0942\\u0901?","answer":"\\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0910\\u092a \\u092e\\u0947\\u0902 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\u092c\\u093f\\u0932 \\u0915\\u093e \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u091a\\u0941\\u0928\\u0947\\u0902, \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249f947409b"},"67249f9dc45ee":{"language":{"en":{"question":"What types of bills can I pay through QRPay Pro?","answer":"You can pay a variety of bills, including utilities, internet, mobile services, and more. Check the available options in the app for specifics."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0641\\u0639\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u062f\\u0641\\u0639 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0641\\u0642 \\u0648\\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0645\\u0632\\u064a\\u062f. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644."},"es":{"question":"\\u00bfQu\\u00e9 tipos de facturas puedo pagar a trav\\u00e9s de QRPay Pro?","answer":"Puede pagar una variedad de facturas, incluidos servicios p\\u00fablicos, Internet, servicios m\\u00f3viles y m\\u00e1s. Consulte las opciones disponibles en la aplicaci\\u00f3n para conocer m\\u00e1s detalles."},"fr":{"question":"Quels types de factures puis-je payer via QRPay Pro\\u00a0?","answer":"Vous pouvez payer diverses factures, notamment les services publics, Internet, les services mobiles, etc. V\\u00e9rifiez les options disponibles dans l\'application pour plus de d\\u00e9tails."},"hi":{"question":"QRPay Pro \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092e\\u0948\\u0902 \\u0915\\u093f\\u0938 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0906\\u092a \\u0909\\u092a\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e\\u0913\\u0902, \\u0907\\u0902\\u091f\\u0930\\u0928\\u0947\\u091f, \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0910\\u092a \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"67249f9dc45ee"},"67249fa828e69":{"language":{"en":{"question":"Is there a limit on the amount I can pay for my bills?","answer":"There may be transaction limits depending on your account type and settings. Please refer to the QRPay guidelines or your account information for specific limits."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f \\u0644\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0641\\u0639\\u0647 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u064a\\u061f","answer":"\\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a\\u0643. \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u0631\\u062c\\u0648\\u0639 \\u0625\\u0644\\u0649 \\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a QRPay \\u0623\\u0648 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0645\\u0639\\u0631\\u0641\\u0629 \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629."},"es":{"question":"\\u00bfExiste un l\\u00edmite en el monto que puedo pagar por mis facturas?","answer":"Puede haber l\\u00edmites de transacciones seg\\u00fan el tipo y la configuraci\\u00f3n de su cuenta. Consulte las pautas de QRPay o la informaci\\u00f3n de su cuenta para conocer l\\u00edmites espec\\u00edficos."},"fr":{"question":"Y a-t-il une limite au montant que je peux payer pour mes factures ?","answer":"Il peut y avoir des limites de transactions en fonction de votre type de compte et de vos param\\u00e8tres. Veuillez vous r\\u00e9f\\u00e9rer aux directives QRPay ou aux informations de votre compte pour conna\\u00eetre les limites sp\\u00e9cifiques."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0930\\u093e\\u0936\\u093f \\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0924\\u092f \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0901 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0943\\u092a\\u092f\\u093e \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936 \\u092f\\u093e \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0926\\u0947\\u0916\\u0947\\u0902\\u0964"}},"id":"67249fa828e69"},"67249fb08d569":{"language":{"en":{"question":"How will I know if my bill payment was successful?","answer":"Once your payment is processed, you will receive a notification confirming the transaction. You can also check your transaction history for details."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0633\\u0623\\u0639\\u0631\\u0641 \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062f\\u0641\\u0639 \\u0641\\u0627\\u062a\\u0648\\u0631\\u062a\\u064a \\u0646\\u0627\\u062c\\u062d\\u064b\\u0627\\u061f","answer":"\\u0628\\u0645\\u062c\\u0631\\u062f \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u062f\\u0641\\u0639\\u062a\\u0643\\u060c \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si el pago de mi factura fue exitoso?","answer":"Una vez que se procese su pago, recibir\\u00e1 una notificaci\\u00f3n confirmando la transacci\\u00f3n. Tambi\\u00e9n puede consultar su historial de transacciones para obtener m\\u00e1s detalles."},"fr":{"question":"Comment saurai-je si le paiement de ma facture a r\\u00e9ussi\\u00a0?","answer":"Une fois votre paiement trait\\u00e9, vous recevrez une notification confirmant la transaction. Vous pouvez \\u00e9galement consulter l\'historique de vos transactions pour plus de d\\u00e9tails."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092e\\u0947\\u0930\\u093e \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u092b\\u0932 \\u0930\\u0939\\u093e?","answer":"\\u090f\\u0915 \\u092c\\u093e\\u0930 \\u0906\\u092a\\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0928\\u0947 \\u092a\\u0930, \\u0906\\u092a\\u0915\\u094b \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964 \\u0906\\u092a \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092d\\u0940 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"67249fb08d569"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:29:44','updated_at' => '2024-11-07 10:09:40'),
            array('id' => '17','parent_id' => '17','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Mobile Top-Up","sub_heading":"Find answers to common questions regarding mobile top-ups with QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f QRPay Pro \\u0644\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644","sub_heading":"\\u0627\\u0639\\u062b\\u0631 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre la recarga m\\u00f3vil QRPay Pro","sub_heading":"Encuentre respuestas a preguntas comunes sobre recargas m\\u00f3viles con QRPay Pro."},"fr":{"heading":"Foire aux questions sur la recharge mobile QRPay Pro","sub_heading":"Trouvez des r\\u00e9ponses aux questions courantes concernant les recharges mobiles avec QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724a058ae1cd":{"language":{"en":{"question":"How do I top up my mobile phone using QRPay Pro?","answer":"To top up your mobile phone, navigate to the Mobile Top-Up section in your QRPay Pro app, select your carrier, enter the phone number, choose the amount, and confirm the transaction."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0642\\u0648\\u0645 \\u0628\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0647\\u0627\\u062a\\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u060c \\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0641\\u064a \\u062a\\u0637\\u0628\\u064a\\u0642 QRPay Pro\\u060c \\u0648\\u062d\\u062f\\u062f \\u0645\\u0634\\u063a\\u0644 \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0644\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641\\u060c \\u0648\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u0623\\u0643\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo recargo mi tel\\u00e9fono m\\u00f3vil usando QRPay Pro?","answer":"Para recargar su tel\\u00e9fono m\\u00f3vil, navegue hasta la secci\\u00f3n Recarga m\\u00f3vil en su aplicaci\\u00f3n QRPay Pro, seleccione su operador, ingrese el n\\u00famero de tel\\u00e9fono, elija el monto y confirme la transacci\\u00f3n."},"fr":{"question":"Comment recharger mon t\\u00e9l\\u00e9phone mobile avec QRPay Pro\\u00a0?","answer":"Pour recharger votre t\\u00e9l\\u00e9phone mobile, acc\\u00e9dez \\u00e0 la section Recharge mobile de votre application QRPay Pro, s\\u00e9lectionnez votre op\\u00e9rateur, saisissez le num\\u00e9ro de t\\u00e9l\\u00e9phone, choisissez le montant et confirmez la transaction."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u093c\\u094b\\u0928 \\u0915\\u093e \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0942\\u0901?","answer":"\\u0905\\u092a\\u0928\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u093c\\u094b\\u0928 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0910\\u092a \\u092e\\u0947\\u0902 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u0905\\u092a\\u0928\\u093e \\u0935\\u093e\\u0939\\u0915 \\u091a\\u0941\\u0928\\u0947\\u0902, \\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724a058ae1cd"},"6724a06157016":{"language":{"en":{"question":"Can I top up a mobile number that belongs to someone else?","answer":"Yes, you can recharge the mobile account of another person by entering their phone number in the Mobile Top-Up section."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0642\\u0645 \\u062c\\u0648\\u0627\\u0644 \\u064a\\u062e\\u0635 \\u0634\\u062e\\u0635 \\u0622\\u062e\\u0631\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0634\\u062d\\u0646 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0644\\u0634\\u062e\\u0635 \\u0622\\u062e\\u0631 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0625\\u062f\\u062e\\u0627\\u0644 \\u0631\\u0642\\u0645 \\u0647\\u0627\\u062a\\u0641\\u0647 \\u0641\\u064a \\u0642\\u0633\\u0645 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644."},"es":{"question":"\\u00bfPuedo recargar un n\\u00famero de m\\u00f3vil que pertenece a otra persona?","answer":"S\\u00ed, puedes recargar la cuenta m\\u00f3vil de otra persona ingresando su n\\u00famero de tel\\u00e9fono en la secci\\u00f3n Recarga M\\u00f3vil."},"fr":{"question":"Puis-je recharger un num\\u00e9ro de mobile appartenant \\u00e0 quelqu\'un d\'autre ?","answer":"Oui, vous pouvez recharger le compte mobile d\'une autre personne en saisissant son num\\u00e9ro de t\\u00e9l\\u00e9phone dans la section Recharge Mobile."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0909\\u0938 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0902\\u092c\\u0930 \\u0915\\u094b \\u091f\\u0949\\u092a \\u0905\\u092a \\u0915\\u0930\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902 \\u091c\\u094b \\u0915\\u093f\\u0938\\u0940 \\u0914\\u0930 \\u0915\\u093e \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0938\\u0940 \\u0905\\u0928\\u094d\\u092f \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u093e \\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0915\\u0947 \\u0909\\u0938\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u0930\\u093f\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724a06157016"},"6724a06c7de3a":{"language":{"en":{"question":"Are there any fees associated with mobile top-ups?","answer":"Mobile top-ups may incur a small service fee, depending on your mobile carrier and the amount being topped up. Please check the details in the app before confirming your transaction."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u061f","answer":"\\u0642\\u062f \\u062a\\u0624\\u062f\\u064a \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0641\\u0631\\u0636 \\u0631\\u0633\\u0648\\u0645 \\u062e\\u062f\\u0645\\u0629 \\u0628\\u0633\\u064a\\u0637\\u0629\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0634\\u063a\\u0644 \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0648\\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u062a\\u062a\\u0645 \\u062a\\u0639\\u0628\\u0626\\u062a\\u0647. \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643."},"es":{"question":"\\u00bfHay alguna tarifa asociada con las recargas m\\u00f3viles?","answer":"Las recargas m\\u00f3viles pueden generar una peque\\u00f1a tarifa de servicio, dependiendo de su operador de telefon\\u00eda m\\u00f3vil y del monto que se recargue. Verifique los detalles en la aplicaci\\u00f3n antes de confirmar su transacci\\u00f3n."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s aux recharges mobiles ?","answer":"Les recharges mobiles peuvent entra\\u00eener des frais de service minimes, en fonction de votre op\\u00e9rateur mobile et du montant recharg\\u00e9. Veuillez v\\u00e9rifier les d\\u00e9tails dans l\'application avant de confirmer votre transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u092a\\u0930 \\u090f\\u0915 \\u091b\\u094b\\u091f\\u093e \\u0938\\u093e \\u0938\\u0947\\u0935\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u091c\\u094b \\u0906\\u092a\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0935\\u093e\\u0939\\u0915 \\u0914\\u0930 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0930\\u093e\\u0936\\u093f \\u092a\\u0930 \\u0928\\u093f\\u0930\\u094d\\u092d\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0915\\u0943\\u092a\\u092f\\u093e \\u0905\\u092a\\u0928\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0910\\u092a \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902\\u0964"}},"id":"6724a06c7de3a"},"6724a0758e02b":{"language":{"en":{"question":"How will I know if my mobile top-up was successful?","answer":"You will receive a confirmation notification once your mobile top-up is processed successfully. You can also check your transaction history for details."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0647\\u0627\\u062a\\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0646\\u0627\\u062c\\u062d\\u0629\\u061f","answer":"\\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0628\\u0645\\u062c\\u0631\\u062f \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0647\\u0627\\u062a\\u0641\\u0643 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0646\\u062c\\u0627\\u062d. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si mi recarga m\\u00f3vil fue exitosa?","answer":"Recibir\\u00e1s una notificaci\\u00f3n de confirmaci\\u00f3n una vez que tu recarga m\\u00f3vil se procese con \\u00e9xito. Tambi\\u00e9n puede consultar su historial de transacciones para obtener m\\u00e1s detalles."},"fr":{"question":"Comment saurai-je si ma recharge mobile a r\\u00e9ussi ?","answer":"Vous recevrez une notification de confirmation une fois que votre recharge mobile aura \\u00e9t\\u00e9 trait\\u00e9e avec succ\\u00e8s. Vous pouvez \\u00e9galement consulter l\'historique de vos transactions pour plus de d\\u00e9tails."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092e\\u0947\\u0930\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u092b\\u0932 \\u0930\\u0939\\u093e?","answer":"\\u090f\\u0915 \\u092c\\u093e\\u0930 \\u0906\\u092a\\u0915\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u092b\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0928\\u0947 \\u092a\\u0930 \\u0906\\u092a\\u0915\\u094b \\u090f\\u0915 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f\\u0915\\u0930\\u0923 \\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964 \\u0906\\u092a \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092d\\u0940 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724a0758e02b"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 15:33:01','updated_at' => '2024-11-07 10:29:30'),
            array('id' => '18','parent_id' => '18','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Receiving Payments with QRPay Pro","sub_heading":"Learn more about using QRPay Pro\\u2019s QR Code feature to accept payments easily and securely."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 QR Code \\u0641\\u064a QRPay Pro \\u0644\\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646."},"es":{"heading":"Preguntas frecuentes sobre la recepci\\u00f3n de pagos con QRPay Pro","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre el uso de la funci\\u00f3n C\\u00f3digo QR de QRPay Pro para aceptar pagos de forma f\\u00e1cil y segura."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur la r\\u00e9ception de paiements avec QRPay Pro","sub_heading":"Apprenez-en davantage sur l\\u2019utilisation de la fonctionnalit\\u00e9 QR Code de QRPay Pro pour accepter les paiements facilement et en toute s\\u00e9curit\\u00e9."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay Pro \\u0915\\u0947 QR \\u0915\\u094b\\u0921 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724b71841d76":{"language":{"en":{"question":"Do I need to create a new QR Code for each transaction?","answer":"No, QRPay Pro provides each merchant account with a unique, permanent QR Code upon registration. Use this QR Code repeatedly to accept payments without generating a new code each time."},"ar":{"question":"\\u0647\\u0644 \\u0623\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0645\\u0632 QR \\u062c\\u062f\\u064a\\u062f \\u0644\\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u061f","answer":"\\u0644\\u0627\\u060c \\u064a\\u0648\\u0641\\u0631 QRPay Pro \\u0644\\u0643\\u0644 \\u062d\\u0633\\u0627\\u0628 \\u062a\\u0627\\u062c\\u0631 \\u0631\\u0645\\u0632 QR \\u0641\\u0631\\u064a\\u062f \\u0648\\u062f\\u0627\\u0626\\u0645 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644. \\u0627\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0647\\u0630\\u0627 \\u0628\\u0634\\u0643\\u0644 \\u0645\\u062a\\u0643\\u0631\\u0631 \\u0644\\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u062f\\u0648\\u0646 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0645\\u0632 \\u062c\\u062f\\u064a\\u062f \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0631\\u0629."},"es":{"question":"\\u00bfNecesito crear un nuevo c\\u00f3digo QR para cada transacci\\u00f3n?","answer":"No, QRPay Pro proporciona a cada cuenta de comerciante un c\\u00f3digo QR \\u00fanico y permanente al registrarse. Utilice este c\\u00f3digo QR repetidamente para aceptar pagos sin generar un c\\u00f3digo nuevo cada vez."},"fr":{"question":"Dois-je cr\\u00e9er un nouveau QR Code pour chaque transaction ?","answer":"Non, QRPay Pro fournit \\u00e0 chaque compte marchand un code QR unique et permanent lors de l\'inscription. Utilisez ce QR Code \\u00e0 plusieurs reprises pour accepter des paiements sans g\\u00e9n\\u00e9rer de nouveau code \\u00e0 chaque fois."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u091d\\u0947 \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0928\\u092f\\u093e \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0928\\u0939\\u0940\\u0902, \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930\\u092a\\u0947 \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u0940 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u094b \\u092a\\u0902\\u091c\\u0940\\u0915\\u0930\\u0923 \\u092a\\u0930 \\u090f\\u0915 \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f, \\u0938\\u094d\\u0925\\u093e\\u092f\\u0940 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u0930 \\u092c\\u093e\\u0930 \\u0928\\u092f\\u093e \\u0915\\u094b\\u0921 \\u091c\\u0928\\u0930\\u0947\\u091f \\u0915\\u093f\\u090f \\u092c\\u093f\\u0928\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0938 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0915\\u093e \\u092c\\u093e\\u0930-\\u092c\\u093e\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724b71841d76"},"6724b7243f9d9":{"language":{"en":{"question":"What payment methods can customers use when scanning my QR Code?","answer":"Customers can pay using various methods that QRPay Pro supports. The platform handles the process seamlessly, ensuring secure and efficient transactions."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0639\\u0646\\u062f \\u0645\\u0633\\u062d \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0637\\u0631\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u064a\\u062f\\u0639\\u0645\\u0647\\u0627 QRPay Pro. \\u062a\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de pago pueden utilizar los clientes al escanear mi c\\u00f3digo QR?","answer":"Los clientes pueden pagar utilizando varios m\\u00e9todos compatibles con QRPay Pro. La plataforma maneja el proceso sin problemas, garantizando transacciones seguras y eficientes."},"fr":{"question":"Quels modes de paiement les clients peuvent-ils utiliser lorsqu\'ils scannent mon QR Code\\u00a0?","answer":"Les clients peuvent payer en utilisant diverses m\\u00e9thodes prises en charge par QRPay Pro. La plateforme g\\u00e8re le processus de mani\\u00e8re transparente, garantissant des transactions s\\u00e9curis\\u00e9es et efficaces."},"hi":{"question":"\\u092e\\u0947\\u0930\\u0947 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0915\\u094b \\u0938\\u094d\\u0915\\u0948\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u0915\\u093f\\u0928 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902?","answer":"\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 QRPay Pro \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u0941\\u0936\\u0932 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0941\\u090f \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0902\\u092d\\u093e\\u0932\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724b7243f9d9"},"6724b72f02292":{"language":{"en":{"question":"Can customers from other countries pay me using the QR Code?","answer":"Yes, QRPay Pro\\u2019s multi-currency support allows you to accept payments from customers worldwide. The platform automatically manages any necessary currency conversion."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0645\\u0646 \\u0628\\u0644\\u062f\\u0627\\u0646 \\u0623\\u062e\\u0631\\u0649 \\u0623\\u0646 \\u064a\\u062f\\u0641\\u0639\\u0648\\u0627 \\u0644\\u064a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062a\\u064a\\u062d \\u0644\\u0643 \\u062f\\u0639\\u0645 QRPay Pro \\u0645\\u062a\\u0639\\u062f\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0641\\u064a \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646\\u062d\\u0627\\u0621 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645. \\u062a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u062a\\u0644\\u0642\\u0627\\u0626\\u064a\\u064b\\u0627 \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0623\\u064a \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0636\\u0631\\u0648\\u0631\\u064a \\u0644\\u0644\\u0639\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfPueden los clientes de otros pa\\u00edses pagarme mediante el C\\u00f3digo QR?","answer":"S\\u00ed, el soporte multidivisa de QRPay Pro le permite aceptar pagos de clientes de todo el mundo. La plataforma gestiona autom\\u00e1ticamente cualquier conversi\\u00f3n de moneda necesaria."},"fr":{"question":"Les clients d\'autres pays peuvent-ils me payer en utilisant le QR Code ?","answer":"Oui, la prise en charge multidevises de QRPay Pro vous permet d\'accepter les paiements de clients du monde entier. La plateforme g\\u00e8re automatiquement toute conversion de devise n\\u00e9cessaire."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0905\\u0928\\u094d\\u092f \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930 \\u0915\\u094b\\u0921 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092e\\u0941\\u091d\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902?","answer":"\\u0939\\u093e\\u0901, QRPay Pro \\u0915\\u093e \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0906\\u092a\\u0915\\u094b \\u0926\\u0941\\u0928\\u093f\\u092f\\u093e \\u092d\\u0930 \\u0915\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0938\\u094d\\u0935\\u091a\\u093e\\u0932\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724b72f02292"},"6724b73908a8c":{"language":{"en":{"question":"How will I know if a payment is successful?","answer":"QRPay Pro sends real-time notifications for every transaction, so you\\u2019ll instantly know when a payment has been received, allowing for better cash flow tracking."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0639\\u0631\\u0641 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0646\\u0627\\u062c\\u062d\\u0629\\u061f","answer":"\\u064a\\u0631\\u0633\\u0644 QRPay Pro \\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a \\u0644\\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0644\\u0630\\u0644\\u0643 \\u0633\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0645\\u062a\\u0649 \\u062a\\u0645 \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0628\\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u062a\\u062f\\u0641\\u0642 \\u0627\\u0644\\u0646\\u0642\\u062f\\u064a \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0641\\u0636\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si un pago se realiz\\u00f3 correctamente?","answer":"QRPay Pro env\\u00eda notificaciones en tiempo real para cada transacci\\u00f3n, por lo que sabr\\u00e1 instant\\u00e1neamente cu\\u00e1ndo se recibi\\u00f3 un pago, lo que permitir\\u00e1 un mejor seguimiento del flujo de efectivo."},"fr":{"question":"Comment saurai-je si un paiement a r\\u00e9ussi\\u00a0?","answer":"QRPay Pro envoie des notifications en temps r\\u00e9el pour chaque transaction, de sorte que vous saurez instantan\\u00e9ment quand un paiement a \\u00e9t\\u00e9 re\\u00e7u, permettant ainsi un meilleur suivi des flux de tr\\u00e9sorerie."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u092b\\u0932 \\u0939\\u0941\\u0906 \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0902 \\u092d\\u0947\\u091c\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092a\\u0924\\u093e \\u091a\\u0932 \\u091c\\u093e\\u090f\\u0917\\u093e \\u0915\\u093f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u092c \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u0941\\u0906 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092c\\u0947\\u0939\\u0924\\u0930 \\u0928\\u0915\\u0926\\u0940 \\u092a\\u094d\\u0930\\u0935\\u093e\\u0939 \\u091f\\u094d\\u0930\\u0948\\u0915\\u093f\\u0902\\u0917 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u092e\\u093f\\u0932\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"6724b73908a8c"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:10:04','updated_at' => '2024-11-06 17:23:25'),
            array('id' => '19','parent_id' => '19','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Currency Exchange in QRPay Pro","sub_heading":"Learn more about securely managing currency exchanges with QRPay Pro\\u2019s powerful tools."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a QRPay Pro","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0623\\u062f\\u0648\\u0627\\u062a QRPay Pro \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629."},"es":{"heading":"Preguntas frecuentes sobre el cambio de divisas en QRPay Pro","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo gestionar de forma segura los cambios de divisas con las potentes herramientas de QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur le change de devises dans QRPay Pro","sub_heading":"Apprenez-en davantage sur la gestion s\\u00e9curis\\u00e9e des \\u00e9changes de devises avec les puissants outils de QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0936\\u0915\\u094d\\u0924\\u093f\\u0936\\u093e\\u0932\\u0940 \\u091f\\u0942\\u0932 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724b7d49624e":{"language":{"en":{"question":"What exchange rates does QRPay Pro use for currency conversion?","answer":"QRPay Pro uses real-time exchange rates provided by trusted financial data sources, ensuring that you get accurate and fair rates during each conversion."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0633\\u062a\\u062e\\u062f\\u0645\\u0647\\u0627 QRPay Pro \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0648\\u0641\\u0631\\u0647\\u0627 \\u0645\\u0635\\u0627\\u062f\\u0631 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u062f\\u0642\\u064a\\u0642\\u0629 \\u0648\\u0639\\u0627\\u062f\\u0644\\u0629 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0643\\u0644 \\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfQu\\u00e9 tipos de cambio utiliza QRPay Pro para la conversi\\u00f3n de moneda?","answer":"QRPay Pro utiliza tipos de cambio en tiempo real proporcionados por fuentes de datos financieros confiables, lo que garantiza que obtenga tasas precisas y justas durante cada conversi\\u00f3n."},"fr":{"question":"Quels taux de change QRPay Pro utilise-t-il pour la conversion de devises\\u00a0?","answer":"QRPay Pro utilise des taux de change en temps r\\u00e9el fournis par des sources de donn\\u00e9es financi\\u00e8res fiables, garantissant que vous obtenez des taux pr\\u00e9cis et \\u00e9quitables lors de chaque conversion."},"hi":{"question":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f QRPay Pro \\u0915\\u093f\\u0938 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0921\\u0947\\u091f\\u093e \\u0938\\u094d\\u0930\\u094b\\u0924\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a\\u0915\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u0938\\u091f\\u0940\\u0915 \\u0914\\u0930 \\u0909\\u091a\\u093f\\u0924 \\u0926\\u0930\\u0947\\u0902 \\u092e\\u093f\\u0932\\u0947\\u0902\\u0964"}},"id":"6724b7d49624e"},"6724b7dd6cb4d":{"language":{"en":{"question":"Are there any fees for currency exchange in QRPay Pro?","answer":"QRPay Pro may charge a small service fee for each currency exchange transaction. You can view any applicable fees before confirming the exchange."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a QRPay Pro\\u061f","answer":"\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0648\\u0641\\u0631\\u0647\\u0627 \\u0645\\u0635\\u0627\\u062f\\u0631 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u062d\\u0635\\u0648\\u0644\\u0643 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u062f\\u0642\\u064a\\u0642\\u0629 \\u0648\\u0639\\u0627\\u062f\\u0644\\u0629 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0643\\u0644 \\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfHay alguna tarifa por el cambio de moneda en QRPay Pro?","answer":"QRPay Pro utiliza tipos de cambio en tiempo real proporcionados por fuentes de datos financieros confiables, lo que garantiza que obtenga tasas precisas y justas durante cada conversi\\u00f3n."},"fr":{"question":"Y a-t-il des frais pour le change de devises dans QRPay Pro\\u00a0?","answer":"QRPay Pro utilise des taux de change en temps r\\u00e9el fournis par des sources de donn\\u00e9es financi\\u00e8res fiables, garantissant que vous obtenez des taux pr\\u00e9cis et \\u00e9quitables lors de chaque conversion."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e QRPay Pro \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093f\\u0936\\u094d\\u0935\\u0938\\u0928\\u0940\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0921\\u0947\\u091f\\u093e \\u0938\\u094d\\u0930\\u094b\\u0924\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0906\\u092a\\u0915\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u0938\\u091f\\u0940\\u0915 \\u0914\\u0930 \\u0909\\u091a\\u093f\\u0924 \\u0926\\u0930\\u0947\\u0902 \\u092e\\u093f\\u0932\\u0947\\u0902\\u0964"}},"id":"6724b7dd6cb4d"},"6724b7e620e85":{"language":{"en":{"question":"How quickly is the currency exchange processed?","answer":"Currency exchanges in QRPay Pro are processed instantly. Once you confirm the exchange, the converted funds are immediately available in your account in the target currency."},"ar":{"question":"\\u0645\\u0627 \\u0645\\u062f\\u0649 \\u0633\\u0631\\u0639\\u0629 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u062a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a QRPay Pro \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631. \\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0623\\u0643\\u064a\\u062f \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644\\u060c \\u062a\\u0635\\u0628\\u062d \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0645\\u062d\\u0648\\u0644\\u0629 \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0628\\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u062f\\u0641\\u0629."},"es":{"question":"\\u00bfQu\\u00e9 tan r\\u00e1pido se procesa el cambio de moneda?","answer":"Los cambios de moneda en QRPay Pro se procesan instant\\u00e1neamente. Una vez que confirme el cambio, los fondos convertidos estar\\u00e1n disponibles inmediatamente en su cuenta en la moneda de destino."},"fr":{"question":"\\u00c0 quelle vitesse le change de devises est-il trait\\u00e9\\u00a0?","answer":"Les \\u00e9changes de devises dans QRPay Pro sont trait\\u00e9s instantan\\u00e9ment. Une fois l\'\\u00e9change confirm\\u00e9, les fonds convertis sont imm\\u00e9diatement disponibles sur votre compte dans la devise cible."},"hi":{"question":"\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u093f\\u0924\\u0928\\u0940 \\u091c\\u0932\\u094d\\u0926\\u0940 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948?","answer":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u090f\\u0915 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0915\\u094d\\u0937\\u094d\\u092f \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u094b \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"6724b7e620e85"},"6724b7ef0316f":{"language":{"en":{"question":"Can I exchange multiple currencies within my account?","answer":"Yes, QRPay Pro supports multi-currency accounts, allowing you to exchange between various supported currencies seamlessly. This feature is ideal for merchants serving customers from different countries."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u0644 \\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u062f\\u0627\\u062e\\u0644 \\u062d\\u0633\\u0627\\u0628\\u064a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0628\\u064a\\u0646 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629. \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u064a\\u0632\\u0629 \\u0645\\u062b\\u0627\\u0644\\u064a\\u0629 \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u062e\\u062f\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0645\\u0646 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0628\\u0644\\u062f\\u0627\\u0646."},"es":{"question":"\\u00bfPuedo cambiar varias monedas dentro de mi cuenta?","answer":"S\\u00ed, QRPay Pro admite cuentas multidivisa, lo que le permite intercambiar entre varias monedas admitidas sin problemas. Esta caracter\\u00edstica es ideal para comerciantes que atienden a clientes de diferentes pa\\u00edses."},"fr":{"question":"Puis-je \\u00e9changer plusieurs devises sur mon compte ?","answer":"Oui, QRPay Pro prend en charge les comptes multi-devises, vous permettant d\'\\u00e9changer de mani\\u00e8re transparente entre diff\\u00e9rentes devises prises en charge. Cette fonctionnalit\\u00e9 est id\\u00e9ale pour les commer\\u00e7ants servant des clients de diff\\u00e9rents pays."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u090f\\u0915\\u093e\\u0927\\u093f\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901, QRPay \\u092a\\u094d\\u0930\\u094b \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0916\\u093e\\u0924\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0928\\u093f\\u0930\\u094d\\u092c\\u093e\\u0927 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0947\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0926\\u0930\\u094d\\u0936 \\u0939\\u0948\\u0964"}},"id":"6724b7ef0316f"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:13:13','updated_at' => '2024-11-07 10:33:20'),
            array('id' => '20','parent_id' => '20','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About QRPay Pro Payment Link","sub_heading":"Discover how QRPay Pro Payment Links make collecting payments easy and secure for merchants."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro","sub_heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0643\\u064a\\u0641 \\u062a\\u062c\\u0639\\u0644 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u062d\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0633\\u0647\\u0644\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0644\\u0644\\u062a\\u062c\\u0627\\u0631."},"es":{"heading":"Preguntas frecuentes sobre el enlace de pago QRPay Pro","sub_heading":"Descubra c\\u00f3mo los enlaces de pago QRPay Pro hacen que el cobro de pagos sea f\\u00e1cil y seguro para los comerciantes."},"fr":{"heading":"Foire aux questions sur le lien de paiement QRPay Pro","sub_heading":"D\\u00e9couvrez comment les liens de paiement QRPay Pro rendent la collecte des paiements facile et s\\u00e9curis\\u00e9e pour les commer\\u00e7ants."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u091c\\u093e\\u0928\\u0947\\u0902 \\u0915\\u093f \\u0915\\u0948\\u0938\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0928\\u093e \\u0906\\u0938\\u093e\\u0928 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092c\\u0928\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"items":{"6724b915e0842":{"language":{"en":{"question":"How do I create a payment link in QRPay Pro?","answer":"To create a payment link, log in to your QRPay Pro merchant dashboard, enter the amount and payment details, and generate the link. You can then share this link with your customers for quick and easy payment."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0642\\u0648\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0631\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0644\\u0648\\u062d\\u0629 \\u062a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u062a\\u0627\\u062c\\u0631 QRPay Pro\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u062b\\u0645 \\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0628\\u0639\\u062f \\u0630\\u0644\\u0643 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0637 \\u0645\\u0639 \\u0639\\u0645\\u0644\\u0627\\u0626\\u0643 \\u0644\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639 \\u0648\\u0627\\u0644\\u0633\\u0647\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo creo un enlace de pago en QRPay Pro?","answer":"Para crear un enlace de pago, inicie sesi\\u00f3n en su panel de comerciante QRPay Pro, ingrese el monto y los detalles del pago y genere el enlace. Luego puede compartir este enlace con sus clientes para realizar un pago r\\u00e1pido y sencillo."},"fr":{"question":"Comment cr\\u00e9er un lien de paiement dans QRPay Pro ?","answer":"Pour cr\\u00e9er un lien de paiement, connectez-vous \\u00e0 votre tableau de bord marchand QRPay Pro, saisissez le montant et les d\\u00e9tails du paiement, puis g\\u00e9n\\u00e9rez le lien. Vous pourrez ensuite partager ce lien avec vos clients pour un paiement simple et rapide."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0948\\u0938\\u0947 \\u092c\\u0928\\u093e\\u090a\\u0902?","answer":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u092e\\u0930\\u094d\\u091a\\u0947\\u0902\\u091f \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0914\\u0930 \\u0932\\u093f\\u0902\\u0915 \\u091c\\u0947\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902\\u0964 \\u092b\\u093f\\u0930 \\u0906\\u092a \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0906\\u0938\\u093e\\u0928 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0938 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724b915e0842"},"6724b9207c65f":{"language":{"en":{"question":"Can I customize the payment link details for different transactions?","answer":"Yes, QRPay Pro allows you to add specific details for each payment link, such as the payment amount, description, and expiration date, to match the needs of each transaction."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u062e\\u0635\\u064a\\u0635 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062a\\u064a\\u062d \\u0644\\u0643 QRPay Pro \\u0625\\u0636\\u0627\\u0641\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0644\\u0643\\u0644 \\u0631\\u0627\\u0628\\u0637 \\u062f\\u0641\\u0639\\u060c \\u0645\\u062b\\u0644 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u062f\\u0641\\u0639\\u0629 \\u0648\\u0627\\u0644\\u0648\\u0635\\u0641 \\u0648\\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0635\\u0644\\u0627\\u062d\\u064a\\u0629\\u060c \\u0644\\u062a\\u062a\\u0646\\u0627\\u0633\\u0628 \\u0645\\u0639 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfPuedo personalizar los detalles del enlace de pago para diferentes transacciones?","answer":"S\\u00ed, QRPay Pro le permite agregar detalles espec\\u00edficos para cada enlace de pago, como el monto del pago, la descripci\\u00f3n y la fecha de vencimiento, para satisfacer las necesidades de cada transacci\\u00f3n."},"fr":{"question":"Puis-je personnaliser les d\\u00e9tails du lien de paiement pour diff\\u00e9rentes transactions\\u00a0?","answer":"Oui, QRPay Pro vous permet d\'ajouter des d\\u00e9tails sp\\u00e9cifiques pour chaque lien de paiement, tels que le montant du paiement, la description et la date d\'expiration, pour r\\u00e9pondre aux besoins de chaque transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u094b \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, \\u0915\\u094d\\u092f\\u0942\\u0906\\u0930\\u092a\\u0947 \\u092a\\u094d\\u0930\\u094b \\u0906\\u092a\\u0915\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u092e\\u0947\\u0932 \\u0916\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0935\\u093f\\u0935\\u0930\\u0923 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0930\\u093e\\u0936\\u093f, \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0914\\u0930 \\u0938\\u092e\\u093e\\u092a\\u094d\\u0924\\u093f \\u0924\\u093f\\u0925\\u093f\\u0964"}},"id":"6724b9207c65f"},"6724b94031cd3":{"language":{"en":{"question":"Are there any fees for using the payment link feature in QRPay Pro?","answer":"QRPay Pro may charge a nominal fee for processing payments through payment links. You can view and confirm any applicable fees before finalizing each transaction."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062e\\u0627\\u0635\\u064a\\u0629 \\u0631\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a QRPay Pro\\u061f","answer":"\\u0642\\u062f \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0631\\u0645\\u0632\\u064a\\u0629 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0639\\u0631\\u0636 \\u0648\\u062a\\u0623\\u0643\\u064a\\u062f \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0645\\u0646 \\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfExiste alguna tarifa por utilizar la funci\\u00f3n de enlace de pago en QRPay Pro?","answer":"QRPay Pro puede cobrar una tarifa nominal por procesar pagos a trav\\u00e9s de enlaces de pago. Puede ver y confirmar las tarifas aplicables antes de finalizar cada transacci\\u00f3n."},"fr":{"question":"Y a-t-il des frais pour l\'utilisation de la fonction de lien de paiement dans QRPay Pro\\u00a0?","answer":"QRPay Pro peut facturer des frais nominaux pour le traitement des paiements via des liens de paiement. Vous pouvez consulter et confirmer tous les frais applicables avant de finaliser chaque transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e QRPay Pro \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"QRPay Pro \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u093e\\u092e\\u0942\\u0932\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u0947 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0905\\u0902\\u0924\\u093f\\u092e \\u0930\\u0942\\u092a \\u0926\\u0947\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u094b \\u0926\\u0947\\u0916 \\u0914\\u0930 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724b94031cd3"},"6724b94bef252":{"language":{"en":{"question":"Is it safe to share payment links with customers?","answer":"Yes, QRPay Pro prioritizes security, and all payment links are encrypted. This ensures that each transaction is protected, allowing you to share links with peace of mind."},"ar":{"question":"\\u0647\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0622\\u0645\\u0646 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0639\\u0637\\u064a QRPay Pro \\u0627\\u0644\\u0623\\u0648\\u0644\\u0648\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0645\\u0646\\u060c \\u0648\\u064a\\u062a\\u0645 \\u062a\\u0634\\u0641\\u064a\\u0631 \\u062c\\u0645\\u064a\\u0639 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639. \\u0648\\u0647\\u0630\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0643\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0631\\u0648\\u0627\\u0628\\u0637 \\u0645\\u0639 \\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644."},"es":{"question":"\\u00bfEs seguro compartir enlaces de pago con los clientes?","answer":"S\\u00ed, QRPay Pro prioriza la seguridad y todos los enlaces de pago est\\u00e1n encriptados. Esto garantiza que cada transacci\\u00f3n est\\u00e9 protegida, lo que le permite compartir enlaces con tranquilidad."},"fr":{"question":"Est-il s\\u00e9curis\\u00e9 de partager des liens de paiement avec des clients\\u00a0?","answer":"Oui, QRPay Pro donne la priorit\\u00e9 \\u00e0 la s\\u00e9curit\\u00e9 et tous les liens de paiement sont crypt\\u00e9s. Cela garantit que chaque transaction est prot\\u00e9g\\u00e9e, vous permettant de partager des liens en toute s\\u00e9r\\u00e9nit\\u00e9."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0901, QRPay Pro \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u0925\\u092e\\u093f\\u0915\\u0924\\u093e \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u0938\\u092d\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0932\\u093f\\u0902\\u0915 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u092e\\u0928 \\u0915\\u0940 \\u0936\\u093e\\u0902\\u0924\\u093f \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0932\\u093f\\u0902\\u0915 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724b94bef252"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:18:31','updated_at' => '2024-11-06 17:35:24'),
            array('id' => '21','parent_id' => '21','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Withdrawing Money","sub_heading":"Learn more about how to securely and efficiently withdraw your funds from QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0633\\u062d\\u0628 \\u0623\\u0645\\u0648\\u0627\\u0644\\u0643 \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646 \\u0648\\u0641\\u0639\\u0627\\u0644 \\u0645\\u0646 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre retirar dinero","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo retirar sus fondos de QRPay Pro de forma segura y eficiente."},"fr":{"heading":"Foire aux questions sur le retrait d\'argent","sub_heading":"Apprenez-en davantage sur la mani\\u00e8re de retirer vos fonds de mani\\u00e8re s\\u00e9curis\\u00e9e et efficace de QRPay Pro."},"hi":{"heading":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay Pro \\u0938\\u0947 \\u0905\\u092a\\u0928\\u0940 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u0941\\u0936\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0930\\u0940\\u0915\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724b9ed0c9d7":{"language":{"en":{"question":"How long does it take to withdraw money from QRPay Pro?","answer":"Withdrawal times may vary depending on the method chosen. Bank transfers generally take 1-3 business days, while digital wallet transfers are often faster. You\\u2019ll receive a notification once the transfer is completed."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u064a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 QRPay Pro\\u061f","answer":"\\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0623\\u0648\\u0642\\u0627\\u062a \\u0627\\u0644\\u0633\\u062d\\u0628 \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0627\\u0631\\u0629. \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0639\\u0627\\u062f\\u0629\\u064b \\u0645\\u0646 1 \\u0625\\u0644\\u0649 3 \\u0623\\u064a\\u0627\\u0645 \\u0639\\u0645\\u0644\\u060c \\u0641\\u064a \\u062d\\u064a\\u0646 \\u0623\\u0646 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629 \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u0645\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0623\\u0633\\u0631\\u0639. \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0628\\u0645\\u062c\\u0631\\u062f \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0642\\u0644."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo se tarda en retirar dinero de QRPay Pro?","answer":"Los tiempos de retiro pueden variar seg\\u00fan el m\\u00e9todo elegido. Las transferencias bancarias generalmente demoran entre 1 y 3 d\\u00edas h\\u00e1biles, mientras que las transferencias de billetera digital suelen ser m\\u00e1s r\\u00e1pidas. Recibir\\u00e1s una notificaci\\u00f3n una vez que se complete la transferencia."},"fr":{"question":"Combien de temps faut-il pour retirer de l\'argent de QRPay Pro ?","answer":"Les d\\u00e9lais de retrait peuvent varier selon la m\\u00e9thode choisie. Les virements bancaires prennent g\\u00e9n\\u00e9ralement 1 \\u00e0 3 jours ouvrables, tandis que les transferts de portefeuille num\\u00e9rique sont souvent plus rapides. Vous recevrez une notification une fois le transfert termin\\u00e9."},"hi":{"question":"QRPay Pro \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u093e \\u0938\\u092e\\u092f \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092e\\u0947\\u0902 \\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 1-3 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0926\\u093f\\u0935\\u0938 \\u0932\\u0917\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u092c\\u0915\\u093f \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0924\\u0947\\u091c\\u093c \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0942\\u0930\\u093e \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0940 \\u0906\\u092a\\u0915\\u094b \\u090f\\u0915 \\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"6724b9ed0c9d7"},"6724b9f78212d":{"language":{"en":{"question":"What are the fees associated with withdrawals on QRPay Pro?","answer":"QRPay Pro may charge a small fee for withdrawals, depending on the transfer method and destination. You\\u2019ll be able to view any applicable fees before confirming the withdrawal."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u0642\\u062f \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0639\\u0644\\u0649 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0633\\u062d\\u0628\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0648\\u0627\\u0644\\u0648\\u062c\\u0647\\u0629. \\u0633\\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0639\\u0631\\u0636 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0633\\u062d\\u0628."},"es":{"question":"\\u00bfCu\\u00e1les son las tarifas asociadas con los retiros en QRPay Pro?","answer":"QRPay Pro puede cobrar una peque\\u00f1a tarifa por los retiros, seg\\u00fan el m\\u00e9todo de transferencia y el destino. Podr\\u00e1s ver las tarifas aplicables antes de confirmar el retiro."},"fr":{"question":"Quels sont les frais associ\\u00e9s aux retraits sur QRPay Pro ?","answer":"QRPay Pro peut facturer des frais minimes pour les retraits, en fonction de la m\\u00e9thode de transfert et de la destination. Vous pourrez consulter tous les frais applicables avant de confirmer le retrait."},"hi":{"question":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u092b\\u0940\\u0938 \\u0915\\u094d\\u092f\\u093e \\u0939\\u0948?","answer":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f \\u0914\\u0930 \\u0917\\u0902\\u0924\\u0935\\u094d\\u092f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930, QRPay Pro \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u091b\\u094b\\u091f\\u093e \\u0938\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u0947 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0915\\u094b\\u0908 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0947\\u0902\\u0917\\u0947\\u0964"}},"id":"6724b9f78212d"},"6724ba008303b":{"language":{"en":{"question":"Can I withdraw money to multiple accounts?","answer":"Yes, QRPay Pro allows you to set up multiple withdrawal methods, such as different bank accounts or digital wallets. Select your preferred account each time you make a withdrawal."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062a\\u064a\\u062d \\u0644\\u0643 QRPay Pro \\u0625\\u0639\\u062f\\u0627\\u062f \\u0637\\u0631\\u0642 \\u0633\\u062d\\u0628 \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0627\\u062e\\u062a\\u0631 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0631\\u0629 \\u062a\\u0642\\u0648\\u0645 \\u0641\\u064a\\u0647\\u0627 \\u0628\\u0627\\u0644\\u0633\\u062d\\u0628."},"es":{"question":"\\u00bfPuedo retirar dinero a varias cuentas?","answer":"S\\u00ed, QRPay Pro te permite configurar m\\u00faltiples m\\u00e9todos de retiro, como diferentes cuentas bancarias o billeteras digitales. Seleccione su cuenta preferida cada vez que realice un retiro."},"fr":{"question":"Puis-je retirer de l\\u2019argent sur plusieurs comptes ?","answer":"Oui, QRPay Pro vous permet de configurer plusieurs m\\u00e9thodes de retrait, telles que diff\\u00e9rents comptes bancaires ou portefeuilles num\\u00e9riques. S\\u00e9lectionnez votre compte pr\\u00e9f\\u00e9r\\u00e9 \\u00e0 chaque fois que vous effectuez un retrait."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0915\\u0908 \\u0916\\u093e\\u0924\\u094b\\u0902 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, QRPay Pro \\u0906\\u092a\\u0915\\u094b \\u0915\\u0908 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0902 \\u0938\\u0947\\u091f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092c\\u0948\\u0902\\u0915 \\u0916\\u093e\\u0924\\u0947 \\u092f\\u093e \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f\\u0964 \\u0939\\u0930 \\u092c\\u093e\\u0930 \\u091c\\u092c \\u0906\\u092a \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0930\\u0947\\u0902 \\u0924\\u094b \\u0905\\u092a\\u0928\\u093e \\u092a\\u0938\\u0902\\u0926\\u0940\\u0926\\u093e \\u0916\\u093e\\u0924\\u093e \\u091a\\u0941\\u0928\\u0947\\u0902\\u0964"}},"id":"6724ba008303b"},"6724ba0d8176c":{"language":{"en":{"question":"Are there withdrawal limits on QRPay Pro?","answer":"QRPay Pro may impose daily or transaction-based withdrawal limits based on your account level and regional regulations. You can view your specific limits in your QRPay Pro dashboard under Withdrawal Settings."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0644\\u0644\\u0633\\u062d\\u0628 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u0642\\u062f \\u064a\\u0641\\u0631\\u0636 QRPay Pro \\u062d\\u062f\\u0648\\u062f \\u0633\\u062d\\u0628 \\u064a\\u0648\\u0645\\u064a\\u0629 \\u0623\\u0648 \\u0642\\u0627\\u0626\\u0645\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0625\\u0642\\u0644\\u064a\\u0645\\u064a\\u0629. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0639\\u0631\\u0636 \\u062d\\u062f\\u0648\\u062f\\u0643 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629 \\u0641\\u064a \\u0644\\u0648\\u062d\\u0629 \\u062a\\u062d\\u0643\\u0645 QRPay Pro \\u0636\\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0633\\u062d\\u0628."},"es":{"question":"\\u00bfExisten l\\u00edmites de retiro en QRPay Pro?","answer":"QRPay Pro puede imponer l\\u00edmites de retiro diarios o basados \\u200b\\u200ben transacciones seg\\u00fan el nivel de su cuenta y las regulaciones regionales. Puede ver sus l\\u00edmites espec\\u00edficos en su panel de QRPay Pro en Configuraci\\u00f3n de retiro."},"fr":{"question":"Y a-t-il des limites de retrait sur QRPay Pro ?","answer":"QRPay Pro peut imposer des limites de retrait quotidiennes ou bas\\u00e9es sur les transactions en fonction du niveau de votre compte et des r\\u00e9glementations r\\u00e9gionales. Vous pouvez consulter vos limites sp\\u00e9cifiques dans votre tableau de bord QRPay Pro sous Param\\u00e8tres de retrait."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e QRPay Pro \\u092a\\u0930 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0939\\u0948?","answer":"QRPay Pro \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u0938\\u094d\\u0924\\u0930 \\u0914\\u0930 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u0940\\u092f \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0926\\u0948\\u0928\\u093f\\u0915 \\u092f\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928-\\u0906\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0938\\u0940\\u092e\\u093e \\u0932\\u0917\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0940 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e\\u090f\\u0901 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724ba0d8176c"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:22:09','updated_at' => '2024-11-06 17:54:27'),
            array('id' => '22','parent_id' => '22','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Gateway Settings","sub_heading":"Learn more about configuring and managing your QRPay Pro payment gateway."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u062a\\u0643\\u0648\\u064a\\u0646 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643."},"es":{"heading":"Preguntas frecuentes sobre la configuraci\\u00f3n de la puerta de enlace","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo configurar y administrar su pasarela de pago QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur les param\\u00e8tres de la passerelle","sub_heading":"Apprenez-en davantage sur la configuration et la gestion de votre passerelle de paiement QRPay Pro."},"hi":{"heading":"\\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0905\\u092a\\u0928\\u0947 QRPay Pro \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u094b \\u0915\\u0949\\u0928\\u094d\\u092b\\u093c\\u093f\\u0917\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724baa2af921":{"language":{"en":{"question":"Can I integrate QRPay Pro\\u2019s payment gateway with my existing e-commerce platform?","answer":"Yes, QRPay Pro\\u2019s payment gateway is designed to integrate seamlessly with various e-commerce platforms. Generate API keys from the QRPay Pro dashboard and follow the integration guide for a smooth setup."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0645\\u062c \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0645\\u0639 \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062d\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u064a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0640 QRPay Pro \\u0644\\u062a\\u062a\\u0643\\u0627\\u0645\\u0644 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0639 \\u0645\\u0646\\u0635\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u0629. \\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0645\\u0646 \\u0644\\u0648\\u062d\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a QRPay Pro \\u0648\\u0627\\u062a\\u0628\\u0639 \\u062f\\u0644\\u064a\\u0644 \\u0627\\u0644\\u062a\\u0643\\u0627\\u0645\\u0644 \\u0644\\u0625\\u0639\\u062f\\u0627\\u062f \\u0633\\u0644\\u0633."},"es":{"question":"\\u00bfPuedo integrar la pasarela de pago de QRPay Pro con mi","answer":"S\\u00ed, la pasarela de pago de QRPay Pro est\\u00e1 dise\\u00f1ada para integrarse perfectamente con varias plataformas de comercio electr\\u00f3nico. Genere claves API desde el panel de QRPay Pro y siga la gu\\u00eda de integraci\\u00f3n para una configuraci\\u00f3n sin problemas."},"fr":{"question":"Puis-je int\\u00e9grer la passerelle de paiement QRPay","answer":"Oui, la passerelle de paiement de QRPay Pro est con\\u00e7ue pour s\'int\\u00e9grer de mani\\u00e8re transparente \\u00e0 diverses plateformes de commerce \\u00e9lectronique. G\\u00e9n\\u00e9rez des cl\\u00e9s API \\u00e0 partir du tableau de bord QRPay Pro et suivez le guide d\'int\\u00e9gration pour une configuration fluide."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u0947 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u092e\\u094c\\u091c\\u0942\\u0926\\u093e \\u0908-\\u0915\\u0949\\u092e\\u0930\\u094d\\u0938 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u0949\\u0930\\u094d\\u092e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0939\\u093e\\u0901, QRPay Pro \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0908-\\u0915\\u0949\\u092e\\u0930\\u094d\\u0938 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093e\\u0930\\u094d\\u092e\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0939\\u091c\\u0924\\u093e \\u0938\\u0947 \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948\\u0964 QRPay Pro \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u0938\\u0947 API \\u0915\\u0941\\u0902\\u091c\\u0940 \\u091c\\u0947\\u0928\\u0930\\u0947\\u091f \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0938\\u0941\\u091a\\u093e\\u0930\\u0942 \\u0938\\u0947\\u091f\\u0905\\u092a \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915\\u0940\\u0915\\u0930\\u0923 \\u0917\\u093e\\u0907\\u0921 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724baa2af921"},"6724baaee5bf9":{"language":{"en":{"question":"How secure is the QRPay Pro payment gateway?","answer":"QRPay Pro uses top-tier security measures, including encryption and 2FA, to ensure that all transactions are protected. You can also enable additional security settings in the Gateway Settings for enhanced protection."},"ar":{"question":"\\u0645\\u0627 \\u0645\\u062f\\u0649 \\u0623\\u0645\\u0627\\u0646 \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 QRPay Pro\\u061f","answer":"\\u064a\\u0633\\u062a\\u062e\\u062f\\u0645 QRPay Pro \\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0623\\u0645\\u0646\\u064a\\u0629 \\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0645\\u0635\\u0627\\u062f\\u0642\\u0629 \\u0627\\u0644\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629 (2FA)\\u060c \\u0644\\u0636\\u0645\\u0627\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u062a\\u0645\\u0643\\u064a\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0641\\u064a \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629."},"es":{"question":"\\u00bfQu\\u00e9 tan segura es la pasarela de pago QRPay Pro?","answer":"QRPay Pro utiliza medidas de seguridad de primer nivel, incluido el cifrado y 2FA, para garantizar que todas las transacciones est\\u00e9n protegidas. Tambi\\u00e9n puede habilitar configuraciones de seguridad adicionales en la Configuraci\\u00f3n de la puerta de enlace para una protecci\\u00f3n mejorada."},"fr":{"question":"Dans quelle mesure la passerelle de paiement QRPay Pro est-elle s\\u00e9curis\\u00e9e\\u00a0?","answer":"QRPay Pro utilise des mesures de s\\u00e9curit\\u00e9 de haut niveau, notamment le cryptage et le 2FA, pour garantir que toutes les transactions sont prot\\u00e9g\\u00e9es. Vous pouvez \\u00e9galement activer des param\\u00e8tres de s\\u00e9curit\\u00e9 suppl\\u00e9mentaires dans les param\\u00e8tres de la passerelle pour une protection am\\u00e9lior\\u00e9e."},"hi":{"question":"QRPay Pro \\u092a\\u0947\\u092e\\u0947\\u0902\\u091f \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093f \\u0938\\u092d\\u0940 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0902, QRPay Pro \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u0936\\u0928 \\u0914\\u0930 2FA \\u0938\\u0939\\u093f\\u0924 \\u0936\\u0940\\u0930\\u094d\\u0937 \\u0938\\u094d\\u0924\\u0930\\u0940\\u092f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092c\\u0947\\u0939\\u0924\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u092e\\u0947\\u0902 \\u0905\\u0924\\u093f\\u0930\\u093f\\u0915\\u094d\\u0924 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u092d\\u0940 \\u0938\\u0915\\u094d\\u0937\\u092e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724baaee5bf9"},"6724bab99f88e":{"language":{"en":{"question":"What payment methods can I offer through QRPay Pro\\u2019s gateway?","answer":"QRPay Pro supports multiple payment methods, including QR code payments, bank transfers, and digital wallet options. Customize your available methods in the Gateway Settings to meet your customers\' needs."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u0642\\u062f\\u064a\\u0645\\u0647\\u0627 \\u0639\\u0628\\u0631 \\u0628\\u0648\\u0627\\u0628\\u0629 QRPay Pro\\u061f","answer":"\\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0637\\u0631\\u0642 \\u062f\\u0641\\u0639 \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u0629. \\u0642\\u0645 \\u0628\\u062a\\u062e\\u0635\\u064a\\u0635 \\u0627\\u0644\\u0637\\u0631\\u0642 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0644\\u062f\\u064a\\u0643 \\u0641\\u064a \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629 \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0639\\u0645\\u0644\\u0627\\u0626\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de pago puedo ofrecer a trav\\u00e9s de la pasarela de QRPay Pro?","answer":"QRPay Pro admite m\\u00faltiples m\\u00e9todos de pago, incluidos pagos con c\\u00f3digos QR, transferencias bancarias y opciones de billetera digital. Personalice sus m\\u00e9todos disponibles en la Configuraci\\u00f3n de la puerta de enlace para satisfacer las necesidades de sus clientes."},"fr":{"question":"Quelles m\\u00e9thodes de paiement puis-je proposer via la passerelle QRPay Pro\\u00a0?","answer":"QRPay Pro prend en charge plusieurs m\\u00e9thodes de paiement, notamment les paiements par code QR, les virements bancaires et les options de portefeuille num\\u00e9rique. Personnalisez vos m\\u00e9thodes disponibles dans les param\\u00e8tres de la passerelle pour r\\u00e9pondre aux besoins de vos clients."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0902 \\u092a\\u0947\\u0936 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"QRPay Pro \\u0915\\u0908 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 QR \\u0915\\u094b\\u0921 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928, \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0914\\u0930 \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u0949\\u0932\\u0947\\u091f \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964 \\u0905\\u092a\\u0928\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0940 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0928\\u0941\\u0915\\u0942\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724bab99f88e"},"6724bac43610b":{"language":{"en":{"question":"Can I view transaction details for payments made through the gateway?","answer":"Yes, QRPay Pro\\u2019s dashboard includes comprehensive transaction logs. You can track and review payment details, manage refunds, and analyze performance directly within the Gateway Settings."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u0627\\u0637\\u0644\\u0627\\u0639 \\u0639\\u0644\\u0649 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0644\\u0648\\u062d\\u0629 \\u062a\\u062d\\u0643\\u0645 QRPay Pro \\u0633\\u062c\\u0644\\u0627\\u062a \\u0634\\u0627\\u0645\\u0644\\u0629 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u062a\\u0628\\u0639 \\u0648\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0631\\u062f\\u0629 \\u0648\\u062a\\u062d\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0623\\u062f\\u0627\\u0621 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0636\\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0628\\u0648\\u0627\\u0628\\u0629."},"es":{"question":"\\u00bfPuedo ver los detalles de las transacciones de pagos realizados a trav\\u00e9s de la pasarela?","answer":"S\\u00ed, el panel de control de QRPay Pro incluye registros de transacciones completos. Puede realizar un seguimiento y revisar los detalles de pago, administrar reembolsos y analizar el rendimiento directamente en la Configuraci\\u00f3n de la puerta de enlace."},"fr":{"question":"Puis-je afficher les d\\u00e9tails des transactions pour les paiements effectu\\u00e9s via la passerelle\\u00a0?","answer":"Oui, le tableau de bord de QRPay Pro comprend des journaux de transactions complets. Vous pouvez suivre et consulter les d\\u00e9tails du paiement, g\\u00e9rer les remboursements et analyser les performances directement dans les param\\u00e8tres de la passerelle."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0915\\u093f\\u090f \\u0917\\u090f \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901, QRPay Pro \\u0915\\u0947 \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u092e\\u0947\\u0902 \\u0935\\u094d\\u092f\\u093e\\u092a\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0932\\u0949\\u0917 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964 \\u0906\\u092a \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0935\\u0930\\u0923\\u094b\\u0902 \\u0915\\u094b \\u091f\\u094d\\u0930\\u0948\\u0915 \\u0914\\u0930 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0930\\u093f\\u092b\\u0902\\u0921 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0938\\u0940\\u0927\\u0947 \\u0917\\u0947\\u091f\\u0935\\u0947 \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917\\u094d\\u0938 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u092a\\u094d\\u0930\\u0926\\u0930\\u094d\\u0936\\u0928 \\u0915\\u093e \\u0935\\u093f\\u0936\\u094d\\u0932\\u0947\\u0937\\u0923 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724bac43610b"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:25:13','updated_at' => '2024-11-06 18:02:52'),
            array('id' => '23','parent_id' => '23','type' => 'business','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About API Key Management","sub_heading":"Learn more about creating, using, and managing API keys with QRPay Pro"},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0648\\u0625\\u062f\\u0627\\u0631\\u062a\\u0647\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro"},"es":{"heading":"Preguntas frecuentes sobre la gesti\\u00f3n de claves API","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo crear, usar y administrar claves API con QRPay Pro"},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur la gestion des cl\\u00e9s API","sub_heading":"En savoir plus sur la cr\\u00e9ation, l\'utilisation et la gestion des cl\\u00e9s API avec QRPay Pro"},"hi":{"heading":"\\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay Pro \\u0915\\u0947 \\u0938\\u093e\\u0925 API \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u093e\\u0901 \\u092c\\u0928\\u093e\\u0928\\u0947, \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902"}},"items":{"6724bb707bf2a":{"language":{"en":{"question":"How do I securely store my QRPay Pro API keys?","answer":"Store your API keys in a secure environment, such as an encrypted server or a password manager, and avoid sharing keys with anyone. QRPay Pro also allows you to regenerate keys if you suspect any security risks."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u062e\\u0632\\u064a\\u0646 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d QRPay Pro API \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646\\u061f","answer":"\\u0642\\u0645 \\u0628\\u062a\\u062e\\u0632\\u064a\\u0646 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0641\\u064a \\u0628\\u064a\\u0626\\u0629 \\u0622\\u0645\\u0646\\u0629\\u060c \\u0645\\u062b\\u0644 \\u062e\\u0627\\u062f\\u0645 \\u0645\\u0634\\u0641\\u0631 \\u0623\\u0648 \\u0645\\u062f\\u064a\\u0631 \\u0643\\u0644\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u0648\\u0631\\u060c \\u0648\\u062a\\u062c\\u0646\\u0628 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0645\\u0641\\u0627\\u062a\\u064a\\u062d \\u0645\\u0639 \\u0623\\u064a \\u0634\\u062e\\u0635. \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 QRPay Pro \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0628\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0641\\u0627\\u062a\\u064a\\u062d \\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062a\\u0634\\u0643 \\u0641\\u064a \\u0648\\u062c\\u0648\\u062f \\u0623\\u064a \\u0645\\u062e\\u0627\\u0637\\u0631 \\u0623\\u0645\\u0646\\u064a\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo almaceno de forma segura mis claves API de QRPay Pro?","answer":"Guarde sus claves API en un entorno seguro, como un servidor cifrado o un administrador de contrase\\u00f1as, y evite compartir claves con nadie. QRPay Pro tambi\\u00e9n le permite regenerar claves si sospecha alg\\u00fan riesgo de seguridad."},"fr":{"question":"Comment stocker en toute s\\u00e9curit\\u00e9 mes cl\\u00e9s API QRPay Pro\\u00a0?","answer":"Stockez vos cl\\u00e9s API dans un environnement s\\u00e9curis\\u00e9, tel qu\'un serveur crypt\\u00e9 ou un gestionnaire de mots de passe, et \\u00e9vitez de partager vos cl\\u00e9s avec qui que ce soit. QRPay Pro vous permet \\u00e9galement de r\\u00e9g\\u00e9n\\u00e9rer les cl\\u00e9s si vous soup\\u00e7onnez des risques de s\\u00e9curit\\u00e9."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939\\u0940\\u0924 \\u0915\\u0930\\u0942\\u0902?","answer":"\\u0905\\u092a\\u0928\\u0940 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0935\\u093e\\u0924\\u093e\\u0935\\u0930\\u0923 \\u092e\\u0947\\u0902 \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939\\u0940\\u0924 \\u0915\\u0930\\u0947\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0938\\u0930\\u094d\\u0935\\u0930 \\u092f\\u093e \\u092a\\u093e\\u0938\\u0935\\u0930\\u094d\\u0921 \\u092e\\u0948\\u0928\\u0947\\u091c\\u0930, \\u0914\\u0930 \\u0915\\u093f\\u0938\\u0940 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u093e\\u0901 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092c\\u091a\\u0947\\u0902\\u0964 \\u092f\\u0926\\u093f \\u0906\\u092a\\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u091c\\u094b\\u0916\\u093f\\u092e \\u0915\\u093e \\u0938\\u0902\\u0926\\u0947\\u0939 \\u0939\\u0948 \\u0924\\u094b QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u092a\\u0915\\u094b \\u091a\\u093e\\u092c\\u093f\\u092f\\u093e\\u0901 \\u092a\\u0941\\u0928: \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u092d\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724bb707bf2a"},"6724bb7b309e9":{"language":{"en":{"question":"Can I create multiple API keys for different uses?","answer":"Yes, QRPay Pro allows you to generate multiple API keys with specific permissions for each, so you can control access based on usage, team members, or integration needs."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062a\\u064a\\u062d \\u0644\\u0643 QRPay Pro \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0628\\u0623\\u0630\\u0648\\u0646\\u0627\\u062a \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0644\\u0643\\u0644 \\u0645\\u0646\\u0647\\u0627\\u060c \\u062d\\u062a\\u0649 \\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0623\\u0648 \\u0623\\u0639\\u0636\\u0627\\u0621 \\u0627\\u0644\\u0641\\u0631\\u064a\\u0642 \\u0623\\u0648 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062a\\u0643\\u0627\\u0645\\u0644."},"es":{"question":"\\u00bfPuedo crear varias claves API para diferentes usos?","answer":"S\\u00ed, QRPay Pro te permite generar m\\u00faltiples claves API con permisos espec\\u00edficos para cada una, para que puedas controlar el acceso seg\\u00fan el uso, los miembros del equipo o las necesidades de integraci\\u00f3n."},"fr":{"question":"Puis-je cr\\u00e9er plusieurs cl\\u00e9s API pour diff\\u00e9rentes utilisations\\u00a0?","answer":"Oui, QRPay Pro vous permet de g\\u00e9n\\u00e9rer plusieurs cl\\u00e9s API avec des autorisations sp\\u00e9cifiques pour chacune, afin que vous puissiez contr\\u00f4ler l\'acc\\u00e8s en fonction de l\'utilisation, des membres de l\'\\u00e9quipe ou des besoins d\'int\\u00e9gration."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915\\u093e\\u0927\\u093f\\u0915 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u093e\\u0901 \\u092c\\u0928\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u092a\\u0915\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u0908 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u0924\\u093e\\u0915\\u093f \\u0906\\u092a \\u0909\\u092a\\u092f\\u094b\\u0917, \\u091f\\u0940\\u092e \\u0915\\u0947 \\u0938\\u0926\\u0938\\u094d\\u092f\\u094b\\u0902 \\u092f\\u093e \\u090f\\u0915\\u0940\\u0915\\u0930\\u0923 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092a\\u0939\\u0941\\u0902\\u091a \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0964"}},"id":"6724bb7b309e9"},"6724bb84d207e":{"language":{"en":{"question":"What should I do if my API key is compromised?","answer":"If your API key is compromised, immediately revoke it through the QRPay Pro dashboard and generate a new key. QRPay Pro\\u2019s secure dashboard allows for easy key management to protect your platform."},"ar":{"question":"\\u0645\\u0627\\u0630\\u0627 \\u0639\\u0644\\u064a \\u0623\\u0646 \\u0623\\u0641\\u0639\\u0644 \\u0625\\u0630\\u0627 \\u062a\\u0645 \\u0627\\u062e\\u062a\\u0631\\u0627\\u0642 \\u0645\\u0641\\u062a\\u0627\\u062d API \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0625\\u0630\\u0627 \\u062a\\u0645 \\u0627\\u062e\\u062a\\u0631\\u0627\\u0642 \\u0645\\u0641\\u062a\\u0627\\u062d API \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643\\u060c \\u0641\\u0642\\u0645 \\u0628\\u0625\\u0644\\u063a\\u0627\\u0626\\u0647 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0644\\u0648\\u062d\\u0629 \\u062a\\u062d\\u0643\\u0645 QRPay Pro \\u0648\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0645\\u0641\\u062a\\u0627\\u062d \\u062c\\u062f\\u064a\\u062f. \\u062a\\u0633\\u0645\\u062d \\u0644\\u0648\\u062d\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0644\\u0640 QRPay Pro \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0641\\u0627\\u062a\\u064a\\u062d \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 debo hacer si mi clave API est\\u00e1 comprometida?","answer":"Si su clave API est\\u00e1 comprometida, revoquela inmediatamente a trav\\u00e9s del panel de QRPay Pro y genere una nueva clave. El panel seguro de QRPay Pro permite una f\\u00e1cil administraci\\u00f3n de claves para proteger su plataforma."},"fr":{"question":"Que dois-je faire si ma cl\\u00e9 API est compromise\\u00a0?","answer":"Si votre cl\\u00e9 API est compromise, r\\u00e9voquez-la imm\\u00e9diatement via le tableau de bord QRPay Pro et g\\u00e9n\\u00e9rez une nouvelle cl\\u00e9. Le tableau de bord s\\u00e9curis\\u00e9 de QRPay Pro permet une gestion facile des cl\\u00e9s pour prot\\u00e9ger votre plateforme."},"hi":{"question":"\\u092f\\u0926\\u093f \\u092e\\u0947\\u0930\\u0940 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0938\\u0947 \\u091b\\u0947\\u0921\\u093c\\u091b\\u093e\\u0921\\u093c \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0924\\u094b \\u092e\\u0941\\u091d\\u0947 \\u0915\\u094d\\u092f\\u093e \\u0915\\u0930\\u0928\\u093e \\u091a\\u093e\\u0939\\u093f\\u090f?","answer":"\\u092f\\u0926\\u093f \\u0906\\u092a\\u0915\\u0940 \\u090f\\u092a\\u0940\\u0906\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0938\\u0947 \\u091b\\u0947\\u0921\\u093c\\u091b\\u093e\\u0921\\u093c \\u0915\\u0940 \\u0917\\u0908 \\u0939\\u0948, \\u0924\\u094b \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0907\\u0938\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0930\\u0926\\u094d\\u0926 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0928\\u0908 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964 QRPay Pro \\u0915\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0921\\u0948\\u0936\\u092c\\u094b\\u0930\\u094d\\u0921 \\u0906\\u092a\\u0915\\u0947 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0938\\u093e\\u0928 \\u0915\\u0941\\u0902\\u091c\\u0940 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724bb84d207e"},"6724bb8cc3c1a":{"language":{"en":{"question":"Do API keys in QRPay Pro have an expiration date?","answer":"No, QRPay Pro API keys do not expire by default. However, you can manually revoke and regenerate them whenever needed to maintain the highest security standards."},"ar":{"question":"\\u0647\\u0644 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d API \\u0641\\u064a QRPay Pro \\u0644\\u0647\\u0627 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0635\\u0644\\u0627\\u062d\\u064a\\u0629\\u061f","answer":"\\u0644\\u0627\\u060c \\u0644\\u0627 \\u062a\\u0646\\u062a\\u0647\\u064a \\u0635\\u0644\\u0627\\u062d\\u064a\\u0629 \\u0645\\u0641\\u0627\\u062a\\u064a\\u062d QRPay Pro API \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u064b\\u0627. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0644\\u063a\\u0627\\u0621\\u0647\\u0627 \\u0648\\u0625\\u0639\\u0627\\u062f\\u0629 \\u0625\\u0646\\u0634\\u0627\\u0626\\u0647\\u0627 \\u064a\\u062f\\u0648\\u064a\\u064b\\u0627 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062d\\u0627\\u062c\\u0629 \\u0644\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646."},"es":{"question":"\\u00bfLas claves API en QRPay Pro tienen fecha de vencimiento?","answer":"No, las claves API de QRPay Pro no caducan de forma predeterminada. Sin embargo, puede revocarlos y regenerarlos manualmente cuando sea necesario para mantener los m\\u00e1s altos est\\u00e1ndares de seguridad."},"fr":{"question":"Les cl\\u00e9s API dans QRPay Pro ont-elles une date d\'expiration ?","answer":"Non, les cl\\u00e9s API QRPay Pro n\'expirent pas par d\\u00e9faut. Cependant, vous pouvez les r\\u00e9voquer et les r\\u00e9g\\u00e9n\\u00e9rer manuellement chaque fois que n\\u00e9cessaire pour maintenir les normes de s\\u00e9curit\\u00e9 les plus \\u00e9lev\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e QRPay Pro \\u092e\\u0947\\u0902 API \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0938\\u092e\\u093e\\u092a\\u094d\\u0924\\u093f \\u0924\\u093f\\u0925\\u093f \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948?","answer":"\\u0928\\u0939\\u0940\\u0902, QRPay Pro API \\u0915\\u0941\\u0902\\u091c\\u093f\\u092f\\u093e\\u0901 \\u0921\\u093f\\u092b\\u093c\\u0949\\u0932\\u094d\\u091f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u092e\\u093e\\u092a\\u094d\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u091c\\u092c \\u092d\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b \\u0906\\u092a \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u092e\\u0948\\u0928\\u094d\\u092f\\u0941\\u0905\\u0932 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0930\\u0926\\u094d\\u0926 \\u0914\\u0930 \\u092a\\u0941\\u0928: \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724bb8cc3c1a"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:28:38','updated_at' => '2024-11-07 10:36:29'),
            array('id' => '24','parent_id' => '24','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Receiving Money as an Agent","sub_heading":"Find answers to common questions on receiving funds through QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0643\\u0648\\u0643\\u064a\\u0644","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre recibir dinero como agente","sub_heading":"Encuentre respuestas a preguntas comunes sobre c\\u00f3mo recibir fondos a trav\\u00e9s de QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur la r\\u00e9ception d\'argent en tant qu\'agent","sub_heading":"Trouvez des r\\u00e9ponses aux questions courantes sur la r\\u00e9ception de fonds via QRPay Pro."},"hi":{"heading":"\\u090f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092a\\u0930 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724bdc8cae48":{"language":{"en":{"question":"How can I provide my account details to the sender?","answer":"You can easily share your unique QRPay Pro QR code or account ID, allowing the sender to initiate a quick and secure transfer directly to your account."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u0642\\u062f\\u064a\\u0645 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628\\u064a \\u0644\\u0644\\u0645\\u0631\\u0633\\u0644\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0631\\u0645\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062c\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0633\\u0631\\u064a\\u0639\\u0629 QRPay Pro \\u0623\\u0648 \\u0645\\u0639\\u0631\\u0641 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0644\\u0645\\u0631\\u0633\\u0644 \\u0628\\u0628\\u062f\\u0621 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0633\\u0631\\u064a\\u0639 \\u0648\\u0622\\u0645\\u0646 \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643."},"es":{"question":"\\u00bfC\\u00f3mo puedo proporcionar los detalles de mi cuenta al remitente?","answer":"Puede compartir f\\u00e1cilmente su c\\u00f3digo QR exclusivo de QRPay Pro o su ID de cuenta, lo que permite al remitente iniciar una transferencia r\\u00e1pida y segura directamente a su cuenta."},"fr":{"question":"Comment puis-je fournir les d\\u00e9tails de mon compte \\u00e0 l\'exp\\u00e9diteur\\u00a0?","answer":"Vous pouvez facilement partager votre code QR QRPay Pro unique ou votre identifiant de compte, permettant \\u00e0 l\'exp\\u00e9diteur d\'initier un transfert rapide et s\\u00e9curis\\u00e9 directement vers votre compte."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0915 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0906\\u092a \\u0906\\u0938\\u093e\\u0928\\u0940 \\u0938\\u0947 \\u0905\\u092a\\u0928\\u093e \\u0905\\u0926\\u094d\\u0935\\u093f\\u0924\\u0940\\u092f QRPay \\u092a\\u094d\\u0930\\u094b QR \\u0915\\u094b\\u0921 \\u092f\\u093e \\u0916\\u093e\\u0924\\u093e \\u0906\\u0908\\u0921\\u0940 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0915 \\u0938\\u0940\\u0927\\u0947 \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0935\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724bdc8cae48"},"6724bdd20b54c":{"language":{"en":{"question":"Can I receive funds in multiple currencies?","answer":"Yes, QRPay Pro supports multi-currency transactions, allowing you to receive payments in various currencies. The platform will handle the conversion based on current exchange rates."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0628\\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629. \\u0633\\u062a\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0627\\u0644\\u062d\\u0627\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfPuedo recibir fondos en varias monedas?","answer":"S\\u00ed, QRPay Pro admite transacciones multidivisa, lo que le permite recibir pagos en varias monedas. La plataforma manejar\\u00e1 la conversi\\u00f3n en funci\\u00f3n de los tipos de cambio actuales."},"fr":{"question":"Puis-je recevoir des fonds dans plusieurs devises ?","answer":"Oui, QRPay Pro prend en charge les transactions multidevises, vous permettant de recevoir des paiements dans diff\\u00e9rentes devises. La plateforme g\\u00e9rera la conversion en fonction des taux de change actuels."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u091d\\u0947 \\u0905\\u0928\\u0947\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, QRPay \\u092a\\u094d\\u0930\\u094b \\u092c\\u0939\\u0941-\\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0906\\u092a \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0935\\u0930\\u094d\\u0924\\u092e\\u093e\\u0928 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932\\u0947\\u0917\\u093e\\u0964"}},"id":"6724bdd20b54c"},"6724bddc1a1e7":{"language":{"en":{"question":"Will I be notified when a payment is received?","answer":"Absolutely. QRPay Pro sends instant notifications when a transfer is complete, so you can verify incoming funds in real time."},"ar":{"question":"\\u0647\\u0644 \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0639\\u0644\\u0627\\u0645\\u064a \\u0639\\u0646\\u062f \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0629\\u061f","answer":"\\u0642\\u0637\\u0639\\u0627\\u064b. \\u064a\\u0631\\u0633\\u0644 QRPay Pro \\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0641\\u0648\\u0631\\u064a\\u0629 \\u0639\\u0646\\u062f \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0642\\u0644\\u060c \\u062d\\u062a\\u0649 \\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0627\\u0631\\u062f\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a."},"es":{"question":"\\u00bfMe notificar\\u00e1n cuando se reciba un pago?","answer":"Absolutamente. QRPay Pro env\\u00eda notificaciones instant\\u00e1neas cuando se completa una transferencia, para que puedas verificar los fondos entrantes en tiempo real."},"fr":{"question":"Serai-je averti lorsqu\'un paiement sera re\\u00e7u\\u00a0?","answer":"Absolument. QRPay Pro envoie des notifications instantan\\u00e9es lorsqu\'un transfert est termin\\u00e9, afin que vous puissiez v\\u00e9rifier les fonds entrants en temps r\\u00e9el."},"hi":{"question":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u092a\\u0930 \\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u091d\\u0947 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e?","answer":"\\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932\\u0964 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0942\\u0930\\u093e \\u0939\\u094b\\u0928\\u0947 \\u092a\\u0930 QRPay Pro \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0942\\u091a\\u0928\\u093e\\u090f\\u0902 \\u092d\\u0947\\u091c\\u0924\\u093e \\u0939\\u0948, \\u0924\\u093e\\u0915\\u093f \\u0906\\u092a \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u092e\\u0947\\u0902 \\u0906\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092b\\u0902\\u0921 \\u0915\\u094b \\u0938\\u0924\\u094d\\u092f\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0964"}},"id":"6724bddc1a1e7"},"6724bde6b81b2":{"language":{"en":{"question":"Is there a fee for receiving funds as an agent?","answer":"Transaction fees may vary based on the currency and type of transfer. Check the QRPay Pro fee schedule in your account for detailed information."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0643\\u0648\\u0643\\u064a\\u0644\\u061f","answer":"\\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u062c\\u062f\\u0648\\u0644 \\u0631\\u0633\\u0648\\u0645 QRPay Pro \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0641\\u0635\\u0644\\u0629."},"es":{"question":"\\u00bfSe aplica una tarifa por recibir fondos como agente?","answer":"Las tarifas de transacci\\u00f3n pueden variar seg\\u00fan la moneda y el tipo de transferencia. Consulte el programa de tarifas de QRPay Pro en su cuenta para obtener informaci\\u00f3n detallada."},"fr":{"question":"Y a-t-il des frais pour recevoir des fonds en tant qu\'agent ?","answer":"Les frais de transaction peuvent varier en fonction de la devise et du type de transfert. Consultez le bar\\u00e8me des frais QRPay Pro dans votre compte pour des informations d\\u00e9taill\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0927\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0914\\u0930 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0905\\u0928\\u0941\\u0938\\u0942\\u091a\\u0940 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724bde6b81b2"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:38:37','updated_at' => '2024-11-06 16:19:28'),
            array('id' => '25','parent_id' => '25','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Common Questions About Exchanging Money on QRPay Pro","sub_heading":"Find out more about currency exchange features for agents on QRPay Pro."},"ar":{"heading":"\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u0645\\u064a\\u0632\\u0627\\u062a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas comunes sobre el intercambio de dinero en QRPay Pro","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre las funciones de cambio de moneda para agentes en QRPay Pro."},"fr":{"heading":"Questions courantes sur l\'\\u00e9change d\'argent sur QRPay Pro","sub_heading":"Apprenez-en davantage sur les fonctionnalit\\u00e9s de change pour les agents sur QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0947 \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724be8e0fec3":{"language":{"en":{"question":"How do I start a currency exchange in my QRPay Pro account?","answer":"To begin an exchange, simply select the currency you currently hold and the currency you wish to receive. QRPay Pro will guide you through the rest of the process."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0628\\u062f\\u0623 \\u0641\\u064a \\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0644\\u0628\\u062f\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0628\\u0627\\u062f\\u0644\\u060c \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a\\u0644\\u0643\\u0647\\u0627 \\u062d\\u0627\\u0644\\u064a\\u064b\\u0627 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u062a\\u0644\\u0642\\u064a\\u0647\\u0627. \\u0633\\u064a\\u0631\\u0634\\u062f\\u0643 QRPay Pro \\u062e\\u0644\\u0627\\u0644 \\u0628\\u0642\\u064a\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo inicio un cambio de moneda en mi cuenta QRPay Pro?","answer":"Para comenzar un intercambio, simplemente seleccione la moneda que posee actualmente y la moneda que desea recibir. QRPay Pro te guiar\\u00e1 por el resto del proceso."},"fr":{"question":"Comment d\\u00e9marrer un \\u00e9change de devises sur mon compte QRPay Pro\\u00a0?","answer":"Pour commencer un \\u00e9change, s\\u00e9lectionnez simplement la devise que vous d\\u00e9tenez actuellement et la devise que vous souhaitez recevoir. QRPay Pro vous guidera tout au long du processus."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0948\\u0938\\u0947 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0942\\u0902?","answer":"\\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u092c\\u0938 \\u0935\\u0939 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091a\\u0941\\u0928\\u0947\\u0902 \\u091c\\u094b \\u0906\\u092a\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0935\\u0930\\u094d\\u0924\\u092e\\u093e\\u0928 \\u092e\\u0947\\u0902 \\u0939\\u0948 \\u0914\\u0930 \\u0935\\u0939 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091c\\u093f\\u0938\\u0947 \\u0906\\u092a \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u093e \\u091a\\u093e\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 QRPay Pro \\u092c\\u093e\\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0906\\u092a\\u0915\\u093e \\u092e\\u093e\\u0930\\u094d\\u0917\\u0926\\u0930\\u094d\\u0936\\u0928 \\u0915\\u0930\\u0947\\u0917\\u093e\\u0964"}},"id":"6724be8e0fec3"},"6724be9c949ab":{"language":{"en":{"question":"Are there fees associated with currency exchange?","answer":"Yes, QRPay Pro applies a nominal fee for currency exchanges, which varies depending on the currencies involved. You can view the exact fee before confirming the transaction."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0635\\u0631\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u064a\\u0637\\u0628\\u0642 QRPay Pro \\u0631\\u0633\\u0648\\u0645\\u064b\\u0627 \\u0631\\u0645\\u0632\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0628\\u0627\\u062e\\u062a\\u0644\\u0627\\u0641 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u062f\\u0642\\u064a\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfExisten tarifas asociadas con el cambio de moneda?","answer":"S\\u00ed, QRPay Pro aplica una tarifa nominal por los cambios de divisas, que var\\u00eda seg\\u00fan las monedas involucradas. Puede ver la tarifa exacta antes de confirmar la transacci\\u00f3n."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s au change de devises ?","answer":"Oui, QRPay Pro applique des frais nominaux pour les \\u00e9changes de devises, qui varient en fonction des devises impliqu\\u00e9es. Vous pouvez consulter les frais exacts avant de confirmer la transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u091c\\u0941\\u0921\\u093c\\u093e \\u0939\\u0941\\u0906 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, QRPay Pro \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092e\\u093e\\u092e\\u0942\\u0932\\u0940 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0938\\u091f\\u0940\\u0915 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724be9c949ab"},"6724bea5c68f8":{"language":{"en":{"question":"Can I see the exchange rate before confirming the transaction?","answer":"Absolutely. QRPay Pro provides real-time exchange rates, so you can review the conversion details before completing your transaction."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0631\\u0624\\u064a\\u0629 \\u0633\\u0639\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u061f","answer":"\\u0642\\u0637\\u0639\\u0627\\u064b. \\u064a\\u0648\\u0641\\u0631 QRPay Pro \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0631\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u060c \\u062d\\u062a\\u0649 \\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0642\\u0628\\u0644 \\u0625\\u0643\\u0645\\u0627\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643."},"es":{"question":"\\u00bfPuedo ver el tipo de cambio antes de confirmar la transacci\\u00f3n?","answer":"Absolutamente. QRPay Pro proporciona tipos de cambio en tiempo real, para que pueda revisar los detalles de la conversi\\u00f3n antes de completar su transacci\\u00f3n."},"fr":{"question":"Puis-je voir le taux de change avant de confirmer la transaction ?","answer":"Absolument. QRPay Pro fournit des taux de change en temps r\\u00e9el, vous permettant ainsi de consulter les d\\u00e9tails de la conversion avant de finaliser votre transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932\\u0964 QRPay \\u092a\\u094d\\u0930\\u094b \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0926\\u0930\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0924\\u093e\\u0915\\u093f \\u0906\\u092a \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0964"}},"id":"6724bea5c68f8"},"6724beae85a60":{"language":{"en":{"question":"Is there a limit to the amount I can exchange at one time?","answer":"There may be limits based on your account type and transaction history. Refer to your QRPay Pro account settings or contact support to understand any specific limits that may apply."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f \\u0644\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u0644\\u0647 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0631\\u0629 \\u0627\\u0644\\u0648\\u0627\\u062d\\u062f\\u0629\\u061f","answer":"\\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0633\\u062c\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a. \\u0627\\u0631\\u062c\\u0639 \\u0625\\u0644\\u0649 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0623\\u0648 \\u0627\\u062a\\u0635\\u0644 \\u0628\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0644\\u0641\\u0647\\u0645 \\u0623\\u064a \\u062d\\u062f\\u0648\\u062f \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642\\u0647\\u0627."},"es":{"question":"\\u00bfExiste un l\\u00edmite en la cantidad que puedo cambiar a la vez?","answer":"Puede haber l\\u00edmites seg\\u00fan su tipo de cuenta e historial de transacciones. Consulte la configuraci\\u00f3n de su cuenta QRPay Pro o comun\\u00edquese con el soporte para comprender los l\\u00edmites espec\\u00edficos que pueden aplicarse."},"fr":{"question":"Y a-t-il une limite au montant que je peux \\u00e9changer en une seule fois ?","answer":"Il peut y avoir des limites en fonction de votre type de compte et de votre historique de transactions. Reportez-vous aux param\\u00e8tres de votre compte QRPay Pro ou contactez l\'assistance pour comprendre les limites sp\\u00e9cifiques qui peuvent s\'appliquer."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0947\\u0930\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u090f\\u0915 \\u0938\\u092e\\u092f \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0930\\u093e\\u0936\\u093f \\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0939\\u0948?","answer":"\\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0901 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e \\u0915\\u094b \\u0938\\u092e\\u091d\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u0926\\u0947\\u0916\\u0947\\u0902 \\u092f\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0938\\u0947 \\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724beae85a60"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:41:55','updated_at' => '2024-11-06 15:45:14'),
            array('id' => '26','parent_id' => '26','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Adding Money on QRPay Pro","sub_heading":"Learn more about funding your account as an agent on QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u062d\\u0648\\u0644 \\u062a\\u0645\\u0648\\u064a\\u0644 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0643\\u0648\\u0643\\u064a\\u0644 \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre c\\u00f3mo agregar dinero en QRPay Pro","sub_heading":"Obtenga m\\u00e1s informaci\\u00f3n sobre c\\u00f3mo financiar su cuenta como agente en QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur l\'ajout d\'argent sur QRPay Pro","sub_heading":"Apprenez-en davantage sur l\'approvisionnement de votre compte en tant qu\'agent sur QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay Pro \\u092a\\u0930 \\u090f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u091c\\u092e\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0914\\u0930 \\u091c\\u093e\\u0928\\u0947\\u0902\\u0964"}},"items":{"6724bf77d41f0":{"language":{"en":{"question":"What methods can I use to add money to my QRPay Pro account?","answer":"You can add money using various methods such as bank transfers, credit\\/debit cards, and other supported payment options available within the QRPay Pro platform."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0637\\u0631\\u0642 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0637\\u0631\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u062b\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0648\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\/\\u0627\\u0644\\u062e\\u0635\\u0645 \\u0648\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0631\\u0629 \\u0636\\u0645\\u0646 \\u0645\\u0646\\u0635\\u0629 QRPay Pro."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos puedo utilizar para agregar dinero a mi cuenta QRPay Pro?","answer":"Puede agregar dinero utilizando varios m\\u00e9todos, como transferencias bancarias, tarjetas de cr\\u00e9dito\\/d\\u00e9bito y otras opciones de pago admitidas disponibles dentro de la plataforma QRPay Pro."},"fr":{"question":"Quelles m\\u00e9thodes puis-je utiliser pour ajouter de l\'argent sur mon compte QRPay Pro\\u00a0?","answer":"Vous pouvez ajouter de l\'argent en utilisant diverses m\\u00e9thodes telles que les virements bancaires, les cartes de cr\\u00e9dit\\/d\\u00e9bit et d\'autres options de paiement prises en charge disponibles sur la plateforme QRPay Pro."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093f\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0906\\u092a QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923, \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f\\/\\u0921\\u0947\\u092c\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724bf77d41f0"},"6724bf7fe857d":{"language":{"en":{"question":"Are there any fees associated with adding money?","answer":"Yes, there may be transaction fees depending on the funding method you choose. You will be informed of any applicable fees before confirming your transaction."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0627\\u0631\\u0647\\u0627. \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0628\\u0644\\u0627\\u063a\\u0643 \\u0628\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0637\\u0628\\u0642\\u0629 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643."},"es":{"question":"\\u00bfHay alguna tarifa asociada con agregar dinero?","answer":"S\\u00ed, es posible que se apliquen tarifas de transacci\\u00f3n seg\\u00fan el m\\u00e9todo de financiaci\\u00f3n que elija. Se le informar\\u00e1 de las tarifas aplicables antes de confirmar su transacci\\u00f3n."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s \\u00e0 l\\u2019ajout d\\u2019argent\\u00a0?","answer":"Oui, des frais de transaction peuvent s\'appliquer selon la m\\u00e9thode de financement que vous choisissez. Vous serez inform\\u00e9 des frais applicables avant de confirmer votre transaction."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u092b\\u0902\\u0921\\u093f\\u0902\\u0917 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a\\u0915\\u0947 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0906\\u092a\\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"6724bf7fe857d"},"6724bf8a1f02a":{"language":{"en":{"question":"How long does it take for the funds to be available in my account?","answer":"Typically, funds added through bank transfers may take a few hours to reflect in your account, while credit\\/debit card transactions are usually processed instantly."},"ar":{"question":"\\u0645\\u0627 \\u0627\\u0644\\u0645\\u062f\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642\\u0647\\u0627 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u062d\\u062a\\u0649 \\u062a\\u0635\\u0628\\u062d \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u064a\\u061f","answer":"\\u0639\\u0627\\u062f\\u0629\\u064b\\u060c \\u0642\\u062f \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0636\\u0627\\u0641\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0628\\u0636\\u0639 \\u0633\\u0627\\u0639\\u0627\\u062a \\u0644\\u062a\\u0638\\u0647\\u0631 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0628\\u064a\\u0646\\u0645\\u0627 \\u062a\\u062a\\u0645 \\u0639\\u0627\\u062f\\u0629\\u064b \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\/\\u0627\\u0644\\u062e\\u0635\\u0645 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo tardan los fondos en estar disponibles en mi cuenta?","answer":"Por lo general, los fondos agregados mediante transferencias bancarias pueden tardar algunas horas en reflejarse en su cuenta, mientras que las transacciones con tarjeta de cr\\u00e9dito\\/d\\u00e9bito generalmente se procesan instant\\u00e1neamente."},"fr":{"question":"Combien de temps faut-il pour que les fonds soient disponibles sur mon compte ?","answer":"En r\\u00e8gle g\\u00e9n\\u00e9rale, les fonds ajout\\u00e9s via les virements bancaires peuvent prendre quelques heures pour \\u00eatre refl\\u00e9t\\u00e9s sur votre compte, tandis que les transactions par carte de cr\\u00e9dit\\/d\\u00e9bit sont g\\u00e9n\\u00e9ralement trait\\u00e9es instantan\\u00e9ment."},"hi":{"question":"\\u092e\\u0947\\u0930\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u094b\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0947\\u0917\\u093e?","answer":"\\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930, \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c\\u0947 \\u0917\\u090f \\u0927\\u0928 \\u0915\\u094b \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092c\\u093f\\u0902\\u092c\\u093f\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u0941\\u091b \\u0918\\u0902\\u091f\\u0947 \\u0932\\u0917 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u092c\\u0915\\u093f \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f\\/\\u0921\\u0947\\u092c\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724bf8a1f02a"},"6724bf92ac4e5":{"language":{"en":{"question":"Is there a limit on how much money I can add at one time?","answer":"Yes, there may be limits based on your account type and transaction history. Please check your QRPay Pro account settings or reach out to customer support for specific limit details."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f \\u0644\\u0639\\u062f\\u062f \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0636\\u0627\\u0641\\u062a\\u0647\\u0627 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0631\\u0629 \\u0627\\u0644\\u0648\\u0627\\u062d\\u062f\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0633\\u062c\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a. \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062d\\u062f \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f."},"es":{"question":"\\u00bfExiste un l\\u00edmite de cu\\u00e1nto dinero puedo agregar a la vez?","answer":"S\\u00ed, puede haber l\\u00edmites seg\\u00fan su tipo de cuenta e historial de transacciones. Verifique la configuraci\\u00f3n de su cuenta QRPay Pro o comun\\u00edquese con atenci\\u00f3n al cliente para obtener detalles de l\\u00edmites espec\\u00edficos."},"fr":{"question":"Y a-t-il une limite au montant d\\u2019argent que je peux ajouter en une seule fois\\u00a0?","answer":"Oui, il peut y avoir des limites en fonction de votre type de compte et de votre historique de transactions. Veuillez v\\u00e9rifier les param\\u00e8tres de votre compte QRPay Pro ou contacter le support client pour obtenir des d\\u00e9tails sp\\u00e9cifiques sur les limites."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u090f\\u0915 \\u092c\\u093e\\u0930 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u091c\\u094b\\u0921\\u093c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901 \\u0907\\u0938\\u0915\\u0940 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0902 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0943\\u092a\\u092f\\u093e \\u0905\\u092a\\u0928\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902 \\u092f\\u093e \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u0947 \\u0938\\u0902\\u092a\\u0930\\u094d\\u0915 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724bf92ac4e5"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:45:50','updated_at' => '2024-11-06 16:09:52'),
            array('id' => '27','parent_id' => '27','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Withdrawing Money on QRPay Pro","sub_heading":"Find answers to your queries regarding the withdrawal process as an agent on QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0643\\u0648\\u0643\\u064a\\u0644 \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre retirar dinero en QRPay Pro","sub_heading":"Encuentre respuestas a sus consultas sobre el proceso de retiro como agente en QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur le retrait d\'argent sur QRPay Pro","sub_heading":"Trouvez des r\\u00e9ponses \\u00e0 vos questions concernant le processus de retrait en tant qu\'agent sur QRPay Pro."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u090f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724c03924266":{"language":{"en":{"question":"How can I withdraw money from my QRPay Pro account?","answer":"To withdraw money, log in to your account, navigate to the \\u2018Withdraw Money\\u2019 section, enter the amount, select your withdrawal method, and confirm the transaction."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\"\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u062d\\u062f\\u062f \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo puedo retirar dinero de mi cuenta QRPay Pro?","answer":"Para retirar dinero, inicie sesi\\u00f3n en su cuenta, navegue hasta la secci\\u00f3n \\"Retirar dinero\\", ingrese el monto, seleccione su m\\u00e9todo de retiro y confirme la transacci\\u00f3n."},"fr":{"question":"Comment puis-je retirer de l\'argent de mon compte QRPay Pro ?","answer":"Pour retirer de l\'argent, connectez-vous \\u00e0 votre compte, acc\\u00e9dez \\u00e0 la section \\u00ab Retirer de l\'argent \\u00bb, saisissez le montant, s\\u00e9lectionnez votre m\\u00e9thode de retrait et confirmez la transaction."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0938\\u0947 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0947\\u0902\' \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\u0930\\u093e\\u0936\\u093f \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0905\\u092a\\u0928\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c03924266"},"6724c04656b40":{"language":{"en":{"question":"What withdrawal methods are available on QRPay Pro?","answer":"You can withdraw funds via bank transfer and other supported methods available in the withdrawal section of your QRPay Pro account."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0631\\u0629 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a \\u0648\\u0627\\u0644\\u0637\\u0631\\u0642 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0641\\u064a \\u0642\\u0633\\u0645 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de retiro est\\u00e1n disponibles en QRPay Pro?","answer":"Puede retirar fondos mediante transferencia bancaria y otros m\\u00e9todos admitidos disponibles en la secci\\u00f3n de retiro de su cuenta QRPay Pro."},"fr":{"question":"Quelles m\\u00e9thodes de retrait sont disponibles sur QRPay Pro ?","answer":"Vous pouvez retirer des fonds par virement bancaire et d\'autres m\\u00e9thodes prises en charge disponibles dans la section retrait de votre compte QRPay Pro."},"hi":{"question":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948\\u0902?","answer":"\\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724c04656b40"},"6724c051c2e7a":{"language":{"en":{"question":"Are there any fees associated with withdrawing money?","answer":"Yes, there may be transaction fees depending on the withdrawal method you choose. The fees will be displayed before you confirm your withdrawal."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u062a\\u0627\\u0631\\u0647\\u0627. \\u0633\\u064a\\u062a\\u0645 \\u0639\\u0631\\u0636 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0642\\u0628\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0633\\u062d\\u0628."},"es":{"question":"\\u00bfExiste alguna tarifa asociada con el retiro de dinero?","answer":"S\\u00ed, puede haber tarifas de transacci\\u00f3n seg\\u00fan el m\\u00e9todo de retiro que elija. Las tarifas se mostrar\\u00e1n antes de que confirme su retiro."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s au retrait d\\u2019argent ?","answer":"Oui, des frais de transaction peuvent s\'appliquer selon la m\\u00e9thode de retrait que vous choisissez. Les frais seront affich\\u00e9s avant que vous confirmiez votre retrait."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u0948\\u0938\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u091a\\u0941\\u0928\\u0940 \\u0917\\u0908 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0906\\u092a\\u0915\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u092a\\u094d\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e\\u0964"}},"id":"6724c051c2e7a"},"6724c05ceb7b1":{"language":{"en":{"question":"How long does it take for my withdrawal request to be processed?","answer":"Withdrawal processing times may vary based on the method selected. Generally, bank transfers may take 1-3 business days to complete, while other methods may be faster."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0637\\u0631\\u0642 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0631\\u0629 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0633\\u062d\\u0628 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a \\u0648\\u0627\\u0644\\u0637\\u0631\\u0642 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0641\\u064a \\u0642\\u0633\\u0645 \\u0627\\u0644\\u0633\\u062d\\u0628 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 m\\u00e9todos de retiro est\\u00e1n disponibles en QRPay Pro?","answer":"Puede retirar fondos mediante transferencia bancaria y otros m\\u00e9todos admitidos disponibles en la secci\\u00f3n de retiro de su cuenta QRPay Pro."},"fr":{"question":"Quelles m\\u00e9thodes de retrait sont disponibles sur QRPay Pro ?","answer":"Vous pouvez retirer des fonds par virement bancaire et d\'autres m\\u00e9thodes prises en charge disponibles dans la section retrait de votre compte QRPay Pro."},"hi":{"question":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948\\u0902?","answer":"\\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u0928\\u093f\\u0915\\u093e\\u0938\\u0940 \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u092c\\u0948\\u0902\\u0915 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0915\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724c05ceb7b1"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:49:03','updated_at' => '2024-11-06 16:35:43'),
            array('id' => '28','parent_id' => '28','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Sending Money as an Agent on QRPay Pro","sub_heading":"Find answers to common queries about the agent-to-agent money transfer process on QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0643\\u0648\\u0643\\u064a\\u0644 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u0646 \\u0648\\u0643\\u064a\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre el env\\u00edo de dinero como agente en QRPay Pro","sub_heading":"Encuentre respuestas a consultas comunes sobre el proceso de transferencia de dinero de agente a agente en QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quemment pos\\u00e9es sur l\'envoi d\'argent en tant qu\'agent sur QRPay Pro","sub_heading":"Trouvez des r\\u00e9ponses aux questions courantes sur le processus de transfert d\'argent d\'agent \\u00e0 agent sur QRPay Pro."},"hi":{"heading":"QRPay Pro \\u092a\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f-\\u091f\\u0942-\\u090f\\u091c\\u0947\\u0902\\u091f \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724c1d0cda27":{"language":{"en":{"question":"How do I send money to another agent on QRPay Pro?","answer":"To send money, log in to your account, navigate to the \\u2018Send Money\\u2019 section, enter the recipient agent\\u2019s details, specify the amount, review the transaction, and confirm to complete the transfer."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 \\u0622\\u062e\\u0631 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\"\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u060c \\u0648\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0648\\u0623\\u0643\\u062f \\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo env\\u00edo dinero a otro agente en QRPay Pro?","answer":"Para enviar dinero, inicie sesi\\u00f3n en su cuenta, navegue hasta la secci\\u00f3n \\"Enviar dinero\\", ingrese los detalles del agente destinatario, especifique el monto, revise la transacci\\u00f3n y confirme para completar la transferencia."},"fr":{"question":"Comment envoyer de l\'argent \\u00e0 un autre agent sur QRPay Pro ?","answer":"Pour envoyer de l\'argent, connectez-vous \\u00e0 votre compte, acc\\u00e9dez \\u00e0 la section \\u00ab Envoyer de l\'argent \\u00bb, saisissez les coordonn\\u00e9es de l\'agent destinataire, sp\\u00e9cifiez le montant, examinez la transaction et confirmez pour terminer le transfert."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u092a\\u0930 \\u0915\\u093f\\u0938\\u0940 \\u0905\\u0928\\u094d\\u092f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0942\\u0902?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0947\\u0902\' \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902, \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c1d0cda27"},"6724c1d930155":{"language":{"en":{"question":"Can I send money to users outside of the agent network?","answer":"No, money transfers using the Send Money feature are strictly for agent-to-agent transactions within QRPay Pro."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u062e\\u0627\\u0631\\u062c \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621\\u061f","answer":"\\u0644\\u0627\\u060c \\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0645\\u062e\\u0635\\u0635\\u0629 \\u0641\\u0642\\u0637 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0646 \\u0648\\u0643\\u064a\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 \\u062f\\u0627\\u062e\\u0644 QRPay Pro."},"es":{"question":"\\u00bfPuedo enviar dinero a usuarios fuera de la red de agentes?","answer":"No, las transferencias de dinero que utilizan la funci\\u00f3n Enviar dinero son estrictamente para transacciones de agente a agente dentro de QRPay Pro."},"fr":{"question":"Puis-je envoyer de l\'argent \\u00e0 des utilisateurs en dehors du r\\u00e9seau d\'agents\\u00a0?","answer":"Non, les transferts d\'argent utilisant la fonction Envoyer de l\'argent sont strictement destin\\u00e9s aux transactions d\'agent \\u00e0 agent au sein de QRPay Pro."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0939\\u0930 \\u0915\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0928\\u0939\\u0940\\u0902, \\u0938\\u0947\\u0902\\u0921 \\u092e\\u0928\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0927\\u0928 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947\\u0935\\u0932 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f-\\u091f\\u0942-\\u090f\\u091c\\u0947\\u0902\\u091f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u0948\\u0964"}},"id":"6724c1d930155"},"6724c1e36f91c":{"language":{"en":{"question":"Is there a limit on how much money I can send to another agent?","answer":"Yes, there may be limits based on your account type and verification status. Check your account settings for specific sending limits."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f \\u0644\\u0645\\u0642\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644\\u0647\\u0627 \\u0625\\u0644\\u0649 \\u0648\\u0643\\u064a\\u0644 \\u0622\\u062e\\u0631\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0645\\u0639\\u0631\\u0641\\u0629 \\u062d\\u062f\\u0648\\u062f \\u0627\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629."},"es":{"question":"\\u00bfExiste un l\\u00edmite de cu\\u00e1nto dinero puedo enviar a otro agente?","answer":"S\\u00ed, puede haber l\\u00edmites seg\\u00fan el tipo de cuenta y el estado de verificaci\\u00f3n. Verifique la configuraci\\u00f3n de su cuenta para conocer los l\\u00edmites de env\\u00edo espec\\u00edficos."},"fr":{"question":"Y a-t-il une limite au montant d\\u2019argent que je peux envoyer \\u00e0 un autre agent ?","answer":"Oui, il peut y avoir des limites en fonction de votre type de compte et de votre statut de v\\u00e9rification. V\\u00e9rifiez les param\\u00e8tres de votre compte pour conna\\u00eetre les limites d\'envoi sp\\u00e9cifiques."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0907\\u0938 \\u092a\\u0930 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092e\\u0948\\u0902 \\u0926\\u0942\\u0938\\u0930\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0915\\u093f\\u0924\\u0928\\u093e \\u092a\\u0948\\u0938\\u093e \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901, \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0938\\u0924\\u094d\\u092f\\u093e\\u092a\\u0928 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0901 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0940\\u092e\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902\\u0964"}},"id":"6724c1e36f91c"},"6724c1eec2967":{"language":{"en":{"question":"How will I be notified of a successful transfer?","answer":"After sending money, you will receive a notification confirming the transaction. You can also view your transaction history in your QRPay Pro account for details."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0633\\u064a\\u062a\\u0645 \\u0625\\u0639\\u0644\\u0627\\u0645\\u064a \\u0628\\u0646\\u062c\\u0627\\u062d \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0642\\u0644\\u061f","answer":"\\u0628\\u0639\\u062f \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0639\\u0631\\u0636 \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u0643 \\u0641\\u064a \\u062d\\u0633\\u0627\\u0628 QRPay Pro \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo se me notificar\\u00e1 de una transferencia exitosa?","answer":"Despu\\u00e9s de enviar dinero, recibir\\u00e1s una notificaci\\u00f3n confirmando la transacci\\u00f3n. Tambi\\u00e9n puede ver su historial de transacciones en su cuenta QRPay Pro para obtener m\\u00e1s detalles."},"fr":{"question":"Comment serai-je inform\\u00e9 d\\u2019un transfert r\\u00e9ussi\\u00a0?","answer":"Apr\\u00e8s avoir envoy\\u00e9 de l\'argent, vous recevrez une notification confirmant la transaction. Vous pouvez \\u00e9galement consulter l\'historique de vos transactions dans votre compte QRPay Pro pour plus de d\\u00e9tails."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0938\\u092b\\u0932 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u0948\\u0938\\u0947 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f\\u0917\\u093e?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926, \\u0906\\u092a\\u0915\\u094b \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 QRPay \\u092a\\u094d\\u0930\\u094b \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u092d\\u0940 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724c1eec2967"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 17:54:49','updated_at' => '2024-11-06 15:27:15'),
            array('id' => '29','parent_id' => '29','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Money In on QRPay Pro","sub_heading":"Get answers to your questions about transferring funds to users\' wallets."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 Money In \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u062d\\u0648\\u0644 \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0627\\u0641\\u0638 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646."},"es":{"heading":"Preguntas frecuentes sobre la entrada de dinero en QRPay Pro","sub_heading":"Obtenga respuestas a sus preguntas sobre la transferencia de fondos a las billeteras de los usuarios."},"fr":{"heading":"Foire aux questions sur les entr\\u00e9es d\'argent sur QRPay Pro","sub_heading":"Obtenez des r\\u00e9ponses \\u00e0 vos questions sur le transfert de fonds vers les portefeuilles des utilisateurs."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092e\\u0928\\u0940 \\u0907\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c54659e55":{"language":{"en":{"question":"How do I send money to a user\'s wallet using QRPay Pro?","answer":"To send money, log in to your account, go to the \\u2018Money In\\u2019 section, select the user by entering their QRPay Pro ID, email, or phone number, specify the amount, review the details, and confirm the transfer."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"Money In\\"\\u060c \\u0648\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0639\\u0646 \\u0637\\u0631\\u064a\\u0642 \\u0625\\u062f\\u062e\\u0627\\u0644 \\u0645\\u0639\\u0631\\u0641 QRPay Pro \\u0623\\u0648 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641\\u060c \\u0648\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo env\\u00edo dinero a la billetera de un usuario usando QRPay Pro?","answer":"Para enviar dinero, inicie sesi\\u00f3n en su cuenta, vaya a la secci\\u00f3n \\"Ingreso de dinero\\", seleccione el usuario ingresando su ID de QRPay Pro, correo electr\\u00f3nico o n\\u00famero de tel\\u00e9fono, especifique el monto, revise los detalles y confirme la transferencia."},"fr":{"question":"Comment puis-je envoyer de l\'argent vers le portefeuille d\'un utilisateur \\u00e0 l\'aide de QRPay Pro\\u00a0?","answer":"Pour envoyer de l\'argent, connectez-vous \\u00e0 votre compte, acc\\u00e9dez \\u00e0 la section \\u00ab Argent entrant \\u00bb, s\\u00e9lectionnez l\'utilisateur en saisissant son identifiant QRPay Pro, son adresse e-mail ou son num\\u00e9ro de t\\u00e9l\\u00e9phone, sp\\u00e9cifiez le montant, v\\u00e9rifiez les d\\u00e9tails et confirmez le transfert."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0942\\u0902?","answer":"\\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092e\\u0928\\u0940 \\u0907\\u0928\' \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0902, \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0909\\u0928\\u0915\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940, \\u0908\\u092e\\u0947\\u0932 \\u092f\\u093e \\u092b\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0915\\u0947 \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902, \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c54659e55"},"6724c54f0a9de":{"language":{"en":{"question":"What information do I need to send money to a user?","answer":"You will need the recipient\'s QRPay Pro ID, email address, or phone number to successfully complete the transfer."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0623\\u062d\\u062a\\u0627\\u062c\\u0647\\u0627 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u061f","answer":"\\u0633\\u062a\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u0645\\u0639\\u0631\\u0641 QRPay Pro \\u0623\\u0648 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0644\\u0625\\u0643\\u0645\\u0627\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0642\\u0644 \\u0628\\u0646\\u062c\\u0627\\u062d."},"es":{"question":"\\u00bfQu\\u00e9 informaci\\u00f3n necesito para enviar dinero a un usuario?","answer":"Necesitar\\u00e1 el ID de QRPay Pro, la direcci\\u00f3n de correo electr\\u00f3nico o el n\\u00famero de tel\\u00e9fono del destinatario para completar con \\u00e9xito la transferencia."},"fr":{"question":"De quelles informations ai-je besoin pour envoyer de l\'argent \\u00e0 un utilisateur\\u00a0?","answer":"Vous aurez besoin de l\'identifiant QRPay Pro, de l\'adresse e-mail ou du num\\u00e9ro de t\\u00e9l\\u00e9phone du destinataire pour r\\u00e9ussir le transfert."},"hi":{"question":"\\u0915\\u093f\\u0938\\u0940 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0941\\u091d\\u0947 \\u0915\\u093f\\u0938 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b\\u0917\\u0940?","answer":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u094b \\u0938\\u092b\\u0932\\u0924\\u093e\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a\\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0940 QRPay \\u092a\\u094d\\u0930\\u094b \\u0906\\u0908\\u0921\\u0940, \\u0908\\u092e\\u0947\\u0932 \\u092a\\u0924\\u093e \\u092f\\u093e \\u092b\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"6724c54f0a9de"},"6724c556354b1":{"language":{"en":{"question":"Are there any fees for sending money to users?","answer":"Fees may apply depending on the transaction amount and any applicable service charges. Please review the fee structure in your account settings for detailed information."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u061f","answer":"\\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0648\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u062e\\u062f\\u0645\\u0629 \\u0645\\u0637\\u0628\\u0642\\u0629. \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0647\\u064a\\u0643\\u0644 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0641\\u064a \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0641\\u0635\\u0644\\u0629."},"es":{"question":"\\u00bfHay alguna tarifa por enviar dinero a los usuarios?","answer":"Es posible que se apliquen tarifas seg\\u00fan el monto de la transacci\\u00f3n y los cargos por servicio aplicables. Revise la estructura de tarifas en la configuraci\\u00f3n de su cuenta para obtener informaci\\u00f3n detallada."},"fr":{"question":"Y a-t-il des frais pour envoyer de l\\u2019argent aux utilisateurs ?","answer":"Des frais peuvent s\'appliquer en fonction du montant de la transaction et des frais de service applicables. Veuillez consulter la structure des frais dans les param\\u00e8tres de votre compte pour des informations d\\u00e9taill\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0938\\u0947\\u0935\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0943\\u092a\\u092f\\u093e \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u092e\\u0947\\u0902 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c556354b1"},"6724c5604f54d":{"language":{"en":{"question":"How long does it take for the funds to reach the user\'s wallet?","answer":"Transfers are typically processed instantly, and the funds should appear in the recipient\'s wallet shortly after you complete the transaction."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u064a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u061f","answer":"\\u062a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0639\\u0627\\u062f\\u0629\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631\\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u0638\\u0647\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0628\\u0639\\u062f \\u0648\\u0642\\u062a \\u0642\\u0635\\u064a\\u0631 \\u0645\\u0646 \\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo tardan los fondos en llegar a la billetera del usuario?","answer":"Las transferencias generalmente se procesan instant\\u00e1neamente y los fondos deber\\u00edan aparecer en la billetera del destinatario poco despu\\u00e9s de completar la transacci\\u00f3n."},"fr":{"question":"Combien de temps faut-il pour que les fonds atteignent le portefeuille de l\'utilisateur\\u00a0?","answer":"Les transferts sont g\\u00e9n\\u00e9ralement trait\\u00e9s instantan\\u00e9ment et les fonds devraient appara\\u00eetre dans le portefeuille du destinataire peu de temps apr\\u00e8s la fin de la transaction."},"hi":{"question":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u0924\\u0915 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u0939\\u0941\\u0902\\u091a\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0938\\u0902\\u0938\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092c\\u093e\\u0926 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0935\\u0949\\u0932\\u0947\\u091f \\u092e\\u0947\\u0902 \\u0926\\u093f\\u0916\\u093e\\u0908 \\u0926\\u0947\\u0928\\u0940 \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964"}},"id":"6724c5604f54d"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:10:30','updated_at' => '2024-11-07 10:43:15'),
            array('id' => '30','parent_id' => '30','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Bill Pay on QRPay Pro","sub_heading":"Find answers to your questions about making bill payments on behalf of users."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0623\\u0633\\u0626\\u0644\\u062a\\u0643 \\u062d\\u0648\\u0644 \\u0633\\u062f\\u0627\\u062f \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646."},"es":{"heading":"Preguntas frecuentes sobre el pago de facturas en QRPay Pro","sub_heading":"Encuentre respuestas a sus preguntas sobre c\\u00f3mo realizar pagos de facturas en nombre de los usuarios."},"fr":{"heading":"Foire aux questions sur le paiement de factures sur QRPay Pro","sub_heading":"Trouvez les r\\u00e9ponses \\u00e0 vos questions sur le paiement des factures au nom des utilisateurs."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0913\\u0930 \\u0938\\u0947 \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724c60951cc9":{"language":{"en":{"question":"How do I pay bills using QRPay Pro?","answer":"To pay bills, log in to your account, navigate to the \\u2018Bill Pay\\u2019 section, select the bill type, enter the required details, review the payment information, and confirm the payment."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\"\\u060c \\u062b\\u0645 \\u062d\\u062f\\u062f \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u0629\\u060c \\u0648\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u062b\\u0645 \\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062f\\u0641\\u0639."},"es":{"question":"\\u00bfC\\u00f3mo pago facturas usando QRPay Pro?","answer":"Para pagar facturas, inicie sesi\\u00f3n en su cuenta, navegue hasta la secci\\u00f3n \\"Pago de facturas\\", seleccione el tipo de factura, ingrese los detalles requeridos, revise la informaci\\u00f3n de pago y confirme el pago."},"fr":{"question":"Comment payer mes factures avec QRPay Pro\\u00a0?","answer":"Pour payer vos factures, connectez-vous \\u00e0 votre compte, acc\\u00e9dez \\u00e0 la section \\u00ab\\u00a0Paiement de factures\\u00a0\\u00bb, s\\u00e9lectionnez le type de facture, saisissez les d\\u00e9tails requis, v\\u00e9rifiez les informations de paiement et confirmez le paiement."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0942\\u0901?","answer":"\\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928\' \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u092c\\u093f\\u0932 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c60951cc9"},"6724c6132c8f5":{"language":{"en":{"question":"What types of bills can I pay through QRPay Pro?","answer":"You can pay a variety of bills including utilities, subscriptions, and other service-related payments, depending on the providers available in your area."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062f\\u0641\\u0639\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u062f\\u0641\\u0639 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0641\\u0648\\u0627\\u062a\\u064a\\u0631 \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0641\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u062e\\u062f\\u0645\\u0629\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0642\\u062f\\u0645\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0631\\u064a\\u0646 \\u0641\\u064a \\u0645\\u0646\\u0637\\u0642\\u062a\\u0643."},"es":{"question":"\\u00bfQu\\u00e9 tipos de facturas puedo pagar a trav\\u00e9s de QRPay Pro?","answer":"Puede pagar una variedad de facturas, incluidos servicios p\\u00fablicos, suscripciones y otros pagos relacionados con servicios, seg\\u00fan los proveedores disponibles en su \\u00e1rea."},"fr":{"question":"Quels types de factures puis-je payer via QRPay Pro\\u00a0?","answer":"Vous pouvez payer diverses factures, notamment les services publics, les abonnements et autres paiements li\\u00e9s aux services, en fonction des fournisseurs disponibles dans votre r\\u00e9gion."},"hi":{"question":"QRPay Pro \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092e\\u0948\\u0902 \\u0915\\u093f\\u0938 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"\\u0906\\u092a \\u0905\\u092a\\u0928\\u0947 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e\\u0913\\u0902, \\u0938\\u0926\\u0938\\u094d\\u092f\\u0924\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u0947\\u0935\\u093e-\\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928\\u094b\\u0902 \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092c\\u093f\\u0932\\u094b\\u0902 \\u0915\\u093e \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"6724c6132c8f5"},"6724c61b864ee":{"language":{"en":{"question":"Is there a fee for using the Bill Pay feature?","answer":"Fees may apply based on the specific bill being paid and any associated service charges. Please check your account settings for detailed fee information."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0631\\u0633\\u0648\\u0645 \\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062e\\u0627\\u0635\\u064a\\u0629 \\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629\\u061f","answer":"\\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0627\\u062a\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062a\\u0645 \\u062f\\u0641\\u0639\\u0647\\u0627 \\u0648\\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u062e\\u062f\\u0645\\u0629 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0647\\u0627. \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0641\\u0635\\u0644\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645."},"es":{"question":"\\u00bfSe aplica alg\\u00fan cargo por utilizar la funci\\u00f3n Pago de facturas?","answer":"Es posible que se apliquen tarifas seg\\u00fan la factura espec\\u00edfica que se pague y los cargos de servicio asociados. Verifique la configuraci\\u00f3n de su cuenta para obtener informaci\\u00f3n detallada sobre las tarifas."},"fr":{"question":"Y a-t-il des frais pour l\'utilisation de la fonction Bill Pay\\u00a0?","answer":"Des frais peuvent s\'appliquer en fonction de la facture sp\\u00e9cifique \\u00e0 payer et des frais de service associ\\u00e9s. Veuillez v\\u00e9rifier les param\\u00e8tres de votre compte pour obtenir des informations d\\u00e9taill\\u00e9es sur les frais."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u093f\\u090f \\u091c\\u093e \\u0930\\u0939\\u0947 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u092c\\u093f\\u0932 \\u0914\\u0930 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u0947\\u0935\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0915\\u0943\\u092a\\u092f\\u093e \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u091c\\u093e\\u0902\\u091a\\u0947\\u0902\\u0964"}},"id":"6724c61b864ee"},"6724c6238ce71":{"language":{"en":{"question":"How will I know if my bill payment was successful?","answer":"You will receive a notification confirming the successful payment, along with a transaction reference number for your records."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0633\\u0623\\u0639\\u0631\\u0641 \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u062f\\u0641\\u0639 \\u0641\\u0627\\u062a\\u0648\\u0631\\u062a\\u064a \\u0646\\u0627\\u062c\\u062d\\u064b\\u0627\\u061f","answer":"\\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0646\\u062c\\u0627\\u062d \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0628\\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0625\\u0644\\u0649 \\u0631\\u0642\\u0645 \\u0645\\u0631\\u062c\\u0639\\u064a \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0644\\u0644\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0628\\u0647 \\u0641\\u064a \\u0633\\u062c\\u0644\\u0627\\u062a\\u0643."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si el pago de mi factura fue exitoso?","answer":"Recibir\\u00e1 una notificaci\\u00f3n confirmando el pago exitoso, junto con un n\\u00famero de referencia de la transacci\\u00f3n para sus registros."},"fr":{"question":"Comment saurai-je si le paiement de ma facture a r\\u00e9ussi\\u00a0?","answer":"Vous recevrez une notification confirmant le paiement r\\u00e9ussi, ainsi qu\'un num\\u00e9ro de r\\u00e9f\\u00e9rence de transaction pour vos dossiers."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092e\\u0947\\u0930\\u093e \\u092c\\u093f\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0938\\u092b\\u0932 \\u0930\\u0939\\u093e?","answer":"\\u0906\\u092a\\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0938\\u0902\\u0916\\u094d\\u092f\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u092b\\u0932 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"6724c6238ce71"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:13:52','updated_at' => '2024-11-06 16:52:49'),
            array('id' => '31','parent_id' => '31','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Mobile Top-Up on QRPay Pro","sub_heading":"Get answers to your queries regarding mobile top-ups for users."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646."},"es":{"heading":"Preguntas frecuentes sobre la recarga m\\u00f3vil en QRPay Pro","sub_heading":"Obt\\u00e9n respuesta a tus consultas sobre recargas de m\\u00f3vil para usuarios."},"fr":{"heading":"Foire aux questions sur la recharge mobile sur QRPay Pro","sub_heading":"Obtenez des r\\u00e9ponses \\u00e0 vos questions concernant les recharges mobiles pour les utilisateurs."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"items":{"6724c6dbe65f0":{"language":{"en":{"question":"How can I top-up a mobile phone using QRPay Pro?","answer":"To top-up a mobile phone, log in to your account, navigate to the \\u2018Mobile Top-Up\\u2019 section, enter the mobile number, select the amount, review the details, and confirm the transaction."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0647\\u0627\\u062a\\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0647\\u0627\\u062a\\u0641 \\u0645\\u062d\\u0645\\u0648\\u0644\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u0648\\u0627\\u0646\\u062a\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0642\\u0633\\u0645 \\"\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\"\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u060c \\u0648\\u062d\\u062f\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629."},"es":{"question":"\\u00bfC\\u00f3mo puedo recargar un tel\\u00e9fono m\\u00f3vil usando QRPay Pro?","answer":"Para recargar un tel\\u00e9fono m\\u00f3vil, inicie sesi\\u00f3n en su cuenta, navegue hasta la secci\\u00f3n \\"Recarga m\\u00f3vil\\", ingrese el n\\u00famero de tel\\u00e9fono m\\u00f3vil, seleccione el monto, revise los detalles y confirme la transacci\\u00f3n."},"fr":{"question":"Comment puis-je recharger un t\\u00e9l\\u00e9phone mobile avec QRPay Pro\\u00a0?","answer":"Pour recharger un t\\u00e9l\\u00e9phone mobile, connectez-vous \\u00e0 votre compte, acc\\u00e9dez \\u00e0 la section \\u00ab Recharge mobile \\u00bb, saisissez le num\\u00e9ro de mobile, s\\u00e9lectionnez le montant, v\\u00e9rifiez les d\\u00e9tails et confirmez la transaction."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay Pro \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u093c\\u094b\\u0928 \\u0915\\u093e \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u092b\\u093c\\u094b\\u0928 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a\' \\u0905\\u0928\\u0941\\u092d\\u093e\\u0917 \\u092a\\u0930 \\u091c\\u093e\\u090f\\u0901, \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930\\u0947\\u0902, \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c6dbe65f0"},"6724c6e520d82":{"language":{"en":{"question":"Which mobile networks can I top-up through QRPay Pro?","answer":"QRPay Pro supports a variety of mobile networks. Please check the available networks in your area on the Mobile Top-Up page."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0634\\u0628\\u0643\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0634\\u062d\\u0646\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 QRPay Pro\\u061f","answer":"\\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0634\\u0628\\u0643\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644. \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0628\\u0643\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d\\u0629 \\u0641\\u064a \\u0645\\u0646\\u0637\\u0642\\u062a\\u0643 \\u0639\\u0644\\u0649 \\u0635\\u0641\\u062d\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644."},"es":{"question":"\\u00bfQu\\u00e9 redes m\\u00f3viles puedo recargar a trav\\u00e9s de QRPay Pro?","answer":"QRPay Pro admite una variedad de redes m\\u00f3viles. Verifique las redes disponibles en su \\u00e1rea en la p\\u00e1gina de recarga m\\u00f3vil."},"fr":{"question":"Quels r\\u00e9seaux mobiles puis-je recharger via QRPay Pro\\u00a0?","answer":"QRPay Pro prend en charge une vari\\u00e9t\\u00e9 de r\\u00e9seaux mobiles. Veuillez v\\u00e9rifier les r\\u00e9seaux disponibles dans votre r\\u00e9gion sur la page Recharge mobile."},"hi":{"question":"QRPay Pro \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092e\\u0948\\u0902 \\u0915\\u094c\\u0928 \\u0938\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915 \\u0915\\u094b \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0902?","answer":"QRPay Pro \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0915\\u0943\\u092a\\u092f\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u092a\\u0943\\u0937\\u094d\\u0920 \\u092a\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c6e520d82"},"6724c6ed4d547":{"language":{"en":{"question":"Are there any fees associated with mobile top-ups?","answer":"Fees may apply based on the top-up amount and the mobile network provider. Review your account settings for specific fee details."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u061f","answer":"\\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0631\\u0633\\u0648\\u0645 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0648\\u0645\\u0632\\u0648\\u062f \\u0634\\u0628\\u0643\\u0629 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644. \\u0642\\u0645 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629."},"es":{"question":"\\u00bfHay alguna tarifa asociada con las recargas m\\u00f3viles?","answer":"Es posible que se apliquen tarifas seg\\u00fan el monto de la recarga y el proveedor de la red m\\u00f3vil. Revise la configuraci\\u00f3n de su cuenta para obtener detalles de tarifas espec\\u00edficas."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s aux recharges mobiles ?","answer":"Des frais peuvent s\'appliquer en fonction du montant de la recharge et du fournisseur de r\\u00e9seau mobile. V\\u00e9rifiez les param\\u00e8tres de votre compte pour conna\\u00eetre les d\\u00e9tails des frais sp\\u00e9cifiques."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0940 \\u0915\\u094b\\u0908 \\u092b\\u0940\\u0938 \\u0939\\u0948?","answer":"\\u0936\\u0941\\u0932\\u094d\\u0915 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0924\\u093e \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c6ed4d547"},"6724c6f7db794":{"language":{"en":{"question":"How will I know if the mobile top-up was successful?","answer":"You will receive a notification confirming the successful top-up along with a transaction reference number for your records."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0633\\u0623\\u0639\\u0631\\u0641 \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644 \\u0646\\u0627\\u062c\\u062d\\u0629\\u061f","answer":"\\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u064a\\u0624\\u0643\\u062f \\u0646\\u062c\\u0627\\u062d \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f \\u0628\\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0625\\u0644\\u0649 \\u0631\\u0642\\u0645 \\u0645\\u0631\\u062c\\u0639\\u064a \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0644\\u0644\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0628\\u0647 \\u0641\\u064a \\u0633\\u062c\\u0644\\u0627\\u062a\\u0643."},"es":{"question":"\\u00bfC\\u00f3mo sabr\\u00e9 si la recarga m\\u00f3vil fue exitosa?","answer":"Recibir\\u00e1s una notificaci\\u00f3n confirmando la recarga exitosa junto con un n\\u00famero de referencia de la transacci\\u00f3n para tus registros."},"fr":{"question":"Comment saurai-je si la recharge mobile a r\\u00e9ussi ?","answer":"Vous recevrez une notification confirmant la recharge r\\u00e9ussie ainsi qu\'un num\\u00e9ro de r\\u00e9f\\u00e9rence de transaction pour vos dossiers."},"hi":{"question":"\\u092e\\u0941\\u091d\\u0947 \\u0915\\u0948\\u0938\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0947\\u0917\\u093e \\u0915\\u093f \\u092e\\u094b\\u092c\\u093e\\u0907\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0938\\u092b\\u0932 \\u0930\\u0939\\u093e?","answer":"\\u0906\\u092a\\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0938\\u0902\\u0916\\u094d\\u092f\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u092b\\u0932 \\u091f\\u0949\\u092a-\\u0905\\u092a \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u090f\\u0915 \\u0905\\u0927\\u093f\\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0917\\u0940\\u0964"}},"id":"6724c6f7db794"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:17:20','updated_at' => '2024-11-06 17:07:21'),
            array('id' => '32','parent_id' => '32','type' => 'enterprise','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About Remittance on QRPay Pro","sub_heading":"Find answers to common questions regarding remittance services for agents."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062f\\u0627\\u0648\\u0644\\u0629 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0639\\u0644\\u0649 QRPay Pro","sub_heading":"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0625\\u062c\\u0627\\u0628\\u0627\\u062a \\u0644\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0644\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621."},"es":{"heading":"Preguntas frecuentes sobre remesas en QRPay Pro","sub_heading":"Encuentre respuestas a preguntas comunes sobre los servicios de remesas para agentes."},"fr":{"heading":"Foire aux questions sur les versements sur QRPay Pro","sub_heading":"Trouvez des r\\u00e9ponses aux questions courantes concernant les services de transfert de fonds pour les agents."},"hi":{"heading":"QRPay \\u092a\\u094d\\u0930\\u094b \\u092a\\u0930 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u090f\\u091c\\u0947\\u0902\\u091f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0916\\u094b\\u091c\\u0947\\u0902\\u0964"}},"items":{"6724c9041a665":{"language":{"en":{"question":"How do I send a remittance using QRPay Pro?","answer":"To send a remittance, log into your account, select the \\u2018Remittance\\u2019 option, enter the recipient\'s details, choose the amount, review the transaction, and confirm the transfer."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644 \\u062d\\u0648\\u0627\\u0644\\u0629 \\u0645\\u0627\\u0644\\u064a\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 QRPay Pro\\u061f","answer":"\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u062d\\u0648\\u0627\\u0644\\u0629\\u060c \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643\\u060c \\u062b\\u0645 \\u062d\\u062f\\u062f \\u062e\\u064a\\u0627\\u0631 \\"\\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\"\\u060c \\u0648\\u0623\\u062f\\u062e\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645\\u060c \\u0648\\u0627\\u062e\\u062a\\u0631 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0648\\u0631\\u0627\\u062c\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0648\\u0642\\u0645 \\u0628\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644."},"es":{"question":"\\u00bfC\\u00f3mo env\\u00edo una remesa usando QRPay Pro?","answer":"Para enviar una remesa, inicie sesi\\u00f3n en su cuenta, seleccione la opci\\u00f3n \'Remesa\', ingrese los datos del destinatario, elija el monto, revise la transacci\\u00f3n y confirme la transferencia."},"fr":{"question":"Comment envoyer un versement en utilisant QRPay Pro\\u00a0?","answer":"Pour envoyer un versement, connectez-vous \\u00e0 votre compte, s\\u00e9lectionnez l\'option \\u00ab Remise de fonds \\u00bb, saisissez les coordonn\\u00e9es du destinataire, choisissez le montant, v\\u00e9rifiez la transaction et confirmez le transfert."},"hi":{"question":"\\u092e\\u0948\\u0902 QRPay \\u092a\\u094d\\u0930\\u094b \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0915\\u0947 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0948\\u0938\\u0947 \\u092d\\u0947\\u091c\\u0942\\u0902?","answer":"\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0905\\u092a\\u0928\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u0932\\u0949\\u0917 \\u0907\\u0928 \\u0915\\u0930\\u0947\\u0902, \'\\u092a\\u094d\\u0930\\u0947\\u0937\\u0923\' \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u091a\\u0941\\u0928\\u0947\\u0902, \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0947\\u0902, \\u0930\\u093e\\u0936\\u093f \\u091a\\u0941\\u0928\\u0947\\u0902, \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u0923 \\u0915\\u0940 \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c9041a665"},"6724c90c318e3":{"language":{"en":{"question":"Is there a limit on how much I can send through remittance?","answer":"Yes, there may be limits on remittance amounts based on your account type and the recipient\'s location. Check the terms in your account settings for specific limits."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f \\u0644\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0625\\u0631\\u0633\\u0627\\u0644\\u0647 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u062f\\u0648\\u062f \\u0644\\u0645\\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0645\\u0648\\u0642\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u0645\\u0648\\u062c\\u0648\\u062f\\u0629 \\u0641\\u064a \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0645\\u0639\\u0631\\u0641\\u0629 \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629."},"es":{"question":"\\u00bfExiste un l\\u00edmite de cu\\u00e1nto puedo enviar mediante remesas?","answer":"S\\u00ed, puede haber l\\u00edmites en los montos de las remesas seg\\u00fan su tipo de cuenta y la ubicaci\\u00f3n del destinatario. Consulte los t\\u00e9rminos en la configuraci\\u00f3n de su cuenta para conocer l\\u00edmites espec\\u00edficos."},"fr":{"question":"Y a-t-il une limite au montant que je peux envoyer par virement de fonds ?","answer":"Oui, il peut y avoir des limites sur les montants des versements en fonction de votre type de compte et de l\'emplacement du destinataire. V\\u00e9rifiez les conditions dans les param\\u00e8tres de votre compte pour conna\\u00eetre les limites sp\\u00e9cifiques."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0907\\u0938 \\u092a\\u0930 \\u0915\\u094b\\u0908 \\u0938\\u0940\\u092e\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092e\\u0948\\u0902 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0915\\u093f\\u0924\\u0928\\u093e \\u092d\\u0947\\u091c \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0902, \\u0906\\u092a\\u0915\\u0947 \\u0916\\u093e\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0938\\u094d\\u0925\\u093e\\u0928 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u0930\\u093e\\u0936\\u093f \\u092a\\u0930 \\u0938\\u0940\\u092e\\u093e\\u090f\\u0902 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u092e\\u0947\\u0902 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u0940 \\u091c\\u093e\\u0901\\u091a \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c90c318e3"},"6724c91468977":{"language":{"en":{"question":"How long does it take for the recipient to receive the funds?","answer":"Funds are typically transferred instantly, but some transactions may take longer depending on the recipient\'s country and local banking processes."},"ar":{"question":"\\u0643\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0642\\u062a \\u064a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u061f","answer":"\\u064a\\u062a\\u0645 \\u0639\\u0627\\u062f\\u0629\\u064b \\u062a\\u062d\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631\\u060c \\u0648\\u0644\\u0643\\u0646 \\u0642\\u062f \\u062a\\u0633\\u062a\\u063a\\u0631\\u0642 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0648\\u0642\\u062a\\u064b\\u0627 \\u0623\\u0637\\u0648\\u0644 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0628\\u0644\\u062f \\u0627\\u0644\\u0645\\u0633\\u062a\\u0644\\u0645 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062d\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfCu\\u00e1nto tiempo tarda el destinatario en recibir los fondos?","answer":"Los fondos generalmente se transfieren instant\\u00e1neamente, pero algunas transacciones pueden demorar m\\u00e1s seg\\u00fan el pa\\u00eds del destinatario y los procesos bancarios locales."},"fr":{"question":"Combien de temps faut-il pour que le b\\u00e9n\\u00e9ficiaire re\\u00e7oive les fonds ?","answer":"Les fonds sont g\\u00e9n\\u00e9ralement transf\\u00e9r\\u00e9s instantan\\u00e9ment, mais certaines transactions peuvent prendre plus de temps en fonction du pays du destinataire et des processus bancaires locaux."},"hi":{"question":"\\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093f\\u0924\\u0928\\u093e \\u0938\\u092e\\u092f \\u0932\\u0917\\u0924\\u093e \\u0939\\u0948?","answer":"\\u0927\\u0928\\u0930\\u093e\\u0936\\u093f \\u0906\\u092e \\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u0939\\u0938\\u094d\\u0924\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948, \\u0932\\u0947\\u0915\\u093f\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0926\\u0947\\u0936 \\u0914\\u0930 \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f \\u092c\\u0948\\u0902\\u0915\\u093f\\u0902\\u0917 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0915\\u0941\\u091b \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u092f \\u0932\\u0917 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"6724c91468977"},"6724c91cc135e":{"language":{"en":{"question":"Are there any fees associated with sending remittances?","answer":"Fees may vary depending on the amount sent and the destination country. Please review the fee structure in your account settings for detailed information."},"ar":{"question":"\\u0647\\u0644 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u062d\\u0648\\u0627\\u0644\\u0627\\u062a\\u061f","answer":"\\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u0631\\u0633\\u0644 \\u0648\\u0628\\u0644\\u062f \\u0627\\u0644\\u0648\\u062c\\u0647\\u0629. \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0647\\u064a\\u0643\\u0644 \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0641\\u064a \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0641\\u0635\\u0644\\u0629."},"es":{"question":"\\u00bfExisten tarifas asociadas con el env\\u00edo de remesas?","answer":"Las tarifas pueden variar seg\\u00fan la cantidad enviada y el pa\\u00eds de destino. Revise la estructura de tarifas en la configuraci\\u00f3n de su cuenta para obtener informaci\\u00f3n detallada."},"fr":{"question":"Y a-t-il des frais associ\\u00e9s \\u00e0 l\\u2019envoi de fonds ?","answer":"Les frais peuvent varier en fonction du montant envoy\\u00e9 et du pays de destination. Veuillez consulter la structure des frais dans les param\\u00e8tres de votre compte pour des informations d\\u00e9taill\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092a\\u094d\\u0930\\u0947\\u0937\\u0923 \\u092d\\u0947\\u091c\\u0928\\u0947 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u094b\\u0908 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0939\\u0948?","answer":"\\u092d\\u0947\\u091c\\u0940 \\u0917\\u0908 \\u0930\\u093e\\u0936\\u093f \\u0914\\u0930 \\u0917\\u0902\\u0924\\u0935\\u094d\\u092f \\u0926\\u0947\\u0936 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0943\\u092a\\u092f\\u093e \\u0905\\u092a\\u0928\\u0940 \\u0916\\u093e\\u0924\\u093e \\u0938\\u0947\\u091f\\u093f\\u0902\\u0917 \\u092e\\u0947\\u0902 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"6724c91cc135e"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-01 18:26:33','updated_at' => '2024-11-07 10:46:10'),
            array('id' => '34','parent_id' => '34','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About P2P Trading","sub_heading":"Everything you need to know about trading currencies on QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631","sub_heading":"\\u0643\\u0644 \\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u0645\\u0639\\u0631\\u0641\\u062a\\u0647 \\u0639\\u0646 \\u062a\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre el comercio P2P","sub_heading":"Todo lo que necesitas saber sobre el comercio de divisas en QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quentes sur le trading P2P","sub_heading":"Tout ce que vous devez savoir sur le trading des devises sur QRPay Pro."},"hi":{"heading":"\\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"QRPay Pro \\u092a\\u0930 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0906\\u092a\\u0915\\u094b \\u091c\\u094b \\u0915\\u0941\\u091b \\u092d\\u0940 \\u091c\\u093e\\u0928\\u0928\\u093e \\u091c\\u0930\\u0942\\u0930\\u0940 \\u0939\\u0948\\u0964"}},"items":{"68301d2742b00":{"language":{"en":{"question":"What is P2P trading on QRPay Pro?","answer":"Peer-to-peer (P2P) trading allows users to buy and sell currencies directly with one another through a secure, in-app marketplace."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u0648 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 \\u0639\\u0644\\u0649 QRPay Pro\\u061f","answer":"\\u064a\\u062a\\u064a\\u062d \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0646 \\u0646\\u0638\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0646\\u0638\\u064a\\u0631 (P2P) \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0634\\u0631\\u0627\\u0621 \\u0648\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0639 \\u0628\\u0639\\u0636\\u0647\\u0645 \\u0627\\u0644\\u0628\\u0639\\u0636 \\u0639\\u0628\\u0631 \\u0633\\u0648\\u0642 \\u0622\\u0645\\u0646 \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642."},"es":{"question":"\\u00bfQu\\u00e9 es el comercio P2P en QRPay Pro?","answer":"El comercio peer-to-peer (P2P) permite a los usuarios comprar y vender monedas directamente entre s\\u00ed a trav\\u00e9s de un mercado seguro dentro de la aplicaci\\u00f3n."},"fr":{"question":"Qu\'est-ce que le trading P2P sur QRPay Pro ?","answer":"Le trading peer-to-peer (P2P) permet aux utilisateurs d\\u2019acheter et de vendre des devises directement entre eux via une marketplace s\\u00e9curis\\u00e9e int\\u00e9gr\\u00e9e \\u00e0 l\\u2019application."},"hi":{"question":"QRPay Pro \\u092a\\u0930 \\u092a\\u09402\\u092a\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0915\\u094d\\u092f\\u093e \\u0939\\u0948?","answer":"\\u092a\\u0940\\u092f\\u0930-\\u091f\\u0942-\\u092a\\u0940\\u092f\\u0930 (P2P) \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924, \\u0907\\u0928-\\u0910\\u092a \\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f\\u092a\\u094d\\u0932\\u0947\\u0938 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0938\\u0940\\u0927\\u0947 \\u090f\\u0915-\\u0926\\u0942\\u0938\\u0930\\u0947 \\u0938\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u0914\\u0930 \\u092c\\u0947\\u091a\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"68301d2742b00"},"68301d36c8f5d":{"language":{"en":{"question":"Can I negotiate prices with other users?","answer":"Yes. The system includes an offer and counteroffer feature that lets both parties settle on terms that work for them."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0645\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0622\\u062e\\u0631\\u064a\\u0646\\u061f","answer":"\\u0646\\u0639\\u0645. \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0636 \\u0648\\u0627\\u0644\\u0631\\u062f \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0631\\u0636 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u064a\\u062d \\u0644\\u0644\\u0637\\u0631\\u0641\\u064a\\u0646 \\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0648\\u0637 \\u062a\\u0646\\u0627\\u0633\\u0628\\u0647\\u0645\\u0627."},"es":{"question":"\\u00bfPuedo negociar precios con otros usuarios?","answer":"S\\u00ed. El sistema incluye una funci\\u00f3n de oferta y contraoferta que permite a ambas partes acordar t\\u00e9rminos que les convengan."},"fr":{"question":"Puis-je n\\u00e9gocier les prix avec d\\u2019autres utilisateurs ?","answer":"Oui. Le syst\\u00e8me inclut une fonctionnalit\\u00e9 d\\u2019offre et de contre-offre qui permet aux deux parties de s\\u2019entendre sur des conditions qui leur conviennent."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u0928\\u094d\\u092f \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u0940\\u092e\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u092c\\u093e\\u0924\\u091a\\u0940\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901\\u0964 \\u0938\\u093f\\u0938\\u094d\\u091f\\u092e \\u092e\\u0947\\u0902 \\u0911\\u092b\\u0930 \\u0914\\u0930 \\u0915\\u093e\\u0909\\u0902\\u091f\\u0930\\u0911\\u092b\\u0930 \\u0915\\u0940 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948 \\u091c\\u094b \\u0926\\u094b\\u0928\\u094b\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u0938\\u0939\\u092e\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u0926\\u0947\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"68301d36c8f5d"},"683024bac2032":{"language":{"en":{"question":"Is it safe to trade with other users?","answer":"Absolutely. All transactions are encrypted and secured, and admin oversight ensures compliance and dispute resolution."},"ar":{"question":"\\u0647\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0622\\u0645\\u0646 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0645\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0622\\u062e\\u0631\\u064a\\u0646\\u061f","answer":"\\u0628\\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f. \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0634\\u0641\\u0631\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629\\u060c \\u0648\\u0631\\u0642\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0648\\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a."},"es":{"question":"\\u00bfEs seguro comerciar con otros usuarios?","answer":"Absolutamente. Todas las transacciones est\\u00e1n encriptadas y seguras, y la supervisi\\u00f3n administrativa garantiza el cumplimiento y la resoluci\\u00f3n de disputas."},"fr":{"question":"Est-il s\\u00fbr de trader avec d\\u2019autres utilisateurs ?","answer":"Absolument. Toutes les transactions sont crypt\\u00e9es et s\\u00e9curis\\u00e9es, et la supervision de l\\u2019administrateur garantit la conformit\\u00e9 et la r\\u00e9solution des litiges."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u0905\\u0928\\u094d\\u092f \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0915\\u0930\\u0928\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932\\u0964 \\u0938\\u092d\\u0940 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0935\\u093e\\u0926 \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"683024bac2032"},"6830250068c5a":{"language":{"en":{"question":"Can I see all my previous trades?","answer":"Yes, your full transaction history is available in the \\u201cMarketplace Transaction List.\\u201d"},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0631\\u0624\\u064a\\u0629 \\u062c\\u0645\\u064a\\u0639 \\u0635\\u0641\\u0642\\u0627\\u062a\\u064a \\u0627\\u0644\\u0633\\u0627\\u0628\\u0642\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645\\u060c \\u0633\\u062c\\u0644 \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0643 \\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0645\\u062a\\u0627\\u062d \\u0641\\u064a \\"\\u0642\\u0627\\u0626\\u0645\\u0629 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0633\\u0648\\u0642\\"."},"es":{"question":"\\u00bfPuedo ver todas mis operaciones anteriores?","answer":"S\\u00ed, tu historial completo de transacciones est\\u00e1 disponible en la \\u201cLista de transacciones del mercado.\\u201d"},"fr":{"question":"Puis-je voir toutes mes transactions pr\\u00e9c\\u00e9dentes ?","answer":"Oui, votre historique complet des transactions est disponible dans la \\u00ab Liste des transactions du march\\u00e9 \\u00bb."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0938\\u092d\\u0940 \\u092a\\u093f\\u091b\\u0932\\u0947 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901, \\u0906\\u092a\\u0915\\u093e \\u092a\\u0942\\u0930\\u093e \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928 \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u201c\\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f\\u092a\\u094d\\u0932\\u0947\\u0938 \\u091f\\u094d\\u0930\\u093e\\u0902\\u091c\\u0948\\u0915\\u094d\\u0936\\u0928 \\u0932\\u093f\\u0938\\u094d\\u091f\\u201d \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948\\u0964"}},"id":"6830250068c5a"},"68302620ac229":{"language":{"en":{"question":"What currencies and payment methods are supported?","answer":"QRPay Pro supports multiple currencies and payment types. Options may vary depending on the local setup."},"ar":{"question":"\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u062a \\u0648\\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062f\\u0639\\u0648\\u0645\\u0629\\u061f","answer":"\\u064a\\u062f\\u0639\\u0645 QRPay Pro \\u0639\\u062f\\u0629 \\u0639\\u0645\\u0644\\u0627\\u062a \\u0648\\u0623\\u0646\\u0648\\u0627\\u0639 \\u062f\\u0641\\u0639. \\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0625\\u0639\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u062d\\u0644\\u064a."},"es":{"question":"\\u00bfQu\\u00e9 monedas y m\\u00e9todos de pago se admiten?","answer":"QRPay Pro admite m\\u00faltiples monedas y tipos de pago. Las opciones pueden variar seg\\u00fan la configuraci\\u00f3n local."},"fr":{"question":"Quelles devises et m\\u00e9thodes de paiement sont prises en charge ?","answer":"QRPay Pro prend en charge plusieurs devises et types de paiement. Les options peuvent varier en fonction de la configuration locale."},"hi":{"question":"\\u0915\\u094c\\u0928-\\u0915\\u094c\\u0928 \\u0938\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u090f\\u0901 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0938\\u092e\\u0930\\u094d\\u0925\\u093f\\u0924 \\u0939\\u0948\\u0902?","answer":"QRPay Pro \\u0915\\u0908 \\u092e\\u0941\\u0926\\u094d\\u0930\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f \\u0938\\u0947\\u091f\\u0905\\u092a \\u0915\\u0947 \\u0905\\u0928\\u0941\\u0938\\u093e\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"68302620ac229"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 13:00:43','updated_at' => '2025-05-23 13:39:12'),
            array('id' => '35','parent_id' => '35','type' => 'personal','value' => '{"language":{"en":{"heading":"Frequently Asked Questions About User Chat","sub_heading":"Learn how live chat improves your trading experience on QRPay Pro."},"ar":{"heading":"\\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0643\\u0631\\u0631\\u0629 \\u062d\\u0648\\u0644 \\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645","sub_heading":"\\u062a\\u0639\\u0631\\u0651\\u0641 \\u0639\\u0644\\u0649 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0644\\u062a\\u062c\\u0631\\u0628\\u062a\\u0643 \\u0641\\u064a \\u0627\\u0644\\u062a\\u062f\\u0627\\u0648\\u0644 \\u0639\\u0644\\u0649 QRPay Pro."},"es":{"heading":"Preguntas frecuentes sobre el chat de usuario","sub_heading":"Aprende c\\u00f3mo el chat en vivo mejora tu experiencia de trading en QRPay Pro."},"fr":{"heading":"Questions fr\\u00e9quentes sur le chat utilisateur","sub_heading":"D\\u00e9couvrez comment le chat en direct am\\u00e9liore votre exp\\u00e9rience de trading sur QRPay Pro."},"hi":{"heading":"\\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u091a\\u0948\\u091f \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092a\\u0942\\u091b\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928","sub_heading":"\\u091c\\u093e\\u0928\\u0947\\u0902 \\u0915\\u093f \\u0932\\u093e\\u0907\\u0935 \\u091a\\u0948\\u091f \\u0915\\u0948\\u0938\\u0947 \\u0906\\u092a\\u0915\\u0947 \\u091f\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u094b QRPay Pro \\u092a\\u0930 \\u092c\\u0947\\u0939\\u0924\\u0930 \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964"}},"items":{"68301d747cc36":{"language":{"en":{"question":"How do I start chatting with another user?","answer":"Simply open their trade listing and click on \\u201cChat with User\\u201d to start messaging them in real time."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0628\\u062f\\u0623 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u0639 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0622\\u062e\\u0631\\u061f","answer":"\\u0628\\u0628\\u0633\\u0627\\u0637\\u0629 \\u0627\\u0641\\u062a\\u062d \\u0625\\u0639\\u0644\\u0627\\u0646 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0647\\u0645 \\u0648\\u0627\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\"\\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\" \\u0644\\u0628\\u062f\\u0621 \\u0645\\u0631\\u0627\\u0633\\u0644\\u062a\\u0647\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u062d\\u0642\\u064a\\u0642\\u064a."},"es":{"question":"\\u00bfC\\u00f3mo empiezo a chatear con otro usuario?","answer":"Simplemente abre su anuncio de comercio y haz clic en \\"Chatear con usuario\\" para comenzar a enviarles mensajes en tiempo real."},"fr":{"question":"Comment commencer \\u00e0 discuter avec un autre utilisateur ?","answer":"Il suffit d\\u2019ouvrir leur annonce commerciale et de cliquer sur \\u00ab Discuter avec l\'utilisateur \\u00bb pour commencer \\u00e0 leur envoyer des messages en temps r\\u00e9el."},"hi":{"question":"\\u092e\\u0948\\u0902 \\u0926\\u0942\\u0938\\u0930\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091a\\u0948\\u091f \\u0915\\u0948\\u0938\\u0947 \\u0936\\u0941\\u0930\\u0942 \\u0915\\u0930\\u0942\\u0902?","answer":"\\u092c\\u0938 \\u0909\\u0928\\u0915\\u0940 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0932\\u093f\\u0938\\u094d\\u091f\\u093f\\u0902\\u0917 \\u0916\\u094b\\u0932\\u0947\\u0902 \\u0914\\u0930 \\u201c\\u092f\\u0942\\u091c\\u093c\\u0930 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091a\\u0948\\u091f \\u0915\\u0930\\u0947\\u0902\\u201d \\u092a\\u0930 \\u0915\\u094d\\u0932\\u093f\\u0915 \\u0915\\u0930\\u0947\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0906\\u092a \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u092e\\u092f \\u092e\\u0947\\u0902 \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u092e\\u0948\\u0938\\u0947\\u091c \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0964"}},"id":"68301d747cc36"},"68301d7ab494a":{"language":{"en":{"question":"Is the chat secure?","answer":"Yes. QRPay Pro\\u2019s chat is encrypted, keeping all communication private and secure."},"ar":{"question":"\\u0647\\u0644 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0622\\u0645\\u0646\\u0629\\u061f","answer":"\\u0646\\u0639\\u0645. \\u062f\\u0631\\u062f\\u0634\\u0629 QRPay Pro \\u0645\\u0634\\u0641\\u0631\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062d\\u0627\\u0641\\u0638 \\u0639\\u0644\\u0649 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u0623\\u0645\\u0627\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a."},"es":{"question":"\\u00bfEs segura la chat?","answer":"S\\u00ed. El chat de QRPay Pro est\\u00e1 encriptado, manteniendo toda la comunicaci\\u00f3n privada y segura."},"fr":{"question":"Le chat est-il s\\u00e9curis\\u00e9 ?","answer":"Oui. Le chat de QRPay Pro est chiffr\\u00e9, garantissant que toutes les communications restent priv\\u00e9es et s\\u00e9curis\\u00e9es."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u091a\\u0948\\u091f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0901\\u0964 QRPay Pro \\u0915\\u0940 \\u091a\\u0948\\u091f \\u090f\\u0928\\u094d\\u0915\\u094d\\u0930\\u093f\\u092a\\u094d\\u091f\\u0947\\u0921 \\u0939\\u0948, \\u091c\\u094b \\u0938\\u092d\\u0940 \\u0938\\u0902\\u091a\\u093e\\u0930 \\u0915\\u094b \\u0928\\u093f\\u091c\\u0940 \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0924\\u0940 \\u0939\\u0948\\u0964"}},"id":"68301d7ab494a"},"68302a7ef0cb9":{"language":{"en":{"question":"Can I chat with users before making an offer?","answer":"Absolutely. You can use the chat to ask questions or clarify terms before sending or accepting an offer."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0642\\u0628\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0639\\u0631\\u0636\\u061f","answer":"\\u0628\\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0644\\u0637\\u0631\\u062d \\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u062a\\u0648\\u0636\\u064a\\u062d \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637 \\u0642\\u0628\\u0644 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0627\\u0644\\u0639\\u0631\\u0636 \\u0623\\u0648 \\u0642\\u0628\\u0648\\u0644\\u0647."},"es":{"question":"\\u00bfPuedo chatear con los usuarios antes de hacer una oferta?","answer":"Absolutamente. Puedes usar el chat para hacer preguntas o aclarar t\\u00e9rminos antes de enviar o aceptar una oferta."},"fr":{"question":"Puis-je discuter avec les utilisateurs avant de faire une offre ?","answer":"Absolument. Vous pouvez utiliser le chat pour poser des questions ou clarifier les conditions avant d\\u2019envoyer ou d\\u2019accepter une offre."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0911\\u092b\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091a\\u0948\\u091f \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932\\u0964 \\u0906\\u092a \\u091a\\u0948\\u091f \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928 \\u092a\\u0942\\u091b\\u0928\\u0947 \\u092f\\u093e \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0915\\u093f \\u0906\\u092a \\u0915\\u094b\\u0908 \\u0911\\u092b\\u0930 \\u092d\\u0947\\u091c\\u0947\\u0902 \\u092f\\u093e \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0947\\u0902\\u0964"}},"id":"68302a7ef0cb9"},"68302ad2764f0":{"language":{"en":{"question":"Is the chat available in multiple languages?","answer":"Yes. The platform supports multi-language chat for a localized user experience."},"ar":{"question":"\\u0647\\u0644 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0628\\u0639\\u062f\\u0629 \\u0644\\u063a\\u0627\\u062a\\u061f","answer":"\\u0646\\u0639\\u0645. \\u062a\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0627\\u062a \\u0644\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0645\\u062d\\u0644\\u064a\\u0629."},"es":{"question":"\\u00bfEst\\u00e1 el chat disponible en varios idiomas?","answer":"S\\u00ed. La plataforma soporta chat multiling\\u00fce para una experiencia de usuario localizada."},"fr":{"question":"Le chat est-il disponible en plusieurs langues ?","answer":"Oui. La plateforme prend en charge le chat multilingue pour une exp\\u00e9rience utilisateur localis\\u00e9e."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u091a\\u0948\\u091f \\u0915\\u0908 \\u092d\\u093e\\u0937\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0939\\u0948?","answer":"\\u0939\\u093e\\u0901\\u0964 \\u092a\\u094d\\u0932\\u0947\\u091f\\u092b\\u093c\\u0949\\u0930\\u094d\\u092e \\u090f\\u0915 \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f\\u0915\\u0943\\u0924 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0915\\u0930\\u094d\\u0924\\u093e \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0939\\u0941\\u092d\\u093e\\u0937\\u0940 \\u091a\\u0948\\u091f \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964"}},"id":"68302ad2764f0"},"68302b0d174b7":{"language":{"en":{"question":"Can I access my chat history?","answer":"Yes. All chat sessions are saved under your trade records for future reference."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0633\\u062c\\u0644 \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u064a\\u061f","answer":"\\u0646\\u0639\\u0645. \\u064a\\u062a\\u0645 \\u062d\\u0641\\u0638 \\u062c\\u0645\\u064a\\u0639 \\u062c\\u0644\\u0633\\u0627\\u062a \\u0627\\u0644\\u062f\\u0631\\u062f\\u0634\\u0629 \\u0636\\u0645\\u0646 \\u0633\\u062c\\u0644\\u0627\\u062a \\u062a\\u062c\\u0627\\u0631\\u062a\\u0643 \\u0644\\u0644\\u0631\\u062c\\u0648\\u0639 \\u0625\\u0644\\u064a\\u0647\\u0627 \\u0645\\u0633\\u062a\\u0642\\u0628\\u0644\\u0627\\u064b."},"es":{"question":"\\u00bfPuedo acceder a mi historial de chat?","answer":"S\\u00ed. Todas las sesiones de chat se guardan en tus registros de comercio para referencia futura."},"fr":{"question":"Puis-je acc\\u00e9der \\u00e0 mon historique de chat ?","answer":"Oui. Toutes les sessions de chat sont enregistr\\u00e9es dans vos dossiers commerciaux pour une r\\u00e9f\\u00e9rence future."},"hi":{"question":"\\u0915\\u094d\\u092f\\u093e \\u092e\\u0948\\u0902 \\u0905\\u092a\\u0928\\u0940 \\u091a\\u0948\\u091f \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u0926\\u0947\\u0916 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0942\\u0901?","answer":"\\u0939\\u093e\\u0901\\u0964 \\u0938\\u092d\\u0940 \\u091a\\u0948\\u091f \\u0938\\u0924\\u094d\\u0930 \\u0906\\u092a\\u0915\\u0947 \\u091f\\u094d\\u0930\\u0947\\u0921 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u092e\\u0947\\u0902 \\u092d\\u0935\\u093f\\u0937\\u094d\\u092f \\u0915\\u0947 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0939\\u0947\\u091c\\u0947 \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964"}},"id":"68302b0d174b7"}}}','last_edit_by' => '1','status' => '1','created_at' => '2025-05-23 13:02:07','updated_at' => '2025-05-23 14:00:13')
        );
        FrontendHeaderSectionFaq::truncate();
        FrontendHeaderSectionFaq::insert($frontend_header_section_faqs);
    }
}
