<?php

use App\Constants\GlobalConst;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('merchants',function(Blueprint $table){
            $table->string('email')->nullable()->change();
            $table->enum("registered_by",[
                GlobalConst::EMAIL,
                GlobalConst::PHONE,
            ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('merchants', function (Blueprint $table) {
            $table->dropColumn('email');
            $table->dropColumn('registered_by');
        });
    }
};
